# Copyright (c) 2024. Rapida
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# Author: Prashant <prashant@rapida.ai>

from google.protobuf.any_pb2 import Any
from rapida.utils.rapida_value import (
    string_to_any,
    any_to_string,
    float_to_any,
    any_to_float,
    int32_to_any,
    any_to_int32,
    bool_to_any,
    any_to_bool,
    bytes_to_any,
    json_to_any,
    any_to_json,
    map_to_object,
)
from rapida.utils.rapida_source import RapidaSource
from rapida.connections import ConnectionConfig
from rapida.utils.rapida_header import (
    HEADER_ENVIRONMENT_KEY,
    HEADER_SOURCE_KEY,
    HEADER_REGION_KEY,
    HEADER_API_KEY,
    HEADER_AUTH_ID,
    HEADER_PROJECT_ID,
    HEADER_USER_AGENT,
    HEADER_LANGUAGE,
    HEADER_PLATFORM,
    HEADER_SCREEN_WIDTH,
    HEADER_SCREEN_HEIGHT,
    HEADER_WINDOW_WIDTH,
    HEADER_WINDOW_HEIGHT,
    HEADER_TIMEZONE,
    HEADER_COLOR_DEPTH,
    HEADER_DEVICE_MEMORY,
    HEADER_HARDWARE_CONCURRENCY,
    HEADER_CONNECTION_TYPE,
    HEADER_CONNECTION_EFFECTIVE_TYPE,
    HEADER_COOKIES_ENABLED,
    HEADER_DO_NOT_TRACK,
    HEADER_REFERRER,
    HEADER_REMOTE_URL,
    HEADER_LATITUDE,
    HEADER_LONGITUDE,
)

from rapida.clients.call import create_phone_call, create_bulk_phone_call
from rapida.clients.assistant import (
    get_assistant,
    get_all_assistant,
    get_assistant_conversation,
    get_all_assistant_conversation,
    get_assistant_webhook,
    get_all_assistant_webhook,
    get_assistant_knowledge,
    get_all_assistant_knowledge,
    get_assistant_tool,
    get_all_assistant_tool,
    get_assistant_webhook_log,
    get_all_assistant_webhook_log,
    get_assistant_analysis,
    get_all_assistant_analysis,
)

from rapida.clients.endpoint import (
    get_endpoint,
    get_all_endpoint,
    get_endpoint_log,
    get_all_endpoint_log,
)

from rapida.clients.invoke import invoke


# # Protobuf imports - Import common_pb2 FIRST since other protos depend on it
from rapida.clients.protos.common_pb2 import (
    FieldSelector,
    Criteria,
    Error,
    Paginate,
    Paginated,
    Ordering,
    User,
    BaseResponse,
    Metadata,
    Argument,
    Variable,
    Tag,
    Organization,
    Metric,
    Content,
    Message as ProtoMessage,
    ToolCall,
    FunctionCall,
    Knowledge,
    TextPrompt,
    TextChatCompletePrompt,
    AssistantConversationMessage,
    AssistantConversationContext,
    AssistantConversation,
    GetAllAssistantConversationRequest,
    GetAllAssistantConversationResponse,
    GetAllConversationMessageRequest,
    GetAllConversationMessageResponse,
    AssistantConversationMessageTextContent,
    AssistantConversationMessageAudioContent,
    AssistantDefinition,
    AssistantConversationConfiguration,
    AssistantConversationInterruption,
    AssistantConversationUserMessage,
    AssistantConversationAction,
    AssistantConversationAssistantMessage,
)

# Now import other protos that may depend on common_pb2
from rapida.clients.protos.assistant_knowledge_pb2 import (
    AssistantKnowledge,
    CreateAssistantKnowledgeRequest,
    UpdateAssistantKnowledgeRequest,
    GetAssistantKnowledgeRequest,
    DeleteAssistantKnowledgeRequest,
    GetAssistantKnowledgeResponse,
    GetAllAssistantKnowledgeRequest,
    GetAllAssistantKnowledgeResponse,
)
# from rapida.clients.protos.audit_logging_api_pb2 import (
#     AuditLog,
#     GetAllAuditLogRequest,
#     GetAllAuditLogResponse,
#     GetAuditLogRequest,
#     GetAuditLogResponse,
#     CreateMetadataRequest,
#     CreateMetadataResponse,
# )
from rapida.clients.protos.vault_api_pb2 import (
    VaultCredential,
    CreateProviderCredentialRequest,
    DeleteCredentialRequest,
    GetAllOrganizationCredentialResponse,
    GetCredentialResponse,
    GetAllOrganizationCredentialRequest,
)
from rapida.clients.protos.talk_api_pb2 import (
    AssistantMessagingRequest,
    AssistantMessagingResponse,
    CreateMessageMetricRequest,
    CreateMessageMetricResponse,
    CreateConversationMetricRequest,
    CreateConversationMetricResponse,
    CreateBulkPhoneCallRequest,
    CreateBulkPhoneCallResponse,
    CreatePhoneCallRequest,
    CreatePhoneCallResponse,
)
from rapida.clients.protos.assistant_analysis_pb2 import (
    AssistantAnalysis,
    CreateAssistantAnalysisRequest,
    UpdateAssistantAnalysisRequest,
    GetAssistantAnalysisRequest,
    DeleteAssistantAnalysisRequest,
    GetAssistantAnalysisResponse,
    GetAllAssistantAnalysisRequest,
    GetAllAssistantAnalysisResponse,
)
from rapida.clients.protos.invoker_api_pb2 import (
    EndpointDefinition,
    InvokeRequest,
    InvokeResponse,
    UpdateRequest,
    UpdateResponse,
    ProbeRequest,
    ProbeResponse,
)
from rapida.clients.protos.web_api_pb2 import (
    AuthenticateRequest,
    RegisterUserRequest,
    Token,
    OrganizationRole,
    ProjectRole,
    FeaturePermission,
    Authentication,
    ScopedAuthentication,
    AuthenticateResponse,
    ForgotPasswordRequest,
    ForgotPasswordResponse,
    CreatePasswordRequest,
    CreatePasswordResponse,
    VerifyTokenRequest,
    VerifyTokenResponse,
    AuthorizeRequest,
    ScopeAuthorizeRequest,
    ScopedAuthenticationResponse,
    GetUserRequest,
    GetUserResponse,
    UpdateUserRequest,
    UpdateUserResponse,
    SocialAuthenticationRequest,
    GetAllUserRequest,
    GetAllUserResponse,
    CreateOrganizationRequest,
    UpdateOrganizationRequest,
    GetOrganizationRequest,
    GetOrganizationResponse,
    CreateOrganizationResponse,
    UpdateOrganizationResponse,
    UpdateBillingInformationRequest,
    Project,
    CreateProjectRequest,
    CreateProjectResponse,
    UpdateProjectRequest,
    UpdateProjectResponse,
    GetProjectRequest,
    GetProjectResponse,
    GetAllProjectRequest,
    GetAllProjectResponse,
    AddUsersToProjectRequest,
    ArchiveProjectRequest,
    ArchiveProjectResponse,
    AddUsersToProjectResponse,
    ProjectCredential,
    CreateProjectCredentialRequest,
    GetAllProjectCredentialRequest,
    CreateProjectCredentialResponse,
    GetAllProjectCredentialResponse,
)
from rapida.clients.protos.assistant_webhook_pb2 import (
    AssistantWebhook,
    AssistantWebhookLog,
    CreateAssistantWebhookRequest,
    UpdateAssistantWebhookRequest,
    GetAssistantWebhookRequest,
    DeleteAssistantWebhookRequest,
    GetAssistantWebhookResponse,
    GetAllAssistantWebhookRequest,
    GetAllAssistantWebhookResponse,
    GetAllAssistantWebhookLogRequest,
    GetAssistantWebhookLogRequest,
    GetAssistantWebhookLogResponse,
    GetAllAssistantWebhookLogResponse,
)
from rapida.clients.protos.connect_api_pb2 import (
    GeneralConnectRequest,
    GeneralConnectResponse,
    GetConnectorFilesRequest,
    GetConnectorFilesResponse,
)
from rapida.clients.protos.endpoint_api_pb2 import (
    EndpointAttribute,
    EndpointProviderModelAttribute,
    CreateEndpointRequest,
    CreateEndpointResponse,
    EndpointProviderModel,
    AggregatedEndpointAnalytics,
    Endpoint,
    CreateEndpointProviderModelRequest,
    CreateEndpointProviderModelResponse,
    GetEndpointRequest,
    GetEndpointResponse,
    GetAllEndpointRequest,
    GetAllEndpointResponse,
    GetAllEndpointProviderModelRequest,
    GetAllEndpointProviderModelResponse,
    UpdateEndpointVersionRequest,
    UpdateEndpointVersionResponse,
    EndpointRetryConfiguration,
    EndpointCacheConfiguration,
    CreateEndpointRetryConfigurationRequest,
    CreateEndpointRetryConfigurationResponse,
    CreateEndpointCacheConfigurationRequest,
    CreateEndpointCacheConfigurationResponse,
    CreateEndpointTagRequest,
    ForkEndpointRequest,
    UpdateEndpointDetailRequest,
    EndpointLog,
    GetAllEndpointLogRequest,
    GetAllEndpointLogResponse,
    GetEndpointLogRequest,
    GetEndpointLogResponse,
)
from rapida.clients.protos.assistant_tool_pb2 import (
    AssistantTool,
    CreateAssistantToolRequest,
    UpdateAssistantToolRequest,
    GetAssistantToolRequest,
    DeleteAssistantToolRequest,
    GetAssistantToolResponse,
    GetAllAssistantToolRequest,
    GetAllAssistantToolResponse,
)
from rapida.clients.protos.integration_api_pb2 import (
    Credential,
    ToolDefinition,
    FunctionDefinition,
    FunctionParameter,
    FunctionParameterProperty,
    Embedding,
    EmbeddingRequest,
    EmbeddingResponse,
    Reranking,
    RerankingRequest,
    RerankingResponse,
    ChatResponse,
    ChatRequest,
    VerifyCredentialRequest,
    VerifyCredentialResponse,
    Moderation,
    GetModerationRequest,
    GetModerationResponse,
)
from rapida.clients.protos.assistant_deployment_pb2 import (
    DeploymentAudioProvider,
    AssistantWebpluginDeployment,
    AssistantPhoneDeployment,
    AssistantWhatsappDeployment,
    AssistantDebuggerDeployment,
    AssistantApiDeployment,
    GetAssistantDeploymentRequest,
)
from rapida.clients.protos.knowledge_api_pb2 import (
    CreateKnowledgeRequest,
    CreateKnowledgeResponse,
    GetAllKnowledgeRequest,
    GetAllKnowledgeResponse,
    GetKnowledgeRequest,
    GetKnowledgeResponse,
    CreateKnowledgeTagRequest,
    KnowledgeDocument,
    GetAllKnowledgeDocumentRequest,
    GetAllKnowledgeDocumentResponse,
    CreateKnowledgeDocumentRequest,
    CreateKnowledgeDocumentResponse,
    KnowledgeDocumentSegment,
    GetAllKnowledgeDocumentSegmentRequest,
    GetAllKnowledgeDocumentSegmentResponse,
    UpdateKnowledgeDetailRequest,
    UpdateKnowledgeDocumentSegmentRequest,
    DeleteKnowledgeDocumentSegmentRequest,
)
from rapida.clients.protos.assistant_api_pb2 import (
    Assistant,
    CreateAssistantRequest,
    CreateAssistantTagRequest,
    GetAssistantRequest,
    DeleteAssistantRequest,
    GetAssistantResponse,
    GetAllAssistantRequest,
    GetAllAssistantResponse,
    GetAllAssistantMessageRequest,
    GetAllAssistantMessageResponse,
    GetAllMessageRequest,
    GetAllMessageResponse,
    UpdateAssistantDetailRequest,
    GetAssistantConversationRequest,
    GetAssistantConversationResponse,
)

from rapida.clients.protos.talk_api_pb2_grpc import (
    TalkServiceServicer, 
    AgentKitStub,
    AgentKit,
    AgentKitServicer,
    add_AgentKitServicer_to_server,
    )

__all__ = [
    "Any",
    "RapidaSource",
    "ConnectionConfig",
    "string_to_any",
    "any_to_string",
    "float_to_any",
    "any_to_float",
    "int32_to_any",
    "any_to_int32",
    "bool_to_any",
    "any_to_bool",
    "bytes_to_any",
    "json_to_any",
    "any_to_json",
    "map_to_object",
    "HEADER_ENVIRONMENT_KEY",
    "HEADER_SOURCE_KEY",
    "HEADER_REGION_KEY",
    "HEADER_API_KEY",
    "HEADER_AUTH_ID",
    "HEADER_PROJECT_ID",
    "HEADER_USER_AGENT",
    "HEADER_LANGUAGE",
    "HEADER_PLATFORM",
    "HEADER_SCREEN_WIDTH",
    "HEADER_SCREEN_HEIGHT",
    "HEADER_WINDOW_WIDTH",
    "HEADER_WINDOW_HEIGHT",
    "HEADER_TIMEZONE",
    "HEADER_COLOR_DEPTH",
    "HEADER_DEVICE_MEMORY",
    "HEADER_HARDWARE_CONCURRENCY",
    "HEADER_CONNECTION_TYPE",
    "HEADER_CONNECTION_EFFECTIVE_TYPE",
    "HEADER_COOKIES_ENABLED",
    "HEADER_DO_NOT_TRACK",
    "HEADER_REFERRER",
    "HEADER_REMOTE_URL",
    "HEADER_LATITUDE",
    "HEADER_LONGITUDE",
    #
    "get_assistant",
    "get_all_assistant",
    "get_assistant_conversation",
    "get_all_assistant_conversation",
    "get_assistant_webhook",
    "get_all_assistant_webhook",
    "get_assistant_knowledge",
    "get_all_assistant_knowledge",
    "get_assistant_tool",
    "get_all_assistant_tool",
    "get_assistant_webhook_log",
    "get_all_assistant_webhook_log",
    "get_endpoint",
    "get_all_endpoint",
    "get_endpoint_log",
    "get_all_endpoint_log",
    "invoke",
    "get_assistant_analysis",
    "get_all_assistant_analysis",
    "create_phone_call",
    "create_bulk_phone_call",
    # Protobuf classes
    "AssistantKnowledge",
    "CreateAssistantKnowledgeRequest",
    "UpdateAssistantKnowledgeRequest",
    "GetAssistantKnowledgeRequest",
    "DeleteAssistantKnowledgeRequest",
    "GetAssistantKnowledgeResponse",
    "GetAllAssistantKnowledgeRequest",
    "GetAllAssistantKnowledgeResponse",
    "AuditLog",
    "GetAllAuditLogRequest",
    "GetAllAuditLogResponse",
    "GetAuditLogRequest",
    "GetAuditLogResponse",
    "CreateMetadataRequest",
    "VaultCredential",
    "CreateProviderCredentialRequest",
    "DeleteCredentialRequest",
    "GetAllOrganizationCredentialResponse",
    "GetCredentialResponse",
    "GetAllOrganizationCredentialRequest",
    "AssistantDefinition",
    "AssistantMessagingRequest",
    "AssistantConversationConfiguration",
    "AssistantConversationInterruption",
    "AssistantConversationUserMessage",
    "AssistantConversationAssistantMessage",
    "AssistantMessagingResponse",
    "CreateMessageMetricRequest",
    "CreateMessageMetricResponse",
    "CreateConversationMetricRequest",
    "CreateConversationMetricResponse",
    "CreateBulkPhoneCallRequest",
    "CreateBulkPhoneCallResponse",
    "CreatePhoneCallRequest",
    "CreatePhoneCallResponse",
    "AssistantAnalysis",
    "CreateAssistantAnalysisRequest",
    "UpdateAssistantAnalysisRequest",
    "GetAssistantAnalysisRequest",
    "DeleteAssistantAnalysisRequest",
    "GetAssistantAnalysisResponse",
    "GetAllAssistantAnalysisRequest",
    "GetAllAssistantAnalysisResponse",
    "EndpointDefinition",
    "InvokeRequest",
    "InvokeResponse",
    "UpdateRequest",
    "UpdateResponse",
    "ProbeRequest",
    "ProbeResponse",
    "AuthenticateRequest",
    "RegisterUserRequest",
    "Token",
    "OrganizationRole",
    "ProjectRole",
    "FeaturePermission",
    "Authentication",
    "ScopedAuthentication",
    "AuthenticateResponse",
    "ForgotPasswordRequest",
    "ForgotPasswordResponse",
    "CreatePasswordRequest",
    "CreatePasswordResponse",
    "VerifyTokenRequest",
    "VerifyTokenResponse",
    "AuthorizeRequest",
    "ScopeAuthorizeRequest",
    "ScopedAuthenticationResponse",
    "GetUserRequest",
    "GetUserResponse",
    "UpdateUserRequest",
    "UpdateUserResponse",
    "SocialAuthenticationRequest",
    "GetAllUserRequest",
    "GetAllUserResponse",
    "CreateOrganizationRequest",
    "UpdateOrganizationRequest",
    "GetOrganizationRequest",
    "GetOrganizationResponse",
    "CreateOrganizationResponse",
    "UpdateOrganizationResponse",
    "UpdateBillingInformationRequest",
    "Project",
    "CreateProjectRequest",
    "CreateProjectResponse",
    "UpdateProjectRequest",
    "UpdateProjectResponse",
    "GetProjectRequest",
    "GetProjectResponse",
    "GetAllProjectRequest",
    "GetAllProjectResponse",
    "AddUsersToProjectRequest",
    "ArchiveProjectRequest",
    "ArchiveProjectResponse",
    "AddUsersToProjectResponse",
    "ProjectCredential",
    "CreateProjectCredentialRequest",
    "GetAllProjectCredentialRequest",
    "CreateProjectCredentialResponse",
    "GetAllProjectCredentialResponse",
    "FieldSelector",
    "Criteria",
    "Error",
    "Paginate",
    "Paginated",
    "Ordering",
    "User",
    "BaseResponse",
    "Metadata",
    "Argument",
    "Variable",
    "Tag",
    "Organization",
    "Metric",
    "Content",
    "ProtoMessage",
    "ToolCall",
    "FunctionCall",
    "Knowledge",
    "TextPrompt",
    "TextChatCompletePrompt",
    "AssistantConversationMessage",
    "AssistantConversationContext",
    "AssistantConversation",
    "GetAllAssistantConversationRequest",
    "GetAllAssistantConversationResponse",
    "GetAllConversationMessageRequest",
    "GetAllConversationMessageResponse",
    "AssistantWebhook",
    "AssistantWebhookLog",
    "CreateAssistantWebhookRequest",
    "UpdateAssistantWebhookRequest",
    "GetAssistantWebhookRequest",
    "DeleteAssistantWebhookRequest",
    "GetAssistantWebhookResponse",
    "GetAllAssistantWebhookRequest",
    "GetAllAssistantWebhookResponse",
    "GetAllAssistantWebhookLogRequest",
    "GetAssistantWebhookLogRequest",
    "GetAssistantWebhookLogResponse",
    "GetAllAssistantWebhookLogResponse",
    "GeneralConnectRequest",
    "GeneralConnectResponse",
    "GetConnectorFilesRequest",
    "GetConnectorFilesResponse",
    "EndpointAttribute",
    "EndpointProviderModelAttribute",
    "CreateEndpointRequest",
    "CreateEndpointResponse",
    "EndpointProviderModel",
    "AggregatedEndpointAnalytics",
    "Endpoint",
    "CreateEndpointProviderModelRequest",
    "CreateEndpointProviderModelResponse",
    "GetEndpointRequest",
    "GetEndpointResponse",
    "GetAllEndpointRequest",
    "GetAllEndpointResponse",
    "GetAllEndpointProviderModelRequest",
    "GetAllEndpointProviderModelResponse",
    "UpdateEndpointVersionRequest",
    "UpdateEndpointVersionResponse",
    "EndpointRetryConfiguration",
    "EndpointCacheConfiguration",
    "CreateEndpointRetryConfigurationRequest",
    "CreateEndpointRetryConfigurationResponse",
    "CreateEndpointCacheConfigurationRequest",
    "CreateEndpointCacheConfigurationResponse",
    "CreateEndpointTagRequest",
    "ForkEndpointRequest",
    "UpdateEndpointDetailRequest",
    "EndpointLog",
    "GetAllEndpointLogRequest",
    "GetAllEndpointLogResponse",
    "GetEndpointLogRequest",
    "GetEndpointLogResponse",
    "AssistantTool",
    "CreateAssistantToolRequest",
    "UpdateAssistantToolRequest",
    "GetAssistantToolRequest",
    "DeleteAssistantToolRequest",
    "GetAssistantToolResponse",
    "GetAllAssistantToolRequest",
    "GetAllAssistantToolResponse",
    "Credential",
    "ToolDefinition",
    "FunctionDefinition",
    "FunctionParameter",
    "FunctionParameterProperty",
    "Embedding",
    "EmbeddingRequest",
    "EmbeddingResponse",
    "Reranking",
    "RerankingRequest",
    "RerankingResponse",
    "ChatResponse",
    "ChatRequest",
    "VerifyCredentialRequest",
    "VerifyCredentialResponse",
    "Moderation",
    "GetModerationRequest",
    "GetModerationResponse",
    "DeploymentAudioProvider",
    "AssistantWebpluginDeployment",
    "AssistantPhoneDeployment",
    "AssistantWhatsappDeployment",
    "AssistantDebuggerDeployment",
    "AssistantApiDeployment",
    "GetAssistantDeploymentRequest",
    "CreateKnowledgeRequest",
    "CreateKnowledgeResponse",
    "GetAllKnowledgeRequest",
    "GetAllKnowledgeResponse",
    "GetKnowledgeRequest",
    "GetKnowledgeResponse",
    "CreateKnowledgeTagRequest",
    "KnowledgeDocument",
    "GetAllKnowledgeDocumentRequest",
    "GetAllKnowledgeDocumentResponse",
    "CreateKnowledgeDocumentRequest",
    "CreateKnowledgeDocumentResponse",
    "KnowledgeDocumentSegment",
    "GetAllKnowledgeDocumentSegmentRequest",
    "GetAllKnowledgeDocumentSegmentResponse",
    "UpdateKnowledgeDetailRequest",
    "UpdateKnowledgeDocumentSegmentRequest",
    "DeleteKnowledgeDocumentSegmentRequest",
    "Assistant",
    "CreateAssistantRequest",
    "CreateAssistantTagRequest",
    "GetAssistantRequest",
    "DeleteAssistantRequest",
    "GetAssistantResponse",
    "GetAllAssistantRequest",
    "GetAllAssistantResponse",
    "GetAllAssistantMessageRequest",
    "GetAllAssistantMessageResponse",
    "GetAllMessageRequest",
    "GetAllMessageResponse",
    "UpdateAssistantDetailRequest",
    "GetAssistantConversationRequest",
    "GetAssistantConversationResponse",
    "AssistantConversationMessageTextContent",
    "AssistantConversationMessageAudioContent",
    "AgentKitStub",
    "AgentKit",
    "AgentKitServicer",
    "TalkServiceServicer",
    "add_AgentKitServicer_to_server",
    "AssistantConversationAction",
]
