from __future__ import annotations

from typing import Any
import os
import sys

from .ray import Ray
from .settings import SettingsFactory


def ray(*values: Any) -> Ray:
    """Entry point similar to the PHP global `ray()` helper.

    Looks for configuration using SettingsFactory, constructs a Ray instance,
    sends the provided values, and returns the Ray instance.
    """

    settings = SettingsFactory.create_from_file()
    r = Ray(settings)
    if values:
        r.send(*values)
    return r


def rd(*values: Any) -> "None":
    """Send values to Ray and then terminate the current process."""

    r = ray(*values)
    # Best-effort flush; Ray client is synchronous so by the time we return,
    # the data should have been sent (or skipped if Ray is unavailable).
    sys.exit(0)
