from __future__ import annotations

from typing import Any, Dict

from .base import Payload


class CreateLockPayload(Payload):
    def __init__(self, name: str) -> None:
        super().__init__()
        self._name = name

    def get_type(self) -> str:
        return "create_lock"

    def get_content(self) -> Dict[str, Any]:
        return {"name": self._name}
