from __future__ import annotations

from typing import Any, Dict

from .base import Payload


class LabelPayload(Payload):
    def __init__(self, label: str) -> None:
        super().__init__()
        self._label = label

    def get_type(self) -> str:
        return "label"

    def get_content(self) -> Dict[str, Any]:
        return {"label": self._label}
