from __future__ import annotations

from typing import Any, Dict, Iterable
import sys
import platform

from .base import Payload


class PythonInfoPayload(Payload):
    def __init__(self, *properties: str) -> None:
        super().__init__()
        self._properties = properties

    def get_type(self) -> str:
        return "table"

    def get_content(self) -> Dict[str, Any]:
        values: Dict[str, Any] = {}
        if self._properties:
            for prop in self._properties:
                if prop == "version":
                    values[prop] = sys.version.replace("\n", " ")
                elif prop == "implementation":
                    values[prop] = platform.python_implementation()
                else:
                    values[prop] = getattr(sys, prop, None)
        else:
            values = {
                "Python version": sys.version.replace("\n", " "),
                "Implementation": platform.python_implementation(),
                "Platform": platform.platform(),
            }

        return {
            "values": values,
            "label": "PythonInfo",
        }
