from __future__ import annotations

from dataclasses import dataclass
from typing import Any, Dict, Iterable, List
import json

from .payloads import Payload


@dataclass
class Request:
    uuid: str
    payloads: List[Payload]
    meta: Dict[str, Any]

    def to_dict(self) -> Dict[str, Any]:
        return {
            "uuid": self.uuid,
            "payloads": [p.to_dict() for p in self.payloads],
            "meta": self.meta,
        }

    def to_json(self) -> str:
        return json.dumps(self.to_dict(), ensure_ascii=False)
