from __future__ import annotations

from typing import Any, Dict

from .base import Payload


class BoolPayload(Payload):
    def __init__(self, value: bool) -> None:
        super().__init__()
        self._value = bool(value)

    def get_type(self) -> str:
        return "custom"

    def get_content(self) -> Dict[str, Any]:
        return {
            "content": self._value,
            "label": "Boolean",
        }
