from __future__ import annotations

from typing import Any, Dict

from .base import Payload


class CallerPayload(Payload):
    def __init__(self, frame: Dict[str, Any]) -> None:
        super().__init__()
        self._frame = frame

    def get_type(self) -> str:
        return "caller"

    def get_content(self) -> Dict[str, Any]:
        return {"frame": self._frame}
