from __future__ import annotations

from typing import Any, Dict, Optional
from datetime import datetime

from .base import Payload


class CarbonPayload(Payload):
    def __init__(self, value: Optional[datetime], fmt: str = "%Y-%m-%d %H:%M:%S") -> None:
        super().__init__()
        self._value = value
        self._fmt = fmt

    def get_type(self) -> str:
        return "carbon"

    def get_content(self) -> Dict[str, Any]:
        if self._value is None:
            return {"formatted": None, "timestamp": None, "timezone": None}
        return {
            "formatted": self._value.strftime(self._fmt),
            "timestamp": int(self._value.timestamp()),
            "timezone": self._value.tzname() or None,
        }
