from __future__ import annotations

from typing import Any, Dict

from .base import Payload


class CustomPayload(Payload):
    def __init__(self, content: str, label: str = "") -> None:
        super().__init__()
        self._content = content
        self._label = label

    def get_type(self) -> str:
        return "custom"

    def get_content(self) -> Dict[str, Any]:
        return {
            "content": self._content,
            "label": self._label,
        }
