from __future__ import annotations

from typing import Any, Dict

from .base import Payload


class NotifyPayload(Payload):
    def __init__(self, text: str) -> None:
        super().__init__()
        self._text = text

    def get_type(self) -> str:
        return "notify"

    def get_content(self) -> Dict[str, Any]:
        return {"value": self._text}
