from __future__ import annotations

from typing import Any, Dict

from .base import Payload


class SizePayload(Payload):
    def __init__(self, size: str) -> None:
        super().__init__()
        self._size = size

    def get_type(self) -> str:
        return "size"

    def get_content(self) -> Dict[str, Any]:
        return {"size": self._size}
