from __future__ import annotations

from typing import Any, Dict
from html import escape
import xml.dom.minidom

from .base import Payload


class XmlPayload(Payload):
    def __init__(self, value: str) -> None:
        super().__init__()
        self._value = value

    def get_type(self) -> str:
        return "custom"

    def get_content(self) -> Dict[str, Any]:
        content = self._format_xml_for_display(self._value)
        return {
            "content": content,
            "label": "XML",
        }

    def _format_xml_for_display(self, xml: str) -> str:
        content = self._format_and_indent_xml(xml)
        return self._encode_xml(content.strip())

    def _encode_xml(self, xml: str) -> str:
        result = escape(xml)
        return result.replace("\n", "<br>").replace(" ", "&nbsp;")

    def _format_and_indent_xml(self, xml: str) -> str:
        try:
            parsed = xml.dom.minidom.parseString(xml)
            return parsed.toprettyxml()
        except Exception:
            return xml
