from __future__ import annotations

from dataclasses import dataclass, field
from typing import Dict


@dataclass
class Counters:
    _counters: Dict[str, int] = field(default_factory=dict)

    def increment(self, name: str) -> int:
        current = self._counters.get(name, 0) + 1
        self._counters[name] = current
        return current

    def get(self, name: str) -> int:
        return self._counters.get(name, 0)

    def clear(self) -> None:
        self._counters.clear()
