from __future__ import annotations

from typing import Any, Callable, TYPE_CHECKING

if TYPE_CHECKING:  # Only for type checkers; avoids circular import at runtime
    from ..ray import Ray


class Invador:
    """Helper returned by Ray.invade(obj) to inspect attributes/method results.

    Example:
        ray().invade(user).password
        ray().invade(service).compute(1, 2)
    """

    def __init__(self, obj: object, ray: "Ray") -> None:
        self._obj = obj
        self._ray = ray

    def __getattr__(self, name: str) -> Any:  # pragma: no cover - thin wrapper
        attr = getattr(self._obj, name)
        if callable(attr):
            def wrapper(*args: Any, **kwargs: Any) -> "Ray":
                result = attr(*args, **kwargs)
                self._ray.send(result)
                return self._ray
            return wrapper
        # attribute access: send value and return Ray for chaining
        self._ray.send(attr)
        return self._ray
