from __future__ import annotations

from dataclasses import dataclass, field
from typing import Dict


@dataclass
class Limiters:
    _counters: Dict[str, tuple[int, int]] = field(default_factory=dict)

    def initialize(self, fingerprint: str, limit: int) -> None:
        if fingerprint not in self._counters:
            self._counters[fingerprint] = (0, limit)

    def increment(self, fingerprint: str) -> None:
        if fingerprint not in self._counters:
            return
        times, limit = self._counters[fingerprint]
        self._counters[fingerprint] = (times + 1, limit)

    def can_send_payload(self, fingerprint: str) -> bool:
        if fingerprint not in self._counters:
            return True
        times, limit = self._counters[fingerprint]
        return times < limit or limit <= 0
