from __future__ import annotations

from dataclasses import dataclass
import json

from python_ray.auto_json import enable_auto_object_json
from python_ray.payloads import PayloadFactory, DecodedJsonPayload


@dataclass
class User:
    id: int
    name: str


def test_enable_auto_object_json_registers_payload_finder():
    enable_auto_object_json()

    user = User(id=1, name="Ada")
    [payload] = PayloadFactory.create_for_values([user])

    # Should be converted into a DecodedJsonPayload containing JSON for the dataclass
    assert isinstance(payload, DecodedJsonPayload)
    content = payload.get_content()
    # Payload now stores pretty-printed JSON text; parse to compare structure.
    data = json.loads(content["content"])
    assert data == {"id": 1, "name": "Ada"}
