from __future__ import annotations

from time import sleep

from python_ray.support.rate_limiter import RateLimiter


def test_rate_limiter_disabled_has_no_limits():
    rl = RateLimiter.disabled()
    for _ in range(5):
        assert not rl.is_max_reached()
        assert not rl.is_max_per_second_reached()
        rl.hit()


def test_rate_limiter_max_calls():
    rl = RateLimiter(max_calls=2, max_per_second=None)
    assert not rl.is_max_reached()
    rl.hit()
    assert not rl.is_max_reached()
    rl.hit()
    assert rl.is_max_reached()

    # clear resets limits and notifications
    rl.clear()
    assert not rl.is_max_reached()


def test_rate_limiter_per_second_window():
    rl = RateLimiter(max_calls=None, max_per_second=2)

    rl.hit()
    rl.hit()
    assert rl.is_max_per_second_reached()

    # after a short sleep, window should eventually clear
    sleep(1.1)
    assert not rl.is_max_per_second_reached()


def test_rate_limiter_notified_flag():
    rl = RateLimiter(max_calls=1, max_per_second=None)

    assert not rl.is_notified()
    rl.hit()
    assert rl.is_max_reached()

    # "notify" is managed by Ray, but we can flip it here to ensure the flag works
    rl.notify()
    assert rl.is_notified()

    # clear resets limits; the notification flag is intentionally left unchanged
    rl.clear()
    assert not rl.is_max_reached()
