from __future__ import annotations

from pathlib import Path

from python_ray.settings import Settings, SettingsFactory


def test_settings_defaults_are_applied():
    s = Settings({})
    # defaults from _DEFAULT_SETTINGS
    assert s.enable is True
    assert s.host == "localhost"
    assert s.port == 23517
    assert s.remote_path is None
    assert s.local_path is None
    assert s.always_send_raw_values is False


def test_settings_overrides_defaults():
    s = Settings({"enable": False, "host": "example.com", "port": 1234})
    assert s.enable is False
    assert s.host == "example.com"
    assert s.port == 1234


def test_create_from_dict_wraps_in_settings():
    s = SettingsFactory.create_from_dict({"host": "foo"})
    assert isinstance(s, Settings)
    assert s.host == "foo"


def test_create_from_file_handles_invalid_json(tmp_path: Path, monkeypatch):
    (tmp_path / "ray.json").write_text("not-json")
    monkeypatch.chdir(tmp_path)

    settings = SettingsFactory.create_from_file()
    # invalid file falls back to defaults
    assert isinstance(settings, Settings)
    assert settings.host == "localhost"
    assert settings.port == 23517
