(self["webpackChunkreact_editable_table"] = self["webpackChunkreact_editable_table"] || []).push([["vendors-node_modules_mantine_core_esm_index_js-node_modules_ahooks_es_index_js-node_modules_i-d1af73"],{

/***/ "./node_modules/@floating-ui/core/dist/floating-ui.core.browser.mjs":
/*!**************************************************************************!*\
  !*** ./node_modules/@floating-ui/core/dist/floating-ui.core.browser.mjs ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "arrow": () => (/* binding */ arrow),
/* harmony export */   "autoPlacement": () => (/* binding */ autoPlacement),
/* harmony export */   "computePosition": () => (/* binding */ computePosition),
/* harmony export */   "detectOverflow": () => (/* binding */ detectOverflow),
/* harmony export */   "flip": () => (/* binding */ flip),
/* harmony export */   "hide": () => (/* binding */ hide),
/* harmony export */   "inline": () => (/* binding */ inline),
/* harmony export */   "limitShift": () => (/* binding */ limitShift),
/* harmony export */   "offset": () => (/* binding */ offset),
/* harmony export */   "rectToClientRect": () => (/* binding */ rectToClientRect),
/* harmony export */   "shift": () => (/* binding */ shift),
/* harmony export */   "size": () => (/* binding */ size)
/* harmony export */ });
function getAlignment(placement) {
  return placement.split('-')[1];
}

function getLengthFromAxis(axis) {
  return axis === 'y' ? 'height' : 'width';
}

function getSide(placement) {
  return placement.split('-')[0];
}

function getMainAxisFromPlacement(placement) {
  return ['top', 'bottom'].includes(getSide(placement)) ? 'x' : 'y';
}

function computeCoordsFromPlacement(_ref, placement, rtl) {
  let {
    reference,
    floating
  } = _ref;
  const commonX = reference.x + reference.width / 2 - floating.width / 2;
  const commonY = reference.y + reference.height / 2 - floating.height / 2;
  const mainAxis = getMainAxisFromPlacement(placement);
  const length = getLengthFromAxis(mainAxis);
  const commonAlign = reference[length] / 2 - floating[length] / 2;
  const side = getSide(placement);
  const isVertical = mainAxis === 'x';
  let coords;
  switch (side) {
    case 'top':
      coords = {
        x: commonX,
        y: reference.y - floating.height
      };
      break;
    case 'bottom':
      coords = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;
    case 'right':
      coords = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;
    case 'left':
      coords = {
        x: reference.x - floating.width,
        y: commonY
      };
      break;
    default:
      coords = {
        x: reference.x,
        y: reference.y
      };
  }
  switch (getAlignment(placement)) {
    case 'start':
      coords[mainAxis] -= commonAlign * (rtl && isVertical ? -1 : 1);
      break;
    case 'end':
      coords[mainAxis] += commonAlign * (rtl && isVertical ? -1 : 1);
      break;
  }
  return coords;
}

/**
 * Computes the `x` and `y` coordinates that will place the floating element
 * next to a reference element when it is given a certain positioning strategy.
 *
 * This export does not have any `platform` interface logic. You will need to
 * write one for the platform you are using Floating UI with.
 */
const computePosition = async (reference, floating, config) => {
  const {
    placement = 'bottom',
    strategy = 'absolute',
    middleware = [],
    platform
  } = config;
  const validMiddleware = middleware.filter(Boolean);
  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(floating));
  let rects = await platform.getElementRects({
    reference,
    floating,
    strategy
  });
  let {
    x,
    y
  } = computeCoordsFromPlacement(rects, placement, rtl);
  let statefulPlacement = placement;
  let middlewareData = {};
  let resetCount = 0;
  for (let i = 0; i < validMiddleware.length; i++) {
    const {
      name,
      fn
    } = validMiddleware[i];
    const {
      x: nextX,
      y: nextY,
      data,
      reset
    } = await fn({
      x,
      y,
      initialPlacement: placement,
      placement: statefulPlacement,
      strategy,
      middlewareData,
      rects,
      platform,
      elements: {
        reference,
        floating
      }
    });
    x = nextX != null ? nextX : x;
    y = nextY != null ? nextY : y;
    middlewareData = {
      ...middlewareData,
      [name]: {
        ...middlewareData[name],
        ...data
      }
    };
    if (reset && resetCount <= 50) {
      resetCount++;
      if (typeof reset === 'object') {
        if (reset.placement) {
          statefulPlacement = reset.placement;
        }
        if (reset.rects) {
          rects = reset.rects === true ? await platform.getElementRects({
            reference,
            floating,
            strategy
          }) : reset.rects;
        }
        ({
          x,
          y
        } = computeCoordsFromPlacement(rects, statefulPlacement, rtl));
      }
      i = -1;
      continue;
    }
  }
  return {
    x,
    y,
    placement: statefulPlacement,
    strategy,
    middlewareData
  };
};

function expandPaddingObject(padding) {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    ...padding
  };
}

function getSideObjectFromPadding(padding) {
  return typeof padding !== 'number' ? expandPaddingObject(padding) : {
    top: padding,
    right: padding,
    bottom: padding,
    left: padding
  };
}

function rectToClientRect(rect) {
  return {
    ...rect,
    top: rect.y,
    left: rect.x,
    right: rect.x + rect.width,
    bottom: rect.y + rect.height
  };
}

/**
 * Resolves with an object of overflow side offsets that determine how much the
 * element is overflowing a given clipping boundary on each side.
 * - positive = overflowing the boundary by that number of pixels
 * - negative = how many pixels left before it will overflow
 * - 0 = lies flush with the boundary
 * @see https://floating-ui.com/docs/detectOverflow
 */
async function detectOverflow(state, options) {
  var _await$platform$isEle;
  if (options === void 0) {
    options = {};
  }
  const {
    x,
    y,
    platform,
    rects,
    elements,
    strategy
  } = state;
  const {
    boundary = 'clippingAncestors',
    rootBoundary = 'viewport',
    elementContext = 'floating',
    altBoundary = false,
    padding = 0
  } = options;
  const paddingObject = getSideObjectFromPadding(padding);
  const altContext = elementContext === 'floating' ? 'reference' : 'floating';
  const element = elements[altBoundary ? altContext : elementContext];
  const clippingClientRect = rectToClientRect(await platform.getClippingRect({
    element: ((_await$platform$isEle = await (platform.isElement == null ? void 0 : platform.isElement(element))) != null ? _await$platform$isEle : true) ? element : element.contextElement || (await (platform.getDocumentElement == null ? void 0 : platform.getDocumentElement(elements.floating))),
    boundary,
    rootBoundary,
    strategy
  }));
  const rect = elementContext === 'floating' ? {
    ...rects.floating,
    x,
    y
  } : rects.reference;
  const offsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(elements.floating));
  const offsetScale = (await (platform.isElement == null ? void 0 : platform.isElement(offsetParent))) ? (await (platform.getScale == null ? void 0 : platform.getScale(offsetParent))) || {
    x: 1,
    y: 1
  } : {
    x: 1,
    y: 1
  };
  const elementClientRect = rectToClientRect(platform.convertOffsetParentRelativeRectToViewportRelativeRect ? await platform.convertOffsetParentRelativeRectToViewportRelativeRect({
    rect,
    offsetParent,
    strategy
  }) : rect);
  return {
    top: (clippingClientRect.top - elementClientRect.top + paddingObject.top) / offsetScale.y,
    bottom: (elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom) / offsetScale.y,
    left: (clippingClientRect.left - elementClientRect.left + paddingObject.left) / offsetScale.x,
    right: (elementClientRect.right - clippingClientRect.right + paddingObject.right) / offsetScale.x
  };
}

const min = Math.min;
const max = Math.max;

function within(min$1, value, max$1) {
  return max(min$1, min(value, max$1));
}

/**
 * Provides data to position an inner element of the floating element so that it
 * appears centered to the reference element.
 * @see https://floating-ui.com/docs/arrow
 */
const arrow = options => ({
  name: 'arrow',
  options,
  async fn(state) {
    // Since `element` is required, we don't Partial<> the type.
    const {
      element,
      padding = 0
    } = options || {};
    const {
      x,
      y,
      placement,
      rects,
      platform,
      elements
    } = state;
    if (element == null) {
      return {};
    }
    const paddingObject = getSideObjectFromPadding(padding);
    const coords = {
      x,
      y
    };
    const axis = getMainAxisFromPlacement(placement);
    const length = getLengthFromAxis(axis);
    const arrowDimensions = await platform.getDimensions(element);
    const isYAxis = axis === 'y';
    const minProp = isYAxis ? 'top' : 'left';
    const maxProp = isYAxis ? 'bottom' : 'right';
    const clientProp = isYAxis ? 'clientHeight' : 'clientWidth';
    const endDiff = rects.reference[length] + rects.reference[axis] - coords[axis] - rects.floating[length];
    const startDiff = coords[axis] - rects.reference[axis];
    const arrowOffsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(element));
    let clientSize = arrowOffsetParent ? arrowOffsetParent[clientProp] : 0;

    // DOM platform can return `window` as the `offsetParent`.
    if (!clientSize || !(await (platform.isElement == null ? void 0 : platform.isElement(arrowOffsetParent)))) {
      clientSize = elements.floating[clientProp] || rects.floating[length];
    }
    const centerToReference = endDiff / 2 - startDiff / 2;

    // Make sure the arrow doesn't overflow the floating element if the center
    // point is outside the floating element's bounds.
    const min = paddingObject[minProp];
    const max = clientSize - arrowDimensions[length] - paddingObject[maxProp];
    const center = clientSize / 2 - arrowDimensions[length] / 2 + centerToReference;
    const offset = within(min, center, max);

    // If the reference is small enough that the arrow's padding causes it to
    // to point to nothing for an aligned placement, adjust the offset of the
    // floating element itself. This stops `shift()` from taking action, but can
    // be worked around by calling it again after the `arrow()` if desired.
    const shouldAddOffset = getAlignment(placement) != null && center != offset && rects.reference[length] / 2 - (center < min ? paddingObject[minProp] : paddingObject[maxProp]) - arrowDimensions[length] / 2 < 0;
    const alignmentOffset = shouldAddOffset ? center < min ? min - center : max - center : 0;
    return {
      [axis]: coords[axis] - alignmentOffset,
      data: {
        [axis]: offset,
        centerOffset: center - offset
      }
    };
  }
});

const sides = ['top', 'right', 'bottom', 'left'];
const allPlacements = /*#__PURE__*/sides.reduce((acc, side) => acc.concat(side, side + "-start", side + "-end"), []);

const oppositeSideMap = {
  left: 'right',
  right: 'left',
  bottom: 'top',
  top: 'bottom'
};
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, side => oppositeSideMap[side]);
}

function getAlignmentSides(placement, rects, rtl) {
  if (rtl === void 0) {
    rtl = false;
  }
  const alignment = getAlignment(placement);
  const mainAxis = getMainAxisFromPlacement(placement);
  const length = getLengthFromAxis(mainAxis);
  let mainAlignmentSide = mainAxis === 'x' ? alignment === (rtl ? 'end' : 'start') ? 'right' : 'left' : alignment === 'start' ? 'bottom' : 'top';
  if (rects.reference[length] > rects.floating[length]) {
    mainAlignmentSide = getOppositePlacement(mainAlignmentSide);
  }
  return {
    main: mainAlignmentSide,
    cross: getOppositePlacement(mainAlignmentSide)
  };
}

const oppositeAlignmentMap = {
  start: 'end',
  end: 'start'
};
function getOppositeAlignmentPlacement(placement) {
  return placement.replace(/start|end/g, alignment => oppositeAlignmentMap[alignment]);
}

function getPlacementList(alignment, autoAlignment, allowedPlacements) {
  const allowedPlacementsSortedByAlignment = alignment ? [...allowedPlacements.filter(placement => getAlignment(placement) === alignment), ...allowedPlacements.filter(placement => getAlignment(placement) !== alignment)] : allowedPlacements.filter(placement => getSide(placement) === placement);
  return allowedPlacementsSortedByAlignment.filter(placement => {
    if (alignment) {
      return getAlignment(placement) === alignment || (autoAlignment ? getOppositeAlignmentPlacement(placement) !== placement : false);
    }
    return true;
  });
}
/**
 * Optimizes the visibility of the floating element by choosing the placement
 * that has the most space available automatically, without needing to specify a
 * preferred placement. Alternative to `flip`.
 * @see https://floating-ui.com/docs/autoPlacement
 */
const autoPlacement = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'autoPlacement',
    options,
    async fn(state) {
      var _middlewareData$autoP, _middlewareData$autoP2, _placementsThatFitOnE;
      const {
        rects,
        middlewareData,
        placement,
        platform,
        elements
      } = state;
      const {
        crossAxis = false,
        alignment,
        allowedPlacements = allPlacements,
        autoAlignment = true,
        ...detectOverflowOptions
      } = options;
      const placements = alignment !== undefined || allowedPlacements === allPlacements ? getPlacementList(alignment || null, autoAlignment, allowedPlacements) : allowedPlacements;
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const currentIndex = ((_middlewareData$autoP = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP.index) || 0;
      const currentPlacement = placements[currentIndex];
      if (currentPlacement == null) {
        return {};
      }
      const {
        main,
        cross
      } = getAlignmentSides(currentPlacement, rects, await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating)));

      // Make `computeCoords` start from the right place.
      if (placement !== currentPlacement) {
        return {
          reset: {
            placement: placements[0]
          }
        };
      }
      const currentOverflows = [overflow[getSide(currentPlacement)], overflow[main], overflow[cross]];
      const allOverflows = [...(((_middlewareData$autoP2 = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP2.overflows) || []), {
        placement: currentPlacement,
        overflows: currentOverflows
      }];
      const nextPlacement = placements[currentIndex + 1];

      // There are more placements to check.
      if (nextPlacement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: nextPlacement
          }
        };
      }
      const placementsSortedByMostSpace = allOverflows.map(d => {
        const alignment = getAlignment(d.placement);
        return [d.placement, alignment && crossAxis ?
        // Check along the mainAxis and main crossAxis side.
        d.overflows.slice(0, 2).reduce((acc, v) => acc + v, 0) :
        // Check only the mainAxis.
        d.overflows[0], d.overflows];
      }).sort((a, b) => a[1] - b[1]);
      const placementsThatFitOnEachSide = placementsSortedByMostSpace.filter(d => d[2].slice(0,
      // Aligned placements should not check their opposite crossAxis
      // side.
      getAlignment(d[0]) ? 2 : 3).every(v => v <= 0));
      const resetPlacement = ((_placementsThatFitOnE = placementsThatFitOnEachSide[0]) == null ? void 0 : _placementsThatFitOnE[0]) || placementsSortedByMostSpace[0][0];
      if (resetPlacement !== placement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: resetPlacement
          }
        };
      }
      return {};
    }
  };
};

function getExpandedPlacements(placement) {
  const oppositePlacement = getOppositePlacement(placement);
  return [getOppositeAlignmentPlacement(placement), oppositePlacement, getOppositeAlignmentPlacement(oppositePlacement)];
}

function getSideList(side, isStart, rtl) {
  const lr = ['left', 'right'];
  const rl = ['right', 'left'];
  const tb = ['top', 'bottom'];
  const bt = ['bottom', 'top'];
  switch (side) {
    case 'top':
    case 'bottom':
      if (rtl) return isStart ? rl : lr;
      return isStart ? lr : rl;
    case 'left':
    case 'right':
      return isStart ? tb : bt;
    default:
      return [];
  }
}
function getOppositeAxisPlacements(placement, flipAlignment, direction, rtl) {
  const alignment = getAlignment(placement);
  let list = getSideList(getSide(placement), direction === 'start', rtl);
  if (alignment) {
    list = list.map(side => side + "-" + alignment);
    if (flipAlignment) {
      list = list.concat(list.map(getOppositeAlignmentPlacement));
    }
  }
  return list;
}

/**
 * Optimizes the visibility of the floating element by flipping the `placement`
 * in order to keep it in view when the preferred placement(s) will overflow the
 * clipping boundary. Alternative to `autoPlacement`.
 * @see https://floating-ui.com/docs/flip
 */
const flip = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'flip',
    options,
    async fn(state) {
      var _middlewareData$flip;
      const {
        placement,
        middlewareData,
        rects,
        initialPlacement,
        platform,
        elements
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true,
        fallbackPlacements: specifiedFallbackPlacements,
        fallbackStrategy = 'bestFit',
        fallbackAxisSideDirection = 'none',
        flipAlignment = true,
        ...detectOverflowOptions
      } = options;
      const side = getSide(placement);
      const isBasePlacement = getSide(initialPlacement) === initialPlacement;
      const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));
      const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [getOppositePlacement(initialPlacement)] : getExpandedPlacements(initialPlacement));
      if (!specifiedFallbackPlacements && fallbackAxisSideDirection !== 'none') {
        fallbackPlacements.push(...getOppositeAxisPlacements(initialPlacement, flipAlignment, fallbackAxisSideDirection, rtl));
      }
      const placements = [initialPlacement, ...fallbackPlacements];
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const overflows = [];
      let overflowsData = ((_middlewareData$flip = middlewareData.flip) == null ? void 0 : _middlewareData$flip.overflows) || [];
      if (checkMainAxis) {
        overflows.push(overflow[side]);
      }
      if (checkCrossAxis) {
        const {
          main,
          cross
        } = getAlignmentSides(placement, rects, rtl);
        overflows.push(overflow[main], overflow[cross]);
      }
      overflowsData = [...overflowsData, {
        placement,
        overflows
      }];

      // One or more sides is overflowing.
      if (!overflows.every(side => side <= 0)) {
        var _middlewareData$flip2, _overflowsData$filter;
        const nextIndex = (((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.index) || 0) + 1;
        const nextPlacement = placements[nextIndex];
        if (nextPlacement) {
          // Try next placement and re-run the lifecycle.
          return {
            data: {
              index: nextIndex,
              overflows: overflowsData
            },
            reset: {
              placement: nextPlacement
            }
          };
        }

        // First, find the candidates that fit on the mainAxis side of overflow,
        // then find the placement that fits the best on the main crossAxis side.
        let resetPlacement = (_overflowsData$filter = overflowsData.filter(d => d.overflows[0] <= 0).sort((a, b) => a.overflows[1] - b.overflows[1])[0]) == null ? void 0 : _overflowsData$filter.placement;

        // Otherwise fallback.
        if (!resetPlacement) {
          switch (fallbackStrategy) {
            case 'bestFit':
              {
                var _overflowsData$map$so;
                const placement = (_overflowsData$map$so = overflowsData.map(d => [d.placement, d.overflows.filter(overflow => overflow > 0).reduce((acc, overflow) => acc + overflow, 0)]).sort((a, b) => a[1] - b[1])[0]) == null ? void 0 : _overflowsData$map$so[0];
                if (placement) {
                  resetPlacement = placement;
                }
                break;
              }
            case 'initialPlacement':
              resetPlacement = initialPlacement;
              break;
          }
        }
        if (placement !== resetPlacement) {
          return {
            reset: {
              placement: resetPlacement
            }
          };
        }
      }
      return {};
    }
  };
};

function getSideOffsets(overflow, rect) {
  return {
    top: overflow.top - rect.height,
    right: overflow.right - rect.width,
    bottom: overflow.bottom - rect.height,
    left: overflow.left - rect.width
  };
}
function isAnySideFullyClipped(overflow) {
  return sides.some(side => overflow[side] >= 0);
}
/**
 * Provides data to hide the floating element in applicable situations, such as
 * when it is not in the same clipping context as the reference element.
 * @see https://floating-ui.com/docs/hide
 */
const hide = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'hide',
    options,
    async fn(state) {
      const {
        strategy = 'referenceHidden',
        ...detectOverflowOptions
      } = options;
      const {
        rects
      } = state;
      switch (strategy) {
        case 'referenceHidden':
          {
            const overflow = await detectOverflow(state, {
              ...detectOverflowOptions,
              elementContext: 'reference'
            });
            const offsets = getSideOffsets(overflow, rects.reference);
            return {
              data: {
                referenceHiddenOffsets: offsets,
                referenceHidden: isAnySideFullyClipped(offsets)
              }
            };
          }
        case 'escaped':
          {
            const overflow = await detectOverflow(state, {
              ...detectOverflowOptions,
              altBoundary: true
            });
            const offsets = getSideOffsets(overflow, rects.floating);
            return {
              data: {
                escapedOffsets: offsets,
                escaped: isAnySideFullyClipped(offsets)
              }
            };
          }
        default:
          {
            return {};
          }
      }
    }
  };
};

function getBoundingRect(rects) {
  const minX = min(...rects.map(rect => rect.left));
  const minY = min(...rects.map(rect => rect.top));
  const maxX = max(...rects.map(rect => rect.right));
  const maxY = max(...rects.map(rect => rect.bottom));
  return {
    x: minX,
    y: minY,
    width: maxX - minX,
    height: maxY - minY
  };
}
function getRectsByLine(rects) {
  const sortedRects = rects.slice().sort((a, b) => a.y - b.y);
  const groups = [];
  let prevRect = null;
  for (let i = 0; i < sortedRects.length; i++) {
    const rect = sortedRects[i];
    if (!prevRect || rect.y - prevRect.y > prevRect.height / 2) {
      groups.push([rect]);
    } else {
      groups[groups.length - 1].push(rect);
    }
    prevRect = rect;
  }
  return groups.map(rect => rectToClientRect(getBoundingRect(rect)));
}
/**
 * Provides improved positioning for inline reference elements that can span
 * over multiple lines, such as hyperlinks or range selections.
 * @see https://floating-ui.com/docs/inline
 */
const inline = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'inline',
    options,
    async fn(state) {
      const {
        placement,
        elements,
        rects,
        platform,
        strategy
      } = state;
      // A MouseEvent's client{X,Y} coords can be up to 2 pixels off a
      // ClientRect's bounds, despite the event listener being triggered. A
      // padding of 2 seems to handle this issue.
      const {
        padding = 2,
        x,
        y
      } = options;
      const nativeClientRects = Array.from((await (platform.getClientRects == null ? void 0 : platform.getClientRects(elements.reference))) || []);
      const clientRects = getRectsByLine(nativeClientRects);
      const fallback = rectToClientRect(getBoundingRect(nativeClientRects));
      const paddingObject = getSideObjectFromPadding(padding);
      function getBoundingClientRect() {
        // There are two rects and they are disjoined.
        if (clientRects.length === 2 && clientRects[0].left > clientRects[1].right && x != null && y != null) {
          // Find the first rect in which the point is fully inside.
          return clientRects.find(rect => x > rect.left - paddingObject.left && x < rect.right + paddingObject.right && y > rect.top - paddingObject.top && y < rect.bottom + paddingObject.bottom) || fallback;
        }

        // There are 2 or more connected rects.
        if (clientRects.length >= 2) {
          if (getMainAxisFromPlacement(placement) === 'x') {
            const firstRect = clientRects[0];
            const lastRect = clientRects[clientRects.length - 1];
            const isTop = getSide(placement) === 'top';
            const top = firstRect.top;
            const bottom = lastRect.bottom;
            const left = isTop ? firstRect.left : lastRect.left;
            const right = isTop ? firstRect.right : lastRect.right;
            const width = right - left;
            const height = bottom - top;
            return {
              top,
              bottom,
              left,
              right,
              width,
              height,
              x: left,
              y: top
            };
          }
          const isLeftSide = getSide(placement) === 'left';
          const maxRight = max(...clientRects.map(rect => rect.right));
          const minLeft = min(...clientRects.map(rect => rect.left));
          const measureRects = clientRects.filter(rect => isLeftSide ? rect.left === minLeft : rect.right === maxRight);
          const top = measureRects[0].top;
          const bottom = measureRects[measureRects.length - 1].bottom;
          const left = minLeft;
          const right = maxRight;
          const width = right - left;
          const height = bottom - top;
          return {
            top,
            bottom,
            left,
            right,
            width,
            height,
            x: left,
            y: top
          };
        }
        return fallback;
      }
      const resetRects = await platform.getElementRects({
        reference: {
          getBoundingClientRect
        },
        floating: elements.floating,
        strategy
      });
      if (rects.reference.x !== resetRects.reference.x || rects.reference.y !== resetRects.reference.y || rects.reference.width !== resetRects.reference.width || rects.reference.height !== resetRects.reference.height) {
        return {
          reset: {
            rects: resetRects
          }
        };
      }
      return {};
    }
  };
};

async function convertValueToCoords(state, value) {
  const {
    placement,
    platform,
    elements
  } = state;
  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));
  const side = getSide(placement);
  const alignment = getAlignment(placement);
  const isVertical = getMainAxisFromPlacement(placement) === 'x';
  const mainAxisMulti = ['left', 'top'].includes(side) ? -1 : 1;
  const crossAxisMulti = rtl && isVertical ? -1 : 1;
  const rawValue = typeof value === 'function' ? value(state) : value;

  // eslint-disable-next-line prefer-const
  let {
    mainAxis,
    crossAxis,
    alignmentAxis
  } = typeof rawValue === 'number' ? {
    mainAxis: rawValue,
    crossAxis: 0,
    alignmentAxis: null
  } : {
    mainAxis: 0,
    crossAxis: 0,
    alignmentAxis: null,
    ...rawValue
  };
  if (alignment && typeof alignmentAxis === 'number') {
    crossAxis = alignment === 'end' ? alignmentAxis * -1 : alignmentAxis;
  }
  return isVertical ? {
    x: crossAxis * crossAxisMulti,
    y: mainAxis * mainAxisMulti
  } : {
    x: mainAxis * mainAxisMulti,
    y: crossAxis * crossAxisMulti
  };
}

/**
 * Modifies the placement by translating the floating element along the
 * specified axes.
 * A number (shorthand for `mainAxis` or distance), or an axes configuration
 * object may be passed.
 * @see https://floating-ui.com/docs/offset
 */
const offset = function (value) {
  if (value === void 0) {
    value = 0;
  }
  return {
    name: 'offset',
    options: value,
    async fn(state) {
      const {
        x,
        y
      } = state;
      const diffCoords = await convertValueToCoords(state, value);
      return {
        x: x + diffCoords.x,
        y: y + diffCoords.y,
        data: diffCoords
      };
    }
  };
};

function getCrossAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}

/**
 * Optimizes the visibility of the floating element by shifting it in order to
 * keep it in view when it will overflow the clipping boundary.
 * @see https://floating-ui.com/docs/shift
 */
const shift = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'shift',
    options,
    async fn(state) {
      const {
        x,
        y,
        placement
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = false,
        limiter = {
          fn: _ref => {
            let {
              x,
              y
            } = _ref;
            return {
              x,
              y
            };
          }
        },
        ...detectOverflowOptions
      } = options;
      const coords = {
        x,
        y
      };
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const mainAxis = getMainAxisFromPlacement(getSide(placement));
      const crossAxis = getCrossAxis(mainAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      if (checkMainAxis) {
        const minSide = mainAxis === 'y' ? 'top' : 'left';
        const maxSide = mainAxis === 'y' ? 'bottom' : 'right';
        const min = mainAxisCoord + overflow[minSide];
        const max = mainAxisCoord - overflow[maxSide];
        mainAxisCoord = within(min, mainAxisCoord, max);
      }
      if (checkCrossAxis) {
        const minSide = crossAxis === 'y' ? 'top' : 'left';
        const maxSide = crossAxis === 'y' ? 'bottom' : 'right';
        const min = crossAxisCoord + overflow[minSide];
        const max = crossAxisCoord - overflow[maxSide];
        crossAxisCoord = within(min, crossAxisCoord, max);
      }
      const limitedCoords = limiter.fn({
        ...state,
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      });
      return {
        ...limitedCoords,
        data: {
          x: limitedCoords.x - x,
          y: limitedCoords.y - y
        }
      };
    }
  };
};
/**
 * Built-in `limiter` that will stop `shift()` at a certain point.
 */
const limitShift = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    options,
    fn(state) {
      const {
        x,
        y,
        placement,
        rects,
        middlewareData
      } = state;
      const {
        offset = 0,
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true
      } = options;
      const coords = {
        x,
        y
      };
      const mainAxis = getMainAxisFromPlacement(placement);
      const crossAxis = getCrossAxis(mainAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      const rawOffset = typeof offset === 'function' ? offset(state) : offset;
      const computedOffset = typeof rawOffset === 'number' ? {
        mainAxis: rawOffset,
        crossAxis: 0
      } : {
        mainAxis: 0,
        crossAxis: 0,
        ...rawOffset
      };
      if (checkMainAxis) {
        const len = mainAxis === 'y' ? 'height' : 'width';
        const limitMin = rects.reference[mainAxis] - rects.floating[len] + computedOffset.mainAxis;
        const limitMax = rects.reference[mainAxis] + rects.reference[len] - computedOffset.mainAxis;
        if (mainAxisCoord < limitMin) {
          mainAxisCoord = limitMin;
        } else if (mainAxisCoord > limitMax) {
          mainAxisCoord = limitMax;
        }
      }
      if (checkCrossAxis) {
        var _middlewareData$offse, _middlewareData$offse2;
        const len = mainAxis === 'y' ? 'width' : 'height';
        const isOriginSide = ['top', 'left'].includes(getSide(placement));
        const limitMin = rects.reference[crossAxis] - rects.floating[len] + (isOriginSide ? ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse[crossAxis]) || 0 : 0) + (isOriginSide ? 0 : computedOffset.crossAxis);
        const limitMax = rects.reference[crossAxis] + rects.reference[len] + (isOriginSide ? 0 : ((_middlewareData$offse2 = middlewareData.offset) == null ? void 0 : _middlewareData$offse2[crossAxis]) || 0) - (isOriginSide ? computedOffset.crossAxis : 0);
        if (crossAxisCoord < limitMin) {
          crossAxisCoord = limitMin;
        } else if (crossAxisCoord > limitMax) {
          crossAxisCoord = limitMax;
        }
      }
      return {
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      };
    }
  };
};

/**
 * Provides data that allows you to change the size of the floating element —
 * for instance, prevent it from overflowing the clipping boundary or match the
 * width of the reference element.
 * @see https://floating-ui.com/docs/size
 */
const size = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'size',
    options,
    async fn(state) {
      const {
        placement,
        rects,
        platform,
        elements
      } = state;
      const {
        apply = () => {},
        ...detectOverflowOptions
      } = options;
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const side = getSide(placement);
      const alignment = getAlignment(placement);
      const axis = getMainAxisFromPlacement(placement);
      const isXAxis = axis === 'x';
      const {
        width,
        height
      } = rects.floating;
      let heightSide;
      let widthSide;
      if (side === 'top' || side === 'bottom') {
        heightSide = side;
        widthSide = alignment === ((await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating))) ? 'start' : 'end') ? 'left' : 'right';
      } else {
        widthSide = side;
        heightSide = alignment === 'end' ? 'top' : 'bottom';
      }
      const overflowAvailableHeight = height - overflow[heightSide];
      const overflowAvailableWidth = width - overflow[widthSide];
      const noShift = !state.middlewareData.shift;
      let availableHeight = overflowAvailableHeight;
      let availableWidth = overflowAvailableWidth;
      if (isXAxis) {
        const maximumClippingWidth = width - overflow.left - overflow.right;
        availableWidth = alignment || noShift ? min(overflowAvailableWidth, maximumClippingWidth) : maximumClippingWidth;
      } else {
        const maximumClippingHeight = height - overflow.top - overflow.bottom;
        availableHeight = alignment || noShift ? min(overflowAvailableHeight, maximumClippingHeight) : maximumClippingHeight;
      }
      if (noShift && !alignment) {
        const xMin = max(overflow.left, 0);
        const xMax = max(overflow.right, 0);
        const yMin = max(overflow.top, 0);
        const yMax = max(overflow.bottom, 0);
        if (isXAxis) {
          availableWidth = width - 2 * (xMin !== 0 || xMax !== 0 ? xMin + xMax : max(overflow.left, overflow.right));
        } else {
          availableHeight = height - 2 * (yMin !== 0 || yMax !== 0 ? yMin + yMax : max(overflow.top, overflow.bottom));
        }
      }
      await apply({
        ...state,
        availableWidth,
        availableHeight
      });
      const nextDimensions = await platform.getDimensions(elements.floating);
      if (width !== nextDimensions.width || height !== nextDimensions.height) {
        return {
          reset: {
            rects: true
          }
        };
      }
      return {};
    }
  };
};




/***/ }),

/***/ "./node_modules/@floating-ui/dom/dist/floating-ui.dom.browser.mjs":
/*!************************************************************************!*\
  !*** ./node_modules/@floating-ui/dom/dist/floating-ui.dom.browser.mjs ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "arrow": () => (/* reexport safe */ _floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.arrow),
/* harmony export */   "autoPlacement": () => (/* reexport safe */ _floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.autoPlacement),
/* harmony export */   "autoUpdate": () => (/* binding */ autoUpdate),
/* harmony export */   "computePosition": () => (/* binding */ computePosition),
/* harmony export */   "detectOverflow": () => (/* reexport safe */ _floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.detectOverflow),
/* harmony export */   "flip": () => (/* reexport safe */ _floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.flip),
/* harmony export */   "getOverflowAncestors": () => (/* binding */ getOverflowAncestors),
/* harmony export */   "hide": () => (/* reexport safe */ _floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.hide),
/* harmony export */   "inline": () => (/* reexport safe */ _floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.inline),
/* harmony export */   "limitShift": () => (/* reexport safe */ _floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.limitShift),
/* harmony export */   "offset": () => (/* reexport safe */ _floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.offset),
/* harmony export */   "platform": () => (/* binding */ platform),
/* harmony export */   "shift": () => (/* reexport safe */ _floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.shift),
/* harmony export */   "size": () => (/* reexport safe */ _floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.size)
/* harmony export */ });
/* harmony import */ var _floating_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @floating-ui/core */ "./node_modules/@floating-ui/core/dist/floating-ui.core.browser.mjs");



function getWindow(node) {
  var _node$ownerDocument;
  return ((_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;
}

function getComputedStyle$1(element) {
  return getWindow(element).getComputedStyle(element);
}

function isNode(value) {
  return value instanceof getWindow(value).Node;
}
function getNodeName(node) {
  return isNode(node) ? (node.nodeName || '').toLowerCase() : '';
}

let uaString;
function getUAString() {
  if (uaString) {
    return uaString;
  }
  const uaData = navigator.userAgentData;
  if (uaData && Array.isArray(uaData.brands)) {
    uaString = uaData.brands.map(item => item.brand + "/" + item.version).join(' ');
    return uaString;
  }
  return navigator.userAgent;
}

function isHTMLElement(value) {
  return value instanceof getWindow(value).HTMLElement;
}
function isElement(value) {
  return value instanceof getWindow(value).Element;
}
function isShadowRoot(node) {
  // Browsers without `ShadowRoot` support.
  if (typeof ShadowRoot === 'undefined') {
    return false;
  }
  const OwnElement = getWindow(node).ShadowRoot;
  return node instanceof OwnElement || node instanceof ShadowRoot;
}
function isOverflowElement(element) {
  const {
    overflow,
    overflowX,
    overflowY,
    display
  } = getComputedStyle$1(element);
  return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !['inline', 'contents'].includes(display);
}
function isTableElement(element) {
  return ['table', 'td', 'th'].includes(getNodeName(element));
}
function isContainingBlock(element) {
  // TODO: Try to use feature detection here instead.
  const isFirefox = /firefox/i.test(getUAString());
  const css = getComputedStyle$1(element);
  const backdropFilter = css.backdropFilter || css.WebkitBackdropFilter;

  // This is non-exhaustive but covers the most common CSS properties that
  // create a containing block.
  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
  return css.transform !== 'none' || css.perspective !== 'none' || (backdropFilter ? backdropFilter !== 'none' : false) || isFirefox && css.willChange === 'filter' || isFirefox && (css.filter ? css.filter !== 'none' : false) || ['transform', 'perspective'].some(value => css.willChange.includes(value)) || ['paint', 'layout', 'strict', 'content'].some(value => {
    // Add type check for old browsers.
    const contain = css.contain;
    return contain != null ? contain.includes(value) : false;
  });
}

/**
 * Determines whether or not `.getBoundingClientRect()` is affected by visual
 * viewport offsets. In Safari, the `x`/`y` offsets are values relative to the
 * visual viewport, while in other engines, they are values relative to the
 * layout viewport.
 */
function isClientRectVisualViewportBased() {
  // TODO: Try to use feature detection here instead. Feature detection for
  // this can fail in various ways, making the userAgent check the most
  // reliable:
  // • Always-visible scrollbar or not
  // • Width of <html>

  // Is Safari.
  return /^((?!chrome|android).)*safari/i.test(getUAString());
}
function isLastTraversableNode(node) {
  return ['html', 'body', '#document'].includes(getNodeName(node));
}

const min = Math.min;
const max = Math.max;
const round = Math.round;

function getCssDimensions(element) {
  const css = getComputedStyle$1(element);
  let width = parseFloat(css.width);
  let height = parseFloat(css.height);
  const hasOffset = isHTMLElement(element);
  const offsetWidth = hasOffset ? element.offsetWidth : width;
  const offsetHeight = hasOffset ? element.offsetHeight : height;
  const shouldFallback = round(width) !== offsetWidth || round(height) !== offsetHeight;
  if (shouldFallback) {
    width = offsetWidth;
    height = offsetHeight;
  }
  return {
    width,
    height,
    fallback: shouldFallback
  };
}

function unwrapElement(element) {
  return !isElement(element) ? element.contextElement : element;
}

const FALLBACK_SCALE = {
  x: 1,
  y: 1
};
function getScale(element) {
  const domElement = unwrapElement(element);
  if (!isHTMLElement(domElement)) {
    return FALLBACK_SCALE;
  }
  const rect = domElement.getBoundingClientRect();
  const {
    width,
    height,
    fallback
  } = getCssDimensions(domElement);
  let x = (fallback ? round(rect.width) : rect.width) / width;
  let y = (fallback ? round(rect.height) : rect.height) / height;

  // 0, NaN, or Infinity should always fallback to 1.

  if (!x || !Number.isFinite(x)) {
    x = 1;
  }
  if (!y || !Number.isFinite(y)) {
    y = 1;
  }
  return {
    x,
    y
  };
}

function getBoundingClientRect(element, includeScale, isFixedStrategy, offsetParent) {
  var _win$visualViewport, _win$visualViewport2;
  if (includeScale === void 0) {
    includeScale = false;
  }
  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }
  const clientRect = element.getBoundingClientRect();
  const domElement = unwrapElement(element);
  let scale = FALLBACK_SCALE;
  if (includeScale) {
    if (offsetParent) {
      if (isElement(offsetParent)) {
        scale = getScale(offsetParent);
      }
    } else {
      scale = getScale(element);
    }
  }
  const win = domElement ? getWindow(domElement) : window;
  const addVisualOffsets = isClientRectVisualViewportBased() && isFixedStrategy;
  let x = (clientRect.left + (addVisualOffsets ? ((_win$visualViewport = win.visualViewport) == null ? void 0 : _win$visualViewport.offsetLeft) || 0 : 0)) / scale.x;
  let y = (clientRect.top + (addVisualOffsets ? ((_win$visualViewport2 = win.visualViewport) == null ? void 0 : _win$visualViewport2.offsetTop) || 0 : 0)) / scale.y;
  let width = clientRect.width / scale.x;
  let height = clientRect.height / scale.y;
  if (domElement) {
    const win = getWindow(domElement);
    const offsetWin = offsetParent && isElement(offsetParent) ? getWindow(offsetParent) : offsetParent;
    let currentIFrame = win.frameElement;
    while (currentIFrame && offsetParent && offsetWin !== win) {
      const iframeScale = getScale(currentIFrame);
      const iframeRect = currentIFrame.getBoundingClientRect();
      const css = getComputedStyle(currentIFrame);
      iframeRect.x += (currentIFrame.clientLeft + parseFloat(css.paddingLeft)) * iframeScale.x;
      iframeRect.y += (currentIFrame.clientTop + parseFloat(css.paddingTop)) * iframeScale.y;
      x *= iframeScale.x;
      y *= iframeScale.y;
      width *= iframeScale.x;
      height *= iframeScale.y;
      x += iframeRect.x;
      y += iframeRect.y;
      currentIFrame = getWindow(currentIFrame).frameElement;
    }
  }
  return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)({
    width,
    height,
    x,
    y
  });
}

function getDocumentElement(node) {
  return ((isNode(node) ? node.ownerDocument : node.document) || window.document).documentElement;
}

function getNodeScroll(element) {
  if (isElement(element)) {
    return {
      scrollLeft: element.scrollLeft,
      scrollTop: element.scrollTop
    };
  }
  return {
    scrollLeft: element.pageXOffset,
    scrollTop: element.pageYOffset
  };
}

function convertOffsetParentRelativeRectToViewportRelativeRect(_ref) {
  let {
    rect,
    offsetParent,
    strategy
  } = _ref;
  const isOffsetParentAnElement = isHTMLElement(offsetParent);
  const documentElement = getDocumentElement(offsetParent);
  if (offsetParent === documentElement) {
    return rect;
  }
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  let scale = {
    x: 1,
    y: 1
  };
  const offsets = {
    x: 0,
    y: 0
  };
  if (isOffsetParentAnElement || !isOffsetParentAnElement && strategy !== 'fixed') {
    if (getNodeName(offsetParent) !== 'body' || isOverflowElement(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }
    if (isHTMLElement(offsetParent)) {
      const offsetRect = getBoundingClientRect(offsetParent);
      scale = getScale(offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    }
  }
  return {
    width: rect.width * scale.x,
    height: rect.height * scale.y,
    x: rect.x * scale.x - scroll.scrollLeft * scale.x + offsets.x,
    y: rect.y * scale.y - scroll.scrollTop * scale.y + offsets.y
  };
}

function getWindowScrollBarX(element) {
  // If <html> has a CSS width greater than the viewport, then this will be
  // incorrect for RTL.
  return getBoundingClientRect(getDocumentElement(element)).left + getNodeScroll(element).scrollLeft;
}

// Gets the entire size of the scrollable document area, even extending outside
// of the `<html>` and `<body>` rect bounds if horizontally scrollable.
function getDocumentRect(element) {
  const html = getDocumentElement(element);
  const scroll = getNodeScroll(element);
  const body = element.ownerDocument.body;
  const width = max(html.scrollWidth, html.clientWidth, body.scrollWidth, body.clientWidth);
  const height = max(html.scrollHeight, html.clientHeight, body.scrollHeight, body.clientHeight);
  let x = -scroll.scrollLeft + getWindowScrollBarX(element);
  const y = -scroll.scrollTop;
  if (getComputedStyle$1(body).direction === 'rtl') {
    x += max(html.clientWidth, body.clientWidth) - width;
  }
  return {
    width,
    height,
    x,
    y
  };
}

function getParentNode(node) {
  if (getNodeName(node) === 'html') {
    return node;
  }
  const result =
  // Step into the shadow DOM of the parent of a slotted node.
  node.assignedSlot ||
  // DOM Element detected.
  node.parentNode ||
  // ShadowRoot detected.
  isShadowRoot(node) && node.host ||
  // Fallback.
  getDocumentElement(node);
  return isShadowRoot(result) ? result.host : result;
}

function getNearestOverflowAncestor(node) {
  const parentNode = getParentNode(node);
  if (isLastTraversableNode(parentNode)) {
    // `getParentNode` will never return a `Document` due to the fallback
    // check, so it's either the <html> or <body> element.
    return parentNode.ownerDocument.body;
  }
  if (isHTMLElement(parentNode) && isOverflowElement(parentNode)) {
    return parentNode;
  }
  return getNearestOverflowAncestor(parentNode);
}

function getOverflowAncestors(node, list) {
  var _node$ownerDocument;
  if (list === void 0) {
    list = [];
  }
  const scrollableAncestor = getNearestOverflowAncestor(node);
  const isBody = scrollableAncestor === ((_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.body);
  const win = getWindow(scrollableAncestor);
  if (isBody) {
    return list.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : []);
  }
  return list.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor));
}

function getViewportRect(element, strategy) {
  const win = getWindow(element);
  const html = getDocumentElement(element);
  const visualViewport = win.visualViewport;
  let width = html.clientWidth;
  let height = html.clientHeight;
  let x = 0;
  let y = 0;
  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    const visualViewportBased = isClientRectVisualViewportBased();
    if (!visualViewportBased || visualViewportBased && strategy === 'fixed') {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }
  return {
    width,
    height,
    x,
    y
  };
}

// Returns the inner client rect, subtracting scrollbars if present.
function getInnerBoundingClientRect(element, strategy) {
  const clientRect = getBoundingClientRect(element, true, strategy === 'fixed');
  const top = clientRect.top + element.clientTop;
  const left = clientRect.left + element.clientLeft;
  const scale = isHTMLElement(element) ? getScale(element) : {
    x: 1,
    y: 1
  };
  const width = element.clientWidth * scale.x;
  const height = element.clientHeight * scale.y;
  const x = left * scale.x;
  const y = top * scale.y;
  return {
    width,
    height,
    x,
    y
  };
}
function getClientRectFromClippingAncestor(element, clippingAncestor, strategy) {
  let rect;
  if (clippingAncestor === 'viewport') {
    rect = getViewportRect(element, strategy);
  } else if (clippingAncestor === 'document') {
    rect = getDocumentRect(getDocumentElement(element));
  } else if (isElement(clippingAncestor)) {
    rect = getInnerBoundingClientRect(clippingAncestor, strategy);
  } else {
    const mutableRect = {
      ...clippingAncestor
    };
    if (isClientRectVisualViewportBased()) {
      var _win$visualViewport, _win$visualViewport2;
      const win = getWindow(element);
      mutableRect.x -= ((_win$visualViewport = win.visualViewport) == null ? void 0 : _win$visualViewport.offsetLeft) || 0;
      mutableRect.y -= ((_win$visualViewport2 = win.visualViewport) == null ? void 0 : _win$visualViewport2.offsetTop) || 0;
    }
    rect = mutableRect;
  }
  return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(rect);
}
function hasFixedPositionAncestor(element, stopNode) {
  const parentNode = getParentNode(element);
  if (parentNode === stopNode || !isElement(parentNode) || isLastTraversableNode(parentNode)) {
    return false;
  }
  return getComputedStyle$1(parentNode).position === 'fixed' || hasFixedPositionAncestor(parentNode, stopNode);
}

// A "clipping ancestor" is an `overflow` element with the characteristic of
// clipping (or hiding) child elements. This returns all clipping ancestors
// of the given element up the tree.
function getClippingElementAncestors(element, cache) {
  const cachedResult = cache.get(element);
  if (cachedResult) {
    return cachedResult;
  }
  let result = getOverflowAncestors(element).filter(el => isElement(el) && getNodeName(el) !== 'body');
  let currentContainingBlockComputedStyle = null;
  const elementIsFixed = getComputedStyle$1(element).position === 'fixed';
  let currentNode = elementIsFixed ? getParentNode(element) : element;

  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
  while (isElement(currentNode) && !isLastTraversableNode(currentNode)) {
    const computedStyle = getComputedStyle$1(currentNode);
    const currentNodeIsContaining = isContainingBlock(currentNode);
    if (!currentNodeIsContaining && computedStyle.position === 'fixed') {
      currentContainingBlockComputedStyle = null;
    }
    const shouldDropCurrentNode = elementIsFixed ? !currentNodeIsContaining && !currentContainingBlockComputedStyle : !currentNodeIsContaining && computedStyle.position === 'static' && !!currentContainingBlockComputedStyle && ['absolute', 'fixed'].includes(currentContainingBlockComputedStyle.position) || isOverflowElement(currentNode) && !currentNodeIsContaining && hasFixedPositionAncestor(element, currentNode);
    if (shouldDropCurrentNode) {
      // Drop non-containing blocks.
      result = result.filter(ancestor => ancestor !== currentNode);
    } else {
      // Record last containing block for next iteration.
      currentContainingBlockComputedStyle = computedStyle;
    }
    currentNode = getParentNode(currentNode);
  }
  cache.set(element, result);
  return result;
}

// Gets the maximum area that the element is visible in due to any number of
// clipping ancestors.
function getClippingRect(_ref) {
  let {
    element,
    boundary,
    rootBoundary,
    strategy
  } = _ref;
  const elementClippingAncestors = boundary === 'clippingAncestors' ? getClippingElementAncestors(element, this._c) : [].concat(boundary);
  const clippingAncestors = [...elementClippingAncestors, rootBoundary];
  const firstClippingAncestor = clippingAncestors[0];
  const clippingRect = clippingAncestors.reduce((accRect, clippingAncestor) => {
    const rect = getClientRectFromClippingAncestor(element, clippingAncestor, strategy);
    accRect.top = max(rect.top, accRect.top);
    accRect.right = min(rect.right, accRect.right);
    accRect.bottom = min(rect.bottom, accRect.bottom);
    accRect.left = max(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromClippingAncestor(element, firstClippingAncestor, strategy));
  return {
    width: clippingRect.right - clippingRect.left,
    height: clippingRect.bottom - clippingRect.top,
    x: clippingRect.left,
    y: clippingRect.top
  };
}

function getDimensions(element) {
  return getCssDimensions(element);
}

function getTrueOffsetParent(element, polyfill) {
  if (!isHTMLElement(element) || getComputedStyle$1(element).position === 'fixed') {
    return null;
  }
  if (polyfill) {
    return polyfill(element);
  }
  return element.offsetParent;
}
function getContainingBlock(element) {
  let currentNode = getParentNode(element);
  while (isHTMLElement(currentNode) && !isLastTraversableNode(currentNode)) {
    if (isContainingBlock(currentNode)) {
      return currentNode;
    } else {
      currentNode = getParentNode(currentNode);
    }
  }
  return null;
}

// Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.
function getOffsetParent(element, polyfill) {
  const window = getWindow(element);
  if (!isHTMLElement(element)) {
    return window;
  }
  let offsetParent = getTrueOffsetParent(element, polyfill);
  while (offsetParent && isTableElement(offsetParent) && getComputedStyle$1(offsetParent).position === 'static') {
    offsetParent = getTrueOffsetParent(offsetParent, polyfill);
  }
  if (offsetParent && (getNodeName(offsetParent) === 'html' || getNodeName(offsetParent) === 'body' && getComputedStyle$1(offsetParent).position === 'static' && !isContainingBlock(offsetParent))) {
    return window;
  }
  return offsetParent || getContainingBlock(element) || window;
}

function getRectRelativeToOffsetParent(element, offsetParent, strategy) {
  const isOffsetParentAnElement = isHTMLElement(offsetParent);
  const documentElement = getDocumentElement(offsetParent);
  const rect = getBoundingClientRect(element, true, strategy === 'fixed', offsetParent);
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const offsets = {
    x: 0,
    y: 0
  };
  if (isOffsetParentAnElement || !isOffsetParentAnElement && strategy !== 'fixed') {
    if (getNodeName(offsetParent) !== 'body' || isOverflowElement(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }
    if (isHTMLElement(offsetParent)) {
      const offsetRect = getBoundingClientRect(offsetParent, true);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = getWindowScrollBarX(documentElement);
    }
  }
  return {
    x: rect.left + scroll.scrollLeft - offsets.x,
    y: rect.top + scroll.scrollTop - offsets.y,
    width: rect.width,
    height: rect.height
  };
}

const platform = {
  getClippingRect,
  convertOffsetParentRelativeRectToViewportRelativeRect,
  isElement,
  getDimensions,
  getOffsetParent,
  getDocumentElement,
  getScale,
  async getElementRects(_ref) {
    let {
      reference,
      floating,
      strategy
    } = _ref;
    const getOffsetParentFn = this.getOffsetParent || getOffsetParent;
    const getDimensionsFn = this.getDimensions;
    return {
      reference: getRectRelativeToOffsetParent(reference, await getOffsetParentFn(floating), strategy),
      floating: {
        x: 0,
        y: 0,
        ...(await getDimensionsFn(floating))
      }
    };
  },
  getClientRects: element => Array.from(element.getClientRects()),
  isRTL: element => getComputedStyle$1(element).direction === 'rtl'
};

/**
 * Automatically updates the position of the floating element when necessary.
 * Should only be called when the floating element is mounted on the DOM or
 * visible on the screen.
 * @returns cleanup function that should be invoked when the floating element is
 * removed from the DOM or hidden from the screen.
 * @see https://floating-ui.com/docs/autoUpdate
 */
function autoUpdate(reference, floating, update, options) {
  if (options === void 0) {
    options = {};
  }
  const {
    ancestorScroll = true,
    ancestorResize = true,
    elementResize = true,
    animationFrame = false
  } = options;
  const ancestors = ancestorScroll || ancestorResize ? [...(isElement(reference) ? getOverflowAncestors(reference) : reference.contextElement ? getOverflowAncestors(reference.contextElement) : []), ...getOverflowAncestors(floating)] : [];
  ancestors.forEach(ancestor => {
    // ignores Window, checks for [object VisualViewport]
    const isVisualViewport = !isElement(ancestor) && ancestor.toString().includes('V');
    if (ancestorScroll && (animationFrame ? isVisualViewport : true)) {
      ancestor.addEventListener('scroll', update, {
        passive: true
      });
    }
    ancestorResize && ancestor.addEventListener('resize', update);
  });
  let observer = null;
  if (elementResize) {
    observer = new ResizeObserver(() => {
      update();
    });
    isElement(reference) && !animationFrame && observer.observe(reference);
    if (!isElement(reference) && reference.contextElement && !animationFrame) {
      observer.observe(reference.contextElement);
    }
    observer.observe(floating);
  }
  let frameId;
  let prevRefRect = animationFrame ? getBoundingClientRect(reference) : null;
  if (animationFrame) {
    frameLoop();
  }
  function frameLoop() {
    const nextRefRect = getBoundingClientRect(reference);
    if (prevRefRect && (nextRefRect.x !== prevRefRect.x || nextRefRect.y !== prevRefRect.y || nextRefRect.width !== prevRefRect.width || nextRefRect.height !== prevRefRect.height)) {
      update();
    }
    prevRefRect = nextRefRect;
    frameId = requestAnimationFrame(frameLoop);
  }
  update();
  return () => {
    var _observer;
    ancestors.forEach(ancestor => {
      ancestorScroll && ancestor.removeEventListener('scroll', update);
      ancestorResize && ancestor.removeEventListener('resize', update);
    });
    (_observer = observer) == null ? void 0 : _observer.disconnect();
    observer = null;
    if (animationFrame) {
      cancelAnimationFrame(frameId);
    }
  };
}

/**
 * Computes the `x` and `y` coordinates that will place the floating element
 * next to a reference element when it is given a certain CSS positioning
 * strategy.
 */
const computePosition = (reference, floating, options) => {
  // This caches the expensive `getClippingElementAncestors` function so that
  // multiple lifecycle resets re-use the same result. It only lives for a
  // single call. If other functions become expensive, we can add them as well.
  const cache = new Map();
  const mergedOptions = {
    platform,
    ...options
  };
  const platformWithCache = {
    ...mergedOptions.platform,
    _c: cache
  };
  return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.computePosition)(reference, floating, {
    ...mergedOptions,
    platform: platformWithCache
  });
};




/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/extends.js":
/*!************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/extends.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _extends)
/* harmony export */ });
function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/objectWithoutPropertiesLoose.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/objectWithoutPropertiesLoose.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _objectWithoutPropertiesLoose)
/* harmony export */ });
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}

/***/ }),

/***/ "./node_modules/@emotion/cache/dist/emotion-cache.browser.esm.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@emotion/cache/dist/emotion-cache.browser.esm.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createCache)
/* harmony export */ });
/* harmony import */ var _emotion_sheet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/sheet */ "./node_modules/@emotion/sheet/dist/emotion-sheet.browser.esm.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! stylis */ "./node_modules/stylis/src/Tokenizer.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! stylis */ "./node_modules/stylis/src/Utility.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! stylis */ "./node_modules/stylis/src/Enum.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! stylis */ "./node_modules/stylis/src/Serializer.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! stylis */ "./node_modules/stylis/src/Middleware.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! stylis */ "./node_modules/stylis/src/Parser.js");
/* harmony import */ var _emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/weak-memoize */ "./node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js");
/* harmony import */ var _emotion_memoize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/memoize */ "./node_modules/@emotion/memoize/dist/emotion-memoize.esm.js");





var identifierWithPointTracking = function identifierWithPointTracking(begin, points, index) {
  var previous = 0;
  var character = 0;

  while (true) {
    previous = character;
    character = (0,stylis__WEBPACK_IMPORTED_MODULE_3__.peek)(); // &\f

    if (previous === 38 && character === 12) {
      points[index] = 1;
    }

    if ((0,stylis__WEBPACK_IMPORTED_MODULE_3__.token)(character)) {
      break;
    }

    (0,stylis__WEBPACK_IMPORTED_MODULE_3__.next)();
  }

  return (0,stylis__WEBPACK_IMPORTED_MODULE_3__.slice)(begin, stylis__WEBPACK_IMPORTED_MODULE_3__.position);
};

var toRules = function toRules(parsed, points) {
  // pretend we've started with a comma
  var index = -1;
  var character = 44;

  do {
    switch ((0,stylis__WEBPACK_IMPORTED_MODULE_3__.token)(character)) {
      case 0:
        // &\f
        if (character === 38 && (0,stylis__WEBPACK_IMPORTED_MODULE_3__.peek)() === 12) {
          // this is not 100% correct, we don't account for literal sequences here - like for example quoted strings
          // stylis inserts \f after & to know when & where it should replace this sequence with the context selector
          // and when it should just concatenate the outer and inner selectors
          // it's very unlikely for this sequence to actually appear in a different context, so we just leverage this fact here
          points[index] = 1;
        }

        parsed[index] += identifierWithPointTracking(stylis__WEBPACK_IMPORTED_MODULE_3__.position - 1, points, index);
        break;

      case 2:
        parsed[index] += (0,stylis__WEBPACK_IMPORTED_MODULE_3__.delimit)(character);
        break;

      case 4:
        // comma
        if (character === 44) {
          // colon
          parsed[++index] = (0,stylis__WEBPACK_IMPORTED_MODULE_3__.peek)() === 58 ? '&\f' : '';
          points[index] = parsed[index].length;
          break;
        }

      // fallthrough

      default:
        parsed[index] += (0,stylis__WEBPACK_IMPORTED_MODULE_4__.from)(character);
    }
  } while (character = (0,stylis__WEBPACK_IMPORTED_MODULE_3__.next)());

  return parsed;
};

var getRules = function getRules(value, points) {
  return (0,stylis__WEBPACK_IMPORTED_MODULE_3__.dealloc)(toRules((0,stylis__WEBPACK_IMPORTED_MODULE_3__.alloc)(value), points));
}; // WeakSet would be more appropriate, but only WeakMap is supported in IE11


var fixedElements = /* #__PURE__ */new WeakMap();
var compat = function compat(element) {
  if (element.type !== 'rule' || !element.parent || // positive .length indicates that this rule contains pseudo
  // negative .length indicates that this rule has been already prefixed
  element.length < 1) {
    return;
  }

  var value = element.value,
      parent = element.parent;
  var isImplicitRule = element.column === parent.column && element.line === parent.line;

  while (parent.type !== 'rule') {
    parent = parent.parent;
    if (!parent) return;
  } // short-circuit for the simplest case


  if (element.props.length === 1 && value.charCodeAt(0) !== 58
  /* colon */
  && !fixedElements.get(parent)) {
    return;
  } // if this is an implicitly inserted rule (the one eagerly inserted at the each new nested level)
  // then the props has already been manipulated beforehand as they that array is shared between it and its "rule parent"


  if (isImplicitRule) {
    return;
  }

  fixedElements.set(element, true);
  var points = [];
  var rules = getRules(value, points);
  var parentRules = parent.props;

  for (var i = 0, k = 0; i < rules.length; i++) {
    for (var j = 0; j < parentRules.length; j++, k++) {
      element.props[k] = points[i] ? rules[i].replace(/&\f/g, parentRules[j]) : parentRules[j] + " " + rules[i];
    }
  }
};
var removeLabel = function removeLabel(element) {
  if (element.type === 'decl') {
    var value = element.value;

    if ( // charcode for l
    value.charCodeAt(0) === 108 && // charcode for b
    value.charCodeAt(2) === 98) {
      // this ignores label
      element["return"] = '';
      element.value = '';
    }
  }
};
var ignoreFlag = 'emotion-disable-server-rendering-unsafe-selector-warning-please-do-not-use-this-the-warning-exists-for-a-reason';

var isIgnoringComment = function isIgnoringComment(element) {
  return element.type === 'comm' && element.children.indexOf(ignoreFlag) > -1;
};

var createUnsafeSelectorsAlarm = function createUnsafeSelectorsAlarm(cache) {
  return function (element, index, children) {
    if (element.type !== 'rule' || cache.compat) return;
    var unsafePseudoClasses = element.value.match(/(:first|:nth|:nth-last)-child/g);

    if (unsafePseudoClasses) {
      var isNested = !!element.parent; // in nested rules comments become children of the "auto-inserted" rule and that's always the `element.parent`
      //
      // considering this input:
      // .a {
      //   .b /* comm */ {}
      //   color: hotpink;
      // }
      // we get output corresponding to this:
      // .a {
      //   & {
      //     /* comm */
      //     color: hotpink;
      //   }
      //   .b {}
      // }

      var commentContainer = isNested ? element.parent.children : // global rule at the root level
      children;

      for (var i = commentContainer.length - 1; i >= 0; i--) {
        var node = commentContainer[i];

        if (node.line < element.line) {
          break;
        } // it is quite weird but comments are *usually* put at `column: element.column - 1`
        // so we seek *from the end* for the node that is earlier than the rule's `element` and check that
        // this will also match inputs like this:
        // .a {
        //   /* comm */
        //   .b {}
        // }
        //
        // but that is fine
        //
        // it would be the easiest to change the placement of the comment to be the first child of the rule:
        // .a {
        //   .b { /* comm */ }
        // }
        // with such inputs we wouldn't have to search for the comment at all
        // TODO: consider changing this comment placement in the next major version


        if (node.column < element.column) {
          if (isIgnoringComment(node)) {
            return;
          }

          break;
        }
      }

      unsafePseudoClasses.forEach(function (unsafePseudoClass) {
        console.error("The pseudo class \"" + unsafePseudoClass + "\" is potentially unsafe when doing server-side rendering. Try changing it to \"" + unsafePseudoClass.split('-child')[0] + "-of-type\".");
      });
    }
  };
};

var isImportRule = function isImportRule(element) {
  return element.type.charCodeAt(1) === 105 && element.type.charCodeAt(0) === 64;
};

var isPrependedWithRegularRules = function isPrependedWithRegularRules(index, children) {
  for (var i = index - 1; i >= 0; i--) {
    if (!isImportRule(children[i])) {
      return true;
    }
  }

  return false;
}; // use this to remove incorrect elements from further processing
// so they don't get handed to the `sheet` (or anything else)
// as that could potentially lead to additional logs which in turn could be overhelming to the user


var nullifyElement = function nullifyElement(element) {
  element.type = '';
  element.value = '';
  element["return"] = '';
  element.children = '';
  element.props = '';
};

var incorrectImportAlarm = function incorrectImportAlarm(element, index, children) {
  if (!isImportRule(element)) {
    return;
  }

  if (element.parent) {
    console.error("`@import` rules can't be nested inside other rules. Please move it to the top level and put it before regular rules. Keep in mind that they can only be used within global styles.");
    nullifyElement(element);
  } else if (isPrependedWithRegularRules(index, children)) {
    console.error("`@import` rules can't be after other rules. Please put your `@import` rules before your other rules.");
    nullifyElement(element);
  }
};

/* eslint-disable no-fallthrough */

function prefix(value, length) {
  switch ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.hash)(value, length)) {
    // color-adjust
    case 5103:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + 'print-' + value + value;
    // animation, animation-(delay|direction|duration|fill-mode|iteration-count|name|play-state|timing-function)

    case 5737:
    case 4201:
    case 3177:
    case 3433:
    case 1641:
    case 4457:
    case 2921: // text-decoration, filter, clip-path, backface-visibility, column, box-decoration-break

    case 5572:
    case 6356:
    case 5844:
    case 3191:
    case 6645:
    case 3005: // mask, mask-image, mask-(mode|clip|size), mask-(repeat|origin), mask-position, mask-composite,

    case 6391:
    case 5879:
    case 5623:
    case 6135:
    case 4599:
    case 4855: // background-clip, columns, column-(count|fill|gap|rule|rule-color|rule-style|rule-width|span|width)

    case 4215:
    case 6389:
    case 5109:
    case 5365:
    case 5621:
    case 3829:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + value;
    // appearance, user-select, transform, hyphens, text-size-adjust

    case 5349:
    case 4246:
    case 4810:
    case 6968:
    case 2756:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MOZ + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + value + value;
    // flex, flex-direction

    case 6828:
    case 4268:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + value + value;
    // order

    case 6165:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + 'flex-' + value + value;
    // align-items

    case 5187:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /(\w+).+(:[^]+)/, stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + 'box-$1$2' + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + 'flex-$1$2') + value;
    // align-self

    case 5443:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + 'flex-item-' + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /flex-|-self/, '') + value;
    // align-content

    case 4675:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + 'flex-line-pack' + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /align-content|flex-|-self/, '') + value;
    // flex-shrink

    case 5548:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, 'shrink', 'negative') + value;
    // flex-basis

    case 5292:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, 'basis', 'preferred-size') + value;
    // flex-grow

    case 6060:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + 'box-' + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, '-grow', '') + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, 'grow', 'positive') + value;
    // transition

    case 4554:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /([^-])(transform)/g, '$1' + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + '$2') + value;
    // cursor

    case 6187:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)((0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)((0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /(zoom-|grab)/, stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + '$1'), /(image-set)/, stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + '$1'), value, '') + value;
    // background, background-image

    case 5495:
    case 3959:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /(image-set\([^]*)/, stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + '$1' + '$`$1');
    // justify-content

    case 4968:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)((0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /(.+:)(flex-)?(.*)/, stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + 'box-pack:$3' + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + 'flex-pack:$3'), /s.+-b[^;]+/, 'justify') + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + value;
    // (margin|padding)-inline-(start|end)

    case 4095:
    case 3583:
    case 4068:
    case 2532:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /(.+)-inline(.+)/, stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + '$1$2') + value;
    // (min|max)?(width|height|inline-size|block-size)

    case 8116:
    case 7059:
    case 5753:
    case 5535:
    case 5445:
    case 5701:
    case 4933:
    case 4677:
    case 5533:
    case 5789:
    case 5021:
    case 4765:
      // stretch, max-content, min-content, fill-available
      if ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.strlen)(value) - 1 - length > 6) switch ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.charat)(value, length + 1)) {
        // (m)ax-content, (m)in-content
        case 109:
          // -
          if ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.charat)(value, length + 4) !== 45) break;
        // (f)ill-available, (f)it-content

        case 102:
          return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /(.+:)(.+)-([^]+)/, '$1' + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + '$2-$3' + '$1' + stylis__WEBPACK_IMPORTED_MODULE_5__.MOZ + ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.charat)(value, length + 3) == 108 ? '$3' : '$2-$3')) + value;
        // (s)tretch

        case 115:
          return ~(0,stylis__WEBPACK_IMPORTED_MODULE_4__.indexof)(value, 'stretch') ? prefix((0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, 'stretch', 'fill-available'), length) + value : value;
      }
      break;
    // position: sticky

    case 4949:
      // (s)ticky?
      if ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.charat)(value, length + 1) !== 115) break;
    // display: (flex|inline-flex)

    case 6444:
      switch ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.charat)(value, (0,stylis__WEBPACK_IMPORTED_MODULE_4__.strlen)(value) - 3 - (~(0,stylis__WEBPACK_IMPORTED_MODULE_4__.indexof)(value, '!important') && 10))) {
        // stic(k)y
        case 107:
          return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, ':', ':' + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT) + value;
        // (inline-)?fl(e)x

        case 101:
          return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /(.+:)([^;!]+)(;|!.+)?/, '$1' + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.charat)(value, 14) === 45 ? 'inline-' : '') + 'box$3' + '$1' + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + '$2$3' + '$1' + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + '$2box$3') + value;
      }

      break;
    // writing-mode

    case 5936:
      switch ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.charat)(value, length + 11)) {
        // vertical-l(r)
        case 114:
          return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /[svh]\w+-[tblr]{2}/, 'tb') + value;
        // vertical-r(l)

        case 108:
          return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /[svh]\w+-[tblr]{2}/, 'tb-rl') + value;
        // horizontal(-)tb

        case 45:
          return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /[svh]\w+-[tblr]{2}/, 'lr') + value;
      }

      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + value + value;
  }

  return value;
}

var prefixer = function prefixer(element, index, children, callback) {
  if (element.length > -1) if (!element["return"]) switch (element.type) {
    case stylis__WEBPACK_IMPORTED_MODULE_5__.DECLARATION:
      element["return"] = prefix(element.value, element.length);
      break;

    case stylis__WEBPACK_IMPORTED_MODULE_5__.KEYFRAMES:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_6__.serialize)([(0,stylis__WEBPACK_IMPORTED_MODULE_3__.copy)(element, {
        value: (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(element.value, '@', '@' + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT)
      })], callback);

    case stylis__WEBPACK_IMPORTED_MODULE_5__.RULESET:
      if (element.length) return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.combine)(element.props, function (value) {
        switch ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.match)(value, /(::plac\w+|:read-\w+)/)) {
          // :read-(only|write)
          case ':read-only':
          case ':read-write':
            return (0,stylis__WEBPACK_IMPORTED_MODULE_6__.serialize)([(0,stylis__WEBPACK_IMPORTED_MODULE_3__.copy)(element, {
              props: [(0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /:(read-\w+)/, ':' + stylis__WEBPACK_IMPORTED_MODULE_5__.MOZ + '$1')]
            })], callback);
          // :placeholder

          case '::placeholder':
            return (0,stylis__WEBPACK_IMPORTED_MODULE_6__.serialize)([(0,stylis__WEBPACK_IMPORTED_MODULE_3__.copy)(element, {
              props: [(0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /:(plac\w+)/, ':' + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + 'input-$1')]
            }), (0,stylis__WEBPACK_IMPORTED_MODULE_3__.copy)(element, {
              props: [(0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /:(plac\w+)/, ':' + stylis__WEBPACK_IMPORTED_MODULE_5__.MOZ + '$1')]
            }), (0,stylis__WEBPACK_IMPORTED_MODULE_3__.copy)(element, {
              props: [(0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /:(plac\w+)/, stylis__WEBPACK_IMPORTED_MODULE_5__.MS + 'input-$1')]
            })], callback);
        }

        return '';
      });
  }
};

var defaultStylisPlugins = [prefixer];

var createCache = function createCache(options) {
  var key = options.key;

  if ( true && !key) {
    throw new Error("You have to configure `key` for your cache. Please make sure it's unique (and not equal to 'css') as it's used for linking styles to your cache.\n" + "If multiple caches share the same key they might \"fight\" for each other's style elements.");
  }

  if (key === 'css') {
    var ssrStyles = document.querySelectorAll("style[data-emotion]:not([data-s])"); // get SSRed styles out of the way of React's hydration
    // document.head is a safe place to move them to(though note document.head is not necessarily the last place they will be)
    // note this very very intentionally targets all style elements regardless of the key to ensure
    // that creating a cache works inside of render of a React component

    Array.prototype.forEach.call(ssrStyles, function (node) {
      // we want to only move elements which have a space in the data-emotion attribute value
      // because that indicates that it is an Emotion 11 server-side rendered style elements
      // while we will already ignore Emotion 11 client-side inserted styles because of the :not([data-s]) part in the selector
      // Emotion 10 client-side inserted styles did not have data-s (but importantly did not have a space in their data-emotion attributes)
      // so checking for the space ensures that loading Emotion 11 after Emotion 10 has inserted some styles
      // will not result in the Emotion 10 styles being destroyed
      var dataEmotionAttribute = node.getAttribute('data-emotion');

      if (dataEmotionAttribute.indexOf(' ') === -1) {
        return;
      }
      document.head.appendChild(node);
      node.setAttribute('data-s', '');
    });
  }

  var stylisPlugins = options.stylisPlugins || defaultStylisPlugins;

  if (true) {
    // $FlowFixMe
    if (/[^a-z-]/.test(key)) {
      throw new Error("Emotion key must only contain lower case alphabetical characters and - but \"" + key + "\" was passed");
    }
  }

  var inserted = {};
  var container;
  var nodesToHydrate = [];

  {
    container = options.container || document.head;
    Array.prototype.forEach.call( // this means we will ignore elements which don't have a space in them which
    // means that the style elements we're looking at are only Emotion 11 server-rendered style elements
    document.querySelectorAll("style[data-emotion^=\"" + key + " \"]"), function (node) {
      var attrib = node.getAttribute("data-emotion").split(' '); // $FlowFixMe

      for (var i = 1; i < attrib.length; i++) {
        inserted[attrib[i]] = true;
      }

      nodesToHydrate.push(node);
    });
  }

  var _insert;

  var omnipresentPlugins = [compat, removeLabel];

  if (true) {
    omnipresentPlugins.push(createUnsafeSelectorsAlarm({
      get compat() {
        return cache.compat;
      }

    }), incorrectImportAlarm);
  }

  {
    var currentSheet;
    var finalizingPlugins = [stylis__WEBPACK_IMPORTED_MODULE_6__.stringify,  true ? function (element) {
      if (!element.root) {
        if (element["return"]) {
          currentSheet.insert(element["return"]);
        } else if (element.value && element.type !== stylis__WEBPACK_IMPORTED_MODULE_5__.COMMENT) {
          // insert empty rule in non-production environments
          // so @emotion/jest can grab `key` from the (JS)DOM for caches without any rules inserted yet
          currentSheet.insert(element.value + "{}");
        }
      }
    } : 0];
    var serializer = (0,stylis__WEBPACK_IMPORTED_MODULE_7__.middleware)(omnipresentPlugins.concat(stylisPlugins, finalizingPlugins));

    var stylis = function stylis(styles) {
      return (0,stylis__WEBPACK_IMPORTED_MODULE_6__.serialize)((0,stylis__WEBPACK_IMPORTED_MODULE_8__.compile)(styles), serializer);
    };

    _insert = function insert(selector, serialized, sheet, shouldCache) {
      currentSheet = sheet;

      if ( true && serialized.map !== undefined) {
        currentSheet = {
          insert: function insert(rule) {
            sheet.insert(rule + serialized.map);
          }
        };
      }

      stylis(selector ? selector + "{" + serialized.styles + "}" : serialized.styles);

      if (shouldCache) {
        cache.inserted[serialized.name] = true;
      }
    };
  }

  var cache = {
    key: key,
    sheet: new _emotion_sheet__WEBPACK_IMPORTED_MODULE_0__.StyleSheet({
      key: key,
      container: container,
      nonce: options.nonce,
      speedy: options.speedy,
      prepend: options.prepend,
      insertionPoint: options.insertionPoint
    }),
    nonce: options.nonce,
    inserted: inserted,
    registered: {},
    insert: _insert
  };
  cache.sheet.hydrate(nodesToHydrate);
  return cache;
};




/***/ }),

/***/ "./node_modules/@emotion/hash/dist/emotion-hash.esm.js":
/*!*************************************************************!*\
  !*** ./node_modules/@emotion/hash/dist/emotion-hash.esm.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ murmur2)
/* harmony export */ });
/* eslint-disable */
// Inspired by https://github.com/garycourt/murmurhash-js
// Ported from https://github.com/aappleby/smhasher/blob/61a0530f28277f2e850bfc39600ce61d02b518de/src/MurmurHash2.cpp#L37-L86
function murmur2(str) {
  // 'm' and 'r' are mixing constants generated offline.
  // They're not really 'magic', they just happen to work well.
  // const m = 0x5bd1e995;
  // const r = 24;
  // Initialize the hash
  var h = 0; // Mix 4 bytes at a time into the hash

  var k,
      i = 0,
      len = str.length;

  for (; len >= 4; ++i, len -= 4) {
    k = str.charCodeAt(i) & 0xff | (str.charCodeAt(++i) & 0xff) << 8 | (str.charCodeAt(++i) & 0xff) << 16 | (str.charCodeAt(++i) & 0xff) << 24;
    k =
    /* Math.imul(k, m): */
    (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16);
    k ^=
    /* k >>> r: */
    k >>> 24;
    h =
    /* Math.imul(k, m): */
    (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16) ^
    /* Math.imul(h, m): */
    (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  } // Handle the last few bytes of the input array


  switch (len) {
    case 3:
      h ^= (str.charCodeAt(i + 2) & 0xff) << 16;

    case 2:
      h ^= (str.charCodeAt(i + 1) & 0xff) << 8;

    case 1:
      h ^= str.charCodeAt(i) & 0xff;
      h =
      /* Math.imul(h, m): */
      (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  } // Do a few final mixes of the hash to ensure the last few
  // bytes are well-incorporated.


  h ^= h >>> 13;
  h =
  /* Math.imul(h, m): */
  (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  return ((h ^ h >>> 15) >>> 0).toString(36);
}




/***/ }),

/***/ "./node_modules/@emotion/memoize/dist/emotion-memoize.esm.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@emotion/memoize/dist/emotion-memoize.esm.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ memoize)
/* harmony export */ });
function memoize(fn) {
  var cache = Object.create(null);
  return function (arg) {
    if (cache[arg] === undefined) cache[arg] = fn(arg);
    return cache[arg];
  };
}




/***/ }),

/***/ "./node_modules/@emotion/react/_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.esm.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@emotion/react/_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.esm.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ hoistNonReactStatics)
/* harmony export */ });
/* harmony import */ var hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! hoist-non-react-statics */ "./node_modules/hoist-non-react-statics/dist/hoist-non-react-statics.cjs.js");
/* harmony import */ var hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_0__);


// this file isolates this package that is not tree-shakeable
// and if this module doesn't actually contain any logic of its own
// then Rollup just use 'hoist-non-react-statics' directly in other chunks

var hoistNonReactStatics = (function (targetComponent, sourceComponent) {
  return hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_0___default()(targetComponent, sourceComponent);
});




/***/ }),

/***/ "./node_modules/@emotion/react/dist/emotion-element-c39617d8.browser.esm.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@emotion/react/dist/emotion-element-c39617d8.browser.esm.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "C": () => (/* binding */ CacheProvider),
/* harmony export */   "E": () => (/* binding */ Emotion$1),
/* harmony export */   "T": () => (/* binding */ ThemeContext),
/* harmony export */   "_": () => (/* binding */ __unsafe_useEmotionCache),
/* harmony export */   "a": () => (/* binding */ ThemeProvider),
/* harmony export */   "b": () => (/* binding */ withTheme),
/* harmony export */   "c": () => (/* binding */ createEmotionProps),
/* harmony export */   "h": () => (/* binding */ hasOwnProperty),
/* harmony export */   "i": () => (/* binding */ isBrowser),
/* harmony export */   "u": () => (/* binding */ useTheme),
/* harmony export */   "w": () => (/* binding */ withEmotionCache)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/cache */ "./node_modules/@emotion/cache/dist/emotion-cache.browser.esm.js");
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @emotion/weak-memoize */ "./node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js");
/* harmony import */ var _isolated_hnrs_dist_emotion_react_isolated_hnrs_browser_esm_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.esm.js */ "./node_modules/@emotion/react/_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.esm.js");
/* harmony import */ var _emotion_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @emotion/utils */ "./node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js");
/* harmony import */ var _emotion_serialize__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @emotion/serialize */ "./node_modules/@emotion/serialize/dist/emotion-serialize.browser.esm.js");
/* harmony import */ var _emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @emotion/use-insertion-effect-with-fallbacks */ "./node_modules/@emotion/use-insertion-effect-with-fallbacks/dist/emotion-use-insertion-effect-with-fallbacks.browser.esm.js");










var isBrowser = "object" !== 'undefined';
var hasOwnProperty = {}.hasOwnProperty;

var EmotionCacheContext = /* #__PURE__ */react__WEBPACK_IMPORTED_MODULE_0__.createContext( // we're doing this to avoid preconstruct's dead code elimination in this one case
// because this module is primarily intended for the browser and node
// but it's also required in react native and similar environments sometimes
// and we could have a special build just for that
// but this is much easier and the native packages
// might use a different theme context in the future anyway
typeof HTMLElement !== 'undefined' ? /* #__PURE__ */(0,_emotion_cache__WEBPACK_IMPORTED_MODULE_1__["default"])({
  key: 'css'
}) : null);

if (true) {
  EmotionCacheContext.displayName = 'EmotionCacheContext';
}

var CacheProvider = EmotionCacheContext.Provider;
var __unsafe_useEmotionCache = function useEmotionCache() {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(EmotionCacheContext);
};

var withEmotionCache = function withEmotionCache(func) {
  // $FlowFixMe
  return /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function (props, ref) {
    // the cache will never be null in the browser
    var cache = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(EmotionCacheContext);
    return func(props, cache, ref);
  });
};

if (!isBrowser) {
  withEmotionCache = function withEmotionCache(func) {
    return function (props) {
      var cache = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(EmotionCacheContext);

      if (cache === null) {
        // yes, we're potentially creating this on every render
        // it doesn't actually matter though since it's only on the server
        // so there will only every be a single render
        // that could change in the future because of suspense and etc. but for now,
        // this works and i don't want to optimise for a future thing that we aren't sure about
        cache = (0,_emotion_cache__WEBPACK_IMPORTED_MODULE_1__["default"])({
          key: 'css'
        });
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(EmotionCacheContext.Provider, {
          value: cache
        }, func(props, cache));
      } else {
        return func(props, cache);
      }
    };
  };
}

var ThemeContext = /* #__PURE__ */react__WEBPACK_IMPORTED_MODULE_0__.createContext({});

if (true) {
  ThemeContext.displayName = 'EmotionThemeContext';
}

var useTheme = function useTheme() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(ThemeContext);
};

var getTheme = function getTheme(outerTheme, theme) {
  if (typeof theme === 'function') {
    var mergedTheme = theme(outerTheme);

    if ( true && (mergedTheme == null || typeof mergedTheme !== 'object' || Array.isArray(mergedTheme))) {
      throw new Error('[ThemeProvider] Please return an object from your theme function, i.e. theme={() => ({})}!');
    }

    return mergedTheme;
  }

  if ( true && (theme == null || typeof theme !== 'object' || Array.isArray(theme))) {
    throw new Error('[ThemeProvider] Please make your theme prop a plain object');
  }

  return (0,_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_2__["default"])({}, outerTheme, theme);
};

var createCacheWithTheme = /* #__PURE__ */(0,_emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_3__["default"])(function (outerTheme) {
  return (0,_emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_3__["default"])(function (theme) {
    return getTheme(outerTheme, theme);
  });
});
var ThemeProvider = function ThemeProvider(props) {
  var theme = react__WEBPACK_IMPORTED_MODULE_0__.useContext(ThemeContext);

  if (props.theme !== theme) {
    theme = createCacheWithTheme(theme)(props.theme);
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(ThemeContext.Provider, {
    value: theme
  }, props.children);
};
function withTheme(Component) {
  var componentName = Component.displayName || Component.name || 'Component';

  var render = function render(props, ref) {
    var theme = react__WEBPACK_IMPORTED_MODULE_0__.useContext(ThemeContext);
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, (0,_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_2__["default"])({
      theme: theme,
      ref: ref
    }, props));
  }; // $FlowFixMe


  var WithTheme = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(render);
  WithTheme.displayName = "WithTheme(" + componentName + ")";
  return (0,_isolated_hnrs_dist_emotion_react_isolated_hnrs_browser_esm_js__WEBPACK_IMPORTED_MODULE_7__["default"])(WithTheme, Component);
}

var getLastPart = function getLastPart(functionName) {
  // The match may be something like 'Object.createEmotionProps' or
  // 'Loader.prototype.render'
  var parts = functionName.split('.');
  return parts[parts.length - 1];
};

var getFunctionNameFromStackTraceLine = function getFunctionNameFromStackTraceLine(line) {
  // V8
  var match = /^\s+at\s+([A-Za-z0-9$.]+)\s/.exec(line);
  if (match) return getLastPart(match[1]); // Safari / Firefox

  match = /^([A-Za-z0-9$.]+)@/.exec(line);
  if (match) return getLastPart(match[1]);
  return undefined;
};

var internalReactFunctionNames = /* #__PURE__ */new Set(['renderWithHooks', 'processChild', 'finishClassComponent', 'renderToString']); // These identifiers come from error stacks, so they have to be valid JS
// identifiers, thus we only need to replace what is a valid character for JS,
// but not for CSS.

var sanitizeIdentifier = function sanitizeIdentifier(identifier) {
  return identifier.replace(/\$/g, '-');
};

var getLabelFromStackTrace = function getLabelFromStackTrace(stackTrace) {
  if (!stackTrace) return undefined;
  var lines = stackTrace.split('\n');

  for (var i = 0; i < lines.length; i++) {
    var functionName = getFunctionNameFromStackTraceLine(lines[i]); // The first line of V8 stack traces is just "Error"

    if (!functionName) continue; // If we reach one of these, we have gone too far and should quit

    if (internalReactFunctionNames.has(functionName)) break; // The component name is the first function in the stack that starts with an
    // uppercase letter

    if (/^[A-Z]/.test(functionName)) return sanitizeIdentifier(functionName);
  }

  return undefined;
};

var typePropName = '__EMOTION_TYPE_PLEASE_DO_NOT_USE__';
var labelPropName = '__EMOTION_LABEL_PLEASE_DO_NOT_USE__';
var createEmotionProps = function createEmotionProps(type, props) {
  if ( true && typeof props.css === 'string' && // check if there is a css declaration
  props.css.indexOf(':') !== -1) {
    throw new Error("Strings are not allowed as css prop values, please wrap it in a css template literal from '@emotion/react' like this: css`" + props.css + "`");
  }

  var newProps = {};

  for (var key in props) {
    if (hasOwnProperty.call(props, key)) {
      newProps[key] = props[key];
    }
  }

  newProps[typePropName] = type; // For performance, only call getLabelFromStackTrace in development and when
  // the label hasn't already been computed

  if ( true && !!props.css && (typeof props.css !== 'object' || typeof props.css.name !== 'string' || props.css.name.indexOf('-') === -1)) {
    var label = getLabelFromStackTrace(new Error().stack);
    if (label) newProps[labelPropName] = label;
  }

  return newProps;
};

var Insertion = function Insertion(_ref) {
  var cache = _ref.cache,
      serialized = _ref.serialized,
      isStringTag = _ref.isStringTag;
  (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_4__.registerStyles)(cache, serialized, isStringTag);
  (0,_emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_6__.useInsertionEffectAlwaysWithSyncFallback)(function () {
    return (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_4__.insertStyles)(cache, serialized, isStringTag);
  });

  return null;
};

var Emotion = /* #__PURE__ */withEmotionCache(function (props, cache, ref) {
  var cssProp = props.css; // so that using `css` from `emotion` and passing the result to the css prop works
  // not passing the registered cache to serializeStyles because it would
  // make certain babel optimisations not possible

  if (typeof cssProp === 'string' && cache.registered[cssProp] !== undefined) {
    cssProp = cache.registered[cssProp];
  }

  var WrappedComponent = props[typePropName];
  var registeredStyles = [cssProp];
  var className = '';

  if (typeof props.className === 'string') {
    className = (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_4__.getRegisteredStyles)(cache.registered, registeredStyles, props.className);
  } else if (props.className != null) {
    className = props.className + " ";
  }

  var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_5__.serializeStyles)(registeredStyles, undefined, react__WEBPACK_IMPORTED_MODULE_0__.useContext(ThemeContext));

  if ( true && serialized.name.indexOf('-') === -1) {
    var labelFromStack = props[labelPropName];

    if (labelFromStack) {
      serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_5__.serializeStyles)([serialized, 'label:' + labelFromStack + ';']);
    }
  }

  className += cache.key + "-" + serialized.name;
  var newProps = {};

  for (var key in props) {
    if (hasOwnProperty.call(props, key) && key !== 'css' && key !== typePropName && ( false || key !== labelPropName)) {
      newProps[key] = props[key];
    }
  }

  newProps.ref = ref;
  newProps.className = className;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Insertion, {
    cache: cache,
    serialized: serialized,
    isStringTag: typeof WrappedComponent === 'string'
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(WrappedComponent, newProps));
});

if (true) {
  Emotion.displayName = 'EmotionCssPropInternal';
}

var Emotion$1 = Emotion;




/***/ }),

/***/ "./node_modules/@emotion/react/dist/emotion-react.browser.esm.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@emotion/react/dist/emotion-react.browser.esm.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CacheProvider": () => (/* reexport safe */ _emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__.C),
/* harmony export */   "ClassNames": () => (/* binding */ ClassNames),
/* harmony export */   "Global": () => (/* binding */ Global),
/* harmony export */   "ThemeContext": () => (/* reexport safe */ _emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__.T),
/* harmony export */   "ThemeProvider": () => (/* reexport safe */ _emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__.a),
/* harmony export */   "__unsafe_useEmotionCache": () => (/* reexport safe */ _emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__._),
/* harmony export */   "createElement": () => (/* binding */ jsx),
/* harmony export */   "css": () => (/* binding */ css),
/* harmony export */   "jsx": () => (/* binding */ jsx),
/* harmony export */   "keyframes": () => (/* binding */ keyframes),
/* harmony export */   "useTheme": () => (/* reexport safe */ _emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__.u),
/* harmony export */   "withEmotionCache": () => (/* reexport safe */ _emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__.w),
/* harmony export */   "withTheme": () => (/* reexport safe */ _emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__.b)
/* harmony export */ });
/* harmony import */ var _emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./emotion-element-c39617d8.browser.esm.js */ "./node_modules/@emotion/react/dist/emotion-element-c39617d8.browser.esm.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _emotion_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/utils */ "./node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js");
/* harmony import */ var _emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @emotion/use-insertion-effect-with-fallbacks */ "./node_modules/@emotion/use-insertion-effect-with-fallbacks/dist/emotion-use-insertion-effect-with-fallbacks.browser.esm.js");
/* harmony import */ var _emotion_serialize__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @emotion/serialize */ "./node_modules/@emotion/serialize/dist/emotion-serialize.browser.esm.js");
/* harmony import */ var _emotion_cache__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @emotion/cache */ "./node_modules/@emotion/cache/dist/emotion-cache.browser.esm.js");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @emotion/weak-memoize */ "./node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js");
/* harmony import */ var hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! hoist-non-react-statics */ "./node_modules/hoist-non-react-statics/dist/hoist-non-react-statics.cjs.js");
/* harmony import */ var hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_8__);












var pkg = {
	name: "@emotion/react",
	version: "11.11.0",
	main: "dist/emotion-react.cjs.js",
	module: "dist/emotion-react.esm.js",
	browser: {
		"./dist/emotion-react.esm.js": "./dist/emotion-react.browser.esm.js"
	},
	exports: {
		".": {
			module: {
				worker: "./dist/emotion-react.worker.esm.js",
				browser: "./dist/emotion-react.browser.esm.js",
				"default": "./dist/emotion-react.esm.js"
			},
			"import": "./dist/emotion-react.cjs.mjs",
			"default": "./dist/emotion-react.cjs.js"
		},
		"./jsx-runtime": {
			module: {
				worker: "./jsx-runtime/dist/emotion-react-jsx-runtime.worker.esm.js",
				browser: "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.esm.js",
				"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.esm.js"
			},
			"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.mjs",
			"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.js"
		},
		"./_isolated-hnrs": {
			module: {
				worker: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.worker.esm.js",
				browser: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.esm.js",
				"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.esm.js"
			},
			"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.mjs",
			"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.js"
		},
		"./jsx-dev-runtime": {
			module: {
				worker: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.worker.esm.js",
				browser: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.esm.js",
				"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.esm.js"
			},
			"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.mjs",
			"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.js"
		},
		"./package.json": "./package.json",
		"./types/css-prop": "./types/css-prop.d.ts",
		"./macro": {
			types: {
				"import": "./macro.d.mts",
				"default": "./macro.d.ts"
			},
			"default": "./macro.js"
		}
	},
	types: "types/index.d.ts",
	files: [
		"src",
		"dist",
		"jsx-runtime",
		"jsx-dev-runtime",
		"_isolated-hnrs",
		"types/*.d.ts",
		"macro.*"
	],
	sideEffects: false,
	author: "Emotion Contributors",
	license: "MIT",
	scripts: {
		"test:typescript": "dtslint types"
	},
	dependencies: {
		"@babel/runtime": "^7.18.3",
		"@emotion/babel-plugin": "^11.11.0",
		"@emotion/cache": "^11.11.0",
		"@emotion/serialize": "^1.1.2",
		"@emotion/use-insertion-effect-with-fallbacks": "^1.0.1",
		"@emotion/utils": "^1.2.1",
		"@emotion/weak-memoize": "^0.3.1",
		"hoist-non-react-statics": "^3.3.1"
	},
	peerDependencies: {
		react: ">=16.8.0"
	},
	peerDependenciesMeta: {
		"@types/react": {
			optional: true
		}
	},
	devDependencies: {
		"@definitelytyped/dtslint": "0.0.112",
		"@emotion/css": "11.11.0",
		"@emotion/css-prettifier": "1.1.3",
		"@emotion/server": "11.11.0",
		"@emotion/styled": "11.11.0",
		"html-tag-names": "^1.1.2",
		react: "16.14.0",
		"svg-tag-names": "^1.1.1",
		typescript: "^4.5.5"
	},
	repository: "https://github.com/emotion-js/emotion/tree/main/packages/react",
	publishConfig: {
		access: "public"
	},
	"umd:main": "dist/emotion-react.umd.min.js",
	preconstruct: {
		entrypoints: [
			"./index.js",
			"./jsx-runtime.js",
			"./jsx-dev-runtime.js",
			"./_isolated-hnrs.js"
		],
		umdName: "emotionReact",
		exports: {
			envConditions: [
				"browser",
				"worker"
			],
			extra: {
				"./types/css-prop": "./types/css-prop.d.ts",
				"./macro": {
					types: {
						"import": "./macro.d.mts",
						"default": "./macro.d.ts"
					},
					"default": "./macro.js"
				}
			}
		}
	}
};

var jsx = function jsx(type, props) {
  var args = arguments;

  if (props == null || !_emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__.h.call(props, 'css')) {
    // $FlowFixMe
    return react__WEBPACK_IMPORTED_MODULE_1__.createElement.apply(undefined, args);
  }

  var argsLength = args.length;
  var createElementArgArray = new Array(argsLength);
  createElementArgArray[0] = _emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__.E;
  createElementArgArray[1] = (0,_emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__.c)(type, props);

  for (var i = 2; i < argsLength; i++) {
    createElementArgArray[i] = args[i];
  } // $FlowFixMe


  return react__WEBPACK_IMPORTED_MODULE_1__.createElement.apply(null, createElementArgArray);
};

var warnedAboutCssPropForGlobal = false; // maintain place over rerenders.
// initial render from browser, insertBefore context.sheet.tags[0] or if a style hasn't been inserted there yet, appendChild
// initial client-side render from SSR, use place of hydrating tag

var Global = /* #__PURE__ */(0,_emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__.w)(function (props, cache) {
  if ( true && !warnedAboutCssPropForGlobal && ( // check for className as well since the user is
  // probably using the custom createElement which
  // means it will be turned into a className prop
  // $FlowFixMe I don't really want to add it to the type since it shouldn't be used
  props.className || props.css)) {
    console.error("It looks like you're using the css prop on Global, did you mean to use the styles prop instead?");
    warnedAboutCssPropForGlobal = true;
  }

  var styles = props.styles;
  var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_4__.serializeStyles)([styles], undefined, react__WEBPACK_IMPORTED_MODULE_1__.useContext(_emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__.T));

  if (!_emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__.i) {
    var _ref;

    var serializedNames = serialized.name;
    var serializedStyles = serialized.styles;
    var next = serialized.next;

    while (next !== undefined) {
      serializedNames += ' ' + next.name;
      serializedStyles += next.styles;
      next = next.next;
    }

    var shouldCache = cache.compat === true;
    var rules = cache.insert("", {
      name: serializedNames,
      styles: serializedStyles
    }, cache.sheet, shouldCache);

    if (shouldCache) {
      return null;
    }

    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement("style", (_ref = {}, _ref["data-emotion"] = cache.key + "-global " + serializedNames, _ref.dangerouslySetInnerHTML = {
      __html: rules
    }, _ref.nonce = cache.sheet.nonce, _ref));
  } // yes, i know these hooks are used conditionally
  // but it is based on a constant that will never change at runtime
  // it's effectively like having two implementations and switching them out
  // so it's not actually breaking anything


  var sheetRef = react__WEBPACK_IMPORTED_MODULE_1__.useRef();
  (0,_emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_3__.useInsertionEffectWithLayoutFallback)(function () {
    var key = cache.key + "-global"; // use case of https://github.com/emotion-js/emotion/issues/2675

    var sheet = new cache.sheet.constructor({
      key: key,
      nonce: cache.sheet.nonce,
      container: cache.sheet.container,
      speedy: cache.sheet.isSpeedy
    });
    var rehydrating = false; // $FlowFixMe

    var node = document.querySelector("style[data-emotion=\"" + key + " " + serialized.name + "\"]");

    if (cache.sheet.tags.length) {
      sheet.before = cache.sheet.tags[0];
    }

    if (node !== null) {
      rehydrating = true; // clear the hash so this node won't be recognizable as rehydratable by other <Global/>s

      node.setAttribute('data-emotion', key);
      sheet.hydrate([node]);
    }

    sheetRef.current = [sheet, rehydrating];
    return function () {
      sheet.flush();
    };
  }, [cache]);
  (0,_emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_3__.useInsertionEffectWithLayoutFallback)(function () {
    var sheetRefCurrent = sheetRef.current;
    var sheet = sheetRefCurrent[0],
        rehydrating = sheetRefCurrent[1];

    if (rehydrating) {
      sheetRefCurrent[1] = false;
      return;
    }

    if (serialized.next !== undefined) {
      // insert keyframes
      (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.insertStyles)(cache, serialized.next, true);
    }

    if (sheet.tags.length) {
      // if this doesn't exist then it will be null so the style element will be appended
      var element = sheet.tags[sheet.tags.length - 1].nextElementSibling;
      sheet.before = element;
      sheet.flush();
    }

    cache.insert("", serialized, sheet, false);
  }, [cache, serialized.name]);
  return null;
});

if (true) {
  Global.displayName = 'EmotionGlobal';
}

function css() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_4__.serializeStyles)(args);
}

var keyframes = function keyframes() {
  var insertable = css.apply(void 0, arguments);
  var name = "animation-" + insertable.name; // $FlowFixMe

  return {
    name: name,
    styles: "@keyframes " + name + "{" + insertable.styles + "}",
    anim: 1,
    toString: function toString() {
      return "_EMO_" + this.name + "_" + this.styles + "_EMO_";
    }
  };
};

var classnames = function classnames(args) {
  var len = args.length;
  var i = 0;
  var cls = '';

  for (; i < len; i++) {
    var arg = args[i];
    if (arg == null) continue;
    var toAdd = void 0;

    switch (typeof arg) {
      case 'boolean':
        break;

      case 'object':
        {
          if (Array.isArray(arg)) {
            toAdd = classnames(arg);
          } else {
            if ( true && arg.styles !== undefined && arg.name !== undefined) {
              console.error('You have passed styles created with `css` from `@emotion/react` package to the `cx`.\n' + '`cx` is meant to compose class names (strings) so you should convert those styles to a class name by passing them to the `css` received from <ClassNames/> component.');
            }

            toAdd = '';

            for (var k in arg) {
              if (arg[k] && k) {
                toAdd && (toAdd += ' ');
                toAdd += k;
              }
            }
          }

          break;
        }

      default:
        {
          toAdd = arg;
        }
    }

    if (toAdd) {
      cls && (cls += ' ');
      cls += toAdd;
    }
  }

  return cls;
};

function merge(registered, css, className) {
  var registeredStyles = [];
  var rawClassName = (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.getRegisteredStyles)(registered, registeredStyles, className);

  if (registeredStyles.length < 2) {
    return className;
  }

  return rawClassName + css(registeredStyles);
}

var Insertion = function Insertion(_ref) {
  var cache = _ref.cache,
      serializedArr = _ref.serializedArr;
  (0,_emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_3__.useInsertionEffectAlwaysWithSyncFallback)(function () {

    for (var i = 0; i < serializedArr.length; i++) {
      (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.insertStyles)(cache, serializedArr[i], false);
    }
  });

  return null;
};

var ClassNames = /* #__PURE__ */(0,_emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__.w)(function (props, cache) {
  var hasRendered = false;
  var serializedArr = [];

  var css = function css() {
    if (hasRendered && "development" !== 'production') {
      throw new Error('css can only be used during render');
    }

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_4__.serializeStyles)(args, cache.registered);
    serializedArr.push(serialized); // registration has to happen here as the result of this might get consumed by `cx`

    (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.registerStyles)(cache, serialized, false);
    return cache.key + "-" + serialized.name;
  };

  var cx = function cx() {
    if (hasRendered && "development" !== 'production') {
      throw new Error('cx can only be used during render');
    }

    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return merge(cache.registered, css, classnames(args));
  };

  var content = {
    css: css,
    cx: cx,
    theme: react__WEBPACK_IMPORTED_MODULE_1__.useContext(_emotion_element_c39617d8_browser_esm_js__WEBPACK_IMPORTED_MODULE_0__.T)
  };
  var ele = props.children(content);
  hasRendered = true;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(Insertion, {
    cache: cache,
    serializedArr: serializedArr
  }), ele);
});

if (true) {
  ClassNames.displayName = 'EmotionClassNames';
}

if (true) {
  var isBrowser = "object" !== 'undefined'; // #1727, #2905 for some reason Jest and Vitest evaluate modules twice if some consuming module gets mocked

  var isTestEnv = typeof jest !== 'undefined' || typeof vi !== 'undefined';

  if (isBrowser && !isTestEnv) {
    // globalThis has wide browser support - https://caniuse.com/?search=globalThis, Node.js 12 and later
    var globalContext = // $FlowIgnore
    typeof globalThis !== 'undefined' ? globalThis // eslint-disable-line no-undef
    : isBrowser ? window : __webpack_require__.g;
    var globalKey = "__EMOTION_REACT_" + pkg.version.split('.')[0] + "__";

    if (globalContext[globalKey]) {
      console.warn('You are loading @emotion/react when it is already loaded. Running ' + 'multiple instances may cause problems. This can happen if multiple ' + 'versions are used, or if multiple builds of the same version are ' + 'used.');
    }

    globalContext[globalKey] = true;
  }
}




/***/ }),

/***/ "./node_modules/@emotion/serialize/dist/emotion-serialize.browser.esm.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@emotion/serialize/dist/emotion-serialize.browser.esm.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "serializeStyles": () => (/* binding */ serializeStyles)
/* harmony export */ });
/* harmony import */ var _emotion_hash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/hash */ "./node_modules/@emotion/hash/dist/emotion-hash.esm.js");
/* harmony import */ var _emotion_unitless__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/unitless */ "./node_modules/@emotion/unitless/dist/emotion-unitless.esm.js");
/* harmony import */ var _emotion_memoize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/memoize */ "./node_modules/@emotion/memoize/dist/emotion-memoize.esm.js");




var ILLEGAL_ESCAPE_SEQUENCE_ERROR = "You have illegal escape sequence in your template literal, most likely inside content's property value.\nBecause you write your CSS inside a JavaScript string you actually have to do double escaping, so for example \"content: '\\00d7';\" should become \"content: '\\\\00d7';\".\nYou can read more about this here:\nhttps://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences";
var UNDEFINED_AS_OBJECT_KEY_ERROR = "You have passed in falsy value as style object's key (can happen when in example you pass unexported component as computed key).";
var hyphenateRegex = /[A-Z]|^ms/g;
var animationRegex = /_EMO_([^_]+?)_([^]*?)_EMO_/g;

var isCustomProperty = function isCustomProperty(property) {
  return property.charCodeAt(1) === 45;
};

var isProcessableValue = function isProcessableValue(value) {
  return value != null && typeof value !== 'boolean';
};

var processStyleName = /* #__PURE__ */(0,_emotion_memoize__WEBPACK_IMPORTED_MODULE_2__["default"])(function (styleName) {
  return isCustomProperty(styleName) ? styleName : styleName.replace(hyphenateRegex, '-$&').toLowerCase();
});

var processStyleValue = function processStyleValue(key, value) {
  switch (key) {
    case 'animation':
    case 'animationName':
      {
        if (typeof value === 'string') {
          return value.replace(animationRegex, function (match, p1, p2) {
            cursor = {
              name: p1,
              styles: p2,
              next: cursor
            };
            return p1;
          });
        }
      }
  }

  if (_emotion_unitless__WEBPACK_IMPORTED_MODULE_1__["default"][key] !== 1 && !isCustomProperty(key) && typeof value === 'number' && value !== 0) {
    return value + 'px';
  }

  return value;
};

if (true) {
  var contentValuePattern = /(var|attr|counters?|url|element|(((repeating-)?(linear|radial))|conic)-gradient)\(|(no-)?(open|close)-quote/;
  var contentValues = ['normal', 'none', 'initial', 'inherit', 'unset'];
  var oldProcessStyleValue = processStyleValue;
  var msPattern = /^-ms-/;
  var hyphenPattern = /-(.)/g;
  var hyphenatedCache = {};

  processStyleValue = function processStyleValue(key, value) {
    if (key === 'content') {
      if (typeof value !== 'string' || contentValues.indexOf(value) === -1 && !contentValuePattern.test(value) && (value.charAt(0) !== value.charAt(value.length - 1) || value.charAt(0) !== '"' && value.charAt(0) !== "'")) {
        throw new Error("You seem to be using a value for 'content' without quotes, try replacing it with `content: '\"" + value + "\"'`");
      }
    }

    var processed = oldProcessStyleValue(key, value);

    if (processed !== '' && !isCustomProperty(key) && key.indexOf('-') !== -1 && hyphenatedCache[key] === undefined) {
      hyphenatedCache[key] = true;
      console.error("Using kebab-case for css properties in objects is not supported. Did you mean " + key.replace(msPattern, 'ms-').replace(hyphenPattern, function (str, _char) {
        return _char.toUpperCase();
      }) + "?");
    }

    return processed;
  };
}

var noComponentSelectorMessage = 'Component selectors can only be used in conjunction with ' + '@emotion/babel-plugin, the swc Emotion plugin, or another Emotion-aware ' + 'compiler transform.';

function handleInterpolation(mergedProps, registered, interpolation) {
  if (interpolation == null) {
    return '';
  }

  if (interpolation.__emotion_styles !== undefined) {
    if ( true && interpolation.toString() === 'NO_COMPONENT_SELECTOR') {
      throw new Error(noComponentSelectorMessage);
    }

    return interpolation;
  }

  switch (typeof interpolation) {
    case 'boolean':
      {
        return '';
      }

    case 'object':
      {
        if (interpolation.anim === 1) {
          cursor = {
            name: interpolation.name,
            styles: interpolation.styles,
            next: cursor
          };
          return interpolation.name;
        }

        if (interpolation.styles !== undefined) {
          var next = interpolation.next;

          if (next !== undefined) {
            // not the most efficient thing ever but this is a pretty rare case
            // and there will be very few iterations of this generally
            while (next !== undefined) {
              cursor = {
                name: next.name,
                styles: next.styles,
                next: cursor
              };
              next = next.next;
            }
          }

          var styles = interpolation.styles + ";";

          if ( true && interpolation.map !== undefined) {
            styles += interpolation.map;
          }

          return styles;
        }

        return createStringFromObject(mergedProps, registered, interpolation);
      }

    case 'function':
      {
        if (mergedProps !== undefined) {
          var previousCursor = cursor;
          var result = interpolation(mergedProps);
          cursor = previousCursor;
          return handleInterpolation(mergedProps, registered, result);
        } else if (true) {
          console.error('Functions that are interpolated in css calls will be stringified.\n' + 'If you want to have a css call based on props, create a function that returns a css call like this\n' + 'let dynamicStyle = (props) => css`color: ${props.color}`\n' + 'It can be called directly with props or interpolated in a styled call like this\n' + "let SomeComponent = styled('div')`${dynamicStyle}`");
        }

        break;
      }

    case 'string':
      if (true) {
        var matched = [];
        var replaced = interpolation.replace(animationRegex, function (match, p1, p2) {
          var fakeVarName = "animation" + matched.length;
          matched.push("const " + fakeVarName + " = keyframes`" + p2.replace(/^@keyframes animation-\w+/, '') + "`");
          return "${" + fakeVarName + "}";
        });

        if (matched.length) {
          console.error('`keyframes` output got interpolated into plain string, please wrap it with `css`.\n\n' + 'Instead of doing this:\n\n' + [].concat(matched, ["`" + replaced + "`"]).join('\n') + '\n\nYou should wrap it with `css` like this:\n\n' + ("css`" + replaced + "`"));
        }
      }

      break;
  } // finalize string values (regular strings and functions interpolated into css calls)


  if (registered == null) {
    return interpolation;
  }

  var cached = registered[interpolation];
  return cached !== undefined ? cached : interpolation;
}

function createStringFromObject(mergedProps, registered, obj) {
  var string = '';

  if (Array.isArray(obj)) {
    for (var i = 0; i < obj.length; i++) {
      string += handleInterpolation(mergedProps, registered, obj[i]) + ";";
    }
  } else {
    for (var _key in obj) {
      var value = obj[_key];

      if (typeof value !== 'object') {
        if (registered != null && registered[value] !== undefined) {
          string += _key + "{" + registered[value] + "}";
        } else if (isProcessableValue(value)) {
          string += processStyleName(_key) + ":" + processStyleValue(_key, value) + ";";
        }
      } else {
        if (_key === 'NO_COMPONENT_SELECTOR' && "development" !== 'production') {
          throw new Error(noComponentSelectorMessage);
        }

        if (Array.isArray(value) && typeof value[0] === 'string' && (registered == null || registered[value[0]] === undefined)) {
          for (var _i = 0; _i < value.length; _i++) {
            if (isProcessableValue(value[_i])) {
              string += processStyleName(_key) + ":" + processStyleValue(_key, value[_i]) + ";";
            }
          }
        } else {
          var interpolated = handleInterpolation(mergedProps, registered, value);

          switch (_key) {
            case 'animation':
            case 'animationName':
              {
                string += processStyleName(_key) + ":" + interpolated + ";";
                break;
              }

            default:
              {
                if ( true && _key === 'undefined') {
                  console.error(UNDEFINED_AS_OBJECT_KEY_ERROR);
                }

                string += _key + "{" + interpolated + "}";
              }
          }
        }
      }
    }
  }

  return string;
}

var labelPattern = /label:\s*([^\s;\n{]+)\s*(;|$)/g;
var sourceMapPattern;

if (true) {
  sourceMapPattern = /\/\*#\ssourceMappingURL=data:application\/json;\S+\s+\*\//g;
} // this is the cursor for keyframes
// keyframes are stored on the SerializedStyles object as a linked list


var cursor;
var serializeStyles = function serializeStyles(args, registered, mergedProps) {
  if (args.length === 1 && typeof args[0] === 'object' && args[0] !== null && args[0].styles !== undefined) {
    return args[0];
  }

  var stringMode = true;
  var styles = '';
  cursor = undefined;
  var strings = args[0];

  if (strings == null || strings.raw === undefined) {
    stringMode = false;
    styles += handleInterpolation(mergedProps, registered, strings);
  } else {
    if ( true && strings[0] === undefined) {
      console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
    }

    styles += strings[0];
  } // we start at 1 since we've already handled the first arg


  for (var i = 1; i < args.length; i++) {
    styles += handleInterpolation(mergedProps, registered, args[i]);

    if (stringMode) {
      if ( true && strings[i] === undefined) {
        console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
      }

      styles += strings[i];
    }
  }

  var sourceMap;

  if (true) {
    styles = styles.replace(sourceMapPattern, function (match) {
      sourceMap = match;
      return '';
    });
  } // using a global regex with .exec is stateful so lastIndex has to be reset each time


  labelPattern.lastIndex = 0;
  var identifierName = '';
  var match; // https://esbench.com/bench/5b809c2cf2949800a0f61fb5

  while ((match = labelPattern.exec(styles)) !== null) {
    identifierName += '-' + // $FlowFixMe we know it's not null
    match[1];
  }

  var name = (0,_emotion_hash__WEBPACK_IMPORTED_MODULE_0__["default"])(styles) + identifierName;

  if (true) {
    // $FlowFixMe SerializedStyles type doesn't have toString property (and we don't want to add it)
    return {
      name: name,
      styles: styles,
      map: sourceMap,
      next: cursor,
      toString: function toString() {
        return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
      }
    };
  }

  return {
    name: name,
    styles: styles,
    next: cursor
  };
};




/***/ }),

/***/ "./node_modules/@emotion/sheet/dist/emotion-sheet.browser.esm.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@emotion/sheet/dist/emotion-sheet.browser.esm.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StyleSheet": () => (/* binding */ StyleSheet)
/* harmony export */ });
/*

Based off glamor's StyleSheet, thanks Sunil ❤️

high performance StyleSheet for css-in-js systems

- uses multiple style tags behind the scenes for millions of rules
- uses `insertRule` for appending in production for *much* faster performance

// usage

import { StyleSheet } from '@emotion/sheet'

let styleSheet = new StyleSheet({ key: '', container: document.head })

styleSheet.insert('#box { border: 1px solid red; }')
- appends a css rule into the stylesheet

styleSheet.flush()
- empties the stylesheet of all its contents

*/
// $FlowFixMe
function sheetForTag(tag) {
  if (tag.sheet) {
    // $FlowFixMe
    return tag.sheet;
  } // this weirdness brought to you by firefox

  /* istanbul ignore next */


  for (var i = 0; i < document.styleSheets.length; i++) {
    if (document.styleSheets[i].ownerNode === tag) {
      // $FlowFixMe
      return document.styleSheets[i];
    }
  }
}

function createStyleElement(options) {
  var tag = document.createElement('style');
  tag.setAttribute('data-emotion', options.key);

  if (options.nonce !== undefined) {
    tag.setAttribute('nonce', options.nonce);
  }

  tag.appendChild(document.createTextNode(''));
  tag.setAttribute('data-s', '');
  return tag;
}

var StyleSheet = /*#__PURE__*/function () {
  // Using Node instead of HTMLElement since container may be a ShadowRoot
  function StyleSheet(options) {
    var _this = this;

    this._insertTag = function (tag) {
      var before;

      if (_this.tags.length === 0) {
        if (_this.insertionPoint) {
          before = _this.insertionPoint.nextSibling;
        } else if (_this.prepend) {
          before = _this.container.firstChild;
        } else {
          before = _this.before;
        }
      } else {
        before = _this.tags[_this.tags.length - 1].nextSibling;
      }

      _this.container.insertBefore(tag, before);

      _this.tags.push(tag);
    };

    this.isSpeedy = options.speedy === undefined ? "development" === 'production' : options.speedy;
    this.tags = [];
    this.ctr = 0;
    this.nonce = options.nonce; // key is the value of the data-emotion attribute, it's used to identify different sheets

    this.key = options.key;
    this.container = options.container;
    this.prepend = options.prepend;
    this.insertionPoint = options.insertionPoint;
    this.before = null;
  }

  var _proto = StyleSheet.prototype;

  _proto.hydrate = function hydrate(nodes) {
    nodes.forEach(this._insertTag);
  };

  _proto.insert = function insert(rule) {
    // the max length is how many rules we have per style tag, it's 65000 in speedy mode
    // it's 1 in dev because we insert source maps that map a single rule to a location
    // and you can only have one source map per style tag
    if (this.ctr % (this.isSpeedy ? 65000 : 1) === 0) {
      this._insertTag(createStyleElement(this));
    }

    var tag = this.tags[this.tags.length - 1];

    if (true) {
      var isImportRule = rule.charCodeAt(0) === 64 && rule.charCodeAt(1) === 105;

      if (isImportRule && this._alreadyInsertedOrderInsensitiveRule) {
        // this would only cause problem in speedy mode
        // but we don't want enabling speedy to affect the observable behavior
        // so we report this error at all times
        console.error("You're attempting to insert the following rule:\n" + rule + '\n\n`@import` rules must be before all other types of rules in a stylesheet but other rules have already been inserted. Please ensure that `@import` rules are before all other rules.');
      }
      this._alreadyInsertedOrderInsensitiveRule = this._alreadyInsertedOrderInsensitiveRule || !isImportRule;
    }

    if (this.isSpeedy) {
      var sheet = sheetForTag(tag);

      try {
        // this is the ultrafast version, works across browsers
        // the big drawback is that the css won't be editable in devtools
        sheet.insertRule(rule, sheet.cssRules.length);
      } catch (e) {
        if ( true && !/:(-moz-placeholder|-moz-focus-inner|-moz-focusring|-ms-input-placeholder|-moz-read-write|-moz-read-only|-ms-clear|-ms-expand|-ms-reveal){/.test(rule)) {
          console.error("There was a problem inserting the following rule: \"" + rule + "\"", e);
        }
      }
    } else {
      tag.appendChild(document.createTextNode(rule));
    }

    this.ctr++;
  };

  _proto.flush = function flush() {
    // $FlowFixMe
    this.tags.forEach(function (tag) {
      return tag.parentNode && tag.parentNode.removeChild(tag);
    });
    this.tags = [];
    this.ctr = 0;

    if (true) {
      this._alreadyInsertedOrderInsensitiveRule = false;
    }
  };

  return StyleSheet;
}();




/***/ }),

/***/ "./node_modules/@emotion/unitless/dist/emotion-unitless.esm.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@emotion/unitless/dist/emotion-unitless.esm.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ unitlessKeys)
/* harmony export */ });
var unitlessKeys = {
  animationIterationCount: 1,
  aspectRatio: 1,
  borderImageOutset: 1,
  borderImageSlice: 1,
  borderImageWidth: 1,
  boxFlex: 1,
  boxFlexGroup: 1,
  boxOrdinalGroup: 1,
  columnCount: 1,
  columns: 1,
  flex: 1,
  flexGrow: 1,
  flexPositive: 1,
  flexShrink: 1,
  flexNegative: 1,
  flexOrder: 1,
  gridRow: 1,
  gridRowEnd: 1,
  gridRowSpan: 1,
  gridRowStart: 1,
  gridColumn: 1,
  gridColumnEnd: 1,
  gridColumnSpan: 1,
  gridColumnStart: 1,
  msGridRow: 1,
  msGridRowSpan: 1,
  msGridColumn: 1,
  msGridColumnSpan: 1,
  fontWeight: 1,
  lineHeight: 1,
  opacity: 1,
  order: 1,
  orphans: 1,
  tabSize: 1,
  widows: 1,
  zIndex: 1,
  zoom: 1,
  WebkitLineClamp: 1,
  // SVG-related properties
  fillOpacity: 1,
  floodOpacity: 1,
  stopOpacity: 1,
  strokeDasharray: 1,
  strokeDashoffset: 1,
  strokeMiterlimit: 1,
  strokeOpacity: 1,
  strokeWidth: 1
};




/***/ }),

/***/ "./node_modules/@emotion/use-insertion-effect-with-fallbacks/dist/emotion-use-insertion-effect-with-fallbacks.browser.esm.js":
/*!***********************************************************************************************************************************!*\
  !*** ./node_modules/@emotion/use-insertion-effect-with-fallbacks/dist/emotion-use-insertion-effect-with-fallbacks.browser.esm.js ***!
  \***********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useInsertionEffectAlwaysWithSyncFallback": () => (/* binding */ useInsertionEffectAlwaysWithSyncFallback),
/* harmony export */   "useInsertionEffectWithLayoutFallback": () => (/* binding */ useInsertionEffectWithLayoutFallback)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var syncFallback = function syncFallback(create) {
  return create();
};

var useInsertionEffect = react__WEBPACK_IMPORTED_MODULE_0__['useInsertion' + 'Effect'] ? react__WEBPACK_IMPORTED_MODULE_0__['useInsertion' + 'Effect'] : false;
var useInsertionEffectAlwaysWithSyncFallback = useInsertionEffect || syncFallback;
var useInsertionEffectWithLayoutFallback = useInsertionEffect || react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect;




/***/ }),

/***/ "./node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getRegisteredStyles": () => (/* binding */ getRegisteredStyles),
/* harmony export */   "insertStyles": () => (/* binding */ insertStyles),
/* harmony export */   "registerStyles": () => (/* binding */ registerStyles)
/* harmony export */ });
var isBrowser = "object" !== 'undefined';
function getRegisteredStyles(registered, registeredStyles, classNames) {
  var rawClassName = '';
  classNames.split(' ').forEach(function (className) {
    if (registered[className] !== undefined) {
      registeredStyles.push(registered[className] + ";");
    } else {
      rawClassName += className + " ";
    }
  });
  return rawClassName;
}
var registerStyles = function registerStyles(cache, serialized, isStringTag) {
  var className = cache.key + "-" + serialized.name;

  if ( // we only need to add the styles to the registered cache if the
  // class name could be used further down
  // the tree but if it's a string tag, we know it won't
  // so we don't have to add it to registered cache.
  // this improves memory usage since we can avoid storing the whole style string
  (isStringTag === false || // we need to always store it if we're in compat mode and
  // in node since emotion-server relies on whether a style is in
  // the registered cache to know whether a style is global or not
  // also, note that this check will be dead code eliminated in the browser
  isBrowser === false ) && cache.registered[className] === undefined) {
    cache.registered[className] = serialized.styles;
  }
};
var insertStyles = function insertStyles(cache, serialized, isStringTag) {
  registerStyles(cache, serialized, isStringTag);
  var className = cache.key + "-" + serialized.name;

  if (cache.inserted[serialized.name] === undefined) {
    var current = serialized;

    do {
      cache.insert(serialized === current ? "." + className : '', current, cache.sheet, true);

      current = current.next;
    } while (current !== undefined);
  }
};




/***/ }),

/***/ "./node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ weakMemoize)
/* harmony export */ });
var weakMemoize = function weakMemoize(func) {
  // $FlowFixMe flow doesn't include all non-primitive types as allowed for weakmaps
  var cache = new WeakMap();
  return function (arg) {
    if (cache.has(arg)) {
      // $FlowFixMe
      return cache.get(arg);
    }

    var ret = func(arg);
    cache.set(arg, ret);
    return ret;
  };
};




/***/ }),

/***/ "./node_modules/@floating-ui/react-dom/dist/floating-ui.react-dom.esm.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@floating-ui/react-dom/dist/floating-ui.react-dom.esm.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "arrow": () => (/* binding */ arrow),
/* harmony export */   "autoPlacement": () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.autoPlacement),
/* harmony export */   "autoUpdate": () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_1__.autoUpdate),
/* harmony export */   "computePosition": () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_1__.computePosition),
/* harmony export */   "detectOverflow": () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.detectOverflow),
/* harmony export */   "flip": () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.flip),
/* harmony export */   "getOverflowAncestors": () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_1__.getOverflowAncestors),
/* harmony export */   "hide": () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.hide),
/* harmony export */   "inline": () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.inline),
/* harmony export */   "limitShift": () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.limitShift),
/* harmony export */   "offset": () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.offset),
/* harmony export */   "platform": () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_1__.platform),
/* harmony export */   "shift": () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.shift),
/* harmony export */   "size": () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.size),
/* harmony export */   "useFloating": () => (/* binding */ useFloating)
/* harmony export */ });
/* harmony import */ var _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @floating-ui/dom */ "./node_modules/@floating-ui/core/dist/floating-ui.core.browser.mjs");
/* harmony import */ var _floating_ui_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @floating-ui/dom */ "./node_modules/@floating-ui/dom/dist/floating-ui.dom.browser.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-dom */ "webpack/sharing/consume/default/react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_3__);






/**
 * A data provider that provides data to position an inner element of the
 * floating element (usually a triangle or caret) so that it is centered to the
 * reference element.
 * This wraps the core `arrow` middleware to allow React refs as the element.
 * @see https://floating-ui.com/docs/arrow
 */
const arrow = options => {
  const {
    element,
    padding
  } = options;
  function isRef(value) {
    return Object.prototype.hasOwnProperty.call(value, 'current');
  }
  return {
    name: 'arrow',
    options,
    fn(args) {
      if (isRef(element)) {
        if (element.current != null) {
          return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.arrow)({
            element: element.current,
            padding
          }).fn(args);
        }
        return {};
      } else if (element) {
        return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.arrow)({
          element,
          padding
        }).fn(args);
      }
      return {};
    }
  };
};

var index = typeof document !== 'undefined' ? react__WEBPACK_IMPORTED_MODULE_2__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_2__.useEffect;

// Fork of `fast-deep-equal` that only does the comparisons we need and compares
// functions
function deepEqual(a, b) {
  if (a === b) {
    return true;
  }
  if (typeof a !== typeof b) {
    return false;
  }
  if (typeof a === 'function' && a.toString() === b.toString()) {
    return true;
  }
  let length, i, keys;
  if (a && b && typeof a == 'object') {
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;) {
        if (!deepEqual(a[i], b[i])) {
          return false;
        }
      }
      return true;
    }
    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) {
      return false;
    }
    for (i = length; i-- !== 0;) {
      if (!Object.prototype.hasOwnProperty.call(b, keys[i])) {
        return false;
      }
    }
    for (i = length; i-- !== 0;) {
      const key = keys[i];
      if (key === '_owner' && a.$$typeof) {
        continue;
      }
      if (!deepEqual(a[key], b[key])) {
        return false;
      }
    }
    return true;
  }
  return a !== a && b !== b;
}

function useLatestRef(value) {
  const ref = react__WEBPACK_IMPORTED_MODULE_2__.useRef(value);
  index(() => {
    ref.current = value;
  });
  return ref;
}

/**
 * Provides data to position a floating element.
 * @see https://floating-ui.com/docs/react
 */
function useFloating(options) {
  if (options === void 0) {
    options = {};
  }
  const {
    placement = 'bottom',
    strategy = 'absolute',
    middleware = [],
    platform,
    whileElementsMounted,
    open
  } = options;
  const [data, setData] = react__WEBPACK_IMPORTED_MODULE_2__.useState({
    x: null,
    y: null,
    strategy,
    placement,
    middlewareData: {},
    isPositioned: false
  });
  const [latestMiddleware, setLatestMiddleware] = react__WEBPACK_IMPORTED_MODULE_2__.useState(middleware);
  if (!deepEqual(latestMiddleware, middleware)) {
    setLatestMiddleware(middleware);
  }
  const referenceRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef(null);
  const floatingRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef(null);
  const dataRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef(data);
  const whileElementsMountedRef = useLatestRef(whileElementsMounted);
  const platformRef = useLatestRef(platform);
  const [reference, _setReference] = react__WEBPACK_IMPORTED_MODULE_2__.useState(null);
  const [floating, _setFloating] = react__WEBPACK_IMPORTED_MODULE_2__.useState(null);
  const setReference = react__WEBPACK_IMPORTED_MODULE_2__.useCallback(node => {
    if (referenceRef.current !== node) {
      referenceRef.current = node;
      _setReference(node);
    }
  }, []);
  const setFloating = react__WEBPACK_IMPORTED_MODULE_2__.useCallback(node => {
    if (floatingRef.current !== node) {
      floatingRef.current = node;
      _setFloating(node);
    }
  }, []);
  const update = react__WEBPACK_IMPORTED_MODULE_2__.useCallback(() => {
    if (!referenceRef.current || !floatingRef.current) {
      return;
    }
    const config = {
      placement,
      strategy,
      middleware: latestMiddleware
    };
    if (platformRef.current) {
      config.platform = platformRef.current;
    }
    (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_1__.computePosition)(referenceRef.current, floatingRef.current, config).then(data => {
      const fullData = {
        ...data,
        isPositioned: true
      };
      if (isMountedRef.current && !deepEqual(dataRef.current, fullData)) {
        dataRef.current = fullData;
        react_dom__WEBPACK_IMPORTED_MODULE_3__.flushSync(() => {
          setData(fullData);
        });
      }
    });
  }, [latestMiddleware, placement, strategy, platformRef]);
  index(() => {
    if (open === false && dataRef.current.isPositioned) {
      dataRef.current.isPositioned = false;
      setData(data => ({
        ...data,
        isPositioned: false
      }));
    }
  }, [open]);
  const isMountedRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef(false);
  index(() => {
    isMountedRef.current = true;
    return () => {
      isMountedRef.current = false;
    };
  }, []);
  index(() => {
    if (reference && floating) {
      if (whileElementsMountedRef.current) {
        return whileElementsMountedRef.current(reference, floating, update);
      } else {
        update();
      }
    }
  }, [reference, floating, update, whileElementsMountedRef]);
  const refs = react__WEBPACK_IMPORTED_MODULE_2__.useMemo(() => ({
    reference: referenceRef,
    floating: floatingRef,
    setReference,
    setFloating
  }), [setReference, setFloating]);
  const elements = react__WEBPACK_IMPORTED_MODULE_2__.useMemo(() => ({
    reference,
    floating
  }), [reference, floating]);
  return react__WEBPACK_IMPORTED_MODULE_2__.useMemo(() => ({
    ...data,
    update,
    refs,
    elements,
    reference: setReference,
    floating: setFloating
  }), [data, update, refs, elements, setReference, setFloating]);
}




/***/ }),

/***/ "./node_modules/@floating-ui/react/dist/floating-ui.react.esm.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@floating-ui/react/dist/floating-ui.react.esm.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FloatingDelayGroup": () => (/* binding */ FloatingDelayGroup),
/* harmony export */   "FloatingFocusManager": () => (/* binding */ FloatingFocusManager),
/* harmony export */   "FloatingNode": () => (/* binding */ FloatingNode),
/* harmony export */   "FloatingOverlay": () => (/* binding */ FloatingOverlay),
/* harmony export */   "FloatingPortal": () => (/* binding */ FloatingPortal),
/* harmony export */   "FloatingTree": () => (/* binding */ FloatingTree),
/* harmony export */   "arrow": () => (/* reexport safe */ _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_2__.arrow),
/* harmony export */   "autoPlacement": () => (/* reexport safe */ _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_3__.autoPlacement),
/* harmony export */   "autoUpdate": () => (/* reexport safe */ _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_4__.autoUpdate),
/* harmony export */   "computePosition": () => (/* reexport safe */ _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_4__.computePosition),
/* harmony export */   "detectOverflow": () => (/* reexport safe */ _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_3__.detectOverflow),
/* harmony export */   "flip": () => (/* reexport safe */ _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_3__.flip),
/* harmony export */   "getOverflowAncestors": () => (/* reexport safe */ _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_4__.getOverflowAncestors),
/* harmony export */   "hide": () => (/* reexport safe */ _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_3__.hide),
/* harmony export */   "inline": () => (/* reexport safe */ _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_3__.inline),
/* harmony export */   "inner": () => (/* binding */ inner),
/* harmony export */   "limitShift": () => (/* reexport safe */ _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_3__.limitShift),
/* harmony export */   "offset": () => (/* reexport safe */ _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_3__.offset),
/* harmony export */   "platform": () => (/* reexport safe */ _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_4__.platform),
/* harmony export */   "safePolygon": () => (/* binding */ safePolygon),
/* harmony export */   "shift": () => (/* reexport safe */ _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_3__.shift),
/* harmony export */   "size": () => (/* reexport safe */ _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_3__.size),
/* harmony export */   "useClick": () => (/* binding */ useClick),
/* harmony export */   "useDelayGroup": () => (/* binding */ useDelayGroup),
/* harmony export */   "useDelayGroupContext": () => (/* binding */ useDelayGroupContext),
/* harmony export */   "useDismiss": () => (/* binding */ useDismiss),
/* harmony export */   "useFloating": () => (/* binding */ useFloating),
/* harmony export */   "useFloatingNodeId": () => (/* binding */ useFloatingNodeId),
/* harmony export */   "useFloatingParentNodeId": () => (/* binding */ useFloatingParentNodeId),
/* harmony export */   "useFloatingPortalNode": () => (/* binding */ useFloatingPortalNode),
/* harmony export */   "useFloatingTree": () => (/* binding */ useFloatingTree),
/* harmony export */   "useFocus": () => (/* binding */ useFocus),
/* harmony export */   "useHover": () => (/* binding */ useHover),
/* harmony export */   "useId": () => (/* binding */ useId),
/* harmony export */   "useInnerOffset": () => (/* binding */ useInnerOffset),
/* harmony export */   "useInteractions": () => (/* binding */ useInteractions),
/* harmony export */   "useListNavigation": () => (/* binding */ useListNavigation),
/* harmony export */   "useMergeRefs": () => (/* binding */ useMergeRefs),
/* harmony export */   "useRole": () => (/* binding */ useRole),
/* harmony export */   "useTransitionStatus": () => (/* binding */ useTransitionStatus),
/* harmony export */   "useTransitionStyles": () => (/* binding */ useTransitionStyles),
/* harmony export */   "useTypeahead": () => (/* binding */ useTypeahead)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var aria_hidden__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! aria-hidden */ "./node_modules/aria-hidden/dist/es2015/index.js");
/* harmony import */ var tabbable__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tabbable */ "./node_modules/tabbable/dist/index.esm.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "webpack/sharing/consume/default/react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @floating-ui/react-dom */ "./node_modules/@floating-ui/dom/dist/floating-ui.dom.browser.mjs");
/* harmony import */ var _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @floating-ui/react-dom */ "./node_modules/@floating-ui/core/dist/floating-ui.core.browser.mjs");
/* harmony import */ var _floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @floating-ui/react-dom */ "./node_modules/@floating-ui/react-dom/dist/floating-ui.react-dom.esm.js");








var index = typeof document !== 'undefined' ? react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_0__.useEffect;

let serverHandoffComplete = false;
let count = 0;
const genId = () => "floating-ui-" + count++;
function useFloatingId() {
  const [id, setId] = react__WEBPACK_IMPORTED_MODULE_0__.useState(() => serverHandoffComplete ? genId() : undefined);
  index(() => {
    if (id == null) {
      setId(genId());
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!serverHandoffComplete) {
      serverHandoffComplete = true;
    }
  }, []);
  return id;
}

// `toString()` prevents bundlers from trying to `import { useId } from 'react'`
const useReactId = react__WEBPACK_IMPORTED_MODULE_0__[/*#__PURE__*/'useId'.toString()];

/**
 * Uses React 18's built-in `useId()` when available, or falls back to a
 * slightly less performant (requiring a double render) implementation for
 * earlier React versions.
 * @see https://floating-ui.com/docs/useId
 */
const useId = useReactId || useFloatingId;

function createPubSub() {
  const map = new Map();
  return {
    emit(event, data) {
      var _map$get;
      (_map$get = map.get(event)) == null ? void 0 : _map$get.forEach(handler => handler(data));
    },
    on(event, listener) {
      map.set(event, [...(map.get(event) || []), listener]);
    },
    off(event, listener) {
      map.set(event, (map.get(event) || []).filter(l => l !== listener));
    }
  };
}

const FloatingNodeContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
const FloatingTreeContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
const useFloatingParentNodeId = () => {
  var _React$useContext;
  return ((_React$useContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(FloatingNodeContext)) == null ? void 0 : _React$useContext.id) || null;
};
const useFloatingTree = () => react__WEBPACK_IMPORTED_MODULE_0__.useContext(FloatingTreeContext);

/**
 * Registers a node into the floating tree, returning its id.
 */
const useFloatingNodeId = customParentId => {
  const id = useId();
  const tree = useFloatingTree();
  const reactParentId = useFloatingParentNodeId();
  const parentId = customParentId || reactParentId;
  index(() => {
    const node = {
      id,
      parentId
    };
    tree == null ? void 0 : tree.addNode(node);
    return () => {
      tree == null ? void 0 : tree.removeNode(node);
    };
  }, [tree, id, parentId]);
  return id;
};

/**
 * Provides parent node context for nested floating elements.
 * @see https://floating-ui.com/docs/FloatingTree
 */
const FloatingNode = _ref => {
  let {
    children,
    id
  } = _ref;
  const parentId = useFloatingParentNodeId();
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(FloatingNodeContext.Provider, {
    value: react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
      id,
      parentId
    }), [id, parentId])
  }, children);
};

/**
 * Provides context for nested floating elements when they are not children of
 * each other on the DOM (i.e. portalled to a common node, rather than their
 * respective parent).
 * @see https://floating-ui.com/docs/FloatingTree
 */
const FloatingTree = _ref2 => {
  let {
    children
  } = _ref2;
  const nodesRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef([]);
  const addNode = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(node => {
    nodesRef.current = [...nodesRef.current, node];
  }, []);
  const removeNode = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(node => {
    nodesRef.current = nodesRef.current.filter(n => n !== node);
  }, []);
  const events = react__WEBPACK_IMPORTED_MODULE_0__.useState(() => createPubSub())[0];
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(FloatingTreeContext.Provider, {
    value: react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
      nodesRef,
      addNode,
      removeNode,
      events
    }), [nodesRef, addNode, removeNode, events])
  }, children);
};

function getDocument(node) {
  return (node == null ? void 0 : node.ownerDocument) || document;
}

// Avoid Chrome DevTools blue warning.
function getPlatform() {
  const uaData = navigator.userAgentData;
  if (uaData != null && uaData.platform) {
    return uaData.platform;
  }
  return navigator.platform;
}
function getUserAgent() {
  const uaData = navigator.userAgentData;
  if (uaData && Array.isArray(uaData.brands)) {
    return uaData.brands.map(_ref => {
      let {
        brand,
        version
      } = _ref;
      return brand + "/" + version;
    }).join(' ');
  }
  return navigator.userAgent;
}

function getWindow(value) {
  return getDocument(value).defaultView || window;
}
function isElement(value) {
  return value ? value instanceof getWindow(value).Element : false;
}
function isHTMLElement(value) {
  return value ? value instanceof getWindow(value).HTMLElement : false;
}
function isShadowRoot(node) {
  // Browsers without `ShadowRoot` support
  if (typeof ShadowRoot === 'undefined') {
    return false;
  }
  const OwnElement = getWindow(node).ShadowRoot;
  return node instanceof OwnElement || node instanceof ShadowRoot;
}

// License: https://github.com/adobe/react-spectrum/blob/b35d5c02fe900badccd0cf1a8f23bb593419f238/packages/@react-aria/utils/src/isVirtualEvent.ts
function isVirtualClick(event) {
  if (event.mozInputSource === 0 && event.isTrusted) {
    return true;
  }
  const androidRe = /Android/i;
  if ((androidRe.test(getPlatform()) || androidRe.test(getUserAgent())) && event.pointerType) {
    return event.type === 'click' && event.buttons === 1;
  }
  return event.detail === 0 && !event.pointerType;
}
function isVirtualPointerEvent(event) {
  return event.width === 0 && event.height === 0 || event.width === 1 && event.height === 1 && event.pressure === 0 && event.detail === 0 && event.pointerType !== 'mouse' ||
  // iOS VoiceOver returns 0.333• for width/height.
  event.width < 1 && event.height < 1 && event.pressure === 0 && event.detail === 0;
}
function isSafari() {
  // Chrome DevTools does not complain about navigator.vendor
  return /apple/i.test(navigator.vendor);
}
function isMac() {
  return getPlatform().toLowerCase().startsWith('mac') && !navigator.maxTouchPoints;
}
function isMouseLikePointerType(pointerType, strict) {
  // On some Linux machines with Chromium, mouse inputs return a `pointerType`
  // of "pen": https://github.com/floating-ui/floating-ui/issues/2015
  const values = ['mouse', 'pen'];
  if (!strict) {
    values.push('', undefined);
  }
  return values.includes(pointerType);
}

function useLatestRef(value) {
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(value);
  index(() => {
    ref.current = value;
  });
  return ref;
}

const safePolygonIdentifier = 'data-floating-ui-safe-polygon';
function getDelay(value, prop, pointerType) {
  if (pointerType && !isMouseLikePointerType(pointerType)) {
    return 0;
  }
  if (typeof value === 'number') {
    return value;
  }
  return value == null ? void 0 : value[prop];
}
/**
 * Opens the floating element while hovering over the reference element, like
 * CSS `:hover`.
 * @see https://floating-ui.com/docs/useHover
 */
const useHover = function (context, _temp) {
  let {
    enabled = true,
    delay = 0,
    handleClose = null,
    mouseOnly = false,
    restMs = 0,
    move = true
  } = _temp === void 0 ? {} : _temp;
  const {
    open,
    onOpenChange,
    dataRef,
    events,
    elements: {
      domReference,
      floating
    },
    refs
  } = context;
  const tree = useFloatingTree();
  const parentId = useFloatingParentNodeId();
  const handleCloseRef = useLatestRef(handleClose);
  const delayRef = useLatestRef(delay);
  const pointerTypeRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  const timeoutRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  const handlerRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  const restTimeoutRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  const blockMouseMoveRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(true);
  const performedPointerEventsMutationRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  const unbindMouseMoveRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(() => {});
  const isHoverOpen = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    var _dataRef$current$open;
    const type = (_dataRef$current$open = dataRef.current.openEvent) == null ? void 0 : _dataRef$current$open.type;
    return (type == null ? void 0 : type.includes('mouse')) && type !== 'mousedown';
  }, [dataRef]);

  // When dismissing before opening, clear the delay timeouts to cancel it
  // from showing.
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!enabled) {
      return;
    }
    function onDismiss() {
      clearTimeout(timeoutRef.current);
      clearTimeout(restTimeoutRef.current);
      blockMouseMoveRef.current = true;
    }
    events.on('dismiss', onDismiss);
    return () => {
      events.off('dismiss', onDismiss);
    };
  }, [enabled, events]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!enabled || !handleCloseRef.current || !open) {
      return;
    }
    function onLeave() {
      if (isHoverOpen()) {
        onOpenChange(false);
      }
    }
    const html = getDocument(floating).documentElement;
    html.addEventListener('mouseleave', onLeave);
    return () => {
      html.removeEventListener('mouseleave', onLeave);
    };
  }, [floating, open, onOpenChange, enabled, handleCloseRef, dataRef, isHoverOpen]);
  const closeWithDelay = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (runElseBranch) {
    if (runElseBranch === void 0) {
      runElseBranch = true;
    }
    const closeDelay = getDelay(delayRef.current, 'close', pointerTypeRef.current);
    if (closeDelay && !handlerRef.current) {
      clearTimeout(timeoutRef.current);
      timeoutRef.current = setTimeout(() => onOpenChange(false), closeDelay);
    } else if (runElseBranch) {
      clearTimeout(timeoutRef.current);
      onOpenChange(false);
    }
  }, [delayRef, onOpenChange]);
  const cleanupMouseMoveHandler = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    unbindMouseMoveRef.current();
    handlerRef.current = undefined;
  }, []);
  const clearPointerEvents = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    if (performedPointerEventsMutationRef.current) {
      const body = getDocument(refs.floating.current).body;
      body.style.pointerEvents = '';
      body.removeAttribute(safePolygonIdentifier);
      performedPointerEventsMutationRef.current = false;
    }
  }, [refs]);

  // Registering the mouse events on the reference directly to bypass React's
  // delegation system. If the cursor was on a disabled element and then entered
  // the reference (no gap), `mouseenter` doesn't fire in the delegation system.
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!enabled) {
      return;
    }
    function isClickLikeOpenEvent() {
      return dataRef.current.openEvent ? ['click', 'mousedown'].includes(dataRef.current.openEvent.type) : false;
    }
    function onMouseEnter(event) {
      clearTimeout(timeoutRef.current);
      blockMouseMoveRef.current = false;
      if (mouseOnly && !isMouseLikePointerType(pointerTypeRef.current) || restMs > 0 && getDelay(delayRef.current, 'open') === 0) {
        return;
      }
      dataRef.current.openEvent = event;
      const openDelay = getDelay(delayRef.current, 'open', pointerTypeRef.current);
      if (openDelay) {
        timeoutRef.current = setTimeout(() => {
          onOpenChange(true);
        }, openDelay);
      } else {
        onOpenChange(true);
      }
    }
    function onMouseLeave(event) {
      if (isClickLikeOpenEvent()) {
        return;
      }
      unbindMouseMoveRef.current();
      const doc = getDocument(floating);
      clearTimeout(restTimeoutRef.current);
      if (handleCloseRef.current) {
        // Prevent clearing `onScrollMouseLeave` timeout.
        if (!open) {
          clearTimeout(timeoutRef.current);
        }
        handlerRef.current = handleCloseRef.current({
          ...context,
          tree,
          x: event.clientX,
          y: event.clientY,
          onClose() {
            clearPointerEvents();
            cleanupMouseMoveHandler();
            closeWithDelay();
          }
        });
        const handler = handlerRef.current;
        doc.addEventListener('mousemove', handler);
        unbindMouseMoveRef.current = () => {
          doc.removeEventListener('mousemove', handler);
        };
        return;
      }
      closeWithDelay();
    }

    // Ensure the floating element closes after scrolling even if the pointer
    // did not move.
    // https://github.com/floating-ui/floating-ui/discussions/1692
    function onScrollMouseLeave(event) {
      if (isClickLikeOpenEvent()) {
        return;
      }
      handleCloseRef.current == null ? void 0 : handleCloseRef.current({
        ...context,
        tree,
        x: event.clientX,
        y: event.clientY,
        onClose() {
          clearPointerEvents();
          cleanupMouseMoveHandler();
          closeWithDelay();
        }
      })(event);
    }
    if (isElement(domReference)) {
      const ref = domReference;
      open && ref.addEventListener('mouseleave', onScrollMouseLeave);
      floating == null ? void 0 : floating.addEventListener('mouseleave', onScrollMouseLeave);
      move && ref.addEventListener('mousemove', onMouseEnter, {
        once: true
      });
      ref.addEventListener('mouseenter', onMouseEnter);
      ref.addEventListener('mouseleave', onMouseLeave);
      return () => {
        open && ref.removeEventListener('mouseleave', onScrollMouseLeave);
        floating == null ? void 0 : floating.removeEventListener('mouseleave', onScrollMouseLeave);
        move && ref.removeEventListener('mousemove', onMouseEnter);
        ref.removeEventListener('mouseenter', onMouseEnter);
        ref.removeEventListener('mouseleave', onMouseLeave);
      };
    }
  }, [domReference, floating, enabled, context, mouseOnly, restMs, move, closeWithDelay, cleanupMouseMoveHandler, clearPointerEvents, onOpenChange, open, tree, delayRef, handleCloseRef, dataRef]);

  // Block pointer-events of every element other than the reference and floating
  // while the floating element is open and has a `handleClose` handler. Also
  // handles nested floating elements.
  // https://github.com/floating-ui/floating-ui/issues/1722
  index(() => {
    var _handleCloseRef$curre;
    if (!enabled) {
      return;
    }
    if (open && (_handleCloseRef$curre = handleCloseRef.current) != null && _handleCloseRef$curre.__options.blockPointerEvents && isHoverOpen()) {
      const body = getDocument(floating).body;
      body.setAttribute(safePolygonIdentifier, '');
      body.style.pointerEvents = 'none';
      performedPointerEventsMutationRef.current = true;
      if (isElement(domReference) && floating) {
        var _tree$nodesRef$curren, _tree$nodesRef$curren2;
        const ref = domReference;
        const parentFloating = tree == null ? void 0 : (_tree$nodesRef$curren = tree.nodesRef.current.find(node => node.id === parentId)) == null ? void 0 : (_tree$nodesRef$curren2 = _tree$nodesRef$curren.context) == null ? void 0 : _tree$nodesRef$curren2.elements.floating;
        if (parentFloating) {
          parentFloating.style.pointerEvents = '';
        }
        ref.style.pointerEvents = 'auto';
        floating.style.pointerEvents = 'auto';
        return () => {
          ref.style.pointerEvents = '';
          floating.style.pointerEvents = '';
        };
      }
    }
  }, [enabled, open, parentId, floating, domReference, tree, handleCloseRef, dataRef, isHoverOpen]);
  index(() => {
    if (!open) {
      pointerTypeRef.current = undefined;
      cleanupMouseMoveHandler();
      clearPointerEvents();
    }
  }, [open, cleanupMouseMoveHandler, clearPointerEvents]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    return () => {
      cleanupMouseMoveHandler();
      clearTimeout(timeoutRef.current);
      clearTimeout(restTimeoutRef.current);
      clearPointerEvents();
    };
  }, [enabled, cleanupMouseMoveHandler, clearPointerEvents]);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    if (!enabled) {
      return {};
    }
    function setPointerRef(event) {
      pointerTypeRef.current = event.pointerType;
    }
    return {
      reference: {
        onPointerDown: setPointerRef,
        onPointerEnter: setPointerRef,
        onMouseMove() {
          if (open || restMs === 0) {
            return;
          }
          clearTimeout(restTimeoutRef.current);
          restTimeoutRef.current = setTimeout(() => {
            if (!blockMouseMoveRef.current) {
              onOpenChange(true);
            }
          }, restMs);
        }
      },
      floating: {
        onMouseEnter() {
          clearTimeout(timeoutRef.current);
        },
        onMouseLeave() {
          events.emit('dismiss', {
            type: 'mouseLeave',
            data: {
              returnFocus: false
            }
          });
          closeWithDelay(false);
        }
      }
    };
  }, [events, enabled, restMs, open, onOpenChange, closeWithDelay]);
};

const FloatingDelayGroupContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext({
  delay: 0,
  initialDelay: 0,
  timeoutMs: 0,
  currentId: null,
  setCurrentId: () => {},
  setState: () => {},
  isInstantPhase: false
});
const useDelayGroupContext = () => react__WEBPACK_IMPORTED_MODULE_0__.useContext(FloatingDelayGroupContext);

/**
 * Provides context for a group of floating elements that should share a
 * `delay`.
 * @see https://floating-ui.com/docs/FloatingDelayGroup
 */
const FloatingDelayGroup = _ref => {
  let {
    children,
    delay,
    timeoutMs = 0
  } = _ref;
  const [state, setState] = react__WEBPACK_IMPORTED_MODULE_0__.useReducer((prev, next) => ({
    ...prev,
    ...next
  }), {
    delay,
    timeoutMs,
    initialDelay: delay,
    currentId: null,
    isInstantPhase: false
  });
  const initialCurrentIdRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);
  const setCurrentId = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(currentId => {
    setState({
      currentId
    });
  }, []);
  index(() => {
    if (state.currentId) {
      if (initialCurrentIdRef.current === null) {
        initialCurrentIdRef.current = state.currentId;
      } else {
        setState({
          isInstantPhase: true
        });
      }
    } else {
      setState({
        isInstantPhase: false
      });
      initialCurrentIdRef.current = null;
    }
  }, [state.currentId]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(FloatingDelayGroupContext.Provider, {
    value: react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
      ...state,
      setState,
      setCurrentId
    }), [state, setState, setCurrentId])
  }, children);
};
const useDelayGroup = (_ref2, _ref3) => {
  let {
    open,
    onOpenChange
  } = _ref2;
  let {
    id
  } = _ref3;
  const {
    currentId,
    setCurrentId,
    initialDelay,
    setState,
    timeoutMs
  } = useDelayGroupContext();
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (currentId) {
      setState({
        delay: {
          open: 1,
          close: getDelay(initialDelay, 'close')
        }
      });
      if (currentId !== id) {
        onOpenChange(false);
      }
    }
  }, [id, onOpenChange, setState, currentId, initialDelay]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    function unset() {
      onOpenChange(false);
      setState({
        delay: initialDelay,
        currentId: null
      });
    }
    if (!open && currentId === id) {
      if (timeoutMs) {
        const timeout = window.setTimeout(unset, timeoutMs);
        return () => {
          clearTimeout(timeout);
        };
      } else {
        unset();
      }
    }
  }, [open, setState, currentId, id, onOpenChange, initialDelay, timeoutMs]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (open) {
      setCurrentId(id);
    }
  }, [open, setCurrentId, id]);
};

function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}

/**
 * Find the real active element. Traverses into shadowRoots.
 */
function activeElement$1(doc) {
  let activeElement = doc.activeElement;
  while (((_activeElement = activeElement) == null ? void 0 : (_activeElement$shadow = _activeElement.shadowRoot) == null ? void 0 : _activeElement$shadow.activeElement) != null) {
    var _activeElement, _activeElement$shadow;
    activeElement = activeElement.shadowRoot.activeElement;
  }
  return activeElement;
}

function contains(parent, child) {
  if (!parent || !child) {
    return false;
  }
  const rootNode = child.getRootNode && child.getRootNode();

  // First, attempt with faster native method
  if (parent.contains(child)) {
    return true;
  }
  // then fallback to custom implementation with Shadow DOM support
  else if (rootNode && isShadowRoot(rootNode)) {
    let next = child;
    do {
      if (next && parent === next) {
        return true;
      }
      // @ts-ignore
      next = next.parentNode || next.host;
    } while (next);
  }

  // Give up, the result is false
  return false;
}

let rafId = 0;
function enqueueFocus(el, options) {
  if (options === void 0) {
    options = {};
  }
  const {
    preventScroll = false,
    cancelPrevious = true,
    sync = false
  } = options;
  cancelPrevious && cancelAnimationFrame(rafId);
  const exec = () => el == null ? void 0 : el.focus({
    preventScroll
  });
  if (sync) {
    exec();
  } else {
    rafId = requestAnimationFrame(exec);
  }
}

function getAncestors(nodes, id) {
  var _nodes$find;
  let allAncestors = [];
  let currentParentId = (_nodes$find = nodes.find(node => node.id === id)) == null ? void 0 : _nodes$find.parentId;
  while (currentParentId) {
    const currentNode = nodes.find(node => node.id === currentParentId);
    currentParentId = currentNode == null ? void 0 : currentNode.parentId;
    if (currentNode) {
      allAncestors = allAncestors.concat(currentNode);
    }
  }
  return allAncestors;
}

function getChildren(nodes, id) {
  let allChildren = nodes.filter(node => {
    var _node$context;
    return node.parentId === id && ((_node$context = node.context) == null ? void 0 : _node$context.open);
  }) || [];
  let currentChildren = allChildren;
  while (currentChildren.length) {
    currentChildren = nodes.filter(node => {
      var _currentChildren;
      return (_currentChildren = currentChildren) == null ? void 0 : _currentChildren.some(n => {
        var _node$context2;
        return node.parentId === n.id && ((_node$context2 = node.context) == null ? void 0 : _node$context2.open);
      });
    }) || [];
    allChildren = allChildren.concat(currentChildren);
  }
  return allChildren;
}

function getTarget(event) {
  if ('composedPath' in event) {
    return event.composedPath()[0];
  }

  // TS thinks `event` is of type never as it assumes all browsers support
  // `composedPath()`, but browsers without shadow DOM don't.
  return event.target;
}

const TYPEABLE_SELECTOR = "input:not([type='hidden']):not([disabled])," + "[contenteditable]:not([contenteditable='false']),textarea:not([disabled])";
function isTypeableElement(element) {
  return isHTMLElement(element) && element.matches(TYPEABLE_SELECTOR);
}

function stopEvent(event) {
  event.preventDefault();
  event.stopPropagation();
}

const getTabbableOptions = () => ({
  getShadowRoot: true,
  displayCheck:
  // JSDOM does not support the `tabbable` library. To solve this we can
  // check if `ResizeObserver` is a real function (not polyfilled), which
  // determines if the current environment is JSDOM-like.
  typeof ResizeObserver === 'function' && ResizeObserver.toString().includes('[native code]') ? 'full' : 'none'
});
function getTabbableIn(container, direction) {
  const allTabbable = (0,tabbable__WEBPACK_IMPORTED_MODULE_5__.tabbable)(container, getTabbableOptions());
  if (direction === 'prev') {
    allTabbable.reverse();
  }
  const activeIndex = allTabbable.indexOf(activeElement$1(getDocument(container)));
  const nextTabbableElements = allTabbable.slice(activeIndex + 1);
  return nextTabbableElements[0];
}
function getNextTabbable() {
  return getTabbableIn(document.body, 'next');
}
function getPreviousTabbable() {
  return getTabbableIn(document.body, 'prev');
}
function isOutsideEvent(event, container) {
  const containerElement = container || event.currentTarget;
  const relatedTarget = event.relatedTarget;
  return !relatedTarget || !contains(containerElement, relatedTarget);
}
function disableFocusInside(container) {
  const tabbableElements = (0,tabbable__WEBPACK_IMPORTED_MODULE_5__.tabbable)(container, getTabbableOptions());
  tabbableElements.forEach(element => {
    element.dataset.tabindex = element.getAttribute('tabindex') || '';
    element.setAttribute('tabindex', '-1');
  });
}
function enableFocusInside(container) {
  const elements = container.querySelectorAll('[data-tabindex]');
  elements.forEach(element => {
    const tabindex = element.dataset.tabindex;
    delete element.dataset.tabindex;
    if (tabindex) {
      element.setAttribute('tabindex', tabindex);
    } else {
      element.removeAttribute('tabindex');
    }
  });
}

// `toString()` prevents bundlers from trying to `import { useInsertionEffect } from 'react'`
const useInsertionEffect = react__WEBPACK_IMPORTED_MODULE_0__[/*#__PURE__*/'useInsertionEffect'.toString()];
const useSafeInsertionEffect = useInsertionEffect || (fn => fn());
function useEvent(callback) {
  const ref = react__WEBPACK_IMPORTED_MODULE_0__.useRef(() => {
    if (true) {
      throw new Error('Cannot call an event handler while rendering.');
    }
  });
  useSafeInsertionEffect(() => {
    ref.current = callback;
  });
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function () {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    return ref.current == null ? void 0 : ref.current(...args);
  }, []);
}

// See Diego Haz's Sandbox for making this logic work well on Safari/iOS:
// https://codesandbox.io/s/tabbable-portal-f4tng?file=/src/FocusTrap.tsx

const HIDDEN_STYLES = {
  border: 0,
  clip: 'rect(0 0 0 0)',
  height: '1px',
  margin: '-1px',
  overflow: 'hidden',
  padding: 0,
  position: 'fixed',
  whiteSpace: 'nowrap',
  width: '1px',
  top: 0,
  left: 0
};
let activeElement;
let timeoutId;
function setActiveElementOnTab(event) {
  if (event.key === 'Tab') {
    activeElement = event.target;
    clearTimeout(timeoutId);
  }
}
function isTabFocus(event) {
  const result = activeElement === event.relatedTarget;
  activeElement = event.relatedTarget;
  clearTimeout(timeoutId);
  return result;
}
const FocusGuard = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function FocusGuard(props, ref) {
  const onFocus = useEvent(props.onFocus);
  const [role, setRole] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  index(() => {
    if (isSafari()) {
      // Unlike other screen readers such as NVDA and JAWS, the virtual cursor
      // on VoiceOver does trigger the onFocus event, so we can use the focus
      // trap element. On Safari, only buttons trigger the onFocus event.
      // NB: "group" role in the Sandbox no longer appears to work, must be a
      // button role.
      setRole('button');
    }
    document.addEventListener('keydown', setActiveElementOnTab);
    return () => {
      document.removeEventListener('keydown', setActiveElementOnTab);
    };
  }, []);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", _extends({}, props, {
    ref: ref,
    tabIndex: 0
    // Role is only for VoiceOver
    ,
    role: role,
    "aria-hidden": role ? undefined : true,
    "data-floating-ui-focus-guard": "",
    style: HIDDEN_STYLES,
    onFocus: event => {
      if (isSafari() && isMac() && !isTabFocus(event)) {
        // On macOS we need to wait a little bit before moving
        // focus again.
        event.persist();
        timeoutId = window.setTimeout(() => {
          onFocus(event);
        }, 50);
      } else {
        onFocus(event);
      }
    }
  }));
});

const PortalContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
const useFloatingPortalNode = function (_temp) {
  let {
    id,
    enabled = true
  } = _temp === void 0 ? {} : _temp;
  const [portalEl, setPortalEl] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);
  const uniqueId = useId();
  const portalContext = usePortalContext();
  index(() => {
    if (!enabled) {
      return;
    }
    const rootNode = id ? document.getElementById(id) : null;
    if (rootNode) {
      rootNode.setAttribute('data-floating-ui-portal', '');
      setPortalEl(rootNode);
    } else {
      const newPortalEl = document.createElement('div');
      if (id !== '') {
        newPortalEl.id = id || uniqueId;
      }
      newPortalEl.setAttribute('data-floating-ui-portal', '');
      setPortalEl(newPortalEl);
      const container = (portalContext == null ? void 0 : portalContext.portalNode) || document.body;
      container.appendChild(newPortalEl);
      return () => {
        container.removeChild(newPortalEl);
      };
    }
  }, [id, portalContext, uniqueId, enabled]);
  return portalEl;
};

/**
 * Portals the floating element into a given container element — by default,
 * outside of the app root and into the body.
 * @see https://floating-ui.com/docs/FloatingPortal
 */
const FloatingPortal = _ref => {
  let {
    children,
    id,
    root = null,
    preserveTabOrder = true
  } = _ref;
  const portalNode = useFloatingPortalNode({
    id,
    enabled: !root
  });
  const [focusManagerState, setFocusManagerState] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);
  const beforeOutsideRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);
  const afterOutsideRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);
  const beforeInsideRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);
  const afterInsideRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);
  const shouldRenderGuards =
  // The FocusManager and therefore floating element are currently open/
  // rendered.
  !!focusManagerState &&
  // Guards are only for non-modal focus management.
  !focusManagerState.modal && !!(root || portalNode) && preserveTabOrder;

  // https://codesandbox.io/s/tabbable-portal-f4tng?file=/src/TabbablePortal.tsx
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!portalNode || !preserveTabOrder || focusManagerState != null && focusManagerState.modal) {
      return;
    }

    // Make sure elements inside the portal element are tabbable only when the
    // portal has already been focused, either by tabbing into a focus trap
    // element outside or using the mouse.
    function onFocus(event) {
      if (portalNode && isOutsideEvent(event)) {
        const focusing = event.type === 'focusin';
        const manageFocus = focusing ? enableFocusInside : disableFocusInside;
        manageFocus(portalNode);
      }
    }
    // Listen to the event on the capture phase so they run before the focus
    // trap elements onFocus prop is called.
    portalNode.addEventListener('focusin', onFocus, true);
    portalNode.addEventListener('focusout', onFocus, true);
    return () => {
      portalNode.removeEventListener('focusin', onFocus, true);
      portalNode.removeEventListener('focusout', onFocus, true);
    };
  }, [portalNode, preserveTabOrder, focusManagerState == null ? void 0 : focusManagerState.modal]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(PortalContext.Provider, {
    value: react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
      preserveTabOrder,
      beforeOutsideRef,
      afterOutsideRef,
      beforeInsideRef,
      afterInsideRef,
      portalNode,
      setFocusManagerState
    }), [preserveTabOrder, portalNode])
  }, shouldRenderGuards && portalNode && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(FocusGuard, {
    "data-type": "outside",
    ref: beforeOutsideRef,
    onFocus: event => {
      if (isOutsideEvent(event, portalNode)) {
        var _beforeInsideRef$curr;
        (_beforeInsideRef$curr = beforeInsideRef.current) == null ? void 0 : _beforeInsideRef$curr.focus();
      } else {
        const prevTabbable = getPreviousTabbable() || (focusManagerState == null ? void 0 : focusManagerState.refs.domReference.current);
        prevTabbable == null ? void 0 : prevTabbable.focus();
      }
    }
  }), shouldRenderGuards && portalNode && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", {
    "aria-owns": portalNode.id,
    style: HIDDEN_STYLES
  }), root ? /*#__PURE__*/(0,react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal)(children, root) : portalNode ? /*#__PURE__*/(0,react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal)(children, portalNode) : null, shouldRenderGuards && portalNode && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(FocusGuard, {
    "data-type": "outside",
    ref: afterOutsideRef,
    onFocus: event => {
      if (isOutsideEvent(event, portalNode)) {
        var _afterInsideRef$curre;
        (_afterInsideRef$curre = afterInsideRef.current) == null ? void 0 : _afterInsideRef$curre.focus();
      } else {
        const nextTabbable = getNextTabbable() || (focusManagerState == null ? void 0 : focusManagerState.refs.domReference.current);
        nextTabbable == null ? void 0 : nextTabbable.focus();
        (focusManagerState == null ? void 0 : focusManagerState.closeOnFocusOut) && (focusManagerState == null ? void 0 : focusManagerState.onOpenChange(false));
      }
    }
  }));
};
const usePortalContext = () => react__WEBPACK_IMPORTED_MODULE_0__.useContext(PortalContext);

const VisuallyHiddenDismiss = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function VisuallyHiddenDismiss(props, ref) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", _extends({}, props, {
    type: "button",
    ref: ref,
    tabIndex: -1,
    style: HIDDEN_STYLES
  }));
});
/**
 * Provides focus management for the floating element.
 * @see https://floating-ui.com/docs/FloatingFocusManager
 */
function FloatingFocusManager(_ref) {
  let {
    context,
    children,
    order = ['content'],
    guards = true,
    initialFocus = 0,
    returnFocus = true,
    modal = true,
    visuallyHiddenDismiss = false,
    closeOnFocusOut = true
  } = _ref;
  const {
    refs,
    nodeId,
    onOpenChange,
    events,
    dataRef,
    elements: {
      domReference,
      floating
    }
  } = context;
  const orderRef = useLatestRef(order);
  const tree = useFloatingTree();
  const portalContext = usePortalContext();
  const [tabbableContentLength, setTabbableContentLength] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);

  // Controlled by `useListNavigation`.
  const ignoreInitialFocus = typeof initialFocus === 'number' && initialFocus < 0;
  const startDismissButtonRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);
  const endDismissButtonRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);
  const preventReturnFocusRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  const previouslyFocusedElementRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);
  const isPointerDownRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  const isInsidePortal = portalContext != null;

  // If the reference is a combobox and is typeable (e.g. input/textarea),
  // there are different focus semantics. The guards should not be rendered, but
  // aria-hidden should be applied to all nodes still. Further, the visually
  // hidden dismiss button should only appear at the end of the list, not the
  // start.
  const isTypeableCombobox = domReference && domReference.getAttribute('role') === 'combobox' && isTypeableElement(domReference);
  const getTabbableContent = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (container) {
    if (container === void 0) {
      container = floating;
    }
    return container ? (0,tabbable__WEBPACK_IMPORTED_MODULE_5__.tabbable)(container, getTabbableOptions()) : [];
  }, [floating]);
  const getTabbableElements = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(container => {
    const content = getTabbableContent(container);
    return orderRef.current.map(type => {
      if (domReference && type === 'reference') {
        return domReference;
      }
      if (floating && type === 'floating') {
        return floating;
      }
      return content;
    }).filter(Boolean).flat();
  }, [domReference, floating, orderRef, getTabbableContent]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!modal) {
      return;
    }
    function onKeyDown(event) {
      if (event.key === 'Tab') {
        // The focus guards have nothing to focus, so we need to stop the event.
        if (getTabbableContent().length === 0 && !isTypeableCombobox) {
          stopEvent(event);
        }
        const els = getTabbableElements();
        const target = getTarget(event);
        if (orderRef.current[0] === 'reference' && target === domReference) {
          stopEvent(event);
          if (event.shiftKey) {
            enqueueFocus(els[els.length - 1]);
          } else {
            enqueueFocus(els[1]);
          }
        }
        if (orderRef.current[1] === 'floating' && target === floating && event.shiftKey) {
          stopEvent(event);
          enqueueFocus(els[0]);
        }
      }
    }
    const doc = getDocument(floating);
    doc.addEventListener('keydown', onKeyDown);
    return () => {
      doc.removeEventListener('keydown', onKeyDown);
    };
  }, [domReference, floating, modal, orderRef, refs, isTypeableCombobox, getTabbableContent, getTabbableElements]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!closeOnFocusOut) {
      return;
    }

    // In Safari, buttons lose focus when pressing them.
    function handlePointerDown() {
      isPointerDownRef.current = true;
      setTimeout(() => {
        isPointerDownRef.current = false;
      });
    }
    function handleFocusOutside(event) {
      const relatedTarget = event.relatedTarget;
      const movedToUnrelatedNode = !(contains(domReference, relatedTarget) || contains(floating, relatedTarget) || contains(relatedTarget, floating) || contains(portalContext == null ? void 0 : portalContext.portalNode, relatedTarget) || relatedTarget != null && relatedTarget.hasAttribute('data-floating-ui-focus-guard') || tree && (getChildren(tree.nodesRef.current, nodeId).find(node => {
        var _node$context, _node$context2;
        return contains((_node$context = node.context) == null ? void 0 : _node$context.elements.floating, relatedTarget) || contains((_node$context2 = node.context) == null ? void 0 : _node$context2.elements.domReference, relatedTarget);
      }) || getAncestors(tree.nodesRef.current, nodeId).find(node => {
        var _node$context3, _node$context4;
        return ((_node$context3 = node.context) == null ? void 0 : _node$context3.elements.floating) === relatedTarget || ((_node$context4 = node.context) == null ? void 0 : _node$context4.elements.domReference) === relatedTarget;
      })));

      // Focus did not move inside the floating tree, and there are no tabbable
      // portal guards to handle closing.
      if (relatedTarget && movedToUnrelatedNode && !isPointerDownRef.current &&
      // Fix React 18 Strict Mode returnFocus due to double rendering.
      relatedTarget !== previouslyFocusedElementRef.current) {
        preventReturnFocusRef.current = true;
        // On iOS VoiceOver, dismissing the nested submenu will cause the
        // first item of the list to receive focus. Delaying it appears to fix
        // the issue.
        setTimeout(() => onOpenChange(false));
      }
    }
    if (floating && isHTMLElement(domReference)) {
      domReference.addEventListener('focusout', handleFocusOutside);
      domReference.addEventListener('pointerdown', handlePointerDown);
      !modal && floating.addEventListener('focusout', handleFocusOutside);
      return () => {
        domReference.removeEventListener('focusout', handleFocusOutside);
        domReference.removeEventListener('pointerdown', handlePointerDown);
        !modal && floating.removeEventListener('focusout', handleFocusOutside);
      };
    }
  }, [domReference, floating, modal, nodeId, tree, portalContext, onOpenChange, closeOnFocusOut]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    var _portalContext$portal;
    // Don't hide portals nested within the parent portal.
    const portalNodes = Array.from((portalContext == null ? void 0 : (_portalContext$portal = portalContext.portalNode) == null ? void 0 : _portalContext$portal.querySelectorAll('[data-floating-ui-portal]')) || []);
    function getDismissButtons() {
      return [startDismissButtonRef.current, endDismissButtonRef.current].filter(Boolean);
    }
    if (floating && modal) {
      const insideNodes = [floating, ...portalNodes, ...getDismissButtons()];
      const cleanup = (0,aria_hidden__WEBPACK_IMPORTED_MODULE_6__.hideOthers)(orderRef.current.includes('reference') || isTypeableCombobox ? insideNodes.concat(domReference || []) : insideNodes);
      return () => {
        cleanup();
      };
    }
  }, [domReference, floating, modal, orderRef, portalContext, isTypeableCombobox]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (modal && !guards && floating) {
      const tabIndexValues = [];
      const options = getTabbableOptions();
      const allTabbable = (0,tabbable__WEBPACK_IMPORTED_MODULE_5__.tabbable)(getDocument(floating).body, options);
      const floatingTabbable = getTabbableElements();

      // Exclude all tabbable elements that are part of the order
      const elements = allTabbable.filter(el => !floatingTabbable.includes(el));
      elements.forEach((el, i) => {
        tabIndexValues[i] = el.getAttribute('tabindex');
        el.setAttribute('tabindex', '-1');
      });
      return () => {
        elements.forEach((el, i) => {
          const value = tabIndexValues[i];
          if (value == null) {
            el.removeAttribute('tabindex');
          } else {
            el.setAttribute('tabindex', value);
          }
        });
      };
    }
  }, [floating, modal, guards, getTabbableElements]);
  index(() => {
    if (!floating) return;
    const doc = getDocument(floating);
    let returnFocusValue = returnFocus;
    let preventReturnFocusScroll = false;
    const previouslyFocusedElement = activeElement$1(doc);
    const contextData = dataRef.current;
    previouslyFocusedElementRef.current = previouslyFocusedElement;
    const focusableElements = getTabbableElements(floating);
    const elToFocus = (typeof initialFocus === 'number' ? focusableElements[initialFocus] : initialFocus.current) || floating;

    // If the `useListNavigation` hook is active, always ignore `initialFocus`
    // because it has its own handling of the initial focus.
    !ignoreInitialFocus && enqueueFocus(elToFocus, {
      preventScroll: elToFocus === floating
    });

    // Dismissing via outside press should always ignore `returnFocus` to
    // prevent unwanted scrolling.
    function onDismiss(payload) {
      if (payload.type === 'escapeKey' && refs.domReference.current) {
        previouslyFocusedElementRef.current = refs.domReference.current;
      }
      if (['referencePress', 'escapeKey'].includes(payload.type)) {
        return;
      }
      const returnFocus = payload.data.returnFocus;
      if (typeof returnFocus === 'object') {
        returnFocusValue = true;
        preventReturnFocusScroll = returnFocus.preventScroll;
      } else {
        returnFocusValue = returnFocus;
      }
    }
    events.on('dismiss', onDismiss);
    return () => {
      events.off('dismiss', onDismiss);
      if (contains(floating, activeElement$1(doc)) && refs.domReference.current) {
        previouslyFocusedElementRef.current = refs.domReference.current;
      }
      if (returnFocusValue && isHTMLElement(previouslyFocusedElementRef.current) && !preventReturnFocusRef.current) {
        // `isPointerDownRef.current` to avoid the focus ring from appearing on
        // the reference element when click-toggling it.
        if (!refs.domReference.current || isPointerDownRef.current) {
          enqueueFocus(previouslyFocusedElementRef.current, {
            // When dismissing nested floating elements, by the time the rAF has
            // executed, the menus will all have been unmounted. When they try
            // to get focused, the calls get ignored — leaving the root
            // reference focused as desired.
            cancelPrevious: false,
            preventScroll: preventReturnFocusScroll
          });
        } else {
          var _previouslyFocusedEle;
          // If the user has specified a `keydown` listener that calls
          // setOpen(false) (e.g. selecting an item and closing the floating
          // element), then sync return focus causes `useClick` to immediately
          // re-open it, unless they call `event.preventDefault()` in the
          // `keydown` listener. This helps keep backwards compatibility with
          // older examples.
          contextData.__syncReturnFocus = true;

          // In Safari, `useListNavigation` moves focus sync, so making this
          // sync ensures the initial item remains focused despite this being
          // invoked in Strict Mode due to double-invoked useEffects. This also
          // has the positive side effect of closing a modally focus-managed
          // <Menu> on `Tab` keydown to move naturally to the next focusable
          // element.
          (_previouslyFocusedEle = previouslyFocusedElementRef.current) == null ? void 0 : _previouslyFocusedEle.focus({
            preventScroll: preventReturnFocusScroll
          });
          setTimeout(() => {
            // This isn't an actual property the user should access, make sure
            // it doesn't persist.
            delete contextData.__syncReturnFocus;
          });
        }
      }
    };
  }, [floating, getTabbableElements, initialFocus, returnFocus, dataRef, refs, events, ignoreInitialFocus]);

  // Synchronize the `context` & `modal` value to the FloatingPortal context.
  // It will decide whether or not it needs to render its own guards.
  index(() => {
    if (!portalContext) return;
    portalContext.setFocusManagerState({
      ...context,
      modal,
      closeOnFocusOut
      // Not concerned about the <RT> generic type.
    });

    return () => {
      portalContext.setFocusManagerState(null);
    };
  }, [portalContext, modal, closeOnFocusOut, context]);
  index(() => {
    if (ignoreInitialFocus || !floating) return;
    function setState() {
      setTabbableContentLength(getTabbableContent().length);
    }
    setState();
    if (typeof MutationObserver === 'function') {
      const observer = new MutationObserver(setState);
      observer.observe(floating, {
        childList: true,
        subtree: true
      });
      return () => {
        observer.disconnect();
      };
    }
  }, [floating, getTabbableContent, ignoreInitialFocus, refs]);
  const shouldRenderGuards = guards && (isInsidePortal || modal) && !isTypeableCombobox;
  function renderDismissButton(location) {
    return visuallyHiddenDismiss && modal ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(VisuallyHiddenDismiss, {
      ref: location === 'start' ? startDismissButtonRef : endDismissButtonRef,
      onClick: () => onOpenChange(false)
    }, typeof visuallyHiddenDismiss === 'string' ? visuallyHiddenDismiss : 'Dismiss') : null;
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, shouldRenderGuards && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(FocusGuard, {
    "data-type": "inside",
    ref: portalContext == null ? void 0 : portalContext.beforeInsideRef,
    onFocus: event => {
      if (modal) {
        const els = getTabbableElements();
        enqueueFocus(order[0] === 'reference' ? els[0] : els[els.length - 1]);
      } else if (portalContext != null && portalContext.preserveTabOrder && portalContext.portalNode) {
        preventReturnFocusRef.current = false;
        if (isOutsideEvent(event, portalContext.portalNode)) {
          const nextTabbable = getNextTabbable() || domReference;
          nextTabbable == null ? void 0 : nextTabbable.focus();
        } else {
          var _portalContext$before;
          (_portalContext$before = portalContext.beforeOutsideRef.current) == null ? void 0 : _portalContext$before.focus();
        }
      }
    }
  }), isTypeableCombobox ? null : renderDismissButton('start'), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(children, tabbableContentLength === 0 || order.includes('floating') ? {
    tabIndex: 0
  } : {}), renderDismissButton('end'), shouldRenderGuards && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(FocusGuard, {
    "data-type": "inside",
    ref: portalContext == null ? void 0 : portalContext.afterInsideRef,
    onFocus: event => {
      if (modal) {
        enqueueFocus(getTabbableElements()[0]);
      } else if (portalContext != null && portalContext.preserveTabOrder && portalContext.portalNode) {
        preventReturnFocusRef.current = true;
        if (isOutsideEvent(event, portalContext.portalNode)) {
          const prevTabbable = getPreviousTabbable() || domReference;
          prevTabbable == null ? void 0 : prevTabbable.focus();
        } else {
          var _portalContext$afterO;
          (_portalContext$afterO = portalContext.afterOutsideRef.current) == null ? void 0 : _portalContext$afterO.focus();
        }
      }
    }
  }));
}

const identifier = 'data-floating-ui-scroll-lock';

/**
 * Provides base styling for a fixed overlay element to dim content or block
 * pointer events behind a floating element.
 * It's a regular `<div>`, so it can be styled via any CSS solution you prefer.
 * @see https://floating-ui.com/docs/FloatingOverlay
 */
const FloatingOverlay = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function FloatingOverlay(_ref, ref) {
  let {
    lockScroll = false,
    ...rest
  } = _ref;
  index(() => {
    var _window$visualViewpor, _window$visualViewpor2;
    if (!lockScroll) {
      return;
    }
    const alreadyLocked = document.body.hasAttribute(identifier);
    if (alreadyLocked) {
      return;
    }
    document.body.setAttribute(identifier, '');

    // RTL <body> scrollbar
    const scrollbarX = Math.round(document.documentElement.getBoundingClientRect().left) + document.documentElement.scrollLeft;
    const paddingProp = scrollbarX ? 'paddingLeft' : 'paddingRight';
    const scrollbarWidth = window.innerWidth - document.documentElement.clientWidth;

    // Only iOS doesn't respect `overflow: hidden` on document.body, and this
    // technique has fewer side effects.
    if (!/iP(hone|ad|od)|iOS/.test(getPlatform())) {
      Object.assign(document.body.style, {
        overflow: 'hidden',
        [paddingProp]: scrollbarWidth + "px"
      });
      return () => {
        document.body.removeAttribute(identifier);
        Object.assign(document.body.style, {
          overflow: '',
          [paddingProp]: ''
        });
      };
    }

    // iOS 12 does not support `visualViewport`.
    const offsetLeft = ((_window$visualViewpor = window.visualViewport) == null ? void 0 : _window$visualViewpor.offsetLeft) || 0;
    const offsetTop = ((_window$visualViewpor2 = window.visualViewport) == null ? void 0 : _window$visualViewpor2.offsetTop) || 0;
    const scrollX = window.pageXOffset;
    const scrollY = window.pageYOffset;
    Object.assign(document.body.style, {
      position: 'fixed',
      overflow: 'hidden',
      top: -(scrollY - Math.floor(offsetTop)) + "px",
      left: -(scrollX - Math.floor(offsetLeft)) + "px",
      right: '0',
      [paddingProp]: scrollbarWidth + "px"
    });
    return () => {
      Object.assign(document.body.style, {
        position: '',
        overflow: '',
        top: '',
        left: '',
        right: '',
        [paddingProp]: ''
      });
      document.body.removeAttribute(identifier);
      window.scrollTo(scrollX, scrollY);
    };
  }, [lockScroll]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", _extends({
    ref: ref
  }, rest, {
    style: {
      position: 'fixed',
      overflow: 'auto',
      top: 0,
      right: 0,
      bottom: 0,
      left: 0,
      ...rest.style
    }
  }));
});

function isButtonTarget(event) {
  return isHTMLElement(event.target) && event.target.tagName === 'BUTTON';
}
function isSpaceIgnored(element) {
  return isTypeableElement(element);
}
/**
 * Opens or closes the floating element when clicking the reference element.
 * @see https://floating-ui.com/docs/useClick
 */
const useClick = function (_ref, _temp) {
  let {
    open,
    onOpenChange,
    dataRef,
    elements: {
      domReference
    }
  } = _ref;
  let {
    enabled = true,
    event: eventOption = 'click',
    toggle = true,
    ignoreMouse = false,
    keyboardHandlers = true
  } = _temp === void 0 ? {} : _temp;
  const pointerTypeRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    if (!enabled) {
      return {};
    }
    return {
      reference: {
        onPointerDown(event) {
          pointerTypeRef.current = event.pointerType;
        },
        onMouseDown(event) {
          // Ignore all buttons except for the "main" button.
          // https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent/button
          if (event.button !== 0) {
            return;
          }
          if (isMouseLikePointerType(pointerTypeRef.current, true) && ignoreMouse) {
            return;
          }
          if (eventOption === 'click') {
            return;
          }
          if (open) {
            if (toggle && (dataRef.current.openEvent ? dataRef.current.openEvent.type === 'mousedown' : true)) {
              onOpenChange(false);
            }
          } else {
            // Prevent stealing focus from the floating element
            event.preventDefault();
            onOpenChange(true);
          }
          dataRef.current.openEvent = event.nativeEvent;
        },
        onClick(event) {
          if (dataRef.current.__syncReturnFocus) {
            return;
          }
          if (eventOption === 'mousedown' && pointerTypeRef.current) {
            pointerTypeRef.current = undefined;
            return;
          }
          if (isMouseLikePointerType(pointerTypeRef.current, true) && ignoreMouse) {
            return;
          }
          if (open) {
            if (toggle && (dataRef.current.openEvent ? dataRef.current.openEvent.type === 'click' : true)) {
              onOpenChange(false);
            }
          } else {
            onOpenChange(true);
          }
          dataRef.current.openEvent = event.nativeEvent;
        },
        onKeyDown(event) {
          pointerTypeRef.current = undefined;
          if (!keyboardHandlers) {
            return;
          }
          if (isButtonTarget(event)) {
            return;
          }
          if (event.key === ' ' && !isSpaceIgnored(domReference)) {
            // Prevent scrolling
            event.preventDefault();
          }
          if (event.key === 'Enter') {
            if (open) {
              if (toggle) {
                onOpenChange(false);
              }
            } else {
              onOpenChange(true);
            }
          }
        },
        onKeyUp(event) {
          if (!keyboardHandlers) {
            return;
          }
          if (isButtonTarget(event) || isSpaceIgnored(domReference)) {
            return;
          }
          if (event.key === ' ') {
            if (open) {
              if (toggle) {
                onOpenChange(false);
              }
            } else {
              onOpenChange(true);
            }
          }
        }
      }
    };
  }, [enabled, dataRef, eventOption, ignoreMouse, keyboardHandlers, domReference, toggle, open, onOpenChange]);
};

/**
 * Check whether the event.target is within the provided node. Uses event.composedPath if available for custom element support.
 *
 * @param event The event whose target/composedPath to check
 * @param node The node to check against
 * @returns Whether the event.target/composedPath is within the node.
 */
function isEventTargetWithin(event, node) {
  if (node == null) {
    return false;
  }
  if ('composedPath' in event) {
    return event.composedPath().includes(node);
  }

  // TS thinks `event` is of type never as it assumes all browsers support composedPath, but browsers without shadow dom don't
  const e = event;
  return e.target != null && node.contains(e.target);
}

const bubbleHandlerKeys = {
  pointerdown: 'onPointerDown',
  mousedown: 'onMouseDown',
  click: 'onClick'
};
const captureHandlerKeys = {
  pointerdown: 'onPointerDownCapture',
  mousedown: 'onMouseDownCapture',
  click: 'onClickCapture'
};
const normalizeBubblesProp = function (bubbles) {
  var _bubbles$escapeKey, _bubbles$outsidePress;
  if (bubbles === void 0) {
    bubbles = true;
  }
  return {
    escapeKeyBubbles: typeof bubbles === 'boolean' ? bubbles : (_bubbles$escapeKey = bubbles.escapeKey) != null ? _bubbles$escapeKey : true,
    outsidePressBubbles: typeof bubbles === 'boolean' ? bubbles : (_bubbles$outsidePress = bubbles.outsidePress) != null ? _bubbles$outsidePress : true
  };
};
/**
 * Closes the floating element when a dismissal is requested — by default, when
 * the user presses the `escape` key or outside of the floating element.
 * @see https://floating-ui.com/docs/useDismiss
 */
const useDismiss = function (_ref, _temp) {
  let {
    open,
    onOpenChange,
    events,
    nodeId,
    elements: {
      reference,
      domReference,
      floating
    },
    dataRef
  } = _ref;
  let {
    enabled = true,
    escapeKey = true,
    outsidePress: unstable_outsidePress = true,
    outsidePressEvent = 'pointerdown',
    referencePress = false,
    referencePressEvent = 'pointerdown',
    ancestorScroll = false,
    bubbles = true
  } = _temp === void 0 ? {} : _temp;
  const tree = useFloatingTree();
  const nested = useFloatingParentNodeId() != null;
  const outsidePressFn = useEvent(typeof unstable_outsidePress === 'function' ? unstable_outsidePress : () => false);
  const outsidePress = typeof unstable_outsidePress === 'function' ? outsidePressFn : unstable_outsidePress;
  const insideReactTreeRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  const {
    escapeKeyBubbles,
    outsidePressBubbles
  } = normalizeBubblesProp(bubbles);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!open || !enabled) {
      return;
    }
    dataRef.current.__escapeKeyBubbles = escapeKeyBubbles;
    dataRef.current.__outsidePressBubbles = outsidePressBubbles;
    function onKeyDown(event) {
      if (event.key === 'Escape') {
        const children = tree ? getChildren(tree.nodesRef.current, nodeId) : [];
        if (children.length > 0) {
          let shouldDismiss = true;
          children.forEach(child => {
            var _child$context;
            if ((_child$context = child.context) != null && _child$context.open && !child.context.dataRef.current.__escapeKeyBubbles) {
              shouldDismiss = false;
              return;
            }
          });
          if (!shouldDismiss) {
            return;
          }
        }
        events.emit('dismiss', {
          type: 'escapeKey',
          data: {
            returnFocus: {
              preventScroll: false
            }
          }
        });
        onOpenChange(false);
      }
    }
    function onOutsidePress(event) {
      // Given developers can stop the propagation of the synthetic event,
      // we can only be confident with a positive value.
      const insideReactTree = insideReactTreeRef.current;
      insideReactTreeRef.current = false;
      if (insideReactTree) {
        return;
      }
      if (typeof outsidePress === 'function' && !outsidePress(event)) {
        return;
      }
      const target = getTarget(event);

      // Check if the click occurred on the scrollbar
      if (isHTMLElement(target) && floating) {
        const win = floating.ownerDocument.defaultView || window;
        const canScrollX = target.scrollWidth > target.clientWidth;
        const canScrollY = target.scrollHeight > target.clientHeight;
        let xCond = canScrollY && event.offsetX > target.clientWidth;

        // In some browsers it is possible to change the <body> (or window)
        // scrollbar to the left side, but is very rare and is difficult to
        // check for. Plus, for modal dialogs with backdrops, it is more
        // important that the backdrop is checked but not so much the window.
        if (canScrollY) {
          const isRTL = win.getComputedStyle(target).direction === 'rtl';
          if (isRTL) {
            xCond = event.offsetX <= target.offsetWidth - target.clientWidth;
          }
        }
        if (xCond || canScrollX && event.offsetY > target.clientHeight) {
          return;
        }
      }
      const targetIsInsideChildren = tree && getChildren(tree.nodesRef.current, nodeId).some(node => {
        var _node$context;
        return isEventTargetWithin(event, (_node$context = node.context) == null ? void 0 : _node$context.elements.floating);
      });
      if (isEventTargetWithin(event, floating) || isEventTargetWithin(event, domReference) || targetIsInsideChildren) {
        return;
      }
      const children = tree ? getChildren(tree.nodesRef.current, nodeId) : [];
      if (children.length > 0) {
        let shouldDismiss = true;
        children.forEach(child => {
          var _child$context2;
          if ((_child$context2 = child.context) != null && _child$context2.open && !child.context.dataRef.current.__outsidePressBubbles) {
            shouldDismiss = false;
            return;
          }
        });
        if (!shouldDismiss) {
          return;
        }
      }
      events.emit('dismiss', {
        type: 'outsidePress',
        data: {
          returnFocus: nested ? {
            preventScroll: true
          } : isVirtualClick(event) || isVirtualPointerEvent(event)
        }
      });
      onOpenChange(false);
    }
    function onScroll() {
      onOpenChange(false);
    }
    const doc = getDocument(floating);
    escapeKey && doc.addEventListener('keydown', onKeyDown);
    outsidePress && doc.addEventListener(outsidePressEvent, onOutsidePress);
    let ancestors = [];
    if (ancestorScroll) {
      if (isElement(domReference)) {
        ancestors = (0,_floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_4__.getOverflowAncestors)(domReference);
      }
      if (isElement(floating)) {
        ancestors = ancestors.concat((0,_floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_4__.getOverflowAncestors)(floating));
      }
      if (!isElement(reference) && reference && reference.contextElement) {
        ancestors = ancestors.concat((0,_floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_4__.getOverflowAncestors)(reference.contextElement));
      }
    }

    // Ignore the visual viewport for scrolling dismissal (allow pinch-zoom)
    ancestors = ancestors.filter(ancestor => {
      var _doc$defaultView;
      return ancestor !== ((_doc$defaultView = doc.defaultView) == null ? void 0 : _doc$defaultView.visualViewport);
    });
    ancestors.forEach(ancestor => {
      ancestor.addEventListener('scroll', onScroll, {
        passive: true
      });
    });
    return () => {
      escapeKey && doc.removeEventListener('keydown', onKeyDown);
      outsidePress && doc.removeEventListener(outsidePressEvent, onOutsidePress);
      ancestors.forEach(ancestor => {
        ancestor.removeEventListener('scroll', onScroll);
      });
    };
  }, [dataRef, floating, domReference, reference, escapeKey, outsidePress, outsidePressEvent, events, tree, nodeId, open, onOpenChange, ancestorScroll, enabled, escapeKeyBubbles, outsidePressBubbles, nested]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    insideReactTreeRef.current = false;
  }, [outsidePress, outsidePressEvent]);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    if (!enabled) {
      return {};
    }
    return {
      reference: {
        [bubbleHandlerKeys[referencePressEvent]]: () => {
          if (referencePress) {
            events.emit('dismiss', {
              type: 'referencePress',
              data: {
                returnFocus: false
              }
            });
            onOpenChange(false);
          }
        }
      },
      floating: {
        [captureHandlerKeys[outsidePressEvent]]: () => {
          insideReactTreeRef.current = true;
        }
      }
    };
  }, [enabled, events, referencePress, outsidePressEvent, referencePressEvent, onOpenChange]);
};

/**
 * Opens the floating element while the reference element has focus, like CSS
 * `:focus`.
 * @see https://floating-ui.com/docs/useFocus
 */
const useFocus = function (_ref, _temp) {
  let {
    open,
    onOpenChange,
    dataRef,
    events,
    refs,
    elements: {
      floating,
      domReference
    }
  } = _ref;
  let {
    enabled = true,
    keyboardOnly = true
  } = _temp === void 0 ? {} : _temp;
  const pointerTypeRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef('');
  const blockFocusRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  const timeoutRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!enabled) {
      return;
    }
    const doc = getDocument(floating);
    const win = doc.defaultView || window;

    // If the reference was focused and the user left the tab/window, and the
    // floating element was not open, the focus should be blocked when they
    // return to the tab/window.
    function onBlur() {
      if (!open && isHTMLElement(domReference) && domReference === activeElement$1(getDocument(domReference))) {
        blockFocusRef.current = true;
      }
    }
    win.addEventListener('blur', onBlur);
    return () => {
      win.removeEventListener('blur', onBlur);
    };
  }, [floating, domReference, open, enabled]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!enabled) {
      return;
    }
    function onDismiss(payload) {
      if (payload.type === 'referencePress' || payload.type === 'escapeKey') {
        blockFocusRef.current = true;
      }
    }
    events.on('dismiss', onDismiss);
    return () => {
      events.off('dismiss', onDismiss);
    };
  }, [events, enabled]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    return () => {
      clearTimeout(timeoutRef.current);
    };
  }, []);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    if (!enabled) {
      return {};
    }
    return {
      reference: {
        onPointerDown(_ref2) {
          let {
            pointerType
          } = _ref2;
          pointerTypeRef.current = pointerType;
          blockFocusRef.current = !!(pointerType && keyboardOnly);
        },
        onMouseLeave() {
          blockFocusRef.current = false;
        },
        onFocus(event) {
          var _dataRef$current$open;
          if (blockFocusRef.current) {
            return;
          }

          // Dismiss with click should ignore the subsequent `focus` trigger,
          // but only if the click originated inside the reference element.
          if (event.type === 'focus' && ((_dataRef$current$open = dataRef.current.openEvent) == null ? void 0 : _dataRef$current$open.type) === 'mousedown' && dataRef.current.openEvent && isEventTargetWithin(dataRef.current.openEvent, domReference)) {
            return;
          }
          dataRef.current.openEvent = event.nativeEvent;
          onOpenChange(true);
        },
        onBlur(event) {
          blockFocusRef.current = false;
          const relatedTarget = event.relatedTarget;

          // Hit the non-modal focus management portal guard. Focus will be
          // moved into the floating element immediately after.
          const movedToFocusGuard = isElement(relatedTarget) && relatedTarget.hasAttribute('data-floating-ui-focus-guard') && relatedTarget.getAttribute('data-type') === 'outside';

          // Wait for the window blur listener to fire.
          timeoutRef.current = setTimeout(() => {
            // When focusing the reference element (e.g. regular click), then
            // clicking into the floating element, prevent it from hiding.
            // Note: it must be focusable, e.g. `tabindex="-1"`.
            if (contains(refs.floating.current, relatedTarget) || contains(domReference, relatedTarget) || movedToFocusGuard) {
              return;
            }
            onOpenChange(false);
          });
        }
      }
    };
  }, [enabled, keyboardOnly, domReference, refs, dataRef, onOpenChange]);
};

let isPreventScrollSupported = false;
const ARROW_UP = 'ArrowUp';
const ARROW_DOWN = 'ArrowDown';
const ARROW_LEFT = 'ArrowLeft';
const ARROW_RIGHT = 'ArrowRight';
function isDifferentRow(index, cols, prevRow) {
  return Math.floor(index / cols) !== prevRow;
}
function isIndexOutOfBounds(listRef, index) {
  return index < 0 || index >= listRef.current.length;
}
function findNonDisabledIndex(listRef, _temp) {
  let {
    startingIndex = -1,
    decrement = false,
    disabledIndices,
    amount = 1
  } = _temp === void 0 ? {} : _temp;
  const list = listRef.current;
  let index = startingIndex;
  do {
    var _list$index, _list$index2;
    index = index + (decrement ? -amount : amount);
  } while (index >= 0 && index <= list.length - 1 && (disabledIndices ? disabledIndices.includes(index) : list[index] == null || ((_list$index = list[index]) == null ? void 0 : _list$index.hasAttribute('disabled')) || ((_list$index2 = list[index]) == null ? void 0 : _list$index2.getAttribute('aria-disabled')) === 'true'));
  return index;
}
function doSwitch(orientation, vertical, horizontal) {
  switch (orientation) {
    case 'vertical':
      return vertical;
    case 'horizontal':
      return horizontal;
    default:
      return vertical || horizontal;
  }
}
function isMainOrientationKey(key, orientation) {
  const vertical = key === ARROW_UP || key === ARROW_DOWN;
  const horizontal = key === ARROW_LEFT || key === ARROW_RIGHT;
  return doSwitch(orientation, vertical, horizontal);
}
function isMainOrientationToEndKey(key, orientation, rtl) {
  const vertical = key === ARROW_DOWN;
  const horizontal = rtl ? key === ARROW_LEFT : key === ARROW_RIGHT;
  return doSwitch(orientation, vertical, horizontal) || key === 'Enter' || key == ' ' || key === '';
}
function isCrossOrientationOpenKey(key, orientation, rtl) {
  const vertical = rtl ? key === ARROW_LEFT : key === ARROW_RIGHT;
  const horizontal = key === ARROW_DOWN;
  return doSwitch(orientation, vertical, horizontal);
}
function isCrossOrientationCloseKey(key, orientation, rtl) {
  const vertical = rtl ? key === ARROW_RIGHT : key === ARROW_LEFT;
  const horizontal = key === ARROW_UP;
  return doSwitch(orientation, vertical, horizontal);
}
function getMinIndex(listRef, disabledIndices) {
  return findNonDisabledIndex(listRef, {
    disabledIndices
  });
}
function getMaxIndex(listRef, disabledIndices) {
  return findNonDisabledIndex(listRef, {
    decrement: true,
    startingIndex: listRef.current.length,
    disabledIndices
  });
}
/**
 * Adds arrow key-based navigation of a list of items, either using real DOM
 * focus or virtual focus.
 * @see https://floating-ui.com/docs/useListNavigation
 */
const useListNavigation = function (_ref, _temp2) {
  let {
    open,
    onOpenChange,
    refs,
    elements: {
      domReference
    }
  } = _ref;
  let {
    listRef,
    activeIndex,
    onNavigate: unstable_onNavigate = () => {},
    enabled = true,
    selectedIndex = null,
    allowEscape = false,
    loop = false,
    nested = false,
    rtl = false,
    virtual = false,
    focusItemOnOpen = 'auto',
    focusItemOnHover = true,
    openOnArrowKeyDown = true,
    disabledIndices = undefined,
    orientation = 'vertical',
    cols = 1,
    scrollItemIntoView = true
  } = _temp2 === void 0 ? {
    listRef: {
      current: []
    },
    activeIndex: null,
    onNavigate: () => {}
  } : _temp2;
  if (true) {
    if (allowEscape) {
      if (!loop) {
        console.warn(['Floating UI: `useListNavigation` looping must be enabled to allow', 'escaping.'].join(' '));
      }
      if (!virtual) {
        console.warn(['Floating UI: `useListNavigation` must be virtual to allow', 'escaping.'].join(' '));
      }
    }
    if (orientation === 'vertical' && cols > 1) {
      console.warn(['Floating UI: In grid list navigation mode (`cols` > 1), the', '`orientation` should be either "horizontal" or "both".'].join(' '));
    }
  }
  const parentId = useFloatingParentNodeId();
  const tree = useFloatingTree();
  const onNavigate = useEvent(unstable_onNavigate);
  const focusItemOnOpenRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(focusItemOnOpen);
  const indexRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(selectedIndex != null ? selectedIndex : -1);
  const keyRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);
  const isPointerModalityRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(true);
  const previousOnNavigateRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(onNavigate);
  const previousOpenRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(open);
  const forceSyncFocus = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  const forceScrollIntoViewRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  const disabledIndicesRef = useLatestRef(disabledIndices);
  const latestOpenRef = useLatestRef(open);
  const scrollItemIntoViewRef = useLatestRef(scrollItemIntoView);
  const [activeId, setActiveId] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  const focusItem = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (listRef, indexRef, forceScrollIntoView) {
    if (forceScrollIntoView === void 0) {
      forceScrollIntoView = false;
    }
    const item = listRef.current[indexRef.current];
    if (virtual) {
      setActiveId(item == null ? void 0 : item.id);
    } else {
      enqueueFocus(item, {
        preventScroll: true,
        // Mac Safari does not move the virtual cursor unless the focus call
        // is sync. However, for the very first focus call, we need to wait
        // for the position to be ready in order to prevent unwanted
        // scrolling. This means the virtual cursor will not move to the first
        // item when first opening the floating element, but will on
        // subsequent calls. `preventScroll` is supported in modern Safari,
        // so we can use that instead.
        // iOS Safari must be async or the first item will not be focused.
        sync: isMac() && isSafari() ? isPreventScrollSupported || forceSyncFocus.current : false
      });
    }
    requestAnimationFrame(() => {
      const scrollIntoViewOptions = scrollItemIntoViewRef.current;
      const shouldScrollIntoView = scrollIntoViewOptions && item && (forceScrollIntoView || !isPointerModalityRef.current);
      if (shouldScrollIntoView) {
        // JSDOM doesn't support `.scrollIntoView()` but it's widely supported
        // by all browsers.
        item.scrollIntoView == null ? void 0 : item.scrollIntoView(typeof scrollIntoViewOptions === 'boolean' ? {
          block: 'nearest',
          inline: 'nearest'
        } : scrollIntoViewOptions);
      }
    });
  }, [virtual, scrollItemIntoViewRef]);
  index(() => {
    document.createElement('div').focus({
      get preventScroll() {
        isPreventScrollSupported = true;
        return false;
      }
    });
  }, []);

  // Sync `selectedIndex` to be the `activeIndex` upon opening the floating
  // element. Also, reset `activeIndex` upon closing the floating element.
  index(() => {
    if (!enabled) {
      return;
    }
    if (open) {
      if (focusItemOnOpenRef.current && selectedIndex != null) {
        // Regardless of the pointer modality, we want to ensure the selected
        // item comes into view when the floating element is opened.
        forceScrollIntoViewRef.current = true;
        onNavigate(selectedIndex);
      }
    } else if (previousOpenRef.current) {
      // Since the user can specify `onNavigate` conditionally
      // (onNavigate: open ? setActiveIndex : setSelectedIndex),
      // we store and call the previous function.
      indexRef.current = -1;
      previousOnNavigateRef.current(null);
    }
  }, [enabled, open, selectedIndex, onNavigate]);

  // Sync `activeIndex` to be the focused item while the floating element is
  // open.
  index(() => {
    if (!enabled) {
      return;
    }
    if (open) {
      if (activeIndex == null) {
        forceSyncFocus.current = false;
        if (selectedIndex != null) {
          return;
        }

        // Reset while the floating element was open (e.g. the list changed).
        if (previousOpenRef.current) {
          indexRef.current = -1;
          focusItem(listRef, indexRef);
        }

        // Initial sync.
        if (!previousOpenRef.current && focusItemOnOpenRef.current && (keyRef.current != null || focusItemOnOpenRef.current === true && keyRef.current == null)) {
          indexRef.current = keyRef.current == null || isMainOrientationToEndKey(keyRef.current, orientation, rtl) || nested ? getMinIndex(listRef, disabledIndicesRef.current) : getMaxIndex(listRef, disabledIndicesRef.current);
          onNavigate(indexRef.current);
        }
      } else if (!isIndexOutOfBounds(listRef, activeIndex)) {
        indexRef.current = activeIndex;
        focusItem(listRef, indexRef, forceScrollIntoViewRef.current);
        forceScrollIntoViewRef.current = false;
      }
    }
  }, [enabled, open, activeIndex, selectedIndex, nested, listRef, orientation, rtl, onNavigate, focusItem, disabledIndicesRef]);

  // Ensure the parent floating element has focus when a nested child closes
  // to allow arrow key navigation to work after the pointer leaves the child.
  index(() => {
    if (!enabled) {
      return;
    }
    if (previousOpenRef.current && !open) {
      var _tree$nodesRef$curren, _tree$nodesRef$curren2;
      const parentFloating = tree == null ? void 0 : (_tree$nodesRef$curren = tree.nodesRef.current.find(node => node.id === parentId)) == null ? void 0 : (_tree$nodesRef$curren2 = _tree$nodesRef$curren.context) == null ? void 0 : _tree$nodesRef$curren2.elements.floating;
      if (parentFloating && !contains(parentFloating, activeElement$1(getDocument(parentFloating)))) {
        parentFloating.focus({
          preventScroll: true
        });
      }
    }
  }, [enabled, open, tree, parentId]);
  index(() => {
    keyRef.current = null;
    previousOnNavigateRef.current = onNavigate;
    previousOpenRef.current = open;
  });
  const hasActiveIndex = activeIndex != null;
  const item = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    function syncCurrentTarget(currentTarget) {
      if (!open) return;
      const index = listRef.current.indexOf(currentTarget);
      if (index !== -1) {
        onNavigate(index);
      }
    }
    const props = {
      onFocus(_ref2) {
        let {
          currentTarget
        } = _ref2;
        syncCurrentTarget(currentTarget);
      },
      onClick: _ref3 => {
        let {
          currentTarget
        } = _ref3;
        return currentTarget.focus({
          preventScroll: true
        });
      },
      // Safari
      ...(focusItemOnHover && {
        onMouseMove(_ref4) {
          let {
            currentTarget
          } = _ref4;
          syncCurrentTarget(currentTarget);
        },
        onPointerLeave() {
          if (!isPointerModalityRef.current) {
            return;
          }
          indexRef.current = -1;
          focusItem(listRef, indexRef);

          // Virtual cursor with VoiceOver on iOS needs this to be flushed
          // synchronously or there is a glitch that prevents nested
          // submenus from being accessible.
          (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.flushSync)(() => onNavigate(null));
          if (!virtual) {
            var _refs$floating$curren;
            // This also needs to be sync to prevent fast mouse movements
            // from leaving behind a stale active item when landing on a
            // disabled button item.
            (_refs$floating$curren = refs.floating.current) == null ? void 0 : _refs$floating$curren.focus({
              preventScroll: true
            });
          }
        }
      })
    };
    return props;
  }, [open, refs, focusItem, focusItemOnHover, listRef, onNavigate, virtual]);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    if (!enabled) {
      return {};
    }
    const disabledIndices = disabledIndicesRef.current;
    function onKeyDown(event) {
      isPointerModalityRef.current = false;
      forceSyncFocus.current = true;

      // If the floating element is animating out, ignore navigation. Otherwise,
      // the `activeIndex` gets set to 0 despite not being open so the next time
      // the user ArrowDowns, the first item won't be focused.
      if (!latestOpenRef.current && event.currentTarget === refs.floating.current) {
        return;
      }
      if (nested && isCrossOrientationCloseKey(event.key, orientation, rtl)) {
        stopEvent(event);
        onOpenChange(false);
        if (isHTMLElement(domReference)) {
          domReference.focus();
        }
        return;
      }
      const currentIndex = indexRef.current;
      const minIndex = getMinIndex(listRef, disabledIndices);
      const maxIndex = getMaxIndex(listRef, disabledIndices);
      if (event.key === 'Home') {
        indexRef.current = minIndex;
        onNavigate(indexRef.current);
      }
      if (event.key === 'End') {
        indexRef.current = maxIndex;
        onNavigate(indexRef.current);
      }

      // Grid navigation.
      if (cols > 1) {
        const prevIndex = indexRef.current;
        if (event.key === ARROW_UP) {
          stopEvent(event);
          if (prevIndex === -1) {
            indexRef.current = maxIndex;
          } else {
            indexRef.current = findNonDisabledIndex(listRef, {
              startingIndex: prevIndex,
              amount: cols,
              decrement: true,
              disabledIndices
            });
            if (loop && (prevIndex - cols < minIndex || indexRef.current < 0)) {
              const col = prevIndex % cols;
              const maxCol = maxIndex % cols;
              const offset = maxIndex - (maxCol - col);
              if (maxCol === col) {
                indexRef.current = maxIndex;
              } else {
                indexRef.current = maxCol > col ? offset : offset - cols;
              }
            }
          }
          if (isIndexOutOfBounds(listRef, indexRef.current)) {
            indexRef.current = prevIndex;
          }
          onNavigate(indexRef.current);
        }
        if (event.key === ARROW_DOWN) {
          stopEvent(event);
          if (prevIndex === -1) {
            indexRef.current = minIndex;
          } else {
            indexRef.current = findNonDisabledIndex(listRef, {
              startingIndex: prevIndex,
              amount: cols,
              disabledIndices
            });
            if (loop && prevIndex + cols > maxIndex) {
              indexRef.current = findNonDisabledIndex(listRef, {
                startingIndex: prevIndex % cols - cols,
                amount: cols,
                disabledIndices
              });
            }
          }
          if (isIndexOutOfBounds(listRef, indexRef.current)) {
            indexRef.current = prevIndex;
          }
          onNavigate(indexRef.current);
        }

        // Remains on the same row/column.
        if (orientation === 'both') {
          const prevRow = Math.floor(prevIndex / cols);
          if (event.key === ARROW_RIGHT) {
            stopEvent(event);
            if (prevIndex % cols !== cols - 1) {
              indexRef.current = findNonDisabledIndex(listRef, {
                startingIndex: prevIndex,
                disabledIndices
              });
              if (loop && isDifferentRow(indexRef.current, cols, prevRow)) {
                indexRef.current = findNonDisabledIndex(listRef, {
                  startingIndex: prevIndex - prevIndex % cols - 1,
                  disabledIndices
                });
              }
            } else if (loop) {
              indexRef.current = findNonDisabledIndex(listRef, {
                startingIndex: prevIndex - prevIndex % cols - 1,
                disabledIndices
              });
            }
            if (isDifferentRow(indexRef.current, cols, prevRow)) {
              indexRef.current = prevIndex;
            }
          }
          if (event.key === ARROW_LEFT) {
            stopEvent(event);
            if (prevIndex % cols !== 0) {
              indexRef.current = findNonDisabledIndex(listRef, {
                startingIndex: prevIndex,
                disabledIndices,
                decrement: true
              });
              if (loop && isDifferentRow(indexRef.current, cols, prevRow)) {
                indexRef.current = findNonDisabledIndex(listRef, {
                  startingIndex: prevIndex + (cols - prevIndex % cols),
                  decrement: true,
                  disabledIndices
                });
              }
            } else if (loop) {
              indexRef.current = findNonDisabledIndex(listRef, {
                startingIndex: prevIndex + (cols - prevIndex % cols),
                decrement: true,
                disabledIndices
              });
            }
            if (isDifferentRow(indexRef.current, cols, prevRow)) {
              indexRef.current = prevIndex;
            }
          }
          const lastRow = Math.floor(maxIndex / cols) === prevRow;
          if (isIndexOutOfBounds(listRef, indexRef.current)) {
            if (loop && lastRow) {
              indexRef.current = event.key === ARROW_LEFT ? maxIndex : findNonDisabledIndex(listRef, {
                startingIndex: prevIndex - prevIndex % cols - 1,
                disabledIndices
              });
            } else {
              indexRef.current = prevIndex;
            }
          }
          onNavigate(indexRef.current);
          return;
        }
      }
      if (isMainOrientationKey(event.key, orientation)) {
        stopEvent(event);

        // Reset the index if no item is focused.
        if (open && !virtual && activeElement$1(event.currentTarget.ownerDocument) === event.currentTarget) {
          indexRef.current = isMainOrientationToEndKey(event.key, orientation, rtl) ? minIndex : maxIndex;
          onNavigate(indexRef.current);
          return;
        }
        if (isMainOrientationToEndKey(event.key, orientation, rtl)) {
          if (loop) {
            indexRef.current = currentIndex >= maxIndex ? allowEscape && currentIndex !== listRef.current.length ? -1 : minIndex : findNonDisabledIndex(listRef, {
              startingIndex: currentIndex,
              disabledIndices
            });
          } else {
            indexRef.current = Math.min(maxIndex, findNonDisabledIndex(listRef, {
              startingIndex: currentIndex,
              disabledIndices
            }));
          }
        } else {
          if (loop) {
            indexRef.current = currentIndex <= minIndex ? allowEscape && currentIndex !== -1 ? listRef.current.length : maxIndex : findNonDisabledIndex(listRef, {
              startingIndex: currentIndex,
              decrement: true,
              disabledIndices
            });
          } else {
            indexRef.current = Math.max(minIndex, findNonDisabledIndex(listRef, {
              startingIndex: currentIndex,
              decrement: true,
              disabledIndices
            }));
          }
        }
        if (isIndexOutOfBounds(listRef, indexRef.current)) {
          onNavigate(null);
        } else {
          onNavigate(indexRef.current);
        }
      }
    }
    function checkVirtualMouse(event) {
      if (focusItemOnOpen === 'auto' && isVirtualClick(event.nativeEvent)) {
        focusItemOnOpenRef.current = true;
      }
    }
    function checkVirtualPointer(event) {
      // `pointerdown` fires first, reset the state then perform the checks.
      focusItemOnOpenRef.current = focusItemOnOpen;
      if (focusItemOnOpen === 'auto' && isVirtualPointerEvent(event.nativeEvent)) {
        focusItemOnOpenRef.current = true;
      }
    }
    const ariaActiveDescendantProp = virtual && open && hasActiveIndex && {
      'aria-activedescendant': activeId
    };
    return {
      reference: {
        ...ariaActiveDescendantProp,
        onKeyDown(event) {
          isPointerModalityRef.current = false;
          const isArrowKey = event.key.indexOf('Arrow') === 0;
          if (virtual && open) {
            return onKeyDown(event);
          }

          // If a floating element should not open on arrow key down, avoid
          // setting `activeIndex` while it's closed.
          if (!open && !openOnArrowKeyDown && isArrowKey) {
            return;
          }
          const isNavigationKey = isArrowKey || event.key === 'Enter' || event.key === ' ' || event.key === '';
          if (isNavigationKey) {
            keyRef.current = event.key;
          }
          if (nested) {
            if (isCrossOrientationOpenKey(event.key, orientation, rtl)) {
              stopEvent(event);
              if (open) {
                indexRef.current = getMinIndex(listRef, disabledIndices);
                onNavigate(indexRef.current);
              } else {
                onOpenChange(true);
              }
            }
            return;
          }
          if (isMainOrientationKey(event.key, orientation)) {
            if (selectedIndex != null) {
              indexRef.current = selectedIndex;
            }
            stopEvent(event);
            if (!open && openOnArrowKeyDown) {
              onOpenChange(true);
            } else {
              onKeyDown(event);
            }
            if (open) {
              onNavigate(indexRef.current);
            }
          }
        },
        onFocus() {
          if (open) {
            onNavigate(null);
          }
        },
        onPointerDown: checkVirtualPointer,
        onMouseDown: checkVirtualMouse,
        onClick: checkVirtualMouse
      },
      floating: {
        'aria-orientation': orientation === 'both' ? undefined : orientation,
        ...ariaActiveDescendantProp,
        onKeyDown,
        onPointerMove() {
          isPointerModalityRef.current = true;
        }
      },
      item
    };
  }, [domReference, refs, activeId, disabledIndicesRef, latestOpenRef, listRef, enabled, orientation, rtl, virtual, open, hasActiveIndex, nested, selectedIndex, openOnArrowKeyDown, allowEscape, cols, loop, focusItemOnOpen, onNavigate, onOpenChange, item]);
};

/**
 * Merges an array of refs into a single memoized callback ref or `null`.
 * @see https://floating-ui.com/docs/useMergeRefs
 */
function useMergeRefs(refs) {
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    if (refs.every(ref => ref == null)) {
      return null;
    }
    return value => {
      refs.forEach(ref => {
        if (typeof ref === 'function') {
          ref(value);
        } else if (ref != null) {
          ref.current = value;
        }
      });
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, refs);
}

/**
 * Adds base screen reader props to the reference and floating elements for a
 * given floating element `role`.
 * @see https://floating-ui.com/docs/useRole
 */
const useRole = function (_ref, _temp) {
  let {
    open
  } = _ref;
  let {
    enabled = true,
    role = 'dialog'
  } = _temp === void 0 ? {} : _temp;
  const rootId = useId();
  const referenceId = useId();
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    const floatingProps = {
      id: rootId,
      role
    };
    if (!enabled) {
      return {};
    }
    if (role === 'tooltip') {
      return {
        reference: {
          'aria-describedby': open ? rootId : undefined
        },
        floating: floatingProps
      };
    }
    return {
      reference: {
        'aria-expanded': open ? 'true' : 'false',
        'aria-haspopup': role === 'alertdialog' ? 'dialog' : role,
        'aria-controls': open ? rootId : undefined,
        ...(role === 'listbox' && {
          role: 'combobox'
        }),
        ...(role === 'menu' && {
          id: referenceId
        })
      },
      floating: {
        ...floatingProps,
        ...(role === 'menu' && {
          'aria-labelledby': referenceId
        })
      }
    };
  }, [enabled, role, open, rootId, referenceId]);
};

// Converts a JS style key like `backgroundColor` to a CSS transition-property
// like `background-color`.
const camelCaseToKebabCase = str => str.replace(/[A-Z]+(?![a-z])|[A-Z]/g, ($, ofs) => (ofs ? '-' : '') + $.toLowerCase());
function useDelayUnmount(open, durationMs) {
  const [isMounted, setIsMounted] = react__WEBPACK_IMPORTED_MODULE_0__.useState(open);
  if (open && !isMounted) {
    setIsMounted(true);
  }
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!open) {
      const timeout = setTimeout(() => setIsMounted(false), durationMs);
      return () => clearTimeout(timeout);
    }
  }, [open, durationMs]);
  return isMounted;
}
/**
 * Provides a status string to apply CSS transitions to a floating element,
 * correctly handling placement-aware transitions.
 * @see https://floating-ui.com/docs/useTransition#usetransitionstatus
 */
function useTransitionStatus(_ref, _temp) {
  let {
    open,
    elements: {
      floating
    }
  } = _ref;
  let {
    duration = 250
  } = _temp === void 0 ? {} : _temp;
  const isNumberDuration = typeof duration === 'number';
  const closeDuration = (isNumberDuration ? duration : duration.close) || 0;
  const [initiated, setInitiated] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
  const [status, setStatus] = react__WEBPACK_IMPORTED_MODULE_0__.useState('unmounted');
  const isMounted = useDelayUnmount(open, closeDuration);

  // `initiated` check prevents this `setState` call from breaking
  // <FloatingPortal />. This call is necessary to ensure subsequent opens
  // after the initial one allows the correct side animation to play when the
  // placement has changed.
  index(() => {
    if (initiated && !isMounted) {
      setStatus('unmounted');
    }
  }, [initiated, isMounted]);
  index(() => {
    if (!floating) return;
    if (open) {
      setStatus('initial');
      const frame = requestAnimationFrame(() => {
        setStatus('open');
      });
      return () => {
        cancelAnimationFrame(frame);
      };
    } else {
      setInitiated(true);
      setStatus('close');
    }
  }, [open, floating]);
  return {
    isMounted,
    status
  };
}
/**
 * Provides styles to apply CSS transitions to a floating element, correctly
 * handling placement-aware transitions. Wrapper around `useTransitionStatus`.
 * @see https://floating-ui.com/docs/useTransition#usetransitionstyles
 */
function useTransitionStyles(context, _temp2) {
  let {
    initial: unstable_initial = {
      opacity: 0
    },
    open: unstable_open,
    close: unstable_close,
    common: unstable_common,
    duration = 250
  } = _temp2 === void 0 ? {} : _temp2;
  const placement = context.placement;
  const side = placement.split('-')[0];
  const [styles, setStyles] = react__WEBPACK_IMPORTED_MODULE_0__.useState({});
  const {
    isMounted,
    status
  } = useTransitionStatus(context, {
    duration
  });
  const initialRef = useLatestRef(unstable_initial);
  const openRef = useLatestRef(unstable_open);
  const closeRef = useLatestRef(unstable_close);
  const commonRef = useLatestRef(unstable_common);
  const isNumberDuration = typeof duration === 'number';
  const openDuration = (isNumberDuration ? duration : duration.open) || 0;
  const closeDuration = (isNumberDuration ? duration : duration.close) || 0;
  index(() => {
    const fnArgs = {
      side,
      placement
    };
    const initial = initialRef.current;
    const close = closeRef.current;
    const open = openRef.current;
    const common = commonRef.current;
    const initialStyles = typeof initial === 'function' ? initial(fnArgs) : initial;
    const closeStyles = typeof close === 'function' ? close(fnArgs) : close;
    const commonStyles = typeof common === 'function' ? common(fnArgs) : common;
    const openStyles = (typeof open === 'function' ? open(fnArgs) : open) || Object.keys(initialStyles).reduce((acc, key) => {
      acc[key] = '';
      return acc;
    }, {});
    if (status === 'initial' || status === 'unmounted') {
      setStyles(styles => ({
        transitionProperty: styles.transitionProperty,
        ...commonStyles,
        ...initialStyles
      }));
    }
    if (status === 'open') {
      setStyles({
        transitionProperty: Object.keys(openStyles).map(camelCaseToKebabCase).join(','),
        transitionDuration: openDuration + "ms",
        ...commonStyles,
        ...openStyles
      });
    }
    if (status === 'close') {
      const styles = closeStyles || initialStyles;
      setStyles({
        transitionProperty: Object.keys(styles).map(camelCaseToKebabCase).join(','),
        transitionDuration: closeDuration + "ms",
        ...commonStyles,
        ...styles
      });
    }
  }, [side, placement, closeDuration, closeRef, initialRef, openRef, commonRef, openDuration, status]);
  return {
    isMounted,
    styles
  };
}

/**
 * Provides a matching callback that can be used to focus an item as the user
 * types, often used in tandem with `useListNavigation()`.
 * @see https://floating-ui.com/docs/useTypeahead
 */
const useTypeahead = function (_ref, _temp) {
  var _ref2;
  let {
    open,
    dataRef,
    refs
  } = _ref;
  let {
    listRef,
    activeIndex,
    onMatch: unstable_onMatch = () => {},
    enabled = true,
    findMatch = null,
    resetMs = 1000,
    ignoreKeys = [],
    selectedIndex = null
  } = _temp === void 0 ? {
    listRef: {
      current: []
    },
    activeIndex: null
  } : _temp;
  const timeoutIdRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  const stringRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef('');
  const prevIndexRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef((_ref2 = selectedIndex != null ? selectedIndex : activeIndex) != null ? _ref2 : -1);
  const matchIndexRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);
  const onMatch = useEvent(unstable_onMatch);
  const findMatchRef = useLatestRef(findMatch);
  const ignoreKeysRef = useLatestRef(ignoreKeys);
  index(() => {
    if (open) {
      clearTimeout(timeoutIdRef.current);
      matchIndexRef.current = null;
      stringRef.current = '';
    }
  }, [open]);
  index(() => {
    // Sync arrow key navigation but not typeahead navigation.
    if (open && stringRef.current === '') {
      var _ref3;
      prevIndexRef.current = (_ref3 = selectedIndex != null ? selectedIndex : activeIndex) != null ? _ref3 : -1;
    }
  }, [open, selectedIndex, activeIndex]);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    if (!enabled) {
      return {};
    }
    function onKeyDown(event) {
      var _refs$floating$curren;
      // Correctly scope nested non-portalled floating elements. Since the nested
      // floating element is inside of the another, we find the closest role
      // that indicates the floating element scope.
      const target = getTarget(event.nativeEvent);
      if (isElement(target) && (activeElement$1(getDocument(target)) !== event.currentTarget ? (_refs$floating$curren = refs.floating.current) != null && _refs$floating$curren.contains(target) ? target.closest('[role="dialog"],[role="menu"],[role="listbox"],[role="tree"],[role="grid"]') !== event.currentTarget : false : !event.currentTarget.contains(target))) {
        return;
      }
      if (stringRef.current.length > 0 && stringRef.current[0] !== ' ') {
        dataRef.current.typing = true;
        if (event.key === ' ') {
          stopEvent(event);
        }
      }
      const listContent = listRef.current;
      if (listContent == null || ignoreKeysRef.current.includes(event.key) ||
      // Character key.
      event.key.length !== 1 ||
      // Modifier key.
      event.ctrlKey || event.metaKey || event.altKey) {
        return;
      }

      // Bail out if the list contains a word like "llama" or "aaron". TODO:
      // allow it in this case, too.
      const allowRapidSuccessionOfFirstLetter = listContent.every(text => {
        var _text$, _text$2;
        return text ? ((_text$ = text[0]) == null ? void 0 : _text$.toLocaleLowerCase()) !== ((_text$2 = text[1]) == null ? void 0 : _text$2.toLocaleLowerCase()) : true;
      });

      // Allows the user to cycle through items that start with the same letter
      // in rapid succession.
      if (allowRapidSuccessionOfFirstLetter && stringRef.current === event.key) {
        stringRef.current = '';
        prevIndexRef.current = matchIndexRef.current;
      }
      stringRef.current += event.key;
      clearTimeout(timeoutIdRef.current);
      timeoutIdRef.current = setTimeout(() => {
        stringRef.current = '';
        prevIndexRef.current = matchIndexRef.current;
        dataRef.current.typing = false;
      }, resetMs);
      const prevIndex = prevIndexRef.current;
      const orderedList = [...listContent.slice((prevIndex || 0) + 1), ...listContent.slice(0, (prevIndex || 0) + 1)];
      const str = findMatchRef.current ? findMatchRef.current(orderedList, stringRef.current) : orderedList.find(text => (text == null ? void 0 : text.toLocaleLowerCase().indexOf(stringRef.current.toLocaleLowerCase())) === 0);
      const index = str ? listContent.indexOf(str) : -1;
      if (index !== -1) {
        onMatch(index);
        matchIndexRef.current = index;
      }
    }
    return {
      reference: {
        onKeyDown
      },
      floating: {
        onKeyDown
      }
    };
  }, [enabled, dataRef, listRef, resetMs, ignoreKeysRef, findMatchRef, onMatch, refs]);
};

function getArgsWithCustomFloatingHeight(state, height) {
  return {
    ...state,
    rects: {
      ...state.rects,
      floating: {
        ...state.rects.floating,
        height
      }
    }
  };
}
/**
 * Positions the floating element such that an inner element inside
 * of it is anchored to the reference element.
 * @see https://floating-ui.com/docs/inner
 */
const inner = props => ({
  name: 'inner',
  options: props,
  async fn(state) {
    const {
      listRef,
      overflowRef,
      onFallbackChange,
      offset: innerOffset = 0,
      index = 0,
      minItemsVisible = 4,
      referenceOverflowThreshold = 0,
      scrollRef,
      ...detectOverflowOptions
    } = props;
    const {
      rects,
      elements: {
        floating
      }
    } = state;
    const item = listRef.current[index];
    if (true) {
      if (!state.placement.startsWith('bottom')) {
        console.warn(['Floating UI: `placement` side must be "bottom" when using the', '`inner` middleware.'].join(' '));
      }
    }
    if (!item) {
      return {};
    }
    const nextArgs = {
      ...state,
      ...(await (0,_floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_3__.offset)(-item.offsetTop - rects.reference.height / 2 - item.offsetHeight / 2 - innerOffset).fn(state))
    };
    const el = (scrollRef == null ? void 0 : scrollRef.current) || floating;
    const overflow = await (0,_floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_3__.detectOverflow)(getArgsWithCustomFloatingHeight(nextArgs, el.scrollHeight), detectOverflowOptions);
    const refOverflow = await (0,_floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_3__.detectOverflow)(nextArgs, {
      ...detectOverflowOptions,
      elementContext: 'reference'
    });
    const diffY = Math.max(0, overflow.top);
    const nextY = nextArgs.y + diffY;
    const maxHeight = Math.max(0, el.scrollHeight - diffY - Math.max(0, overflow.bottom));
    el.style.maxHeight = maxHeight + "px";
    el.scrollTop = diffY;

    // There is not enough space, fallback to standard anchored positioning
    if (onFallbackChange) {
      if (el.offsetHeight < item.offsetHeight * Math.min(minItemsVisible, listRef.current.length - 1) - 1 || refOverflow.top >= -referenceOverflowThreshold || refOverflow.bottom >= -referenceOverflowThreshold) {
        (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.flushSync)(() => onFallbackChange(true));
      } else {
        (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.flushSync)(() => onFallbackChange(false));
      }
    }
    if (overflowRef) {
      overflowRef.current = await (0,_floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_3__.detectOverflow)(getArgsWithCustomFloatingHeight({
        ...nextArgs,
        y: nextY
      }, el.offsetHeight), detectOverflowOptions);
    }
    return {
      y: nextY
    };
  }
});
/**
 * Changes the `inner` middleware's `offset` upon a `wheel` event to
 * expand the floating element's height, revealing more list items.
 * @see https://floating-ui.com/docs/inner
 */
const useInnerOffset = (_ref, _ref2) => {
  let {
    open,
    elements
  } = _ref;
  let {
    enabled = true,
    overflowRef,
    scrollRef,
    onChange: unstable_onChange
  } = _ref2;
  const onChange = useEvent(unstable_onChange);
  const controlledScrollingRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  const prevScrollTopRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);
  const initialOverflowRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!enabled) {
      return;
    }
    function onWheel(e) {
      if (e.ctrlKey || !el || overflowRef.current == null) {
        return;
      }
      const dY = e.deltaY;
      const isAtTop = overflowRef.current.top >= -0.5;
      const isAtBottom = overflowRef.current.bottom >= -0.5;
      const remainingScroll = el.scrollHeight - el.clientHeight;
      const sign = dY < 0 ? -1 : 1;
      const method = dY < 0 ? 'max' : 'min';
      if (el.scrollHeight <= el.clientHeight) {
        return;
      }
      if (!isAtTop && dY > 0 || !isAtBottom && dY < 0) {
        e.preventDefault();
        (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.flushSync)(() => {
          onChange(d => d + Math[method](dY, remainingScroll * sign));
        });
      } else if (/firefox/i.test(getUserAgent())) {
        // Needed to propagate scrolling during momentum scrolling phase once
        // it gets limited by the boundary. UX improvement, not critical.
        el.scrollTop += dY;
      }
    }
    const el = (scrollRef == null ? void 0 : scrollRef.current) || elements.floating;
    if (open && el) {
      el.addEventListener('wheel', onWheel);

      // Wait for the position to be ready.
      requestAnimationFrame(() => {
        prevScrollTopRef.current = el.scrollTop;
        if (overflowRef.current != null) {
          initialOverflowRef.current = {
            ...overflowRef.current
          };
        }
      });
      return () => {
        prevScrollTopRef.current = null;
        initialOverflowRef.current = null;
        el.removeEventListener('wheel', onWheel);
      };
    }
  }, [enabled, open, elements.floating, overflowRef, scrollRef, onChange]);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    if (!enabled) {
      return {};
    }
    return {
      floating: {
        onKeyDown() {
          controlledScrollingRef.current = true;
        },
        onWheel() {
          controlledScrollingRef.current = false;
        },
        onPointerMove() {
          controlledScrollingRef.current = false;
        },
        onScroll() {
          const el = (scrollRef == null ? void 0 : scrollRef.current) || elements.floating;
          if (!overflowRef.current || !el || !controlledScrollingRef.current) {
            return;
          }
          if (prevScrollTopRef.current !== null) {
            const scrollDiff = el.scrollTop - prevScrollTopRef.current;
            if (overflowRef.current.bottom < -0.5 && scrollDiff < -1 || overflowRef.current.top < -0.5 && scrollDiff > 1) {
              (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.flushSync)(() => onChange(d => d + scrollDiff));
            }
          }

          // [Firefox] Wait for the height change to have been applied.
          requestAnimationFrame(() => {
            prevScrollTopRef.current = el.scrollTop;
          });
        }
      }
    };
  }, [enabled, overflowRef, elements.floating, scrollRef, onChange]);
};

function isPointInPolygon(point, polygon) {
  const [x, y] = point;
  let isInside = false;
  const length = polygon.length;
  for (let i = 0, j = length - 1; i < length; j = i++) {
    const [xi, yi] = polygon[i] || [0, 0];
    const [xj, yj] = polygon[j] || [0, 0];
    const intersect = yi >= y !== yj >= y && x <= (xj - xi) * (y - yi) / (yj - yi) + xi;
    if (intersect) {
      isInside = !isInside;
    }
  }
  return isInside;
}
function isInside(point, rect) {
  return point[0] >= rect.x && point[0] <= rect.x + rect.width && point[1] >= rect.y && point[1] <= rect.y + rect.height;
}
function safePolygon(_temp) {
  let {
    restMs = 0,
    buffer = 0.5,
    blockPointerEvents = false
  } = _temp === void 0 ? {} : _temp;
  let timeoutId;
  let isInsideRect = false;
  let hasLanded = false;
  const fn = _ref => {
    let {
      x,
      y,
      placement,
      elements,
      onClose,
      nodeId,
      tree
    } = _ref;
    return function onMouseMove(event) {
      function close() {
        clearTimeout(timeoutId);
        onClose();
      }
      clearTimeout(timeoutId);
      if (!elements.domReference || !elements.floating || placement == null || x == null || y == null) {
        return;
      }
      const {
        clientX,
        clientY
      } = event;
      const clientPoint = [clientX, clientY];
      const target = getTarget(event);
      const isLeave = event.type === 'mouseleave';
      const isOverFloatingEl = contains(elements.floating, target);
      const isOverReferenceEl = contains(elements.domReference, target);
      const refRect = elements.domReference.getBoundingClientRect();
      const rect = elements.floating.getBoundingClientRect();
      const side = placement.split('-')[0];
      const cursorLeaveFromRight = x > rect.right - rect.width / 2;
      const cursorLeaveFromBottom = y > rect.bottom - rect.height / 2;
      const isOverReferenceRect = isInside(clientPoint, refRect);
      if (isOverFloatingEl) {
        hasLanded = true;
        if (!isLeave) {
          return;
        }
      }
      if (isOverReferenceEl) {
        hasLanded = false;
      }
      if (isOverReferenceEl && !isLeave) {
        hasLanded = true;
        return;
      }

      // Prevent overlapping floating element from being stuck in an open-close
      // loop: https://github.com/floating-ui/floating-ui/issues/1910
      if (isLeave && isElement(event.relatedTarget) && contains(elements.floating, event.relatedTarget)) {
        return;
      }

      // If any nested child is open, abort.
      if (tree && getChildren(tree.nodesRef.current, nodeId).some(_ref2 => {
        let {
          context
        } = _ref2;
        return context == null ? void 0 : context.open;
      })) {
        return;
      }

      // If the pointer is leaving from the opposite side, the "buffer" logic
      // creates a point where the floating element remains open, but should be
      // ignored.
      // A constant of 1 handles floating point rounding errors.
      if (side === 'top' && y >= refRect.bottom - 1 || side === 'bottom' && y <= refRect.top + 1 || side === 'left' && x >= refRect.right - 1 || side === 'right' && x <= refRect.left + 1) {
        return close();
      }

      // Ignore when the cursor is within the rectangular trough between the
      // two elements. Since the triangle is created from the cursor point,
      // which can start beyond the ref element's edge, traversing back and
      // forth from the ref to the floating element can cause it to close. This
      // ensures it always remains open in that case.
      let rectPoly = [];
      switch (side) {
        case 'top':
          rectPoly = [[rect.left, refRect.top + 1], [rect.left, rect.bottom - 1], [rect.right, rect.bottom - 1], [rect.right, refRect.top + 1]];
          isInsideRect = clientX >= rect.left && clientX <= rect.right && clientY >= rect.top && clientY <= refRect.top + 1;
          break;
        case 'bottom':
          rectPoly = [[rect.left, rect.top + 1], [rect.left, refRect.bottom - 1], [rect.right, refRect.bottom - 1], [rect.right, rect.top + 1]];
          isInsideRect = clientX >= rect.left && clientX <= rect.right && clientY >= refRect.bottom - 1 && clientY <= rect.bottom;
          break;
        case 'left':
          rectPoly = [[rect.right - 1, rect.bottom], [rect.right - 1, rect.top], [refRect.left + 1, rect.top], [refRect.left + 1, rect.bottom]];
          isInsideRect = clientX >= rect.left && clientX <= refRect.left + 1 && clientY >= rect.top && clientY <= rect.bottom;
          break;
        case 'right':
          rectPoly = [[refRect.right - 1, rect.bottom], [refRect.right - 1, rect.top], [rect.left + 1, rect.top], [rect.left + 1, rect.bottom]];
          isInsideRect = clientX >= refRect.right - 1 && clientX <= rect.right && clientY >= rect.top && clientY <= rect.bottom;
          break;
      }
      function getPolygon(_ref3) {
        let [x, y] = _ref3;
        const isFloatingWider = rect.width > refRect.width;
        const isFloatingTaller = rect.height > refRect.height;
        switch (side) {
          case 'top':
            {
              const cursorPointOne = [isFloatingWider ? x + buffer / 2 : cursorLeaveFromRight ? x + buffer * 4 : x - buffer * 4, y + buffer + 1];
              const cursorPointTwo = [isFloatingWider ? x - buffer / 2 : cursorLeaveFromRight ? x + buffer * 4 : x - buffer * 4, y + buffer + 1];
              const commonPoints = [[rect.left, cursorLeaveFromRight ? rect.bottom - buffer : isFloatingWider ? rect.bottom - buffer : rect.top], [rect.right, cursorLeaveFromRight ? isFloatingWider ? rect.bottom - buffer : rect.top : rect.bottom - buffer]];
              return [cursorPointOne, cursorPointTwo, ...commonPoints];
            }
          case 'bottom':
            {
              const cursorPointOne = [isFloatingWider ? x + buffer / 2 : cursorLeaveFromRight ? x + buffer * 4 : x - buffer * 4, y - buffer];
              const cursorPointTwo = [isFloatingWider ? x - buffer / 2 : cursorLeaveFromRight ? x + buffer * 4 : x - buffer * 4, y - buffer];
              const commonPoints = [[rect.left, cursorLeaveFromRight ? rect.top + buffer : isFloatingWider ? rect.top + buffer : rect.bottom], [rect.right, cursorLeaveFromRight ? isFloatingWider ? rect.top + buffer : rect.bottom : rect.top + buffer]];
              return [cursorPointOne, cursorPointTwo, ...commonPoints];
            }
          case 'left':
            {
              const cursorPointOne = [x + buffer + 1, isFloatingTaller ? y + buffer / 2 : cursorLeaveFromBottom ? y + buffer * 4 : y - buffer * 4];
              const cursorPointTwo = [x + buffer + 1, isFloatingTaller ? y - buffer / 2 : cursorLeaveFromBottom ? y + buffer * 4 : y - buffer * 4];
              const commonPoints = [[cursorLeaveFromBottom ? rect.right - buffer : isFloatingTaller ? rect.right - buffer : rect.left, rect.top], [cursorLeaveFromBottom ? isFloatingTaller ? rect.right - buffer : rect.left : rect.right - buffer, rect.bottom]];
              return [...commonPoints, cursorPointOne, cursorPointTwo];
            }
          case 'right':
            {
              const cursorPointOne = [x - buffer, isFloatingTaller ? y + buffer / 2 : cursorLeaveFromBottom ? y + buffer * 4 : y - buffer * 4];
              const cursorPointTwo = [x - buffer, isFloatingTaller ? y - buffer / 2 : cursorLeaveFromBottom ? y + buffer * 4 : y - buffer * 4];
              const commonPoints = [[cursorLeaveFromBottom ? rect.left + buffer : isFloatingTaller ? rect.left + buffer : rect.right, rect.top], [cursorLeaveFromBottom ? isFloatingTaller ? rect.left + buffer : rect.right : rect.left + buffer, rect.bottom]];
              return [cursorPointOne, cursorPointTwo, ...commonPoints];
            }
        }
      }
      const poly = isInsideRect ? rectPoly : getPolygon([x, y]);
      if (isInsideRect) {
        return;
      } else if (hasLanded && !isOverReferenceRect) {
        return close();
      }
      if (!isPointInPolygon([clientX, clientY], poly)) {
        close();
      } else if (restMs && !hasLanded) {
        timeoutId = setTimeout(close, restMs);
      }
    };
  };
  fn.__options = {
    blockPointerEvents
  };
  return fn;
}

/**
 * Provides data to position a floating element and context to add interactions.
 * @see https://floating-ui.com/docs/react
 */
function useFloating(options) {
  if (options === void 0) {
    options = {};
  }
  const {
    open = false,
    onOpenChange: unstable_onOpenChange,
    nodeId
  } = options;
  const position = (0,_floating_ui_react_dom__WEBPACK_IMPORTED_MODULE_2__.useFloating)(options);
  const tree = useFloatingTree();
  const domReferenceRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);
  const dataRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef({});
  const events = react__WEBPACK_IMPORTED_MODULE_0__.useState(() => createPubSub())[0];
  const [domReference, setDomReference] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);
  const setPositionReference = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(node => {
    const positionReference = isElement(node) ? {
      getBoundingClientRect: () => node.getBoundingClientRect(),
      contextElement: node
    } : node;
    position.refs.setReference(positionReference);
  }, [position.refs]);
  const setReference = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(node => {
    if (isElement(node) || node === null) {
      domReferenceRef.current = node;
      setDomReference(node);
    }

    // Backwards-compatibility for passing a virtual element to `reference`
    // after it has set the DOM reference.
    if (isElement(position.refs.reference.current) || position.refs.reference.current === null ||
    // Don't allow setting virtual elements using the old technique back to
    // `null` to support `positionReference` + an unstable `reference`
    // callback ref.
    node !== null && !isElement(node)) {
      position.refs.setReference(node);
    }
  }, [position.refs]);
  const refs = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    ...position.refs,
    setReference,
    setPositionReference,
    domReference: domReferenceRef
  }), [position.refs, setReference, setPositionReference]);
  const elements = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    ...position.elements,
    domReference: domReference
  }), [position.elements, domReference]);
  const onOpenChange = useEvent(unstable_onOpenChange);
  const context = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    ...position,
    refs,
    elements,
    dataRef,
    nodeId,
    events,
    open,
    onOpenChange
  }), [position, nodeId, events, open, onOpenChange, refs, elements]);
  index(() => {
    const node = tree == null ? void 0 : tree.nodesRef.current.find(node => node.id === nodeId);
    if (node) {
      node.context = context;
    }
  });
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    ...position,
    context,
    refs,
    reference: setReference,
    positionReference: setPositionReference
  }), [position, refs, context, setReference, setPositionReference]);
}

function mergeProps(userProps, propsList, elementKey) {
  const map = new Map();
  return {
    ...(elementKey === 'floating' && {
      tabIndex: -1
    }),
    ...userProps,
    ...propsList.map(value => value ? value[elementKey] : null).concat(userProps).reduce((acc, props) => {
      if (!props) {
        return acc;
      }
      Object.entries(props).forEach(_ref => {
        let [key, value] = _ref;
        if (key.indexOf('on') === 0) {
          if (!map.has(key)) {
            map.set(key, []);
          }
          if (typeof value === 'function') {
            var _map$get;
            (_map$get = map.get(key)) == null ? void 0 : _map$get.push(value);
            acc[key] = function () {
              var _map$get2;
              for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
              }
              (_map$get2 = map.get(key)) == null ? void 0 : _map$get2.forEach(fn => fn(...args));
            };
          }
        } else {
          acc[key] = value;
        }
      });
      return acc;
    }, {})
  };
}
const useInteractions = function (propsList) {
  if (propsList === void 0) {
    propsList = [];
  }
  // The dependencies are a dynamic array, so we can't use the linter's
  // suggestion to add it to the deps array.
  const deps = propsList;
  const getReferenceProps = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(userProps => mergeProps(userProps, propsList, 'reference'),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  deps);
  const getFloatingProps = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(userProps => mergeProps(userProps, propsList, 'floating'),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  deps);
  const getItemProps = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(userProps => mergeProps(userProps, propsList, 'item'),
  // Granularly check for `item` changes, because the `getItemProps` getter
  // should be as referentially stable as possible since it may be passed as
  // a prop to many components. All `item` key values must therefore be
  // memoized.
  // eslint-disable-next-line react-hooks/exhaustive-deps
  propsList.map(key => key == null ? void 0 : key.item));
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    getReferenceProps,
    getFloatingProps,
    getItemProps
  }), [getReferenceProps, getFloatingProps, getItemProps]);
};




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Accordion/Accordion.context.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Accordion/Accordion.context.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccordionContextProvider": () => (/* binding */ AccordionContextProvider),
/* harmony export */   "useAccordionContext": () => (/* binding */ useAccordionContext)
/* harmony export */ });
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-safe-context/create-safe-context.js");
/* harmony import */ var _Accordion_errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Accordion.errors.js */ "./node_modules/@mantine/core/esm/Accordion/Accordion.errors.js");



const [AccordionContextProvider, useAccordionContext] = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_0__.createSafeContext)(_Accordion_errors_js__WEBPACK_IMPORTED_MODULE_1__.ACCORDION_ERRORS.context);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Accordion/Accordion.errors.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Accordion/Accordion.errors.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ACCORDION_ERRORS": () => (/* binding */ ACCORDION_ERRORS)
/* harmony export */ });
const ACCORDION_ERRORS = {
  context: "Accordion component was not found in the tree",
  itemContext: "Accordion.Item component was not found in the tree",
  value: "Accordion.Item component was rendered with invalid value or without value"
};




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Accordion/Accordion.js":
/*!***************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Accordion/Accordion.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Accordion": () => (/* binding */ Accordion)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _AccordionProvider_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AccordionProvider.js */ "./node_modules/@mantine/core/esm/Accordion/AccordionProvider.js");
/* harmony import */ var _AccordionItem_AccordionItem_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./AccordionItem/AccordionItem.js */ "./node_modules/@mantine/core/esm/Accordion/AccordionItem/AccordionItem.js");
/* harmony import */ var _AccordionControl_AccordionControl_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./AccordionControl/AccordionControl.js */ "./node_modules/@mantine/core/esm/Accordion/AccordionControl/AccordionControl.js");
/* harmony import */ var _AccordionPanel_AccordionPanel_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./AccordionPanel/AccordionPanel.js */ "./node_modules/@mantine/core/esm/Accordion/AccordionPanel/AccordionPanel.js");
/* harmony import */ var _ChevronIcon_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ChevronIcon.js */ "./node_modules/@mantine/core/esm/Accordion/ChevronIcon.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");









var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  multiple: false,
  disableChevronRotation: false,
  transitionDuration: 200,
  chevronPosition: "right",
  variant: "default",
  chevronSize: 24,
  chevron: /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ChevronIcon_js__WEBPACK_IMPORTED_MODULE_1__.ChevronIcon, null)
};
function Accordion(props) {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.useComponentDefaultProps)("Accordion", defaultProps, props), {
    id,
    loop,
    children,
    multiple,
    value,
    defaultValue,
    onChange,
    transitionDuration,
    disableChevronRotation,
    chevronPosition,
    chevronSize,
    order,
    chevron,
    classNames,
    styles,
    unstyled,
    variant,
    radius
  } = _a, others = __objRest(_a, [
    "id",
    "loop",
    "children",
    "multiple",
    "value",
    "defaultValue",
    "onChange",
    "transitionDuration",
    "disableChevronRotation",
    "chevronPosition",
    "chevronSize",
    "order",
    "chevron",
    "classNames",
    "styles",
    "unstyled",
    "variant",
    "radius"
  ]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_AccordionProvider_js__WEBPACK_IMPORTED_MODULE_3__.AccordionProvider, {
    id,
    multiple,
    value,
    defaultValue,
    onChange,
    loop,
    transitionDuration,
    disableChevronRotation,
    chevronPosition,
    chevronSize,
    order,
    chevron,
    variant,
    radius,
    classNames,
    styles,
    unstyled
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadProps(__spreadValues({}, others), {
    "data-accordion": true
  }), children));
}
Accordion.Item = _AccordionItem_AccordionItem_js__WEBPACK_IMPORTED_MODULE_5__.AccordionItem;
Accordion.Control = _AccordionControl_AccordionControl_js__WEBPACK_IMPORTED_MODULE_6__.AccordionControl;
Accordion.Panel = _AccordionPanel_AccordionPanel_js__WEBPACK_IMPORTED_MODULE_7__.AccordionPanel;
Accordion.displayName = "@mantine/core/Accordion";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Accordion/AccordionControl/AccordionControl.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Accordion/AccordionControl/AccordionControl.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccordionControl": () => (/* binding */ AccordionControl)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-scoped-keydown-handler/create-scoped-keydown-handler.js");
/* harmony import */ var _Accordion_context_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Accordion.context.js */ "./node_modules/@mantine/core/esm/Accordion/Accordion.context.js");
/* harmony import */ var _AccordionItem_context_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../AccordionItem.context.js */ "./node_modules/@mantine/core/esm/Accordion/AccordionItem.context.js");
/* harmony import */ var _AccordionControl_styles_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./AccordionControl.styles.js */ "./node_modules/@mantine/core/esm/Accordion/AccordionControl/AccordionControl.styles.js");
/* harmony import */ var _UnstyledButton_UnstyledButton_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../UnstyledButton/UnstyledButton.js */ "./node_modules/@mantine/core/esm/UnstyledButton/UnstyledButton.js");








var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {};
const AccordionControl = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("AccordionControl", defaultProps, props), { disabled, onKeyDown, onClick, chevron, children, className, icon } = _a, others = __objRest(_a, ["disabled", "onKeyDown", "onClick", "chevron", "children", "className", "icon"]);
  const ctx = (0,_Accordion_context_js__WEBPACK_IMPORTED_MODULE_2__.useAccordionContext)();
  const { value } = (0,_AccordionItem_context_js__WEBPACK_IMPORTED_MODULE_3__.useAccordionItemContext)();
  const { classes, cx } = (0,_AccordionControl_styles_js__WEBPACK_IMPORTED_MODULE_4__["default"])({
    transitionDuration: ctx.transitionDuration,
    chevronPosition: ctx.chevronPosition,
    chevronSize: ctx.chevronSize,
    radius: ctx.radius
  }, {
    name: "Accordion",
    classNames: ctx.classNames,
    styles: ctx.styles,
    unstyled: ctx.unstyled,
    variant: ctx.variant
  });
  const isActive = ctx.isItemActive(value);
  const shouldWrapWithHeading = typeof ctx.order === "number";
  const Heading = `h${ctx.order}`;
  const content = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_UnstyledButton_UnstyledButton_js__WEBPACK_IMPORTED_MODULE_5__.UnstyledButton, __spreadProps(__spreadValues({}, others), {
    ref,
    "data-accordion-control": true,
    disabled,
    className: cx(classes.control, className),
    onClick: (event) => {
      onClick == null ? void 0 : onClick(event);
      ctx.onChange(value);
    },
    type: "button",
    "data-active": isActive || void 0,
    "aria-expanded": isActive,
    "aria-controls": ctx.getRegionId(value),
    id: ctx.getControlId(value),
    unstyled: ctx.unstyled,
    onKeyDown: (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_6__.createScopedKeydownHandler)({
      siblingSelector: "[data-accordion-control]",
      parentSelector: "[data-accordion]",
      activateOnFocus: false,
      loop: ctx.loop,
      orientation: "vertical",
      onKeyDown
    })
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: classes.chevron,
    "data-rotate": !ctx.disableChevronRotation && isActive || void 0
  }, chevron || ctx.chevron), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: classes.label
  }, children), icon && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: classes.icon
  }, icon));
  return shouldWrapWithHeading ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Heading, {
    className: classes.itemTitle
  }, content) : content;
});
AccordionControl.displayName = "@mantine/core/AccordionControl";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Accordion/AccordionControl/AccordionControl.styles.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Accordion/AccordionControl/AccordionControl.styles.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
function getVariantStyles(theme, variant) {
  if (variant === "default" || variant === "contained") {
    return theme.fn.hover({
      backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[6] : theme.colors.gray[0]
    });
  }
  return {};
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { transitionDuration, chevronPosition, chevronSize }, { variant }) => ({
  icon: {
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    marginRight: chevronPosition === "left" ? 0 : theme.spacing.sm,
    marginLeft: chevronPosition === "left" ? theme.spacing.lg : 0
  },
  chevron: {
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    transition: `transform ${transitionDuration}ms ease`,
    marginRight: chevronPosition === "right" ? 0 : theme.spacing.sm,
    marginLeft: chevronPosition === "right" ? theme.spacing.lg : 0,
    width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(chevronSize),
    minWidth: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(chevronSize),
    "&[data-rotate]": {
      transform: "rotate(180deg)"
    }
  },
  label: {
    color: "inherit",
    fontWeight: 400,
    flex: 1,
    overflow: "hidden",
    textOverflow: "ellipsis",
    paddingTop: theme.spacing.md,
    paddingBottom: theme.spacing.md
  },
  itemTitle: {
    margin: 0,
    padding: 0
  },
  control: __spreadProps(__spreadValues(__spreadValues(__spreadValues({}, theme.fn.focusStyles()), theme.fn.fontStyles()), getVariantStyles(theme, variant)), {
    width: "100%",
    display: "flex",
    alignItems: "center",
    flexDirection: chevronPosition === "right" ? "row-reverse" : "row",
    paddingRight: theme.spacing.md,
    paddingLeft: chevronPosition === "right" ? `calc(${theme.spacing.md} + ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(4)})` : theme.spacing.xs,
    textAlign: "left",
    color: theme.colorScheme === "dark" ? theme.colors.dark[0] : theme.black,
    "&:disabled": __spreadValues({
      opacity: 0.4,
      cursor: "not-allowed"
    }, theme.fn.hover({ backgroundColor: "transparent" }))
  })
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Accordion/AccordionItem.context.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Accordion/AccordionItem.context.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccordionItemContextProvider": () => (/* binding */ AccordionItemContextProvider),
/* harmony export */   "useAccordionItemContext": () => (/* binding */ useAccordionItemContext)
/* harmony export */ });
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-safe-context/create-safe-context.js");
/* harmony import */ var _Accordion_errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Accordion.errors.js */ "./node_modules/@mantine/core/esm/Accordion/Accordion.errors.js");



const [AccordionItemContextProvider, useAccordionItemContext] = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_0__.createSafeContext)(_Accordion_errors_js__WEBPACK_IMPORTED_MODULE_1__.ACCORDION_ERRORS.itemContext);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Accordion/AccordionItem/AccordionItem.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Accordion/AccordionItem/AccordionItem.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccordionItem": () => (/* binding */ AccordionItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _AccordionItem_context_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../AccordionItem.context.js */ "./node_modules/@mantine/core/esm/Accordion/AccordionItem.context.js");
/* harmony import */ var _AccordionItem_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AccordionItem.styles.js */ "./node_modules/@mantine/core/esm/Accordion/AccordionItem/AccordionItem.styles.js");
/* harmony import */ var _Accordion_context_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Accordion.context.js */ "./node_modules/@mantine/core/esm/Accordion/Accordion.context.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");







var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {};
const AccordionItem = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("AccordionItem", defaultProps, props), { children, className, value } = _a, others = __objRest(_a, ["children", "className", "value"]);
  const ctx = (0,_Accordion_context_js__WEBPACK_IMPORTED_MODULE_2__.useAccordionContext)();
  const { classes, cx } = (0,_AccordionItem_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])({ radius: ctx.radius }, {
    name: "Accordion",
    classNames: ctx.classNames,
    styles: ctx.styles,
    unstyled: ctx.unstyled,
    variant: ctx.variant
  });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_AccordionItem_context_js__WEBPACK_IMPORTED_MODULE_4__.AccordionItemContextProvider, {
    value: { value }
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_5__.Box, __spreadValues({
    ref,
    className: cx(classes.item, className),
    "data-active": ctx.isItemActive(value) || void 0
  }, others), children));
});
AccordionItem.displayName = "@mantine/core/AccordionItem";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Accordion/AccordionItem/AccordionItem.styles.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Accordion/AccordionItem/AccordionItem.styles.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


function getVariantStyles(theme, variant, { radius }) {
  const borderColor = theme.colorScheme === "dark" ? theme.colors.dark[4] : theme.colors.gray[3];
  const filledColor = theme.colorScheme === "dark" ? theme.colors.dark[6] : theme.colors.gray[0];
  const borderRadius = theme.fn.radius(radius);
  if (variant === "default") {
    return {
      color: theme.colorScheme === "dark" ? theme.colors.dark[0] : theme.black,
      borderBottom: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)} solid ${borderColor}`
    };
  }
  if (variant === "contained") {
    return {
      border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)} solid ${borderColor}`,
      transition: "background-color 150ms ease",
      "&[data-active]": {
        backgroundColor: filledColor
      },
      "&:first-of-type": {
        borderTopRightRadius: borderRadius,
        borderTopLeftRadius: borderRadius,
        "& > [data-accordion-control]": {
          borderTopRightRadius: borderRadius,
          borderTopLeftRadius: borderRadius
        }
      },
      "&:last-of-type": {
        borderBottomRightRadius: borderRadius,
        borderBottomLeftRadius: borderRadius,
        "& > [data-accordion-control]": {
          borderBottomRightRadius: borderRadius,
          borderBottomLeftRadius: borderRadius
        }
      },
      "& + &": {
        borderTop: 0
      }
    };
  }
  if (variant === "filled") {
    return {
      borderRadius,
      "&[data-active]": {
        backgroundColor: filledColor
      }
    };
  }
  if (variant === "separated") {
    return {
      borderRadius,
      backgroundColor: filledColor,
      border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)} solid transparent`,
      transition: "background-color 150ms ease",
      "& + &": {
        marginTop: theme.spacing.md
      },
      "&[data-active]": {
        backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[7] : theme.white,
        borderColor
      }
    };
  }
  return {};
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.createStyles)((theme, params, { variant }) => ({
  item: getVariantStyles(theme, variant, params)
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Accordion/AccordionPanel/AccordionPanel.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Accordion/AccordionPanel/AccordionPanel.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccordionPanel": () => (/* binding */ AccordionPanel)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _Accordion_context_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Accordion.context.js */ "./node_modules/@mantine/core/esm/Accordion/Accordion.context.js");
/* harmony import */ var _AccordionItem_context_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../AccordionItem.context.js */ "./node_modules/@mantine/core/esm/Accordion/AccordionItem.context.js");
/* harmony import */ var _AccordionPanel_styles_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./AccordionPanel.styles.js */ "./node_modules/@mantine/core/esm/Accordion/AccordionPanel/AccordionPanel.styles.js");
/* harmony import */ var _Collapse_Collapse_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Collapse/Collapse.js */ "./node_modules/@mantine/core/esm/Collapse/Collapse.js");







var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {};
function AccordionPanel(props) {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("AccordionPanel", defaultProps, props), { children, className } = _a, others = __objRest(_a, ["children", "className"]);
  const ctx = (0,_Accordion_context_js__WEBPACK_IMPORTED_MODULE_2__.useAccordionContext)();
  const { value } = (0,_AccordionItem_context_js__WEBPACK_IMPORTED_MODULE_3__.useAccordionItemContext)();
  const { classNames, styles, unstyled } = (0,_Accordion_context_js__WEBPACK_IMPORTED_MODULE_2__.useAccordionContext)();
  const { classes, cx } = (0,_AccordionPanel_styles_js__WEBPACK_IMPORTED_MODULE_4__["default"])({ radius: ctx.radius }, { name: "Accordion", classNames, styles, unstyled, variant: ctx.variant });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Collapse_Collapse_js__WEBPACK_IMPORTED_MODULE_5__.Collapse, __spreadProps(__spreadValues({}, others), {
    className: cx(classes.panel, className),
    in: ctx.isItemActive(value),
    transitionDuration: ctx.transitionDuration,
    role: "region",
    id: ctx.getRegionId(value),
    "aria-labelledby": ctx.getControlId(value)
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.content
  }, children));
}
AccordionPanel.displayName = "@mantine/core/AccordionPanel";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Accordion/AccordionPanel/AccordionPanel.styles.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Accordion/AccordionPanel/AccordionPanel.styles.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, _params) => ({
  panel: __spreadProps(__spreadValues({}, theme.fn.fontStyles()), {
    wordBreak: "break-word",
    lineHeight: theme.lineHeight
  }),
  content: {
    padding: theme.spacing.md,
    paddingTop: `calc(${theme.spacing.xs} / 2)`
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Accordion/AccordionProvider.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Accordion/AccordionProvider.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccordionProvider": () => (/* binding */ AccordionProvider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/get-safe-id/get-safe-id.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-id/use-id.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-uncontrolled/use-uncontrolled.js");
/* harmony import */ var _Accordion_context_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Accordion.context.js */ "./node_modules/@mantine/core/esm/Accordion/Accordion.context.js");
/* harmony import */ var _Accordion_errors_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Accordion.errors.js */ "./node_modules/@mantine/core/esm/Accordion/Accordion.errors.js");






function AccordionProvider({
  children,
  multiple,
  value,
  defaultValue,
  onChange,
  id,
  loop,
  transitionDuration,
  disableChevronRotation,
  chevronPosition,
  chevronSize,
  order,
  chevron,
  variant,
  radius,
  classNames,
  styles,
  unstyled
}) {
  const uid = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_1__.useId)(id);
  const [_value, handleChange] = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.useUncontrolled)({
    value,
    defaultValue,
    finalValue: multiple ? [] : null,
    onChange
  });
  const isItemActive = (itemValue) => Array.isArray(_value) ? _value.includes(itemValue) : itemValue === _value;
  const handleItemChange = (itemValue) => {
    const nextValue = Array.isArray(_value) ? _value.includes(itemValue) ? _value.filter((selectedValue) => selectedValue !== itemValue) : [..._value, itemValue] : itemValue === _value ? null : itemValue;
    handleChange(nextValue);
  };
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Accordion_context_js__WEBPACK_IMPORTED_MODULE_3__.AccordionContextProvider, {
    value: {
      isItemActive,
      onChange: handleItemChange,
      getControlId: (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_4__.getSafeId)(`${uid}-control`, _Accordion_errors_js__WEBPACK_IMPORTED_MODULE_5__.ACCORDION_ERRORS.value),
      getRegionId: (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_4__.getSafeId)(`${uid}-panel`, _Accordion_errors_js__WEBPACK_IMPORTED_MODULE_5__.ACCORDION_ERRORS.value),
      transitionDuration,
      disableChevronRotation,
      chevronPosition,
      chevronSize,
      order,
      chevron,
      loop,
      variant,
      radius,
      classNames,
      styles,
      unstyled
    }
  }, children);
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Accordion/ChevronIcon.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Accordion/ChevronIcon.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ChevronIcon": () => (/* binding */ ChevronIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
function ChevronIcon(props) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __spreadValues({
    viewBox: "0 0 15 15",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    width: "1rem",
    height: "1rem"
  }, props), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    d: "M3.13523 6.15803C3.3241 5.95657 3.64052 5.94637 3.84197 6.13523L7.5 9.56464L11.158 6.13523C11.3595 5.94637 11.6759 5.95657 11.8648 6.15803C12.0536 6.35949 12.0434 6.67591 11.842 6.86477L7.84197 10.6148C7.64964 10.7951 7.35036 10.7951 7.15803 10.6148L3.15803 6.86477C2.95657 6.67591 2.94637 6.35949 3.13523 6.15803Z",
    fill: "currentColor",
    fillRule: "evenodd",
    clipRule: "evenodd"
  }));
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ActionIcon/ActionIcon.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ActionIcon/ActionIcon.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ActionIcon": () => (/* binding */ ActionIcon),
/* harmony export */   "_ActionIcon": () => (/* binding */ _ActionIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _ActionIcon_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ActionIcon.styles.js */ "./node_modules/@mantine/core/esm/ActionIcon/ActionIcon.styles.js");
/* harmony import */ var _Loader_Loader_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Loader/Loader.js */ "./node_modules/@mantine/core/esm/Loader/Loader.js");
/* harmony import */ var _UnstyledButton_UnstyledButton_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../UnstyledButton/UnstyledButton.js */ "./node_modules/@mantine/core/esm/UnstyledButton/UnstyledButton.js");







var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  color: "gray",
  size: "md",
  variant: "subtle"
};
const _ActionIcon = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("ActionIcon", defaultProps, props), {
    className,
    color,
    children,
    radius,
    size,
    variant,
    gradient,
    disabled,
    loaderProps,
    loading,
    unstyled,
    __staticSelector
  } = _a, others = __objRest(_a, [
    "className",
    "color",
    "children",
    "radius",
    "size",
    "variant",
    "gradient",
    "disabled",
    "loaderProps",
    "loading",
    "unstyled",
    "__staticSelector"
  ]);
  const { classes, cx, theme } = (0,_ActionIcon_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ radius, color, gradient }, { name: ["ActionIcon", __staticSelector], unstyled, size, variant });
  const loader = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Loader_Loader_js__WEBPACK_IMPORTED_MODULE_3__.Loader, __spreadValues({
    color: theme.fn.variant({ color, variant }).color,
    size: "100%",
    "data-action-icon-loader": true
  }, loaderProps));
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_UnstyledButton_UnstyledButton_js__WEBPACK_IMPORTED_MODULE_4__.UnstyledButton, __spreadValues({
    className: cx(classes.root, className),
    ref,
    disabled,
    "data-disabled": disabled || void 0,
    "data-loading": loading || void 0,
    unstyled
  }, others), loading ? loader : children);
});
_ActionIcon.displayName = "@mantine/core/ActionIcon";
const ActionIcon = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_5__.createPolymorphicComponent)(_ActionIcon);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ActionIcon/ActionIcon.styles.js":
/*!************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ActionIcon/ActionIcon.styles.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ACTION_ICON_VARIANTS": () => (/* binding */ ACTION_ICON_VARIANTS),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "sizes": () => (/* binding */ sizes)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const ACTION_ICON_VARIANTS = [
  "subtle",
  "filled",
  "outline",
  "light",
  "default",
  "transparent",
  "gradient"
];
const sizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(18),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(22),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(28),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(34),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(44)
};
function getVariantStyles({ variant, theme, color, gradient }) {
  const colors = theme.fn.variant({ color, variant, gradient });
  if (variant === "gradient") {
    return {
      border: 0,
      backgroundImage: colors.background,
      color: colors.color,
      "&:hover": theme.fn.hover({
        backgroundSize: "200%"
      })
    };
  }
  if (ACTION_ICON_VARIANTS.includes(variant)) {
    return __spreadValues({
      border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)} solid ${colors.border}`,
      backgroundColor: colors.background,
      color: colors.color
    }, theme.fn.hover({
      backgroundColor: colors.hover
    }));
  }
  return null;
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.createStyles)((theme, { radius, color, gradient }, { variant, size }) => ({
  root: __spreadProps(__spreadValues({
    position: "relative",
    borderRadius: theme.fn.radius(radius),
    padding: 0,
    lineHeight: 1,
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes }),
    minHeight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes }),
    width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes }),
    minWidth: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes })
  }, getVariantStyles({ variant, theme, color, gradient })), {
    "&:active": theme.activeStyles,
    "& [data-action-icon-loader]": {
      maxWidth: "70%"
    },
    "&:disabled, &[data-disabled]": {
      color: theme.colors.gray[theme.colorScheme === "dark" ? 6 : 4],
      cursor: "not-allowed",
      backgroundColor: variant === "transparent" ? void 0 : theme.fn.themeColor("gray", theme.colorScheme === "dark" ? 8 : 1),
      borderColor: variant === "transparent" ? void 0 : theme.fn.themeColor("gray", theme.colorScheme === "dark" ? 8 : 1),
      backgroundImage: "none",
      pointerEvents: "none",
      "&:active": {
        transform: "none"
      }
    },
    "&[data-loading]": {
      pointerEvents: "none",
      "&::before": __spreadProps(__spreadValues({
        content: '""'
      }, theme.fn.cover((0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(-1))), {
        backgroundColor: theme.colorScheme === "dark" ? theme.fn.rgba(theme.colors.dark[7], 0.5) : "rgba(255, 255, 255, .5)",
        borderRadius: theme.fn.radius(radius),
        cursor: "not-allowed"
      })
    }
  })
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);



/***/ }),

/***/ "./node_modules/@mantine/core/esm/Affix/Affix.js":
/*!*******************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Affix/Affix.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Affix": () => (/* binding */ Affix)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-default-z-index/get-default-z-index.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/pack-sx/pack-sx.js");
/* harmony import */ var _Portal_OptionalPortal_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Portal/OptionalPortal.js */ "./node_modules/@mantine/core/esm/Portal/OptionalPortal.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");






var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  position: { bottom: 0, right: 0 },
  zIndex: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getDefaultZIndex)("modal"),
  withinPortal: true
};
const Affix = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.useComponentDefaultProps)("Affix", defaultProps, props), { target, position, zIndex, sx, withinPortal, portalProps } = _a, others = __objRest(_a, ["target", "position", "zIndex", "sx", "withinPortal", "portalProps"]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Portal_OptionalPortal_js__WEBPACK_IMPORTED_MODULE_3__.OptionalPortal, __spreadProps(__spreadValues({}, portalProps), {
    withinPortal,
    target
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    sx: [__spreadValues({ position: "fixed", zIndex }, position), ...(0,_mantine_utils__WEBPACK_IMPORTED_MODULE_5__.packSx)(sx)],
    ref
  }, others)));
});
Affix.displayName = "@mantine/core/Affix";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Alert/Alert.js":
/*!*******************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Alert/Alert.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Alert": () => (/* binding */ Alert)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-id/use-id.js");
/* harmony import */ var _Alert_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Alert.styles.js */ "./node_modules/@mantine/core/esm/Alert/Alert.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");
/* harmony import */ var _CloseButton_CloseButton_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../CloseButton/CloseButton.js */ "./node_modules/@mantine/core/esm/CloseButton/CloseButton.js");







var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  variant: "light"
};
const Alert = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Alert", defaultProps, props), {
    id,
    className,
    title,
    variant,
    children,
    color,
    classNames,
    icon,
    styles,
    onClose,
    radius,
    withCloseButton,
    closeButtonLabel,
    unstyled
  } = _a, others = __objRest(_a, [
    "id",
    "className",
    "title",
    "variant",
    "children",
    "color",
    "classNames",
    "icon",
    "styles",
    "onClose",
    "radius",
    "withCloseButton",
    "closeButtonLabel",
    "unstyled"
  ]);
  const { classes, cx } = (0,_Alert_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ color, radius }, { classNames, styles, unstyled, variant, name: "Alert" });
  const rootId = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_3__.useId)(id);
  const titleId = title && `${rootId}-title`;
  const bodyId = `${rootId}-body`;
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    id: rootId,
    role: "alert",
    "aria-labelledby": titleId,
    "aria-describedby": bodyId,
    className: cx(classes.root, classes[variant], className),
    ref
  }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.wrapper
  }, icon && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.icon
  }, icon), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.body
  }, title && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.title,
    "data-with-close-button": withCloseButton || void 0
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    id: titleId,
    className: classes.label
  }, title)), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    id: bodyId,
    className: classes.message
  }, children)), withCloseButton && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CloseButton_CloseButton_js__WEBPACK_IMPORTED_MODULE_5__.CloseButton, {
    className: classes.closeButton,
    onClick: onClose,
    variant: "transparent",
    size: 16,
    iconSize: 16,
    "aria-label": closeButtonLabel
  })));
});
Alert.displayName = "@mantine/core/Alert";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Alert/Alert.styles.js":
/*!**************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Alert/Alert.styles.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
function getVariantStyles({ variant, color, theme }) {
  if (variant === "filled") {
    const colors = theme.fn.variant({ variant: "filled", color });
    return {
      backgroundColor: colors.background,
      color: theme.white
    };
  }
  if (variant === "outline") {
    const colors = theme.fn.variant({ variant: "outline", color });
    return {
      color: colors.color,
      borderColor: colors.border,
      backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[6] : theme.white
    };
  }
  if (variant === "light") {
    const colors = theme.fn.variant({ variant: "light", color });
    return {
      backgroundColor: colors.background,
      color: colors.color
    };
  }
  return null;
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { radius, color }, { variant }) => ({
  root: __spreadValues(__spreadProps(__spreadValues({}, theme.fn.fontStyles()), {
    position: "relative",
    overflow: "hidden",
    paddingTop: theme.spacing.sm,
    paddingBottom: theme.spacing.sm,
    paddingLeft: theme.spacing.md,
    paddingRight: theme.spacing.sm,
    borderRadius: theme.fn.radius(radius),
    border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(1)} solid transparent`
  }), getVariantStyles({ variant, color, theme })),
  wrapper: {
    display: "flex"
  },
  body: {
    flex: 1
  },
  title: {
    boxSizing: "border-box",
    margin: 0,
    marginBottom: theme.spacing.xs,
    display: "flex",
    alignItems: "center",
    justifyContent: "space-between",
    lineHeight: theme.lineHeight,
    fontSize: theme.fontSizes.sm,
    fontWeight: 700,
    "&[data-with-close-button]": {
      paddingRight: theme.spacing.md
    }
  },
  label: {
    display: "block",
    overflow: "hidden",
    textOverflow: "ellipsis"
  },
  icon: {
    lineHeight: 1,
    width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(20),
    height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(20),
    display: "flex",
    alignItems: "center",
    justifyContent: "flex-start",
    marginRight: theme.spacing.md,
    marginTop: 1
  },
  message: __spreadProps(__spreadValues({}, theme.fn.fontStyles()), {
    lineHeight: theme.lineHeight,
    textOverflow: "ellipsis",
    overflow: "hidden",
    fontSize: theme.fontSizes.sm,
    color: variant === "filled" ? theme.white : theme.colorScheme === "dark" ? variant === "light" ? theme.white : theme.colors.dark[0] : theme.black
  }),
  closeButton: {
    width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(10),
    height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(10)
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Anchor/Anchor.js":
/*!*********************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Anchor/Anchor.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Anchor": () => (/* binding */ Anchor),
/* harmony export */   "_Anchor": () => (/* binding */ _Anchor)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _Text_Text_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Text/Text.js */ "./node_modules/@mantine/core/esm/Text/Text.js");
/* harmony import */ var _Anchor_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Anchor.styles.js */ "./node_modules/@mantine/core/esm/Anchor/Anchor.styles.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  underline: true
};
const _Anchor = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Anchor", defaultProps, props), { component, className, unstyled, variant, size, color, underline } = _a, others = __objRest(_a, ["component", "className", "unstyled", "variant", "size", "color", "underline"]);
  const { classes, cx } = (0,_Anchor_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ color, underline }, { name: "Anchor", unstyled, variant, size });
  const buttonProps = component === "button" ? { type: "button" } : null;
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Text_Text_js__WEBPACK_IMPORTED_MODULE_3__.Text, __spreadValues(__spreadValues({
    component: component || "a",
    ref,
    className: cx(classes.root, className),
    size
  }, buttonProps), others));
});
_Anchor.displayName = "@mantine/core/Anchor";
const Anchor = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_4__.createPolymorphicComponent)(_Anchor);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Anchor/Anchor.styles.js":
/*!****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Anchor/Anchor.styles.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
function getAnchorColor({ theme, color }) {
  if (color === "dimmed") {
    return theme.fn.dimmed();
  }
  return theme.fn.themeColor(color || theme.primaryColor, theme.colorScheme === "dark" ? 4 : 7, false, true);
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { color, underline }) => ({
  root: __spreadValues({
    backgroundColor: "transparent",
    cursor: "pointer",
    padding: 0,
    border: 0,
    color: getAnchorColor({ theme, color })
  }, theme.fn.hover({ textDecoration: underline ? "underline" : "none" }))
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/AppShell/AppShell.context.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AppShell/AppShell.context.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppShellProvider": () => (/* binding */ AppShellProvider),
/* harmony export */   "useAppShellContext": () => (/* binding */ useAppShellContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const AppShellContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({
  zIndex: 1e3,
  fixed: false,
  layout: "default"
});
const AppShellProvider = AppShellContext.Provider;
function useAppShellContext() {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(AppShellContext);
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/AppShell/AppShell.js":
/*!*************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AppShell/AppShell.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppShell": () => (/* binding */ AppShell)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _AppShell_context_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AppShell.context.js */ "./node_modules/@mantine/core/esm/AppShell/AppShell.context.js");
/* harmony import */ var _AppShell_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AppShell.styles.js */ "./node_modules/@mantine/core/esm/AppShell/AppShell.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  fixed: true,
  padding: "md"
};
const AppShell = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("AppShell", defaultProps, props), {
    children,
    navbar,
    header,
    footer,
    aside,
    fixed,
    zIndex,
    padding,
    navbarOffsetBreakpoint,
    asideOffsetBreakpoint,
    className,
    styles,
    classNames,
    unstyled,
    hidden,
    layout,
    variant
  } = _a, others = __objRest(_a, [
    "children",
    "navbar",
    "header",
    "footer",
    "aside",
    "fixed",
    "zIndex",
    "padding",
    "navbarOffsetBreakpoint",
    "asideOffsetBreakpoint",
    "className",
    "styles",
    "classNames",
    "unstyled",
    "hidden",
    "layout",
    "variant"
  ]);
  const { classes, cx } = (0,_AppShell_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ padding, fixed, navbarOffsetBreakpoint, asideOffsetBreakpoint }, { styles, classNames, unstyled, name: "AppShell", variant });
  if (hidden) {
    return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, children);
  }
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_AppShell_context_js__WEBPACK_IMPORTED_MODULE_3__.AppShellProvider, {
    value: { fixed, zIndex, layout }
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    className: cx(classes.root, className),
    ref
  }, others), header, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.body
  }, navbar, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("main", {
    className: classes.main
  }, children), aside), footer));
});
AppShell.displayName = "@mantine/core/AppShell";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/AppShell/AppShell.styles.js":
/*!********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AppShell/AppShell.styles.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/functions/fns/breakpoints/breakpoints.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
function getPositionStyles(props, theme) {
  const padding = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.getSize)({ size: props.padding, sizes: theme.spacing });
  const navbarOffset = props.navbarOffsetBreakpoint ? (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.getSize)({ size: props.navbarOffsetBreakpoint, sizes: theme.breakpoints }) : null;
  const asideOffset = props.asideOffsetBreakpoint ? (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.getSize)({ size: props.asideOffsetBreakpoint, sizes: theme.breakpoints }) : null;
  if (!props.fixed) {
    return { padding };
  }
  return {
    minHeight: "100vh",
    paddingTop: `calc(var(--mantine-header-height, 0px) + ${padding})`,
    paddingBottom: `calc(var(--mantine-footer-height, 0px) + ${padding})`,
    paddingLeft: `calc(var(--mantine-navbar-width, 0px) + ${padding})`,
    paddingRight: `calc(var(--mantine-aside-width, 0px) + ${padding})`,
    [`@media (max-width: ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.em)((0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getBreakpointValue)(navbarOffset) - 1)})`]: {
      paddingLeft: padding
    },
    [`@media (max-width: ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.em)((0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getBreakpointValue)(asideOffset) - 1)})`]: {
      paddingRight: padding
    }
  };
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.createStyles)((theme, props) => ({
  root: {
    boxSizing: "border-box"
  },
  body: {
    display: "flex",
    boxSizing: "border-box"
  },
  main: __spreadValues({
    flex: 1,
    width: "100vw",
    boxSizing: "border-box"
  }, getPositionStyles(props, theme))
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/AppShell/Aside/Aside.js":
/*!****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AppShell/Aside/Aside.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Aside": () => (/* binding */ Aside)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _HorizontalSection_HorizontalSection_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../HorizontalSection/HorizontalSection.js */ "./node_modules/@mantine/core/esm/AppShell/HorizontalSection/HorizontalSection.js");
/* harmony import */ var _HorizontalSection_Section_Section_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../HorizontalSection/Section/Section.js */ "./node_modules/@mantine/core/esm/AppShell/HorizontalSection/Section/Section.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
const defaultProps = {
  fixed: false,
  position: { top: 0, right: 0 },
  hiddenBreakpoint: "md",
  hidden: false
};
const Aside = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _props = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Aside", defaultProps, props);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_HorizontalSection_HorizontalSection_js__WEBPACK_IMPORTED_MODULE_2__.HorizontalSection, __spreadValues({
    section: "aside",
    __staticSelector: "Aside",
    ref
  }, _props));
});
Aside.Section = _HorizontalSection_Section_Section_js__WEBPACK_IMPORTED_MODULE_3__.Section;
Aside.displayName = "@mantine/core/Aside";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/AppShell/Footer/Footer.js":
/*!******************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AppShell/Footer/Footer.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Footer": () => (/* binding */ Footer)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _VerticalSection_VerticalSection_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../VerticalSection/VerticalSection.js */ "./node_modules/@mantine/core/esm/AppShell/VerticalSection/VerticalSection.js");




var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const defaultProps = {
  fixed: false,
  position: { bottom: 0, left: 0, right: 0 }
};
const Footer = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _props = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Footer", defaultProps, props);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_VerticalSection_VerticalSection_js__WEBPACK_IMPORTED_MODULE_2__.VerticalSection, __spreadProps(__spreadValues({
    section: "footer",
    __staticSelector: "Footer"
  }, _props), {
    ref
  }));
});
Footer.displayName = "@mantine/core/Footer";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/AppShell/Header/Header.js":
/*!******************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AppShell/Header/Header.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Header": () => (/* binding */ Header)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _VerticalSection_VerticalSection_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../VerticalSection/VerticalSection.js */ "./node_modules/@mantine/core/esm/AppShell/VerticalSection/VerticalSection.js");




var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const defaultProps = {
  fixed: false,
  position: { top: 0, left: 0, right: 0 }
};
const Header = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _props = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Header", defaultProps, props);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_VerticalSection_VerticalSection_js__WEBPACK_IMPORTED_MODULE_2__.VerticalSection, __spreadProps(__spreadValues({
    section: "header",
    __staticSelector: "Header"
  }, _props), {
    ref
  }));
});
Header.displayName = "@mantine/core/Header";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/AppShell/HorizontalSection/HorizontalSection.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AppShell/HorizontalSection/HorizontalSection.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HorizontalSection": () => (/* binding */ HorizontalSection)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-default-z-index/get-default-z-index.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/Global.js");
/* harmony import */ var _AppShell_context_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../AppShell.context.js */ "./node_modules/@mantine/core/esm/AppShell/AppShell.context.js");
/* harmony import */ var _get_sorted_breakpoints_get_sorted_breakpoints_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./get-sorted-breakpoints/get-sorted-breakpoints.js */ "./node_modules/@mantine/core/esm/AppShell/HorizontalSection/get-sorted-breakpoints/get-sorted-breakpoints.js");
/* harmony import */ var _HorizontalSection_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./HorizontalSection.styles.js */ "./node_modules/@mantine/core/esm/AppShell/HorizontalSection/HorizontalSection.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");







var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const HorizontalSection = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((_a, ref) => {
  var _b = _a, {
    width,
    height,
    fixed = false,
    position,
    zIndex,
    hiddenBreakpoint = "md",
    hidden = false,
    withBorder = true,
    className,
    classNames,
    styles,
    children,
    section,
    __staticSelector,
    unstyled,
    variant
  } = _b, others = __objRest(_b, [
    "width",
    "height",
    "fixed",
    "position",
    "zIndex",
    "hiddenBreakpoint",
    "hidden",
    "withBorder",
    "className",
    "classNames",
    "styles",
    "children",
    "section",
    "__staticSelector",
    "unstyled",
    "variant"
  ]);
  const ctx = (0,_AppShell_context_js__WEBPACK_IMPORTED_MODULE_1__.useAppShellContext)();
  const { classes, cx, theme } = (0,_HorizontalSection_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({
    width,
    height,
    fixed: ctx.fixed || fixed,
    position,
    hiddenBreakpoint,
    zIndex: zIndex || ctx.zIndex || (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getDefaultZIndex)("app"),
    section,
    withBorder,
    layout: ctx.layout
  }, { classNames, styles, name: __staticSelector, unstyled, variant });
  const breakpoints = (0,_get_sorted_breakpoints_get_sorted_breakpoints_js__WEBPACK_IMPORTED_MODULE_4__.getSortedBreakpoints)(width, theme).reduce((acc, [breakpoint, breakpointSize]) => {
    acc[`@media (min-width: ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.em)(breakpoint)})`] = {
      [`--mantine-${section}-width`]: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.rem)(breakpointSize)
    };
    return acc;
  }, {});
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_6__.Box, __spreadValues({
    component: section === "navbar" ? "nav" : "aside",
    ref,
    "data-hidden": hidden || void 0,
    className: cx(classes.root, className)
  }, others), children, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mantine_styles__WEBPACK_IMPORTED_MODULE_7__.Global, {
    styles: () => ({
      ":root": __spreadValues({
        [`--mantine-${section}-width`]: (width == null ? void 0 : width.base) ? (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.rem)(width.base) : "0rem"
      }, breakpoints)
    })
  }));
});
HorizontalSection.displayName = "@mantine/core/HorizontalSection";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/AppShell/HorizontalSection/HorizontalSection.styles.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AppShell/HorizontalSection/HorizontalSection.styles.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/functions/fns/breakpoints/breakpoints.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _get_sorted_breakpoints_get_sorted_breakpoints_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./get-sorted-breakpoints/get-sorted-breakpoints.js */ "./node_modules/@mantine/core/esm/AppShell/HorizontalSection/get-sorted-breakpoints/get-sorted-breakpoints.js");



var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, {
  height,
  width,
  fixed,
  position,
  hiddenBreakpoint,
  zIndex,
  section,
  withBorder,
  layout
}) => {
  const breakpoints = typeof width === "object" && width !== null ? (0,_get_sorted_breakpoints_get_sorted_breakpoints_js__WEBPACK_IMPORTED_MODULE_1__.getSortedBreakpoints)(width, theme).reduce((acc, [breakpoint, breakpointSize]) => {
    acc[`@media (min-width: ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.em)(breakpoint)})`] = {
      width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(breakpointSize),
      minWidth: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(breakpointSize)
    };
    return acc;
  }, {}) : null;
  const borderStyles = withBorder ? {
    [section === "navbar" ? "borderRight" : "borderLeft"]: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(1)} solid ${theme.colorScheme === "dark" ? theme.colors.dark[5] : theme.colors.gray[2]}`
  } : {};
  return {
    root: __spreadProps(__spreadValues(__spreadValues(__spreadProps(__spreadValues(__spreadValues({}, theme.fn.fontStyles()), position), {
      top: layout === "alt" ? 0 : (position == null ? void 0 : position.top) || "var(--mantine-header-height)",
      bottom: 0,
      zIndex,
      height: height ? (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(height) : layout === "alt" ? "auto" : "calc(100vh - var(--mantine-header-height, 0rem) - var(--mantine-footer-height, 0rem))",
      width: (width == null ? void 0 : width.base) ? (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(width == null ? void 0 : width.base) : "100%",
      position: fixed ? "fixed" : "static",
      boxSizing: "border-box",
      display: "flex",
      flexDirection: "column",
      backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[7] : theme.white
    }), borderStyles), breakpoints), {
      "&[data-hidden]": {
        [`@media (max-width: ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.em)((0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getBreakpointValue)((0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.getSize)({
          size: hiddenBreakpoint,
          sizes: theme.breakpoints
        })) - 1)})`]: {
          display: "none"
        }
      }
    })
  };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/AppShell/HorizontalSection/Section/Section.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AppShell/HorizontalSection/Section/Section.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Section": () => (/* binding */ Section),
/* harmony export */   "_Section": () => (/* binding */ _Section)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/pack-sx/pack-sx.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");




var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const _Section = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((_a, ref) => {
  var _b = _a, { children, grow = false, sx } = _b, others = __objRest(_b, ["children", "grow", "sx"]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_1__.Box, __spreadValues({
    ref,
    sx: [{ flex: grow ? 1 : 0, boxSizing: "border-box" }, ...(0,_mantine_utils__WEBPACK_IMPORTED_MODULE_2__.packSx)(sx)]
  }, others), children);
});
_Section.displayName = "@mantine/core/Section";
const Section = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_3__.createPolymorphicComponent)(_Section);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/AppShell/HorizontalSection/get-sorted-breakpoints/get-sorted-breakpoints.js":
/*!********************************************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AppShell/HorizontalSection/get-sorted-breakpoints/get-sorted-breakpoints.js ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getSortedBreakpoints": () => (/* binding */ getSortedBreakpoints)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/functions/fns/breakpoints/breakpoints.js");


function getSortedBreakpoints(breakpoints, theme) {
  if (!breakpoints) {
    return [];
  }
  const values = Object.keys(breakpoints).filter((breakpoint) => breakpoint !== "base").map((breakpoint) => [
    (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.getSize)({ size: breakpoint, sizes: theme.breakpoints, units: "em" }),
    breakpoints[breakpoint]
  ]);
  values.sort((a, b) => (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getBreakpointValue)(a[0]) - (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getBreakpointValue)(b[0]));
  return values;
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/AppShell/Navbar/Navbar.js":
/*!******************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AppShell/Navbar/Navbar.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Navbar": () => (/* binding */ Navbar)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _HorizontalSection_HorizontalSection_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../HorizontalSection/HorizontalSection.js */ "./node_modules/@mantine/core/esm/AppShell/HorizontalSection/HorizontalSection.js");
/* harmony import */ var _HorizontalSection_Section_Section_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../HorizontalSection/Section/Section.js */ "./node_modules/@mantine/core/esm/AppShell/HorizontalSection/Section/Section.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
const defaultProps = {
  fixed: false,
  position: { top: 0, left: 0 },
  hiddenBreakpoint: "md",
  hidden: false
};
const Navbar = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _props = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Navbar", defaultProps, props);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_HorizontalSection_HorizontalSection_js__WEBPACK_IMPORTED_MODULE_2__.HorizontalSection, __spreadValues({
    section: "navbar",
    __staticSelector: "Navbar",
    ref
  }, _props));
});
Navbar.Section = _HorizontalSection_Section_Section_js__WEBPACK_IMPORTED_MODULE_3__.Section;
Navbar.displayName = "@mantine/core/Navbar";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/AppShell/VerticalSection/VerticalSection.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AppShell/VerticalSection/VerticalSection.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "VerticalSection": () => (/* binding */ VerticalSection)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-default-z-index/get-default-z-index.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/Global.js");
/* harmony import */ var _AppShell_context_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../AppShell.context.js */ "./node_modules/@mantine/core/esm/AppShell/AppShell.context.js");
/* harmony import */ var _VerticalSection_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./VerticalSection.styles.js */ "./node_modules/@mantine/core/esm/AppShell/VerticalSection/VerticalSection.styles.js");
/* harmony import */ var _HorizontalSection_get_sorted_breakpoints_get_sorted_breakpoints_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../HorizontalSection/get-sorted-breakpoints/get-sorted-breakpoints.js */ "./node_modules/@mantine/core/esm/AppShell/HorizontalSection/get-sorted-breakpoints/get-sorted-breakpoints.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");







var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const VerticalSection = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((_a, ref) => {
  var _b = _a, {
    children,
    className,
    classNames,
    styles,
    height,
    fixed = false,
    withBorder = true,
    position,
    zIndex,
    section,
    unstyled,
    __staticSelector,
    variant
  } = _b, others = __objRest(_b, [
    "children",
    "className",
    "classNames",
    "styles",
    "height",
    "fixed",
    "withBorder",
    "position",
    "zIndex",
    "section",
    "unstyled",
    "__staticSelector",
    "variant"
  ]);
  const ctx = (0,_AppShell_context_js__WEBPACK_IMPORTED_MODULE_1__.useAppShellContext)();
  const _zIndex = zIndex || ctx.zIndex || (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getDefaultZIndex)("app");
  const { classes, cx, theme } = (0,_VerticalSection_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
    height,
    fixed: ctx.fixed || fixed,
    position,
    zIndex: typeof _zIndex === "number" && ctx.layout === "default" ? _zIndex + 1 : _zIndex,
    layout: ctx.layout,
    borderPosition: withBorder ? section === "header" ? "bottom" : "top" : "none"
  }, { name: __staticSelector, classNames, styles, unstyled, variant });
  const breakpoints = typeof height === "object" && height !== null ? (0,_HorizontalSection_get_sorted_breakpoints_get_sorted_breakpoints_js__WEBPACK_IMPORTED_MODULE_4__.getSortedBreakpoints)(height, theme).reduce((acc, [breakpoint, breakpointSize]) => {
    acc[`@media (min-width: ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.em)(breakpoint)})`] = {
      [`--mantine-${section}-height`]: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.rem)(breakpointSize)
    };
    return acc;
  }, {}) : null;
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_6__.Box, __spreadValues({
    component: section === "header" ? "header" : "footer",
    className: cx(classes.root, className),
    ref
  }, others), children, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mantine_styles__WEBPACK_IMPORTED_MODULE_7__.Global, {
    styles: () => ({
      ":root": __spreadValues({
        [`--mantine-${section}-height`]: typeof height === "object" ? (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.rem)(height == null ? void 0 : height.base) || "100%" : (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.rem)(height)
      }, breakpoints)
    })
  }));
});
VerticalSection.displayName = "@mantine/core/VerticalSection";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/AppShell/VerticalSection/VerticalSection.styles.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AppShell/VerticalSection/VerticalSection.styles.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _HorizontalSection_get_sorted_breakpoints_get_sorted_breakpoints_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../HorizontalSection/get-sorted-breakpoints/get-sorted-breakpoints.js */ "./node_modules/@mantine/core/esm/AppShell/HorizontalSection/get-sorted-breakpoints/get-sorted-breakpoints.js");



var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { height, fixed, position, zIndex, borderPosition, layout }) => {
  const breakpoints = typeof height === "object" && height !== null ? (0,_HorizontalSection_get_sorted_breakpoints_get_sorted_breakpoints_js__WEBPACK_IMPORTED_MODULE_1__.getSortedBreakpoints)(height, theme).reduce((acc, [breakpoint, breakpointSize]) => {
    acc[`@media (min-width: ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.em)(breakpoint)})`] = {
      height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(breakpointSize),
      minHeight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(breakpointSize)
    };
    return acc;
  }, {}) : null;
  return {
    root: __spreadProps(__spreadValues(__spreadProps(__spreadValues(__spreadValues({}, theme.fn.fontStyles()), position), {
      zIndex,
      left: layout === "alt" ? "var(--mantine-navbar-width, 0)" : 0,
      right: layout === "alt" ? "var(--mantine-aside-width, 0)" : 0,
      height: typeof height === "object" ? (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(height == null ? void 0 : height.base) || "100%" : (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(height),
      maxHeight: typeof height === "object" ? (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(height == null ? void 0 : height.base) || "100%" : (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(height),
      position: fixed ? "fixed" : "static",
      boxSizing: "border-box",
      backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[7] : theme.white
    }), breakpoints), {
      borderBottom: borderPosition === "bottom" ? `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(1)} solid ${theme.colorScheme === "dark" ? theme.colors.dark[5] : theme.colors.gray[2]}` : void 0,
      borderTop: borderPosition === "top" ? `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(1)} solid ${theme.colorScheme === "dark" ? theme.colors.dark[5] : theme.colors.gray[2]}` : void 0
    })
  };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/AspectRatio/AspectRatio.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AspectRatio/AspectRatio.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AspectRatio": () => (/* binding */ AspectRatio)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");
/* harmony import */ var _AspectRatio_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AspectRatio.styles.js */ "./node_modules/@mantine/core/esm/AspectRatio/AspectRatio.styles.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const AspectRatio = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("AspectRatio", {}, props), { className, ratio, children, unstyled, variant } = _a, others = __objRest(_a, ["className", "ratio", "children", "unstyled", "variant"]);
  const { classes, cx } = (0,_AspectRatio_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ ratio }, { name: "AspectRatio", unstyled, variant });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_3__.Box, __spreadValues({
    ref,
    className: cx(classes.root, className)
  }, others), children);
});
AspectRatio.displayName = "@mantine/core/AspectRatio";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/AspectRatio/AspectRatio.styles.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/AspectRatio/AspectRatio.styles.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { ratio }) => ({
  root: {
    position: "relative",
    maxWidth: "100%",
    "&::before": {
      content: '""',
      height: 0,
      display: "block",
      paddingBottom: `${1 / ratio * 100}%`
    },
    "&::after": {
      content: '""',
      display: "table",
      clear: "both"
    },
    "& > *:not(style)": __spreadProps(__spreadValues({}, theme.fn.cover()), {
      overflow: "hidden",
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      width: "100%",
      height: "100%"
    }),
    "& > img, & > video": {
      objectFit: "cover"
    }
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Autocomplete/Autocomplete.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Autocomplete/Autocomplete.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Autocomplete": () => (/* binding */ Autocomplete),
/* harmony export */   "defaultFilter": () => (/* binding */ defaultFilter)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-uncontrolled/use-uncontrolled.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-did-update/use-did-update.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-merged-ref/use-merged-ref.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-default-z-index/get-default-z-index.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/group-options/group-options.js");
/* harmony import */ var _Select_SelectItems_SelectItems_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../Select/SelectItems/SelectItems.js */ "./node_modules/@mantine/core/esm/Select/SelectItems/SelectItems.js");
/* harmony import */ var _Select_DefaultItem_DefaultItem_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Select/DefaultItem/DefaultItem.js */ "./node_modules/@mantine/core/esm/Select/DefaultItem/DefaultItem.js");
/* harmony import */ var _Select_SelectPopover_SelectPopover_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../Select/SelectPopover/SelectPopover.js */ "./node_modules/@mantine/core/esm/Select/SelectPopover/SelectPopover.js");
/* harmony import */ var _Select_SelectScrollArea_SelectScrollArea_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../Select/SelectScrollArea/SelectScrollArea.js */ "./node_modules/@mantine/core/esm/Select/SelectScrollArea/SelectScrollArea.js");
/* harmony import */ var _filter_data_filter_data_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./filter-data/filter-data.js */ "./node_modules/@mantine/core/esm/Autocomplete/filter-data/filter-data.js");
/* harmony import */ var _Autocomplete_styles_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Autocomplete.styles.js */ "./node_modules/@mantine/core/esm/Autocomplete/Autocomplete.styles.js");
/* harmony import */ var _Input_use_input_props_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Input/use-input-props.js */ "./node_modules/@mantine/core/esm/Input/use-input-props.js");
/* harmony import */ var _Input_Input_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Input/Input.js */ "./node_modules/@mantine/core/esm/Input/Input.js");













var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function defaultFilter(value, item) {
  return item.value.toLowerCase().trim().includes(value.toLowerCase().trim());
}
const defaultProps = {
  required: false,
  size: "sm",
  shadow: "sm",
  limit: 5,
  itemComponent: _Select_DefaultItem_DefaultItem_js__WEBPACK_IMPORTED_MODULE_1__.DefaultItem,
  transitionProps: { transition: "fade", duration: 0 },
  initiallyOpened: false,
  filter: defaultFilter,
  switchDirectionOnFlip: false,
  zIndex: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getDefaultZIndex)("popover"),
  dropdownPosition: "flip",
  maxDropdownHeight: "auto",
  positionDependencies: []
};
const Autocomplete = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_Input_use_input_props_js__WEBPACK_IMPORTED_MODULE_3__.useInputProps)("Autocomplete", defaultProps, props), {
    inputProps,
    wrapperProps,
    shadow,
    data,
    limit,
    value,
    defaultValue,
    onChange,
    unstyled,
    itemComponent,
    onItemSubmit,
    onKeyDown,
    onFocus,
    onBlur,
    onClick,
    transitionProps,
    initiallyOpened,
    classNames,
    styles,
    filter,
    nothingFound,
    onDropdownClose,
    onDropdownOpen,
    withinPortal,
    switchDirectionOnFlip,
    zIndex,
    dropdownPosition,
    maxDropdownHeight,
    dropdownComponent,
    positionDependencies,
    readOnly,
    hoverOnSearchChange
  } = _a, others = __objRest(_a, [
    "inputProps",
    "wrapperProps",
    "shadow",
    "data",
    "limit",
    "value",
    "defaultValue",
    "onChange",
    "unstyled",
    "itemComponent",
    "onItemSubmit",
    "onKeyDown",
    "onFocus",
    "onBlur",
    "onClick",
    "transitionProps",
    "initiallyOpened",
    "classNames",
    "styles",
    "filter",
    "nothingFound",
    "onDropdownClose",
    "onDropdownOpen",
    "withinPortal",
    "switchDirectionOnFlip",
    "zIndex",
    "dropdownPosition",
    "maxDropdownHeight",
    "dropdownComponent",
    "positionDependencies",
    "readOnly",
    "hoverOnSearchChange"
  ]);
  const { classes } = (0,_Autocomplete_styles_js__WEBPACK_IMPORTED_MODULE_4__["default"])(null, { classNames, styles, name: "Autocomplete", unstyled });
  const [dropdownOpened, _setDropdownOpened] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initiallyOpened);
  const [hovered, setHovered] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(-1);
  const [direction, setDirection] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("column");
  const inputRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const [IMEOpen, setIMEOpen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [_value, handleChange] = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_5__.useUncontrolled)({
    value,
    defaultValue,
    finalValue: "",
    onChange
  });
  const setDropdownOpened = (opened) => {
    _setDropdownOpened(opened);
    const handler = opened ? onDropdownOpen : onDropdownClose;
    typeof handler === "function" && handler();
  };
  (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_6__.useDidUpdate)(() => {
    if (hoverOnSearchChange && _value) {
      setHovered(0);
    } else {
      setHovered(-1);
    }
  }, [_value, hoverOnSearchChange]);
  const handleItemClick = (item) => {
    handleChange(item.value);
    typeof onItemSubmit === "function" && onItemSubmit(item);
    setDropdownOpened(false);
  };
  const formattedData = data.map((item) => typeof item === "string" ? { value: item } : item);
  const filteredData = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_7__.groupOptions)({
    data: (0,_filter_data_filter_data_js__WEBPACK_IMPORTED_MODULE_8__.filterData)({ data: formattedData, value: _value, limit, filter })
  });
  const handleInputKeydown = (event) => {
    if (IMEOpen) {
      return;
    }
    typeof onKeyDown === "function" && onKeyDown(event);
    const isColumn = direction === "column";
    const handleNext = () => {
      setHovered((current) => current < filteredData.length - 1 ? current + 1 : current);
    };
    const handlePrevious = () => {
      setHovered((current) => current > 0 ? current - 1 : current);
    };
    switch (event.key) {
      case "ArrowUp": {
        event.preventDefault();
        isColumn ? handlePrevious() : handleNext();
        break;
      }
      case "ArrowDown": {
        event.preventDefault();
        isColumn ? handleNext() : handlePrevious();
        break;
      }
      case "Enter": {
        if (filteredData[hovered] && dropdownOpened) {
          event.preventDefault();
          handleChange(filteredData[hovered].value);
          typeof onItemSubmit === "function" && onItemSubmit(filteredData[hovered]);
          setDropdownOpened(false);
        }
        break;
      }
      case "Escape": {
        if (dropdownOpened) {
          event.preventDefault();
          setDropdownOpened(false);
        }
      }
    }
  };
  const handleInputFocus = (event) => {
    typeof onFocus === "function" && onFocus(event);
    setDropdownOpened(true);
  };
  const handleInputBlur = (event) => {
    typeof onBlur === "function" && onBlur(event);
    setDropdownOpened(false);
  };
  const handleInputClick = (event) => {
    typeof onClick === "function" && onClick(event);
    setDropdownOpened(true);
  };
  const shouldRenderDropdown = dropdownOpened && (filteredData.length > 0 || filteredData.length === 0 && !!nothingFound);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Input_Input_js__WEBPACK_IMPORTED_MODULE_9__.Input.Wrapper, __spreadProps(__spreadValues({}, wrapperProps), {
    __staticSelector: "Autocomplete"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Select_SelectPopover_SelectPopover_js__WEBPACK_IMPORTED_MODULE_10__.SelectPopover, {
    opened: shouldRenderDropdown,
    transitionProps,
    shadow: "sm",
    withinPortal,
    __staticSelector: "Autocomplete",
    onDirectionChange: setDirection,
    switchDirectionOnFlip,
    zIndex,
    dropdownPosition,
    positionDependencies,
    classNames,
    styles,
    unstyled,
    readOnly,
    variant: inputProps.variant
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Select_SelectPopover_SelectPopover_js__WEBPACK_IMPORTED_MODULE_10__.SelectPopover.Target, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.wrapper,
    "aria-controls": inputProps.id,
    onMouseLeave: () => setHovered(-1),
    tabIndex: -1
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Input_Input_js__WEBPACK_IMPORTED_MODULE_9__.Input, __spreadProps(__spreadValues(__spreadValues({
    type: "search",
    autoComplete: "off"
  }, inputProps), others), {
    readOnly,
    "data-mantine-stop-propagation": dropdownOpened,
    ref: (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_11__.useMergedRef)(ref, inputRef),
    onKeyDown: handleInputKeydown,
    classNames,
    styles,
    __staticSelector: "Autocomplete",
    value: _value,
    onChange: (event) => {
      handleChange(event.currentTarget.value);
      setDropdownOpened(true);
    },
    onFocus: handleInputFocus,
    onBlur: handleInputBlur,
    onClick: handleInputClick,
    onCompositionStart: () => setIMEOpen(true),
    onCompositionEnd: () => setIMEOpen(false),
    role: "combobox",
    "aria-haspopup": "listbox",
    "aria-owns": shouldRenderDropdown ? `${inputProps.id}-items` : null,
    "aria-expanded": shouldRenderDropdown,
    "aria-autocomplete": "list",
    "aria-controls": shouldRenderDropdown ? `${inputProps.id}-items` : null,
    "aria-activedescendant": hovered >= 0 ? `${inputProps.id}-${hovered}` : null
  })))), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Select_SelectPopover_SelectPopover_js__WEBPACK_IMPORTED_MODULE_10__.SelectPopover.Dropdown, {
    component: dropdownComponent || _Select_SelectScrollArea_SelectScrollArea_js__WEBPACK_IMPORTED_MODULE_12__.SelectScrollArea,
    maxHeight: maxDropdownHeight,
    direction,
    id: inputProps.id,
    __staticSelector: "Autocomplete",
    classNames,
    styles
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Select_SelectItems_SelectItems_js__WEBPACK_IMPORTED_MODULE_13__.SelectItems, {
    data: filteredData,
    hovered,
    classNames,
    styles,
    uuid: inputProps.id,
    __staticSelector: "Autocomplete",
    onItemHover: setHovered,
    onItemSelect: handleItemClick,
    itemComponent,
    size: inputProps.size,
    nothingFound,
    variant: inputProps.variant
  }))));
});
Autocomplete.displayName = "@mantine/core/Autocomplete";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Autocomplete/Autocomplete.styles.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Autocomplete/Autocomplete.styles.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)(() => ({
  wrapper: {
    position: "relative"
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Autocomplete/filter-data/filter-data.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Autocomplete/filter-data/filter-data.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "filterData": () => (/* binding */ filterData)
/* harmony export */ });
function filterData({ data, limit, value, filter }) {
  const result = [];
  for (let i = 0; i < data.length; i += 1) {
    if (filter(value, data[i])) {
      result.push(data[i]);
    }
    if (result.length >= limit) {
      break;
    }
  }
  return result;
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Avatar/Avatar.js":
/*!*********************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Avatar/Avatar.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Avatar": () => (/* binding */ Avatar),
/* harmony export */   "_Avatar": () => (/* binding */ _Avatar)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _AvatarPlaceholderIcon_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./AvatarPlaceholderIcon.js */ "./node_modules/@mantine/core/esm/Avatar/AvatarPlaceholderIcon.js");
/* harmony import */ var _AvatarGroup_AvatarGroup_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./AvatarGroup/AvatarGroup.js */ "./node_modules/@mantine/core/esm/Avatar/AvatarGroup/AvatarGroup.js");
/* harmony import */ var _AvatarGroup_AvatarGroup_context_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AvatarGroup/AvatarGroup.context.js */ "./node_modules/@mantine/core/esm/Avatar/AvatarGroup/AvatarGroup.context.js");
/* harmony import */ var _Avatar_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Avatar.styles.js */ "./node_modules/@mantine/core/esm/Avatar/Avatar.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");









var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  size: "md",
  color: "gray",
  variant: "light"
};
const _Avatar = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Avatar", defaultProps, props), {
    className,
    size,
    src,
    alt,
    radius,
    children,
    color,
    variant,
    gradient,
    classNames,
    styles,
    imageProps,
    unstyled
  } = _a, others = __objRest(_a, [
    "className",
    "size",
    "src",
    "alt",
    "radius",
    "children",
    "color",
    "variant",
    "gradient",
    "classNames",
    "styles",
    "imageProps",
    "unstyled"
  ]);
  const ctx = (0,_AvatarGroup_AvatarGroup_context_js__WEBPACK_IMPORTED_MODULE_2__.useAvatarGroupContext)();
  const [error, setError] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(!src);
  const { classes, cx } = (0,_Avatar_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])({ color, radius, withinGroup: ctx.withinGroup, spacing: ctx.spacing, gradient }, { classNames, styles, unstyled, name: "Avatar", variant, size });
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    !src ? setError(true) : setError(false);
  }, [src]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    component: "div",
    className: cx(classes.root, className),
    ref
  }, others), error ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.placeholder,
    title: alt
  }, children || /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_AvatarPlaceholderIcon_js__WEBPACK_IMPORTED_MODULE_5__.AvatarPlaceholderIcon, {
    className: classes.placeholderIcon
  })) : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("img", __spreadProps(__spreadValues({}, imageProps), {
    className: classes.image,
    src,
    alt,
    onError: () => setError(true)
  })));
});
_Avatar.displayName = "@mantine/core/Avatar";
_Avatar.Group = _AvatarGroup_AvatarGroup_js__WEBPACK_IMPORTED_MODULE_6__.AvatarGroup;
const Avatar = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_7__.createPolymorphicComponent)(_Avatar);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Avatar/Avatar.styles.js":
/*!****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Avatar/Avatar.styles.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AVATAR_VARIANTS": () => (/* binding */ AVATAR_VARIANTS),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "sizes": () => (/* binding */ sizes)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const AVATAR_VARIANTS = ["filled", "light", "gradient", "outline"];
const sizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(16),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(26),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(38),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(56),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(84)
};
function getGroupStyles({ withinGroup, spacing, theme }) {
  if (!withinGroup) {
    return null;
  }
  return {
    marginLeft: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size: spacing, sizes: theme.spacing })} * -1)`,
    backgroundColor: `${theme.colorScheme === "dark" ? theme.colors.dark[7] : theme.white}`,
    border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(2)} solid ${theme.colorScheme === "dark" ? theme.colors.dark[7] : theme.white}`
  };
}
function getVariantStyles({ theme, variant, color, gradient }) {
  const colors = theme.fn.variant({ variant, color, gradient });
  if (AVATAR_VARIANTS.includes(variant)) {
    return {
      placeholder: {
        color: colors.color,
        backgroundColor: colors.background,
        backgroundImage: variant === "gradient" ? colors.background : void 0,
        border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(variant === "gradient" ? 0 : 1)} solid ${colors.border}`
      },
      placeholderIcon: {
        color: colors.color
      }
    };
  }
  return {};
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.createStyles)((theme, { radius, withinGroup, spacing, color, gradient }, { variant, size }) => {
  const variantStyles = getVariantStyles({ theme, color, gradient, variant });
  return {
    root: __spreadValues(__spreadProps(__spreadValues({}, theme.fn.focusStyles()), {
      WebkitTapHighlightColor: "transparent",
      boxSizing: "border-box",
      position: "relative",
      display: "block",
      userSelect: "none",
      overflow: "hidden",
      borderRadius: theme.fn.radius(radius),
      textDecoration: "none",
      border: 0,
      backgroundColor: "transparent",
      padding: 0,
      width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size, sizes }),
      minWidth: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size, sizes }),
      height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size, sizes })
    }), getGroupStyles({ withinGroup, spacing, theme })),
    image: {
      objectFit: "cover",
      width: "100%",
      height: "100%",
      display: "block"
    },
    placeholder: __spreadValues(__spreadProps(__spreadValues({}, theme.fn.fontStyles()), {
      fontWeight: 700,
      display: "flex",
      alignItems: "center",
      justifyContent: "center",
      width: "100%",
      height: "100%",
      userSelect: "none",
      borderRadius: theme.fn.radius(radius),
      fontSize: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size, sizes })} / 2.5)`
    }), variantStyles.placeholder),
    placeholderIcon: __spreadValues({
      width: "70%",
      height: "70%"
    }, variantStyles.placeholderIcon)
  };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);



/***/ }),

/***/ "./node_modules/@mantine/core/esm/Avatar/AvatarGroup/AvatarGroup.context.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Avatar/AvatarGroup/AvatarGroup.context.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AvatarGroupProvider": () => (/* binding */ AvatarGroupProvider),
/* harmony export */   "useAvatarGroupContext": () => (/* binding */ useAvatarGroupContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const AvatarGroupContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
function AvatarGroupProvider({ spacing, children }) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(AvatarGroupContext.Provider, {
    value: { spacing }
  }, children);
}
function useAvatarGroupContext() {
  const ctx = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(AvatarGroupContext);
  if (ctx) {
    return __spreadProps(__spreadValues({}, ctx), { withinGroup: true });
  }
  return { spacing: null, withinGroup: false };
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Avatar/AvatarGroup/AvatarGroup.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Avatar/AvatarGroup/AvatarGroup.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AvatarGroup": () => (/* binding */ AvatarGroup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _AvatarGroup_context_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AvatarGroup.context.js */ "./node_modules/@mantine/core/esm/Avatar/AvatarGroup/AvatarGroup.context.js");
/* harmony import */ var _AvatarGroup_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AvatarGroup.styles.js */ "./node_modules/@mantine/core/esm/Avatar/AvatarGroup/AvatarGroup.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {};
const AvatarGroup = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("AvatarGroup", defaultProps, props), {
    children,
    spacing = "sm",
    unstyled,
    className,
    variant
  } = _a, others = __objRest(_a, [
    "children",
    "spacing",
    "unstyled",
    "className",
    "variant"
  ]);
  const { classes, cx } = (0,_AvatarGroup_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ spacing }, { name: "AvatarGroup", unstyled, variant });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_AvatarGroup_context_js__WEBPACK_IMPORTED_MODULE_3__.AvatarGroupProvider, {
    spacing
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    ref,
    className: cx(classes.root, className)
  }, others), children));
});
AvatarGroup.displayName = "@mantine/core/AvatarGroup";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Avatar/AvatarGroup/AvatarGroup.styles.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Avatar/AvatarGroup/AvatarGroup.styles.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { spacing }) => ({
  root: {
    display: "flex",
    paddingLeft: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size: spacing, sizes: theme.spacing })
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Avatar/AvatarPlaceholderIcon.js":
/*!************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Avatar/AvatarPlaceholderIcon.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AvatarPlaceholderIcon": () => (/* binding */ AvatarPlaceholderIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
function AvatarPlaceholderIcon(props) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __spreadProps(__spreadValues({}, props), {
    width: "15",
    height: "15",
    viewBox: "0 0 15 15",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    d: "M0.877014 7.49988C0.877014 3.84219 3.84216 0.877045 7.49985 0.877045C11.1575 0.877045 14.1227 3.84219 14.1227 7.49988C14.1227 11.1575 11.1575 14.1227 7.49985 14.1227C3.84216 14.1227 0.877014 11.1575 0.877014 7.49988ZM7.49985 1.82704C4.36683 1.82704 1.82701 4.36686 1.82701 7.49988C1.82701 8.97196 2.38774 10.3131 3.30727 11.3213C4.19074 9.94119 5.73818 9.02499 7.50023 9.02499C9.26206 9.02499 10.8093 9.94097 11.6929 11.3208C12.6121 10.3127 13.1727 8.97172 13.1727 7.49988C13.1727 4.36686 10.6328 1.82704 7.49985 1.82704ZM10.9818 11.9787C10.2839 10.7795 8.9857 9.97499 7.50023 9.97499C6.01458 9.97499 4.71624 10.7797 4.01845 11.9791C4.97952 12.7272 6.18765 13.1727 7.49985 13.1727C8.81227 13.1727 10.0206 12.727 10.9818 11.9787ZM5.14999 6.50487C5.14999 5.207 6.20212 4.15487 7.49999 4.15487C8.79786 4.15487 9.84999 5.207 9.84999 6.50487C9.84999 7.80274 8.79786 8.85487 7.49999 8.85487C6.20212 8.85487 5.14999 7.80274 5.14999 6.50487ZM7.49999 5.10487C6.72679 5.10487 6.09999 5.73167 6.09999 6.50487C6.09999 7.27807 6.72679 7.90487 7.49999 7.90487C8.27319 7.90487 8.89999 7.27807 8.89999 6.50487C8.89999 5.73167 8.27319 5.10487 7.49999 5.10487Z",
    fill: "currentColor",
    fillRule: "evenodd",
    clipRule: "evenodd"
  }));
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/BackgroundImage/BackgroundImage.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/BackgroundImage/BackgroundImage.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BackgroundImage": () => (/* binding */ BackgroundImage),
/* harmony export */   "_BackgroundImage": () => (/* binding */ _BackgroundImage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _BackgroundImage_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./BackgroundImage.styles.js */ "./node_modules/@mantine/core/esm/BackgroundImage/BackgroundImage.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");






var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  radius: 0
};
const _BackgroundImage = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("BackgroundImage", defaultProps, props), { src, radius, variant, unstyled, className } = _a, others = __objRest(_a, ["src", "radius", "variant", "unstyled", "className"]);
  const { classes, cx } = (0,_BackgroundImage_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ radius, src }, { name: "BackgroundImage", variant, unstyled });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_3__.Box, __spreadProps(__spreadValues({}, others), {
    ref,
    className: cx(classes.root, className)
  }));
});
_BackgroundImage.displayName = "@mantine/core/BackgroundImage";
const BackgroundImage = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_4__.createPolymorphicComponent)(_BackgroundImage);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/BackgroundImage/BackgroundImage.styles.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/BackgroundImage/BackgroundImage.styles.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { radius, src }) => ({
  root: __spreadProps(__spreadValues({}, theme.fn.focusStyles()), {
    backgroundSize: "cover",
    backgroundPosition: "center",
    display: "block",
    width: "100%",
    border: 0,
    textDecoration: "none",
    color: theme.colorScheme === "dark" ? theme.colors.dark[0] : theme.black,
    backgroundImage: `url(${src})`,
    borderRadius: theme.fn.radius(radius)
  })
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Badge/Badge.js":
/*!*******************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Badge/Badge.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Badge": () => (/* binding */ Badge),
/* harmony export */   "_Badge": () => (/* binding */ _Badge)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _Badge_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Badge.styles.js */ "./node_modules/@mantine/core/esm/Badge/Badge.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  variant: "light",
  size: "md",
  radius: "xl"
};
const _Badge = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Badge", defaultProps, props), {
    className,
    color,
    variant,
    fullWidth,
    children,
    size,
    leftSection,
    rightSection,
    radius,
    gradient,
    classNames,
    styles,
    unstyled
  } = _a, others = __objRest(_a, [
    "className",
    "color",
    "variant",
    "fullWidth",
    "children",
    "size",
    "leftSection",
    "rightSection",
    "radius",
    "gradient",
    "classNames",
    "styles",
    "unstyled"
  ]);
  const { classes, cx } = (0,_Badge_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ fullWidth, color, radius, gradient }, { classNames, styles, name: "Badge", unstyled, variant, size });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_3__.Box, __spreadValues({
    className: cx(classes.root, className),
    ref
  }, others), leftSection && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: classes.leftSection
  }, leftSection), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: classes.inner
  }, children), rightSection && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: classes.rightSection
  }, rightSection));
});
_Badge.displayName = "@mantine/core/Badge";
const Badge = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_4__.createPolymorphicComponent)(_Badge);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Badge/Badge.styles.js":
/*!**************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Badge/Badge.styles.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const BADGE_VARIANTS = ["light", "filled", "outline", "dot", "gradient"];
const sizes = {
  xs: { fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(9), height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(16) },
  sm: { fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(10), height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(18) },
  md: { fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(11), height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(20) },
  lg: { fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(13), height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(26) },
  xl: { fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(16), height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(32) }
};
const dotSizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(4),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(4),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(6),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(8),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(10)
};
function getVariantStyles({ theme, variant, color, size, gradient }) {
  if (!BADGE_VARIANTS.includes(variant)) {
    return null;
  }
  if (variant === "dot") {
    const dotSize = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size, sizes: dotSizes });
    return {
      backgroundColor: "transparent",
      color: theme.colorScheme === "dark" ? theme.colors.dark[0] : theme.colors.gray[7],
      border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)} solid ${theme.colorScheme === "dark" ? theme.colors.dark[3] : theme.colors.gray[3]}`,
      paddingLeft: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size, sizes: theme.spacing })} / 1.5 - ${dotSize} / 2)`,
      "&::before": {
        content: '""',
        display: "block",
        width: dotSize,
        height: dotSize,
        borderRadius: dotSize,
        backgroundColor: theme.fn.themeColor(color, theme.colorScheme === "dark" ? 4 : theme.fn.primaryShade("light"), true),
        marginRight: dotSize
      }
    };
  }
  const colors = theme.fn.variant({ color, variant, gradient });
  return {
    background: colors.background,
    color: colors.color,
    border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(variant === "gradient" ? 0 : 1)} solid ${colors.border}`
  };
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.createStyles)((theme, { color, radius, gradient, fullWidth }, { variant, size }) => {
  const { fontSize, height } = size in sizes ? sizes[size] : sizes.md;
  return {
    leftSection: {
      marginRight: `calc(${theme.spacing.xs} / 2)`
    },
    rightSection: {
      marginLeft: `calc(${theme.spacing.xs} / 2)`
    },
    inner: {
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis"
    },
    root: __spreadValues(__spreadProps(__spreadValues(__spreadValues({}, theme.fn.focusStyles()), theme.fn.fontStyles()), {
      fontSize,
      height,
      WebkitTapHighlightColor: "transparent",
      lineHeight: `calc(${height} - ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(2)})`,
      textDecoration: "none",
      padding: `0 calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size, sizes: theme.spacing })} / 1.5)`,
      boxSizing: "border-box",
      display: fullWidth ? "flex" : "inline-flex",
      alignItems: "center",
      justifyContent: "center",
      width: fullWidth ? "100%" : "auto",
      textTransform: "uppercase",
      borderRadius: theme.fn.radius(radius),
      fontWeight: 700,
      letterSpacing: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(0.25),
      cursor: "inherit",
      textOverflow: "ellipsis",
      overflow: "hidden"
    }), getVariantStyles({ theme, variant, color, size, gradient }))
  };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Blockquote/Blockquote.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Blockquote/Blockquote.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Blockquote": () => (/* binding */ Blockquote)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _QuoteIcon_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./QuoteIcon.js */ "./node_modules/@mantine/core/esm/Blockquote/QuoteIcon.js");
/* harmony import */ var _Blockquote_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Blockquote.styles.js */ "./node_modules/@mantine/core/esm/Blockquote/Blockquote.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  color: "gray",
  icon: /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_QuoteIcon_js__WEBPACK_IMPORTED_MODULE_1__.QuoteIcon, null)
};
const Blockquote = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.useComponentDefaultProps)("Blockquote", defaultProps, props), {
    className,
    color,
    icon,
    cite,
    children,
    classNames,
    styles,
    unstyled,
    variant
  } = _a, others = __objRest(_a, [
    "className",
    "color",
    "icon",
    "cite",
    "children",
    "classNames",
    "styles",
    "unstyled",
    "variant"
  ]);
  const { classes, cx } = (0,_Blockquote_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])({ color }, { classNames, styles, unstyled, name: "Blockquote", variant });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    component: "blockquote",
    className: cx(classes.root, className),
    ref
  }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.inner
  }, icon && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.icon
  }, icon), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.body
  }, children, cite && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("cite", {
    className: classes.cite
  }, cite))));
});
Blockquote.displayName = "@mantine/core/Blockquote";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Blockquote/Blockquote.styles.js":
/*!************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Blockquote/Blockquote.styles.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { color }) => ({
  root: __spreadProps(__spreadValues({}, theme.fn.fontStyles()), {
    fontSize: theme.fontSizes.lg,
    lineHeight: theme.lineHeight,
    color: theme.colorScheme === "dark" ? theme.colors.dark[0] : theme.black,
    margin: 0,
    borderTopRightRadius: theme.radius.sm,
    borderBottomRightRadius: theme.radius.sm,
    padding: `${theme.spacing.md} ${theme.spacing.lg}`
  }),
  inner: {
    display: "flex"
  },
  body: {
    flex: 1,
    overflow: "hidden",
    textOverflow: "ellipsis"
  },
  icon: {
    color: theme.fn.variant({ variant: "filled", color }).background,
    marginRight: theme.spacing.lg,
    marginTop: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(2),
    width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(22)
  },
  cite: {
    display: "block",
    fontSize: theme.fontSizes.sm,
    marginTop: theme.spacing.xs,
    color: theme.colorScheme === "dark" ? theme.colors.dark[2] : theme.colors.gray[6],
    overflow: "hidden",
    textOverflow: "ellipsis"
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Blockquote/QuoteIcon.js":
/*!****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Blockquote/QuoteIcon.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "QuoteIcon": () => (/* binding */ QuoteIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");



var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
function QuoteIcon(props) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __spreadValues({
    width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(20),
    height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(20),
    viewBox: "0 0 409.294 409.294",
    fill: "currentColor",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    d: "M0 204.647v175.412h175.412V204.647H58.471c0-64.48 52.461-116.941 116.941-116.941V29.235C78.684 29.235 0 107.919 0 204.647zM409.294 87.706V29.235c-96.728 0-175.412 78.684-175.412 175.412v175.412h175.412V204.647H292.353c0-64.48 52.461-116.941 116.941-116.941z"
  }));
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Box/Box.js":
/*!***************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Box/Box.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Box": () => (/* binding */ Box),
/* harmony export */   "_Box": () => (/* binding */ _Box)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _style_system_props_extract_system_styles_extract_system_styles_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./style-system-props/extract-system-styles/extract-system-styles.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/extract-system-styles/extract-system-styles.js");
/* harmony import */ var _use_sx_use_sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./use-sx/use-sx.js */ "./node_modules/@mantine/core/esm/Box/use-sx/use-sx.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const _Box = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((_a, ref) => {
  var _b = _a, { className, component, style, sx } = _b, others = __objRest(_b, ["className", "component", "style", "sx"]);
  const { systemStyles, rest } = (0,_style_system_props_extract_system_styles_extract_system_styles_js__WEBPACK_IMPORTED_MODULE_1__.extractSystemStyles)(others);
  const Element = component || "div";
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Element, __spreadValues({
    ref,
    className: (0,_use_sx_use_sx_js__WEBPACK_IMPORTED_MODULE_2__.useSx)(sx, systemStyles, className),
    style
  }, rest));
});
_Box.displayName = "@mantine/core/Box";
const Box = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_3__.createPolymorphicComponent)(_Box);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Box/style-system-props/extract-system-styles/extract-system-styles.js":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Box/style-system-props/extract-system-styles/extract-system-styles.js ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "extractSystemStyles": () => (/* binding */ extractSystemStyles)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/filter-props/filter-props.js");


var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function extractSystemStyles(others) {
  const _a = others, {
    m,
    mx,
    my,
    mt,
    mb,
    ml,
    mr,
    p,
    px,
    py,
    pt,
    pb,
    pl,
    pr,
    bg,
    c,
    opacity,
    ff,
    fz,
    fw,
    lts,
    ta,
    lh,
    fs,
    tt,
    td,
    w,
    miw,
    maw,
    h,
    mih,
    mah,
    bgsz,
    bgp,
    bgr,
    bga,
    pos,
    top,
    left,
    bottom,
    right,
    inset,
    display
  } = _a, rest = __objRest(_a, [
    "m",
    "mx",
    "my",
    "mt",
    "mb",
    "ml",
    "mr",
    "p",
    "px",
    "py",
    "pt",
    "pb",
    "pl",
    "pr",
    "bg",
    "c",
    "opacity",
    "ff",
    "fz",
    "fw",
    "lts",
    "ta",
    "lh",
    "fs",
    "tt",
    "td",
    "w",
    "miw",
    "maw",
    "h",
    "mih",
    "mah",
    "bgsz",
    "bgp",
    "bgr",
    "bga",
    "pos",
    "top",
    "left",
    "bottom",
    "right",
    "inset",
    "display"
  ]);
  const systemStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.filterProps)({
    m,
    mx,
    my,
    mt,
    mb,
    ml,
    mr,
    p,
    px,
    py,
    pt,
    pb,
    pl,
    pr,
    bg,
    c,
    opacity,
    ff,
    fz,
    fw,
    lts,
    ta,
    lh,
    fs,
    tt,
    td,
    w,
    miw,
    maw,
    h,
    mih,
    mah,
    bgsz,
    bgp,
    bgr,
    bga,
    pos,
    top,
    left,
    bottom,
    right,
    inset,
    display
  });
  return { systemStyles, rest };
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Box/style-system-props/get-responsive-value/get-responsive-value.js":
/*!************************************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Box/style-system-props/get-responsive-value/get-responsive-value.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getResponsiveValue": () => (/* binding */ getResponsiveValue)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/functions/fns/breakpoints/breakpoints.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


function getSortedKeys(value, theme) {
  const sorted = Object.keys(value).filter((breakpoint) => breakpoint !== "base").sort((a, b) => (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.getBreakpointValue)((0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size: a, sizes: theme.breakpoints })) - (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.getBreakpointValue)((0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size: b, sizes: theme.breakpoints })));
  return "base" in value ? ["base", ...sorted] : sorted;
}
function getResponsiveValue({ value, theme, getValue, property }) {
  if (value == null) {
    return void 0;
  }
  if (typeof value === "object") {
    const result = getSortedKeys(value, theme).reduce((acc, breakpointKey) => {
      if (breakpointKey === "base" && value.base !== void 0) {
        const baseValue = getValue(value.base, theme);
        if (Array.isArray(property)) {
          property.forEach((prop) => {
            acc[prop] = baseValue;
          });
          return acc;
        }
        acc[property] = baseValue;
        return acc;
      }
      const breakpointValue = getValue(value[breakpointKey], theme);
      if (Array.isArray(property)) {
        acc[theme.fn.largerThan(breakpointKey)] = {};
        property.forEach((prop) => {
          acc[theme.fn.largerThan(breakpointKey)][prop] = breakpointValue;
        });
        return acc;
      }
      acc[theme.fn.largerThan(breakpointKey)] = {
        [property]: breakpointValue
      };
      return acc;
    }, {});
    return result;
  }
  const cssValue = getValue(value, theme);
  if (Array.isArray(property)) {
    return property.reduce((acc, prop) => {
      acc[prop] = cssValue;
      return acc;
    }, {});
  }
  return { [property]: cssValue };
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Box/style-system-props/get-system-styles/get-system-styles.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Box/style-system-props/get-system-styles/get-system-styles.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getSystemStyles": () => (/* binding */ getSystemStyles)
/* harmony export */ });
/* harmony import */ var _get_responsive_value_get_responsive_value_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../get-responsive-value/get-responsive-value.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/get-responsive-value/get-responsive-value.js");
/* harmony import */ var _value_getters_value_getters_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../value-getters/value-getters.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/value-getters.js");
/* harmony import */ var _system_props_system_props_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../system-props/system-props.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/system-props/system-props.js");




var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
function getSystemStyles(systemStyles, theme, systemProps = _system_props_system_props_js__WEBPACK_IMPORTED_MODULE_0__.SYSTEM_PROPS) {
  const styles = Object.keys(systemProps).reduce((acc, systemProp) => {
    if (systemProp in systemStyles && systemStyles[systemProp] !== void 0) {
      acc.push((0,_get_responsive_value_get_responsive_value_js__WEBPACK_IMPORTED_MODULE_1__.getResponsiveValue)({
        value: systemStyles[systemProp],
        getValue: _value_getters_value_getters_js__WEBPACK_IMPORTED_MODULE_2__.valueGetters[systemProps[systemProp].type],
        property: systemProps[systemProp].property,
        theme
      }));
    }
    return acc;
  }, []);
  return styles.reduce((acc, stylesPartial) => {
    Object.keys(stylesPartial).forEach((property) => {
      if (typeof stylesPartial[property] === "object" && stylesPartial[property] !== null) {
        if (!(property in acc)) {
          acc[property] = stylesPartial[property];
        } else {
          acc[property] = __spreadValues(__spreadValues({}, acc[property]), stylesPartial[property]);
        }
      } else {
        acc[property] = stylesPartial[property];
      }
    });
    return acc;
  }, {});
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Box/style-system-props/system-props/system-props.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Box/style-system-props/system-props/system-props.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SYSTEM_PROPS": () => (/* binding */ SYSTEM_PROPS)
/* harmony export */ });
const SYSTEM_PROPS = {
  m: { type: "spacing", property: "margin" },
  mt: { type: "spacing", property: "marginTop" },
  mb: { type: "spacing", property: "marginBottom" },
  ml: { type: "spacing", property: "marginLeft" },
  mr: { type: "spacing", property: "marginRight" },
  mx: { type: "spacing", property: ["marginRight", "marginLeft"] },
  my: { type: "spacing", property: ["marginTop", "marginBottom"] },
  p: { type: "spacing", property: "padding" },
  pt: { type: "spacing", property: "paddingTop" },
  pb: { type: "spacing", property: "paddingBottom" },
  pl: { type: "spacing", property: "paddingLeft" },
  pr: { type: "spacing", property: "paddingRight" },
  px: { type: "spacing", property: ["paddingRight", "paddingLeft"] },
  py: { type: "spacing", property: ["paddingTop", "paddingBottom"] },
  bg: { type: "color", property: "background" },
  c: { type: "color", property: "color" },
  opacity: { type: "identity", property: "opacity" },
  ff: { type: "identity", property: "fontFamily" },
  fz: { type: "fontSize", property: "fontSize" },
  fw: { type: "identity", property: "fontWeight" },
  lts: { type: "size", property: "letterSpacing" },
  ta: { type: "identity", property: "textAlign" },
  lh: { type: "identity", property: "lineHeight" },
  fs: { type: "identity", property: "fontStyle" },
  tt: { type: "identity", property: "textTransform" },
  td: { type: "identity", property: "textDecoration" },
  w: { type: "spacing", property: "width" },
  miw: { type: "spacing", property: "minWidth" },
  maw: { type: "spacing", property: "maxWidth" },
  h: { type: "spacing", property: "height" },
  mih: { type: "spacing", property: "minHeight" },
  mah: { type: "spacing", property: "maxHeight" },
  bgsz: { type: "size", property: "backgroundSize" },
  bgp: { type: "identity", property: "backgroundPosition" },
  bgr: { type: "identity", property: "backgroundRepeat" },
  bga: { type: "identity", property: "backgroundAttachment" },
  pos: { type: "identity", property: "position" },
  top: { type: "identity", property: "top" },
  left: { type: "size", property: "left" },
  bottom: { type: "size", property: "bottom" },
  right: { type: "size", property: "right" },
  inset: { type: "size", property: "inset" },
  display: { type: "identity", property: "display" }
};




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/get-color-value.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/get-color-value.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getColorValue": () => (/* binding */ getColorValue)
/* harmony export */ });
function getColorValue(color, theme) {
  if (color === "dimmed") {
    return theme.colorScheme === "dark" ? theme.colors.dark[2] : theme.colors.gray[6];
  }
  return theme.fn.variant({ variant: "filled", color, primaryFallback: false }).background;
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/get-default-value.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/get-default-value.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getSizeValue": () => (/* binding */ getSizeValue),
/* harmony export */   "identity": () => (/* binding */ identity)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


function getSizeValue(value) {
  return (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(value);
}
function identity(value) {
  return value;
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/get-font-size-value.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/get-font-size-value.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getFontSizeValue": () => (/* binding */ getFontSizeValue)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


function getFontSizeValue(size, theme) {
  return (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.getSize)({ size, sizes: theme.fontSizes });
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/get-spacing-value.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/get-spacing-value.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getSpacingValue": () => (/* binding */ getSpacingValue)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


const NEGATIVE_VALUES = ["-xs", "-sm", "-md", "-lg", "-xl"];
function getSpacingValue(size, theme) {
  if (NEGATIVE_VALUES.includes(size)) {
    return `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.getSize)({
      size: size.replace("-", ""),
      sizes: theme.spacing
    })} * -1)`;
  }
  return (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.getSize)({ size, sizes: theme.spacing });
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/value-getters.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/value-getters.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "valueGetters": () => (/* binding */ valueGetters)
/* harmony export */ });
/* harmony import */ var _get_color_value_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./get-color-value.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/get-color-value.js");
/* harmony import */ var _get_default_value_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./get-default-value.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/get-default-value.js");
/* harmony import */ var _get_font_size_value_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./get-font-size-value.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/get-font-size-value.js");
/* harmony import */ var _get_spacing_value_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./get-spacing-value.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/value-getters/get-spacing-value.js");





const valueGetters = {
  identity: _get_default_value_js__WEBPACK_IMPORTED_MODULE_0__.identity,
  color: _get_color_value_js__WEBPACK_IMPORTED_MODULE_1__.getColorValue,
  size: _get_default_value_js__WEBPACK_IMPORTED_MODULE_0__.getSizeValue,
  fontSize: _get_font_size_value_js__WEBPACK_IMPORTED_MODULE_2__.getFontSizeValue,
  spacing: _get_spacing_value_js__WEBPACK_IMPORTED_MODULE_3__.getSpacingValue
};




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Box/use-sx/use-sx.js":
/*!*************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Box/use-sx/use-sx.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useSx": () => (/* binding */ useSx)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/use-css.js");
/* harmony import */ var _style_system_props_get_system_styles_get_system_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../style-system-props/get-system-styles/get-system-styles.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/get-system-styles/get-system-styles.js");



function extractSx(sx, theme) {
  return typeof sx === "function" ? sx(theme) : sx;
}
function useSx(sx, systemProps, className) {
  const theme = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.useMantineTheme)();
  const { css, cx } = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useCss)();
  if (Array.isArray(sx)) {
    return cx(className, css((0,_style_system_props_get_system_styles_get_system_styles_js__WEBPACK_IMPORTED_MODULE_2__.getSystemStyles)(systemProps, theme)), sx.map((partial) => css(extractSx(partial, theme))));
  }
  return cx(className, css(extractSx(sx, theme)), css((0,_style_system_props_get_system_styles_get_system_styles_js__WEBPACK_IMPORTED_MODULE_2__.getSystemStyles)(systemProps, theme)));
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Breadcrumbs/Breadcrumbs.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Breadcrumbs/Breadcrumbs.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Breadcrumbs": () => (/* binding */ Breadcrumbs)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/is-element/is-element.js");
/* harmony import */ var _Breadcrumbs_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Breadcrumbs.styles.js */ "./node_modules/@mantine/core/esm/Breadcrumbs/Breadcrumbs.styles.js");
/* harmony import */ var _Text_Text_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Text/Text.js */ "./node_modules/@mantine/core/esm/Text/Text.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");







var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  separator: "/"
};
const Breadcrumbs = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Breadcrumbs", defaultProps, props), { className, children, separator, classNames, styles, unstyled, variant } = _a, others = __objRest(_a, ["className", "children", "separator", "classNames", "styles", "unstyled", "variant"]);
  const { classes, cx } = (0,_Breadcrumbs_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])(null, {
    classNames,
    styles,
    unstyled,
    name: "Breadcrumbs",
    variant
  });
  const items = react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).reduce((acc, child, index, array) => {
    var _a2;
    const item = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_3__.isElement)(child) ? react__WEBPACK_IMPORTED_MODULE_0___default().cloneElement(child, {
      className: cx(classes.breadcrumb, (_a2 = child.props) == null ? void 0 : _a2.className),
      key: index
    }) : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: classes.breadcrumb,
      key: index
    }, child);
    acc.push(item);
    if (index !== array.length - 1) {
      acc.push(/* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Text_Text_js__WEBPACK_IMPORTED_MODULE_4__.Text, {
        size: "sm",
        className: classes.separator,
        key: `separator-${index}`
      }, separator));
    }
    return acc;
  }, []);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_5__.Box, __spreadValues({
    className: cx(classes.root, className),
    ref
  }, others), items);
});
Breadcrumbs.displayName = "@mantine/core/Breadcrumbs";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Breadcrumbs/Breadcrumbs.styles.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Breadcrumbs/Breadcrumbs.styles.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme) => ({
  root: {
    display: "flex",
    alignItems: "center"
  },
  breadcrumb: {
    lineHeight: 1,
    whiteSpace: "nowrap",
    WebkitTapHighlightColor: "transparent"
  },
  separator: {
    marginLeft: theme.spacing.xs,
    marginRight: theme.spacing.xs,
    color: theme.colorScheme === "dark" ? theme.colors.dark[2] : theme.colors.gray[7],
    lineHeight: 1,
    display: "flex",
    alignItems: "center",
    justifyContent: "center"
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Burger/Burger.js":
/*!*********************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Burger/Burger.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Burger": () => (/* binding */ Burger)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _Burger_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Burger.styles.js */ "./node_modules/@mantine/core/esm/Burger/Burger.styles.js");
/* harmony import */ var _UnstyledButton_UnstyledButton_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../UnstyledButton/UnstyledButton.js */ "./node_modules/@mantine/core/esm/UnstyledButton/UnstyledButton.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  size: "md",
  transitionDuration: 300
};
const Burger = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Burger", defaultProps, props), {
    className,
    opened,
    color,
    size,
    classNames,
    styles,
    transitionDuration,
    variant
  } = _a, others = __objRest(_a, [
    "className",
    "opened",
    "color",
    "size",
    "classNames",
    "styles",
    "transitionDuration",
    "variant"
  ]);
  const { classes, cx } = (0,_Burger_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ color, transitionDuration }, { classNames, styles, name: "Burger", variant, size });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_UnstyledButton_UnstyledButton_js__WEBPACK_IMPORTED_MODULE_3__.UnstyledButton, __spreadValues({
    className: cx(classes.root, className),
    ref
  }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    "data-opened": opened || void 0,
    className: classes.burger
  }));
});
Burger.displayName = "@mantine/core/Burger";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Burger/Burger.styles.js":
/*!****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Burger/Burger.styles.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


const sizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(12),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(18),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(24),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(34),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(42)
};
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.createStyles)((theme, { color, transitionDuration }, { size }) => {
  const sizeValue = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes });
  const _color = color || (theme.colorScheme === "dark" ? theme.white : theme.black);
  return {
    root: {
      borderRadius: theme.radius.sm,
      width: `calc(${sizeValue} + ${theme.spacing.xs})`,
      height: `calc(${sizeValue} + ${theme.spacing.xs})`,
      padding: `calc(${theme.spacing.xs} / 2)`,
      cursor: "pointer"
    },
    burger: {
      position: "relative",
      userSelect: "none",
      boxSizing: "border-box",
      "&, &::before, &::after": {
        display: "block",
        width: sizeValue,
        height: `calc(${sizeValue} / 12)`,
        backgroundColor: _color,
        outline: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)} solid transparent`,
        transitionProperty: "background-color, transform",
        transitionDuration: `${transitionDuration}ms`,
        "@media (prefers-reduced-motion)": {
          transitionDuration: theme.respectReducedMotion ? "0ms" : void 0
        }
      },
      "&::before, &::after": {
        position: "absolute",
        content: '""',
        left: 0
      },
      "&::before": {
        top: `calc((${sizeValue} / 3) * -1)`
      },
      "&::after": {
        top: `calc(${sizeValue} / 3)`
      },
      "&[data-opened]": {
        backgroundColor: "transparent",
        "&::before": {
          transform: `translateY(calc(${sizeValue} / 3)) rotate(45deg)`
        },
        "&::after": {
          transform: `translateY(calc(-${sizeValue} / 3)) rotate(-45deg)`
        }
      }
    }
  };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Button/Button.js":
/*!*********************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Button/Button.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Button": () => (/* binding */ Button),
/* harmony export */   "_Button": () => (/* binding */ _Button)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _ButtonGroup_ButtonGroup_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ButtonGroup/ButtonGroup.js */ "./node_modules/@mantine/core/esm/Button/ButtonGroup/ButtonGroup.js");
/* harmony import */ var _Button_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Button.styles.js */ "./node_modules/@mantine/core/esm/Button/Button.styles.js");
/* harmony import */ var _Loader_Loader_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Loader/Loader.js */ "./node_modules/@mantine/core/esm/Loader/Loader.js");
/* harmony import */ var _UnstyledButton_UnstyledButton_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../UnstyledButton/UnstyledButton.js */ "./node_modules/@mantine/core/esm/UnstyledButton/UnstyledButton.js");








var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  size: "sm",
  type: "button",
  variant: "filled",
  loaderPosition: "left"
};
const _Button = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Button", defaultProps, props), {
    className,
    size,
    color,
    type,
    disabled,
    children,
    leftIcon,
    rightIcon,
    fullWidth,
    variant,
    radius,
    uppercase,
    compact,
    loading,
    loaderPosition,
    loaderProps,
    gradient,
    classNames,
    styles,
    unstyled
  } = _a, others = __objRest(_a, [
    "className",
    "size",
    "color",
    "type",
    "disabled",
    "children",
    "leftIcon",
    "rightIcon",
    "fullWidth",
    "variant",
    "radius",
    "uppercase",
    "compact",
    "loading",
    "loaderPosition",
    "loaderProps",
    "gradient",
    "classNames",
    "styles",
    "unstyled"
  ]);
  const { classes, cx, theme } = (0,_Button_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({
    radius,
    color,
    fullWidth,
    compact,
    gradient,
    withLeftIcon: !!leftIcon,
    withRightIcon: !!rightIcon
  }, { name: "Button", unstyled, classNames, styles, variant, size });
  const colors = theme.fn.variant({ color, variant });
  const loader = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Loader_Loader_js__WEBPACK_IMPORTED_MODULE_3__.Loader, __spreadValues({
    color: colors.color,
    size: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.getSize)({ size, sizes: _Button_styles_js__WEBPACK_IMPORTED_MODULE_2__.sizes }).height} / 2)`
  }, loaderProps));
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_UnstyledButton_UnstyledButton_js__WEBPACK_IMPORTED_MODULE_5__.UnstyledButton, __spreadValues({
    className: cx(classes.root, className),
    type,
    disabled,
    "data-button": true,
    "data-disabled": disabled || void 0,
    "data-loading": loading || void 0,
    ref,
    unstyled
  }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.inner
  }, (leftIcon || loading && loaderPosition === "left") && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: cx(classes.icon, classes.leftIcon)
  }, loading && loaderPosition === "left" ? loader : leftIcon), loading && loaderPosition === "center" && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: classes.centerLoader
  }, loader), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: classes.label,
    style: { textTransform: uppercase ? "uppercase" : void 0 }
  }, children), (rightIcon || loading && loaderPosition === "right") && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: cx(classes.icon, classes.rightIcon)
  }, loading && loaderPosition === "right" ? loader : rightIcon)));
});
_Button.displayName = "@mantine/core/Button";
_Button.Group = _ButtonGroup_ButtonGroup_js__WEBPACK_IMPORTED_MODULE_6__.ButtonGroup;
const Button = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_7__.createPolymorphicComponent)(_Button);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Button/Button.styles.js":
/*!****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Button/Button.styles.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BUTTON_VARIANTS": () => (/* binding */ BUTTON_VARIANTS),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "sizes": () => (/* binding */ sizes)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _Input_Input_styles_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Input/Input.styles.js */ "./node_modules/@mantine/core/esm/Input/Input.styles.js");



var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const BUTTON_VARIANTS = [
  "filled",
  "outline",
  "light",
  "white",
  "default",
  "subtle",
  "gradient"
];
const sizes = {
  xs: { height: _Input_Input_styles_js__WEBPACK_IMPORTED_MODULE_0__.sizes.xs, paddingLeft: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(14), paddingRight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(14) },
  sm: { height: _Input_Input_styles_js__WEBPACK_IMPORTED_MODULE_0__.sizes.sm, paddingLeft: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(18), paddingRight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(18) },
  md: { height: _Input_Input_styles_js__WEBPACK_IMPORTED_MODULE_0__.sizes.md, paddingLeft: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(22), paddingRight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(22) },
  lg: { height: _Input_Input_styles_js__WEBPACK_IMPORTED_MODULE_0__.sizes.lg, paddingLeft: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(26), paddingRight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(26) },
  xl: { height: _Input_Input_styles_js__WEBPACK_IMPORTED_MODULE_0__.sizes.xl, paddingLeft: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(32), paddingRight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(32) },
  "compact-xs": { height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(22), paddingLeft: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(7), paddingRight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(7) },
  "compact-sm": { height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(26), paddingLeft: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(8), paddingRight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(8) },
  "compact-md": { height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(30), paddingLeft: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(10), paddingRight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(10) },
  "compact-lg": { height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(34), paddingLeft: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(12), paddingRight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(12) },
  "compact-xl": { height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(40), paddingLeft: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(14), paddingRight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(14) }
};
function getSizeStyles({ compact, size, withLeftIcon, withRightIcon }) {
  if (compact) {
    return sizes[`compact-${size}`];
  }
  const _sizes = sizes[size];
  if (!_sizes) {
    return {};
  }
  return __spreadProps(__spreadValues({}, _sizes), {
    paddingLeft: withLeftIcon ? `calc(${_sizes.paddingLeft}  / 1.5)` : _sizes.paddingLeft,
    paddingRight: withRightIcon ? `calc(${_sizes.paddingRight}  / 1.5)` : _sizes.paddingRight
  });
}
const getWidthStyles = (fullWidth) => ({
  display: fullWidth ? "block" : "inline-block",
  width: fullWidth ? "100%" : "auto"
});
function getVariantStyles({ variant, theme, color, gradient }) {
  if (!BUTTON_VARIANTS.includes(variant)) {
    return null;
  }
  const colors = theme.fn.variant({ color, variant, gradient });
  if (variant === "gradient") {
    return __spreadValues({
      border: 0,
      backgroundImage: colors.background,
      color: colors.color
    }, theme.fn.hover({ backgroundSize: "200%" }));
  }
  return __spreadValues({
    border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(1)} solid ${colors.border}`,
    backgroundColor: colors.background,
    color: colors.color
  }, theme.fn.hover({ backgroundColor: colors.hover }));
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.createStyles)((theme, {
  radius,
  fullWidth,
  compact,
  withLeftIcon,
  withRightIcon,
  color,
  gradient
}, { variant, size }) => ({
  root: __spreadProps(__spreadValues(__spreadProps(__spreadValues(__spreadValues(__spreadValues(__spreadValues({}, getSizeStyles({ compact, size, withLeftIcon, withRightIcon })), theme.fn.fontStyles()), theme.fn.focusStyles()), getWidthStyles(fullWidth)), {
    borderRadius: theme.fn.radius(radius),
    fontWeight: 600,
    position: "relative",
    lineHeight: 1,
    fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes: theme.fontSizes }),
    userSelect: "none",
    cursor: "pointer"
  }), getVariantStyles({ variant, theme, color, gradient })), {
    "&:active": theme.activeStyles,
    "&:disabled, &[data-disabled]": {
      borderColor: "transparent",
      backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[4] : theme.colors.gray[2],
      color: theme.colorScheme === "dark" ? theme.colors.dark[6] : theme.colors.gray[5],
      cursor: "not-allowed",
      backgroundImage: "none",
      pointerEvents: "none",
      "&:active": {
        transform: "none"
      }
    },
    "&[data-loading]": {
      pointerEvents: "none",
      "&::before": __spreadProps(__spreadValues({
        content: '""'
      }, theme.fn.cover((0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(-1))), {
        backgroundColor: theme.colorScheme === "dark" ? theme.fn.rgba(theme.colors.dark[7], 0.5) : "rgba(255, 255, 255, .5)",
        borderRadius: theme.fn.radius(radius),
        cursor: "not-allowed"
      })
    }
  }),
  icon: {
    display: "flex",
    alignItems: "center"
  },
  leftIcon: {
    marginRight: theme.spacing.xs
  },
  rightIcon: {
    marginLeft: theme.spacing.xs
  },
  centerLoader: {
    position: "absolute",
    left: "50%",
    transform: "translateX(-50%)",
    opacity: 0.5
  },
  inner: {
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    height: "100%",
    overflow: "visible"
  },
  label: {
    whiteSpace: "nowrap",
    height: "100%",
    overflow: "hidden",
    display: "flex",
    alignItems: "center"
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);



/***/ }),

/***/ "./node_modules/@mantine/core/esm/Button/ButtonGroup/ButtonGroup.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Button/ButtonGroup/ButtonGroup.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ButtonGroup": () => (/* binding */ ButtonGroup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _ButtonGroup_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ButtonGroup.styles.js */ "./node_modules/@mantine/core/esm/Button/ButtonGroup/ButtonGroup.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  orientation: "horizontal",
  buttonBorderWidth: 1
};
const ButtonGroup = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("ButtonGroup", defaultProps, props), { className, orientation, buttonBorderWidth, unstyled } = _a, others = __objRest(_a, ["className", "orientation", "buttonBorderWidth", "unstyled"]);
  const { classes, cx } = (0,_ButtonGroup_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ orientation, buttonBorderWidth }, { name: "ButtonGroup", unstyled });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_3__.Box, __spreadValues({
    className: cx(classes.root, className),
    ref
  }, others));
});
ButtonGroup.displayName = "@mantine/core/ButtonGroup";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Button/ButtonGroup/ButtonGroup.styles.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Button/ButtonGroup/ButtonGroup.styles.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((_theme, { orientation, buttonBorderWidth }) => ({
  root: {
    display: "flex",
    flexDirection: orientation === "vertical" ? "column" : "row",
    "& [data-button]": {
      "&:first-of-type:not(:last-of-type)": {
        borderBottomRightRadius: 0,
        [orientation === "vertical" ? "borderBottomLeftRadius" : "borderTopRightRadius"]: 0,
        [orientation === "vertical" ? "borderBottomWidth" : "borderRightWidth"]: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(buttonBorderWidth)} / 2)`
      },
      "&:last-of-type:not(:first-of-type)": {
        borderTopLeftRadius: 0,
        [orientation === "vertical" ? "borderTopRightRadius" : "borderBottomLeftRadius"]: 0,
        [orientation === "vertical" ? "borderTopWidth" : "borderLeftWidth"]: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(buttonBorderWidth)} / 2)`
      },
      "&:not(:first-of-type):not(:last-of-type)": {
        borderRadius: 0,
        [orientation === "vertical" ? "borderTopWidth" : "borderLeftWidth"]: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(buttonBorderWidth)} / 2)`,
        [orientation === "vertical" ? "borderBottomWidth" : "borderRightWidth"]: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(buttonBorderWidth)} / 2)`
      },
      "& + [data-button]": {
        [orientation === "vertical" ? "marginTop" : "marginLeft"]: `calc(${buttonBorderWidth} * -1)`,
        "@media (min-resolution: 192dpi)": {
          [orientation === "vertical" ? "marginTop" : "marginLeft"]: 0
        }
      }
    }
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Card/Card.context.js":
/*!*************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Card/Card.context.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CardProvider": () => (/* binding */ CardProvider),
/* harmony export */   "useCardPadding": () => (/* binding */ useCardPadding)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const CardContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({ padding: 0 });
const CardProvider = CardContext.Provider;
const useCardPadding = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(CardContext).padding;




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Card/Card.js":
/*!*****************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Card/Card.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Card": () => (/* binding */ Card),
/* harmony export */   "_Card": () => (/* binding */ _Card)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _Paper_Paper_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Paper/Paper.js */ "./node_modules/@mantine/core/esm/Paper/Paper.js");
/* harmony import */ var _CardSection_CardSection_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CardSection/CardSection.js */ "./node_modules/@mantine/core/esm/Card/CardSection/CardSection.js");
/* harmony import */ var _Card_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Card.styles.js */ "./node_modules/@mantine/core/esm/Card/Card.styles.js");
/* harmony import */ var _Card_context_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Card.context.js */ "./node_modules/@mantine/core/esm/Card/Card.context.js");








var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  padding: "md"
};
const _Card = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Card", defaultProps, props), { className, padding, radius, children, unstyled, variant } = _a, others = __objRest(_a, ["className", "padding", "radius", "children", "unstyled", "variant"]);
  const { classes, cx } = (0,_Card_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])(null, { name: "Card", unstyled, variant });
  const _children = react__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(children);
  const content = _children.map((child, index) => {
    if (typeof child === "object" && child && "type" in child && child.type === _CardSection_CardSection_js__WEBPACK_IMPORTED_MODULE_3__.CardSection) {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(child, {
        variant,
        padding,
        "data-first": index === 0 || void 0,
        "data-last": index === _children.length - 1 || void 0
      });
    }
    return child;
  });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Card_context_js__WEBPACK_IMPORTED_MODULE_4__.CardProvider, {
    value: { padding }
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Paper_Paper_js__WEBPACK_IMPORTED_MODULE_5__.Paper, __spreadValues({
    className: cx(classes.root, className),
    radius,
    p: padding,
    ref
  }, others), content));
});
_Card.Section = _CardSection_CardSection_js__WEBPACK_IMPORTED_MODULE_3__.CardSection;
_Card.displayName = "@mantine/core/Card";
const Card = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_6__.createPolymorphicComponent)(_Card);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Card/Card.styles.js":
/*!************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Card/Card.styles.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme) => ({
  root: {
    position: "relative",
    overflow: "hidden",
    backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[6] : theme.white
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Card/CardSection/CardSection.js":
/*!************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Card/CardSection/CardSection.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CardSection": () => (/* binding */ CardSection),
/* harmony export */   "_CardSection": () => (/* binding */ _CardSection)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _Card_context_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Card.context.js */ "./node_modules/@mantine/core/esm/Card/Card.context.js");
/* harmony import */ var _CardSection_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CardSection.styles.js */ "./node_modules/@mantine/core/esm/Card/CardSection/CardSection.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");







var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  withBorder: false,
  inheritPadding: false
};
const _CardSection = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("CardSection", defaultProps, props), { className, withBorder, inheritPadding, unstyled, variant } = _a, others = __objRest(_a, ["className", "withBorder", "inheritPadding", "unstyled", "variant"]);
  const { classes, cx } = (0,_CardSection_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ padding: (0,_Card_context_js__WEBPACK_IMPORTED_MODULE_3__.useCardPadding)(), withBorder, inheritPadding }, { name: "Card", unstyled, variant });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    className: cx(classes.cardSection, className),
    ref
  }, others));
});
_CardSection.displayName = "@mantine/core/CardSection";
const CardSection = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_5__.createPolymorphicComponent)(_CardSection);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Card/CardSection/CardSection.styles.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Card/CardSection/CardSection.styles.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { padding, withBorder, inheritPadding }) => {
  const spacing = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size: padding, sizes: theme.spacing });
  const offset = `calc(-1 * ${spacing})`;
  const borderColor = theme.colorScheme === "dark" ? theme.colors.dark[4] : theme.colors.gray[3];
  return {
    cardSection: {
      display: "block",
      marginLeft: offset,
      marginRight: offset,
      paddingLeft: inheritPadding ? spacing : void 0,
      paddingRight: inheritPadding ? spacing : void 0,
      borderTop: withBorder ? `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(1)} solid ${borderColor}` : void 0,
      borderBottom: withBorder ? `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(1)} solid ${borderColor}` : void 0,
      "& + &": {
        borderTop: 0
      },
      "&[data-first]": {
        marginTop: offset,
        borderTop: 0,
        borderBottom: withBorder ? `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(1)} solid ${borderColor}` : void 0
      },
      "&[data-last]": {
        marginBottom: offset,
        borderBottom: 0
      }
    }
  };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Center/Center.js":
/*!*********************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Center/Center.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Center": () => (/* binding */ Center),
/* harmony export */   "_Center": () => (/* binding */ _Center)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _Center_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Center.styles.js */ "./node_modules/@mantine/core/esm/Center/Center.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const _Center = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Center", {}, props), { inline, className, unstyled, variant } = _a, others = __objRest(_a, ["inline", "className", "unstyled", "variant"]);
  const { classes, cx } = (0,_Center_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ inline }, { name: "Center", unstyled, variant });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_3__.Box, __spreadValues({
    ref,
    className: cx(classes.root, className)
  }, others));
});
_Center.displayName = "@mantine/core/Center";
const Center = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_4__.createPolymorphicComponent)(_Center);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Center/Center.styles.js":
/*!****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Center/Center.styles.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { inline }) => ({
  root: {
    display: inline ? "inline-flex" : "flex",
    alignItems: "center",
    justifyContent: "center"
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Checkbox/Checkbox.js":
/*!*************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Checkbox/Checkbox.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Checkbox": () => (/* binding */ Checkbox)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-id/use-id.js");
/* harmony import */ var _CheckboxGroup_context_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CheckboxGroup.context.js */ "./node_modules/@mantine/core/esm/Checkbox/CheckboxGroup.context.js");
/* harmony import */ var _CheckboxGroup_CheckboxGroup_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./CheckboxGroup/CheckboxGroup.js */ "./node_modules/@mantine/core/esm/Checkbox/CheckboxGroup/CheckboxGroup.js");
/* harmony import */ var _CheckboxIcon_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CheckboxIcon.js */ "./node_modules/@mantine/core/esm/Checkbox/CheckboxIcon.js");
/* harmony import */ var _Checkbox_styles_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Checkbox.styles.js */ "./node_modules/@mantine/core/esm/Checkbox/Checkbox.styles.js");
/* harmony import */ var _Box_style_system_props_extract_system_styles_extract_system_styles_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box/style-system-props/extract-system-styles/extract-system-styles.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/extract-system-styles/extract-system-styles.js");
/* harmony import */ var _InlineInput_InlineInput_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../InlineInput/InlineInput.js */ "./node_modules/@mantine/core/esm/InlineInput/InlineInput.js");










var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  size: "sm",
  transitionDuration: 100,
  icon: _CheckboxIcon_js__WEBPACK_IMPORTED_MODULE_1__.CheckboxIcon,
  labelPosition: "right"
};
const Checkbox = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.useComponentDefaultProps)("Checkbox", defaultProps, props), {
    className,
    style,
    sx,
    checked,
    disabled,
    color,
    label,
    indeterminate,
    id,
    size,
    radius,
    wrapperProps,
    children,
    classNames,
    styles,
    transitionDuration,
    icon: Icon,
    unstyled,
    labelPosition,
    description,
    error,
    variant
  } = _a, others = __objRest(_a, [
    "className",
    "style",
    "sx",
    "checked",
    "disabled",
    "color",
    "label",
    "indeterminate",
    "id",
    "size",
    "radius",
    "wrapperProps",
    "children",
    "classNames",
    "styles",
    "transitionDuration",
    "icon",
    "unstyled",
    "labelPosition",
    "description",
    "error",
    "variant"
  ]);
  const ctx = (0,_CheckboxGroup_context_js__WEBPACK_IMPORTED_MODULE_3__.useCheckboxGroupContext)();
  const uuid = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_4__.useId)(id);
  const { systemStyles, rest } = (0,_Box_style_system_props_extract_system_styles_extract_system_styles_js__WEBPACK_IMPORTED_MODULE_5__.extractSystemStyles)(others);
  const { classes } = (0,_Checkbox_styles_js__WEBPACK_IMPORTED_MODULE_6__["default"])({
    radius,
    color,
    transitionDuration,
    labelPosition,
    error: !!error,
    indeterminate
  }, { name: "Checkbox", classNames, styles, unstyled, variant, size: (ctx == null ? void 0 : ctx.size) || size });
  const contextProps = ctx ? {
    checked: ctx.value.includes(rest.value),
    onChange: ctx.onChange
  } : {};
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_InlineInput_InlineInput_js__WEBPACK_IMPORTED_MODULE_7__.InlineInput, __spreadValues(__spreadValues({
    className,
    sx,
    style,
    id: uuid,
    size: (ctx == null ? void 0 : ctx.size) || size,
    labelPosition,
    label,
    description,
    error,
    disabled,
    __staticSelector: "Checkbox",
    classNames,
    styles,
    unstyled,
    "data-checked": contextProps.checked || void 0,
    variant
  }, systemStyles), wrapperProps), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.inner
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", __spreadValues(__spreadValues({
    id: uuid,
    ref,
    type: "checkbox",
    className: classes.input,
    checked,
    disabled
  }, rest), contextProps)), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Icon, {
    indeterminate,
    className: classes.icon
  })));
});
Checkbox.displayName = "@mantine/core/Checkbox";
Checkbox.Group = _CheckboxGroup_CheckboxGroup_js__WEBPACK_IMPORTED_MODULE_8__.CheckboxGroup;




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Checkbox/Checkbox.styles.js":
/*!********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Checkbox/Checkbox.styles.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/get-styles-ref.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const sizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(16),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(20),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(24),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(30),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(36)
};
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.createStyles)((theme, {
  radius,
  color,
  transitionDuration,
  labelPosition,
  error,
  indeterminate
}, { size }) => {
  const _size = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes });
  const colors = theme.fn.variant({ variant: "filled", color });
  return {
    icon: __spreadProps(__spreadValues({}, theme.fn.cover()), {
      ref: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getStylesRef)("icon"),
      color: indeterminate ? "inherit" : theme.white,
      transform: indeterminate ? "none" : `translateY(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(5)}) scale(0.5)`,
      opacity: indeterminate ? 1 : 0,
      transitionProperty: "opacity, transform",
      transitionTimingFunction: "ease",
      transitionDuration: `${transitionDuration}ms`,
      pointerEvents: "none",
      width: "60%",
      position: "absolute",
      zIndex: 1,
      margin: "auto",
      "@media (prefers-reduced-motion)": {
        transitionDuration: theme.respectReducedMotion ? "0ms" : void 0
      }
    }),
    inner: {
      position: "relative",
      width: _size,
      height: _size,
      order: labelPosition === "left" ? 2 : 1
    },
    input: __spreadProps(__spreadValues({}, theme.fn.focusStyles()), {
      appearance: "none",
      backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[6] : theme.white,
      border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)} solid ${error ? theme.fn.variant({ variant: "filled", color: "red" }).background : theme.colorScheme === "dark" ? theme.colors.dark[4] : theme.colors.gray[4]}`,
      width: _size,
      height: _size,
      borderRadius: theme.fn.radius(radius),
      padding: 0,
      display: "block",
      margin: 0,
      transition: `border-color ${transitionDuration}ms ease, background-color ${transitionDuration}ms ease`,
      cursor: theme.cursorType,
      "&:checked": {
        backgroundColor: colors.background,
        borderColor: colors.background,
        [`& + .${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getStylesRef)("icon")}`]: {
          opacity: 1,
          color: theme.white,
          transform: "translateY(0) scale(1)"
        }
      },
      "&:disabled": {
        backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[4] : theme.colors.gray[2],
        borderColor: theme.colorScheme === "dark" ? theme.colors.dark[6] : theme.colors.gray[3],
        cursor: "not-allowed",
        [`& + .${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getStylesRef)("icon")}`]: {
          color: theme.colorScheme === "dark" ? theme.colors.dark[6] : theme.colors.gray[5]
        }
      }
    })
  };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Checkbox/CheckboxGroup.context.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Checkbox/CheckboxGroup.context.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CheckboxGroupProvider": () => (/* binding */ CheckboxGroupProvider),
/* harmony export */   "useCheckboxGroupContext": () => (/* binding */ useCheckboxGroupContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const CheckboxGroupContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
const CheckboxGroupProvider = CheckboxGroupContext.Provider;
const useCheckboxGroupContext = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(CheckboxGroupContext);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Checkbox/CheckboxGroup/CheckboxGroup.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Checkbox/CheckboxGroup/CheckboxGroup.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CheckboxGroup": () => (/* binding */ CheckboxGroup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-uncontrolled/use-uncontrolled.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _CheckboxGroup_context_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../CheckboxGroup.context.js */ "./node_modules/@mantine/core/esm/Checkbox/CheckboxGroup.context.js");
/* harmony import */ var _Input_Input_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Input/Input.js */ "./node_modules/@mantine/core/esm/Input/Input.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  size: "sm"
};
const CheckboxGroup = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("CheckboxGroup", defaultProps, props), { children, value, defaultValue, onChange, size, wrapperProps } = _a, others = __objRest(_a, ["children", "value", "defaultValue", "onChange", "size", "wrapperProps"]);
  const [_value, setValue] = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.useUncontrolled)({
    value,
    defaultValue,
    finalValue: [],
    onChange
  });
  const handleChange = (event) => {
    const itemValue = event.currentTarget.value;
    setValue(_value.includes(itemValue) ? _value.filter((item) => item !== itemValue) : [..._value, itemValue]);
  };
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CheckboxGroup_context_js__WEBPACK_IMPORTED_MODULE_3__.CheckboxGroupProvider, {
    value: { value: _value, onChange: handleChange, size }
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Input_Input_js__WEBPACK_IMPORTED_MODULE_4__.Input.Wrapper, __spreadValues(__spreadValues({
    labelElement: "div",
    size,
    __staticSelector: "CheckboxGroup",
    ref
  }, wrapperProps), others), children));
});
CheckboxGroup.displayName = "@mantine/core/CheckboxGroup";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Checkbox/CheckboxIcon.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Checkbox/CheckboxIcon.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CheckIcon": () => (/* binding */ CheckIcon),
/* harmony export */   "CheckboxIcon": () => (/* binding */ CheckboxIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function CheckIcon(props) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __spreadValues({
    viewBox: "0 0 10 7",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    d: "M4 4.586L1.707 2.293A1 1 0 1 0 .293 3.707l3 3a.997.997 0 0 0 1.414 0l5-5A1 1 0 1 0 8.293.293L4 4.586z",
    fill: "currentColor",
    fillRule: "evenodd",
    clipRule: "evenodd"
  }));
}
function CheckboxIcon(_a) {
  var _b = _a, { indeterminate } = _b, others = __objRest(_b, ["indeterminate"]);
  if (indeterminate) {
    return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __spreadValues({
      xmlns: "http://www.w3.org/2000/svg",
      fill: "none",
      viewBox: "0 0 32 6"
    }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
      width: "32",
      height: "6",
      fill: "currentColor",
      rx: "3"
    }));
  }
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(CheckIcon, __spreadValues({}, others));
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Chip/Chip.js":
/*!*****************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Chip/Chip.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Chip": () => (/* binding */ Chip)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-id/use-id.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-uncontrolled/use-uncontrolled.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _ChipGroup_ChipGroup_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ChipGroup/ChipGroup.js */ "./node_modules/@mantine/core/esm/Chip/ChipGroup/ChipGroup.js");
/* harmony import */ var _ChipGroup_context_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ChipGroup.context.js */ "./node_modules/@mantine/core/esm/Chip/ChipGroup.context.js");
/* harmony import */ var _Chip_styles_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Chip.styles.js */ "./node_modules/@mantine/core/esm/Chip/Chip.styles.js");
/* harmony import */ var _Box_style_system_props_extract_system_styles_extract_system_styles_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box/style-system-props/extract-system-styles/extract-system-styles.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/extract-system-styles/extract-system-styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");
/* harmony import */ var _Checkbox_CheckboxIcon_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Checkbox/CheckboxIcon.js */ "./node_modules/@mantine/core/esm/Checkbox/CheckboxIcon.js");










var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  type: "checkbox",
  size: "sm",
  radius: "xl",
  variant: "outline"
};
const Chip = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Chip", defaultProps, props), {
    radius,
    type,
    size,
    variant,
    disabled,
    id,
    color,
    children,
    className,
    classNames,
    style,
    styles,
    checked,
    defaultChecked,
    onChange,
    sx,
    wrapperProps,
    value,
    unstyled
  } = _a, others = __objRest(_a, [
    "radius",
    "type",
    "size",
    "variant",
    "disabled",
    "id",
    "color",
    "children",
    "className",
    "classNames",
    "style",
    "styles",
    "checked",
    "defaultChecked",
    "onChange",
    "sx",
    "wrapperProps",
    "value",
    "unstyled"
  ]);
  const ctx = (0,_ChipGroup_context_js__WEBPACK_IMPORTED_MODULE_2__.useChipGroup)();
  const uuid = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_3__.useId)(id);
  const { systemStyles, rest } = (0,_Box_style_system_props_extract_system_styles_extract_system_styles_js__WEBPACK_IMPORTED_MODULE_4__.extractSystemStyles)(others);
  const { classes, cx } = (0,_Chip_styles_js__WEBPACK_IMPORTED_MODULE_5__["default"])({ radius, color }, { classNames, styles, unstyled, name: "Chip", variant, size });
  const [_value, setValue] = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_6__.useUncontrolled)({
    value: checked,
    defaultValue: defaultChecked,
    finalValue: false,
    onChange
  });
  const contextProps = ctx ? {
    checked: ctx.isChipSelected(value),
    onChange: ctx.onChange,
    type: ctx.multiple ? "checkbox" : "radio"
  } : {};
  const _checked = contextProps.checked || _value;
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_7__.Box, __spreadValues(__spreadValues({
    className: cx(classes.root, className),
    style,
    sx
  }, systemStyles), wrapperProps), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", __spreadValues(__spreadValues({
    type,
    className: classes.input,
    checked: _checked,
    onChange: (event) => setValue(event.currentTarget.checked),
    id: uuid,
    disabled,
    ref,
    value
  }, contextProps), rest)), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", {
    htmlFor: uuid,
    "data-checked": _checked || void 0,
    "data-disabled": disabled || void 0,
    className: classes.label
  }, _checked && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: classes.iconWrapper
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Checkbox_CheckboxIcon_js__WEBPACK_IMPORTED_MODULE_8__.CheckIcon, {
    className: classes.checkIcon
  })), children));
});
Chip.displayName = "@mantine/core/Chip";
Chip.Group = _ChipGroup_ChipGroup_js__WEBPACK_IMPORTED_MODULE_9__.ChipGroup;




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Chip/Chip.styles.js":
/*!************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Chip/Chip.styles.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "sizes": () => (/* binding */ sizes)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/get-styles-ref.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const sizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(24),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(28),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(32),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(36),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(40)
};
const iconSizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(10),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(12),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(14),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(16),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(18)
};
const padding = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(16),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(20),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(24),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(28),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(32)
};
const checkedPadding = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(7.5),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(10),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(11.5),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(13),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(15)
};
function getVariantStyles(theme, { color }, variant) {
  const filledColors = theme.fn.variant({ variant: "filled", color });
  const lightColors = theme.fn.variant({ variant: "light", color });
  if (variant === "light") {
    return {
      label: __spreadValues({
        backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[6] : theme.colors.gray[1]
      }, theme.fn.hover({
        backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[5] : theme.colors.gray[0]
      })),
      checked: __spreadProps(__spreadValues({
        color: lightColors.color,
        backgroundColor: lightColors.background
      }, theme.fn.hover({ backgroundColor: lightColors.hover })), {
        "&, &:hover": {
          backgroundColor: theme.fn.variant({ variant: "light", color }).background
        }
      })
    };
  }
  if (variant === "filled") {
    return {
      label: __spreadValues({
        backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[6] : theme.colors.gray[1]
      }, theme.fn.hover({
        backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[5] : theme.colors.gray[0]
      })),
      checked: __spreadValues({
        color: filledColors.color,
        backgroundColor: filledColors.background
      }, theme.fn.hover({ backgroundColor: filledColors.hover }))
    };
  }
  if (variant === "outline") {
    return {
      label: __spreadValues({
        backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[6] : theme.white,
        borderColor: theme.colorScheme === "dark" ? theme.colors.dark[4] : theme.colors.gray[4]
      }, theme.fn.hover({
        backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[5] : theme.colors.gray[0]
      })),
      checked: {
        border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)} solid ${filledColors.background}`
      }
    };
  }
  return { label: null, checked: null };
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.createStyles)((theme, { radius, color }, { size, variant }) => {
  const variantStyles = getVariantStyles(theme, { color }, variant);
  return {
    root: {},
    label: __spreadProps(__spreadValues(__spreadProps(__spreadValues({
      ref: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getStylesRef)("label")
    }, theme.fn.fontStyles()), {
      boxSizing: "border-box",
      color: theme.colorScheme === "dark" ? theme.colors.dark[0] : theme.black,
      display: "inline-block",
      alignItems: "center",
      userSelect: "none",
      border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)} solid transparent`,
      borderRadius: theme.fn.radius(radius),
      height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes }),
      fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes: theme.fontSizes }),
      lineHeight: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes })} - ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(2)})`,
      paddingLeft: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes: padding }),
      paddingRight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes: padding }),
      cursor: "pointer",
      whiteSpace: "nowrap",
      transition: "background-color 100ms ease",
      WebkitTapHighlightColor: "transparent"
    }), variantStyles.label), {
      "&[data-disabled]": __spreadProps(__spreadValues({
        backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[5] : theme.colors.gray[1],
        borderColor: theme.colorScheme === "dark" ? theme.colors.dark[5] : theme.colors.gray[1],
        color: theme.colorScheme === "dark" ? theme.colors.dark[3] : theme.colors.gray[5],
        cursor: "not-allowed"
      }, theme.fn.hover({
        backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[5] : theme.colors.gray[1]
      })), {
        [`& .${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getStylesRef)("iconWrapper")}`]: {
          color: theme.colorScheme === "dark" ? theme.colors.dark[3] : theme.colors.gray[5]
        }
      }),
      "&[data-checked]": {
        paddingLeft: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes: checkedPadding }),
        paddingRight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes: checkedPadding }),
        "&:not([data-disabled])": variantStyles.checked
      }
    }),
    iconWrapper: {
      ref: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getStylesRef)("iconWrapper"),
      color: variant === "filled" ? theme.white : theme.fn.variant({ variant: "filled", color }).background,
      width: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes: iconSizes })} + (${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({
        size,
        sizes: theme.spacing
      })} / 1.5))`,
      maxWidth: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes: iconSizes })} + (${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({
        size,
        sizes: theme.spacing
      })} / 1.5))`,
      height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes: iconSizes }),
      display: "inline-block",
      verticalAlign: "middle",
      overflow: "hidden"
    },
    checkIcon: {
      width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes: iconSizes }),
      height: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes: iconSizes })} / 1.1)`,
      display: "block"
    },
    input: {
      width: 0,
      height: 0,
      padding: 0,
      opacity: 0,
      margin: 0,
      "&:focus": {
        outline: "none",
        [`& + .${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getStylesRef)("label")}`]: __spreadValues({}, theme.focusRing === "always" || theme.focusRing === "auto" ? theme.focusRingStyles.styles(theme) : theme.focusRingStyles.resetStyles(theme)),
        "&:focus:not(:focus-visible)": {
          [`& + .${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getStylesRef)("label")}`]: __spreadValues({}, theme.focusRing === "auto" || theme.focusRing === "never" ? theme.focusRingStyles.resetStyles(theme) : null)
        }
      }
    }
  };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);



/***/ }),

/***/ "./node_modules/@mantine/core/esm/Chip/ChipGroup.context.js":
/*!******************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Chip/ChipGroup.context.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ChipGroupProvider": () => (/* binding */ ChipGroupProvider),
/* harmony export */   "useChipGroup": () => (/* binding */ useChipGroup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const ChipGroupContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
const ChipGroupProvider = ChipGroupContext.Provider;
const useChipGroup = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(ChipGroupContext);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Chip/ChipGroup/ChipGroup.js":
/*!********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Chip/ChipGroup/ChipGroup.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ChipGroup": () => (/* binding */ ChipGroup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-uncontrolled/use-uncontrolled.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _ChipGroup_context_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../ChipGroup.context.js */ "./node_modules/@mantine/core/esm/Chip/ChipGroup.context.js");





const defaultProps = {};
function ChipGroup(props) {
  const { value, defaultValue, onChange, multiple, children } = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("ChipGroup", defaultProps, props);
  const [_value, setValue] = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.useUncontrolled)({
    value,
    defaultValue,
    finalValue: multiple ? [] : null,
    onChange
  });
  const isChipSelected = (val) => Array.isArray(_value) ? _value.includes(val) : val === _value;
  const handleChange = (event) => {
    const val = event.currentTarget.value;
    if (Array.isArray(_value)) {
      setValue(_value.includes(val) ? _value.filter((v) => v !== val) : [..._value, val]);
    } else {
      setValue(val);
    }
  };
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ChipGroup_context_js__WEBPACK_IMPORTED_MODULE_3__.ChipGroupProvider, {
    value: { isChipSelected, onChange: handleChange, multiple }
  }, children);
}
ChipGroup.displayName = "@mantine/core/ChipGroup";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/CloseButton/CloseButton.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/CloseButton/CloseButton.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CloseButton": () => (/* binding */ CloseButton),
/* harmony export */   "_CloseButton": () => (/* binding */ _CloseButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _ActionIcon_ActionIcon_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../ActionIcon/ActionIcon.js */ "./node_modules/@mantine/core/esm/ActionIcon/ActionIcon.js");
/* harmony import */ var _CloseIcon_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CloseIcon.js */ "./node_modules/@mantine/core/esm/CloseButton/CloseIcon.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const iconSizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(12),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(16),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(20),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(28),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(34)
};
const defaultProps = {
  size: "sm"
};
const _CloseButton = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.useComponentDefaultProps)("CloseButton", defaultProps, props), { iconSize, size, children } = _a, others = __objRest(_a, ["iconSize", "size", "children"]);
  const _iconSize = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(iconSize || iconSizes[size]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ActionIcon_ActionIcon_js__WEBPACK_IMPORTED_MODULE_3__.ActionIcon, __spreadValues({
    ref,
    __staticSelector: "CloseButton",
    size
  }, others), children || /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CloseIcon_js__WEBPACK_IMPORTED_MODULE_4__.CloseIcon, {
    width: _iconSize,
    height: _iconSize
  }));
});
_CloseButton.displayName = "@mantine/core/CloseButton";
const CloseButton = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_5__.createPolymorphicComponent)(_CloseButton);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/CloseButton/CloseIcon.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/CloseButton/CloseIcon.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CloseIcon": () => (/* binding */ CloseIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
function CloseIcon(props) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __spreadValues({
    viewBox: "0 0 15 15",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    d: "M11.7816 4.03157C12.0062 3.80702 12.0062 3.44295 11.7816 3.2184C11.5571 2.99385 11.193 2.99385 10.9685 3.2184L7.50005 6.68682L4.03164 3.2184C3.80708 2.99385 3.44301 2.99385 3.21846 3.2184C2.99391 3.44295 2.99391 3.80702 3.21846 4.03157L6.68688 7.49999L3.21846 10.9684C2.99391 11.193 2.99391 11.557 3.21846 11.7816C3.44301 12.0061 3.80708 12.0061 4.03164 11.7816L7.50005 8.31316L10.9685 11.7816C11.193 12.0061 11.5571 12.0061 11.7816 11.7816C12.0062 11.557 12.0062 11.193 11.7816 10.9684L8.31322 7.49999L11.7816 4.03157Z",
    fill: "currentColor",
    fillRule: "evenodd",
    clipRule: "evenodd"
  }));
}
CloseIcon.displayName = "@mantine/core/CloseIcon";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Code/Code.js":
/*!*****************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Code/Code.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Code": () => (/* binding */ Code)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _Code_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Code.styles.js */ "./node_modules/@mantine/core/esm/Code/Code.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {};
const Code = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Code", defaultProps, props), { className, children, block, color, unstyled, variant } = _a, others = __objRest(_a, ["className", "children", "block", "color", "unstyled", "variant"]);
  const { classes, cx } = (0,_Code_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ color }, { name: "Code", unstyled, variant });
  if (block) {
    return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_3__.Box, __spreadValues({
      component: "pre",
      dir: "ltr",
      className: cx(classes.root, classes.block, className),
      ref
    }, others), children);
  }
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_3__.Box, __spreadValues({
    component: "code",
    className: cx(classes.root, className),
    ref,
    dir: "ltr"
  }, others), children);
});
Code.displayName = "@mantine/core/Code";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Code/Code.styles.js":
/*!************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Code/Code.styles.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { color: _color }) => {
  const color = _color || (theme.colorScheme === "dark" ? "dark" : "gray");
  const colors = theme.fn.variant({ color, variant: "light" });
  return {
    root: __spreadProps(__spreadValues({}, theme.fn.fontStyles()), {
      lineHeight: theme.lineHeight,
      padding: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(2)} calc(${theme.spacing.xs} / 2)`,
      borderRadius: theme.radius.sm,
      color: theme.colorScheme === "dark" ? color === "dark" ? theme.colors.dark[0] : theme.white : theme.colors.dark[7],
      backgroundColor: theme.colorScheme === "dark" && color === "dark" ? theme.colors.dark[5] : colors.background,
      fontFamily: theme.fontFamilyMonospace,
      fontSize: theme.fontSizes.xs
    }),
    block: {
      padding: theme.spacing.xs,
      margin: 0,
      overflowX: "auto"
    }
  };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Collapse/Collapse.js":
/*!*************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Collapse/Collapse.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Collapse": () => (/* binding */ Collapse)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-reduced-motion/use-reduced-motion.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _use_collapse_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./use-collapse.js */ "./node_modules/@mantine/core/esm/Collapse/use-collapse.js");
/* harmony import */ var _Box_style_system_props_extract_system_styles_extract_system_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box/style-system-props/extract-system-styles/extract-system-styles.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/extract-system-styles/extract-system-styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");







var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  transitionDuration: 200,
  transitionTimingFunction: "ease",
  animateOpacity: true
};
const Collapse = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Collapse", defaultProps, props), {
    children,
    in: opened,
    transitionDuration,
    transitionTimingFunction,
    style,
    onTransitionEnd,
    animateOpacity
  } = _a, others = __objRest(_a, [
    "children",
    "in",
    "transitionDuration",
    "transitionTimingFunction",
    "style",
    "onTransitionEnd",
    "animateOpacity"
  ]);
  const theme = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useMantineTheme)();
  const shouldReduceMotion = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.useReducedMotion)();
  const reduceMotion = theme.respectReducedMotion ? shouldReduceMotion : false;
  const duration = reduceMotion ? 0 : transitionDuration;
  const { systemStyles, rest } = (0,_Box_style_system_props_extract_system_styles_extract_system_styles_js__WEBPACK_IMPORTED_MODULE_3__.extractSystemStyles)(others);
  const getCollapseProps = (0,_use_collapse_js__WEBPACK_IMPORTED_MODULE_4__.useCollapse)({
    opened,
    transitionDuration: duration,
    transitionTimingFunction,
    onTransitionEnd
  });
  if (duration === 0) {
    return opened ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_5__.Box, __spreadValues({}, rest), children) : null;
  }
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_5__.Box, __spreadValues({}, getCollapseProps(__spreadValues(__spreadValues({ style, ref }, rest), systemStyles))), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    style: {
      opacity: opened || !animateOpacity ? 1 : 0,
      transition: animateOpacity ? `opacity ${duration}ms ${transitionTimingFunction}` : "none"
    }
  }, children));
});
Collapse.displayName = "@mantine/core/Collapse";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Collapse/use-collapse.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Collapse/use-collapse.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getElementHeight": () => (/* binding */ getElementHeight),
/* harmony export */   "useCollapse": () => (/* binding */ useCollapse)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "webpack/sharing/consume/default/react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-did-update/use-did-update.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-merged-ref/use-merged-ref.js");




var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function getAutoHeightDuration(height) {
  if (!height || typeof height === "string") {
    return 0;
  }
  const constant = height / 36;
  return Math.round((4 + 15 * constant ** 0.25 + constant / 5) * 10);
}
function getElementHeight(el) {
  return (el == null ? void 0 : el.current) ? el.current.scrollHeight : "auto";
}
const raf = typeof window !== "undefined" && window.requestAnimationFrame;
function useCollapse({
  transitionDuration,
  transitionTimingFunction = "ease",
  onTransitionEnd = () => {
  },
  opened
}) {
  const el = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const collapsedHeight = 0;
  const collapsedStyles = {
    display: "none",
    height: 0,
    overflow: "hidden"
  };
  const [styles, setStylesRaw] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(opened ? {} : collapsedStyles);
  const setStyles = (newStyles) => {
    (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.flushSync)(() => setStylesRaw(newStyles));
  };
  const mergeStyles = (newStyles) => {
    setStyles((oldStyles) => __spreadValues(__spreadValues({}, oldStyles), newStyles));
  };
  function getTransitionStyles(height) {
    const _duration = transitionDuration || getAutoHeightDuration(height);
    return {
      transition: `height ${_duration}ms ${transitionTimingFunction}`
    };
  }
  (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.useDidUpdate)(() => {
    if (opened) {
      raf(() => {
        mergeStyles({ willChange: "height", display: "block", overflow: "hidden" });
        raf(() => {
          const height = getElementHeight(el);
          mergeStyles(__spreadProps(__spreadValues({}, getTransitionStyles(height)), { height }));
        });
      });
    } else {
      raf(() => {
        const height = getElementHeight(el);
        mergeStyles(__spreadProps(__spreadValues({}, getTransitionStyles(height)), { willChange: "height", height }));
        raf(() => mergeStyles({ height: collapsedHeight, overflow: "hidden" }));
      });
    }
  }, [opened]);
  const handleTransitionEnd = (e) => {
    if (e.target !== el.current || e.propertyName !== "height") {
      return;
    }
    if (opened) {
      const height = getElementHeight(el);
      if (height === styles.height) {
        setStyles({});
      } else {
        mergeStyles({ height });
      }
      onTransitionEnd();
    } else if (styles.height === collapsedHeight) {
      setStyles(collapsedStyles);
      onTransitionEnd();
    }
  };
  function getCollapseProps(_a = {}) {
    var _b = _a, { style = {}, refKey = "ref" } = _b, rest = __objRest(_b, ["style", "refKey"]);
    const theirRef = rest[refKey];
    return __spreadProps(__spreadValues({
      "aria-hidden": !opened
    }, rest), {
      [refKey]: (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_3__.mergeRefs)(el, theirRef),
      onTransitionEnd: handleTransitionEnd,
      style: __spreadValues(__spreadValues({ boxSizing: "border-box" }, style), styles)
    });
  }
  return getCollapseProps;
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorInput/ColorInput.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorInput/ColorInput.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ColorInput": () => (/* binding */ ColorInput)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-uncontrolled/use-uncontrolled.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-eye-dropper/use-eye-dropper.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-did-update/use-did-update.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-default-z-index/get-default-z-index.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/noop/noop.js");
/* harmony import */ var _ColorPicker_ColorPicker_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../ColorPicker/ColorPicker.js */ "./node_modules/@mantine/core/esm/ColorPicker/ColorPicker.js");
/* harmony import */ var _EyeDropperIcon_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./EyeDropperIcon.js */ "./node_modules/@mantine/core/esm/ColorInput/EyeDropperIcon.js");
/* harmony import */ var _Input_use_input_props_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Input/use-input-props.js */ "./node_modules/@mantine/core/esm/Input/use-input-props.js");
/* harmony import */ var _ActionIcon_ActionIcon_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../ActionIcon/ActionIcon.js */ "./node_modules/@mantine/core/esm/ActionIcon/ActionIcon.js");
/* harmony import */ var _ColorPicker_converters_converters_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../ColorPicker/converters/converters.js */ "./node_modules/@mantine/core/esm/ColorPicker/converters/converters.js");
/* harmony import */ var _ColorPicker_converters_parsers_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../ColorPicker/converters/parsers.js */ "./node_modules/@mantine/core/esm/ColorPicker/converters/parsers.js");
/* harmony import */ var _Input_Input_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../Input/Input.js */ "./node_modules/@mantine/core/esm/Input/Input.js");
/* harmony import */ var _Popover_Popover_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../Popover/Popover.js */ "./node_modules/@mantine/core/esm/Popover/Popover.js");
/* harmony import */ var _ColorSwatch_ColorSwatch_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../ColorSwatch/ColorSwatch.js */ "./node_modules/@mantine/core/esm/ColorSwatch/ColorSwatch.js");














var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const SWATCH_SIZES = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(16),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(18),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(22),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(28),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(36)
};
const EYE_DROPPER_SIZES = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(14),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(16),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(18),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(20),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(22)
};
const defaultProps = {
  size: "sm",
  format: "hex",
  fixOnBlur: true,
  withPreview: true,
  swatchesPerRow: 10,
  withPicker: true,
  transitionProps: { transition: "fade", duration: 0 },
  dropdownZIndex: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getDefaultZIndex)("popover"),
  withinPortal: true,
  shadow: "md",
  withEyeDropper: true
};
const ColorInput = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_Input_use_input_props_js__WEBPACK_IMPORTED_MODULE_3__.useInputProps)("ColorInput", defaultProps, props), {
    wrapperProps,
    inputProps,
    format,
    onChange,
    onChangeEnd,
    onFocus,
    onBlur,
    onClick,
    value,
    defaultValue,
    disallowInput,
    fixOnBlur,
    withPreview,
    swatchesPerRow,
    withPicker,
    icon,
    transitionProps,
    dropdownZIndex,
    withinPortal,
    portalProps,
    swatches,
    shadow,
    classNames,
    styles,
    unstyled,
    readOnly,
    withEyeDropper,
    eyeDropperIcon,
    rightSection,
    closeOnColorSwatchClick,
    disabled
  } = _a, others = __objRest(_a, [
    "wrapperProps",
    "inputProps",
    "format",
    "onChange",
    "onChangeEnd",
    "onFocus",
    "onBlur",
    "onClick",
    "value",
    "defaultValue",
    "disallowInput",
    "fixOnBlur",
    "withPreview",
    "swatchesPerRow",
    "withPicker",
    "icon",
    "transitionProps",
    "dropdownZIndex",
    "withinPortal",
    "portalProps",
    "swatches",
    "shadow",
    "classNames",
    "styles",
    "unstyled",
    "readOnly",
    "withEyeDropper",
    "eyeDropperIcon",
    "rightSection",
    "closeOnColorSwatchClick",
    "disabled"
  ]);
  const theme = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.useMantineTheme)();
  const [dropdownOpened, setDropdownOpened] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [lastValidValue, setLastValidValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("");
  const [_value, setValue] = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_5__.useUncontrolled)({
    value,
    defaultValue,
    finalValue: "",
    onChange
  });
  const { supported: eyeDropperSupported, open: openEyeDropper } = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_6__.useEyeDropper)();
  const eyeDropper = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ActionIcon_ActionIcon_js__WEBPACK_IMPORTED_MODULE_7__.ActionIcon, {
    sx: { color: theme.colorScheme === "dark" ? theme.colors.dark[0] : theme.black },
    size: inputProps.size,
    onClick: () => openEyeDropper().then(({ sRGBHex }) => {
      const color = (0,_ColorPicker_converters_converters_js__WEBPACK_IMPORTED_MODULE_8__.convertHsvaTo)(format, (0,_ColorPicker_converters_parsers_js__WEBPACK_IMPORTED_MODULE_9__.parseColor)(sRGBHex));
      setValue(color);
      onChangeEnd == null ? void 0 : onChangeEnd(color);
    }).catch(_mantine_utils__WEBPACK_IMPORTED_MODULE_10__.noop)
  }, eyeDropperIcon || /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_EyeDropperIcon_js__WEBPACK_IMPORTED_MODULE_11__.EyeDropperIcon, {
    size: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_12__.getSize)({ size: inputProps.size, sizes: EYE_DROPPER_SIZES })
  }));
  const handleInputFocus = (event) => {
    onFocus == null ? void 0 : onFocus(event);
    setDropdownOpened(true);
  };
  const handleInputBlur = (event) => {
    fixOnBlur && setValue(lastValidValue);
    onBlur == null ? void 0 : onBlur(event);
    setDropdownOpened(false);
  };
  const handleInputClick = (event) => {
    onClick == null ? void 0 : onClick(event);
    setDropdownOpened(true);
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if ((0,_ColorPicker_converters_parsers_js__WEBPACK_IMPORTED_MODULE_9__.isColorValid)(_value) || _value.trim() === "") {
      setLastValidValue(_value);
    }
  }, [_value]);
  (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_13__.useDidUpdate)(() => {
    if ((0,_ColorPicker_converters_parsers_js__WEBPACK_IMPORTED_MODULE_9__.isColorValid)(_value)) {
      setValue((0,_ColorPicker_converters_converters_js__WEBPACK_IMPORTED_MODULE_8__.convertHsvaTo)(format, (0,_ColorPicker_converters_parsers_js__WEBPACK_IMPORTED_MODULE_9__.parseColor)(_value)));
    }
  }, [format]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Input_Input_js__WEBPACK_IMPORTED_MODULE_14__.Input.Wrapper, __spreadProps(__spreadValues({}, wrapperProps), {
    __staticSelector: "ColorInput"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Popover_Popover_js__WEBPACK_IMPORTED_MODULE_15__.Popover, {
    __staticSelector: "ColorInput",
    position: "bottom-start",
    offset: 5,
    zIndex: dropdownZIndex,
    withinPortal,
    portalProps,
    transitionProps,
    opened: dropdownOpened,
    shadow,
    classNames,
    styles,
    unstyled,
    disabled: readOnly || withPicker === false && (!Array.isArray(swatches) || swatches.length === 0)
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Popover_Popover_js__WEBPACK_IMPORTED_MODULE_15__.Popover.Target, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Input_Input_js__WEBPACK_IMPORTED_MODULE_14__.Input, __spreadProps(__spreadValues(__spreadValues({
    autoComplete: "off"
  }, others), inputProps), {
    disabled,
    ref,
    __staticSelector: "ColorInput",
    onFocus: handleInputFocus,
    onBlur: handleInputBlur,
    onClick: handleInputClick,
    spellCheck: false,
    value: _value,
    onChange: (event) => {
      const inputValue = event.currentTarget.value;
      setValue(inputValue);
      if ((0,_ColorPicker_converters_parsers_js__WEBPACK_IMPORTED_MODULE_9__.isColorValid)(inputValue)) {
        onChangeEnd == null ? void 0 : onChangeEnd((0,_ColorPicker_converters_converters_js__WEBPACK_IMPORTED_MODULE_8__.convertHsvaTo)(format, (0,_ColorPicker_converters_parsers_js__WEBPACK_IMPORTED_MODULE_9__.parseColor)(inputValue)));
      }
    },
    icon: icon || (withPreview ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ColorSwatch_ColorSwatch_js__WEBPACK_IMPORTED_MODULE_16__.ColorSwatch, {
      color: (0,_ColorPicker_converters_parsers_js__WEBPACK_IMPORTED_MODULE_9__.isColorValid)(_value) ? _value : "#fff",
      size: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_12__.getSize)({ size: inputProps.size, sizes: SWATCH_SIZES })
    }) : null),
    readOnly: disallowInput || readOnly,
    sx: { cursor: disallowInput ? "pointer" : void 0 },
    unstyled,
    classNames,
    styles,
    rightSection: rightSection || (withEyeDropper && !disabled && !readOnly && eyeDropperSupported ? eyeDropper : null)
  })))), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Popover_Popover_js__WEBPACK_IMPORTED_MODULE_15__.Popover.Dropdown, {
    onMouseDown: (event) => event.preventDefault(),
    p: inputProps.size
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ColorPicker_ColorPicker_js__WEBPACK_IMPORTED_MODULE_17__.ColorPicker, {
    __staticSelector: "ColorInput",
    value: _value,
    onChange: setValue,
    onChangeEnd,
    format,
    swatches,
    swatchesPerRow,
    withPicker,
    size: inputProps.size,
    focusable: false,
    unstyled,
    styles,
    classNames,
    onColorSwatchClick: () => closeOnColorSwatchClick && setDropdownOpened(false)
  }))));
});
ColorInput.displayName = "@mantine/core/ColorInput";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorInput/EyeDropperIcon.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorInput/EyeDropperIcon.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EyeDropperIcon": () => (/* binding */ EyeDropperIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function EyeDropperIcon(_a) {
  var _b = _a, {
    size
  } = _b, others = __objRest(_b, [
    "size"
  ]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __spreadValues({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-color-picker",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: "1.5",
    stroke: "currentColor",
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    d: "M11 7l6 6"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    d: "M4 16l11.7 -11.7a1 1 0 0 1 1.4 0l2.6 2.6a1 1 0 0 1 0 1.4l-11.7 11.7h-4v-4z"
  }));
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorPicker/AlphaSlider/AlphaSlider.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorPicker/AlphaSlider/AlphaSlider.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AlphaSlider": () => (/* binding */ AlphaSlider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _ColorSlider_ColorSlider_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../ColorSlider/ColorSlider.js */ "./node_modules/@mantine/core/esm/ColorPicker/ColorSlider/ColorSlider.js");
/* harmony import */ var _converters_parsers_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../converters/parsers.js */ "./node_modules/@mantine/core/esm/ColorPicker/converters/parsers.js");





var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {};
const AlphaSlider = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("AlphaSlider", defaultProps, props), { value, onChange, onChangeEnd, color, __staticSelector } = _a, others = __objRest(_a, ["value", "onChange", "onChangeEnd", "color", "__staticSelector"]);
  const theme = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useMantineTheme)();
  const _color = theme.colorScheme === "dark" ? theme.colors.dark[4] : theme.colors.gray[3];
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ColorSlider_ColorSlider_js__WEBPACK_IMPORTED_MODULE_2__.ColorSlider, __spreadProps(__spreadValues({}, others), {
    ref,
    value,
    onChange: (val) => onChange((0,_converters_parsers_js__WEBPACK_IMPORTED_MODULE_3__.round)(val, 2)),
    onChangeEnd: (val) => onChangeEnd((0,_converters_parsers_js__WEBPACK_IMPORTED_MODULE_3__.round)(val, 2)),
    maxValue: 1,
    round: false,
    __staticSelector: __staticSelector || "AlphaSlider",
    overlays: [
      {
        backgroundImage: `linear-gradient(45deg, ${_color} 25%, transparent 25%), linear-gradient(-45deg, ${_color} 25%, transparent 25%), linear-gradient(45deg, transparent 75%, ${_color} 75%), linear-gradient(-45deg, ${theme.colorScheme === "dark" ? theme.colors.dark[7] : theme.white} 75%, ${_color} 75%)`,
        backgroundSize: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(8)} ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(8)}`,
        backgroundPosition: `0 0, 0 ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(4)}, ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(4)} -${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(4)}, -${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(4)} 0`
      },
      {
        backgroundImage: `linear-gradient(90deg, transparent, ${color})`
      },
      {
        boxShadow: `rgba(0, 0, 0, .1) 0 0 0 ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(1)} inset, rgb(0, 0, 0, .15) 0 0 ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(4)} inset`
      }
    ]
  }));
});
AlphaSlider.displayName = "@mantine/core/AlphaSlider";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorPicker/ColorPicker.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorPicker/ColorPicker.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ColorPicker": () => (/* binding */ ColorPicker)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-uncontrolled/use-uncontrolled.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-did-update/use-did-update.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _ColorSwatch_ColorSwatch_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../ColorSwatch/ColorSwatch.js */ "./node_modules/@mantine/core/esm/ColorSwatch/ColorSwatch.js");
/* harmony import */ var _HueSlider_HueSlider_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./HueSlider/HueSlider.js */ "./node_modules/@mantine/core/esm/ColorPicker/HueSlider/HueSlider.js");
/* harmony import */ var _AlphaSlider_AlphaSlider_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./AlphaSlider/AlphaSlider.js */ "./node_modules/@mantine/core/esm/ColorPicker/AlphaSlider/AlphaSlider.js");
/* harmony import */ var _Saturation_Saturation_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Saturation/Saturation.js */ "./node_modules/@mantine/core/esm/ColorPicker/Saturation/Saturation.js");
/* harmony import */ var _Swatches_Swatches_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Swatches/Swatches.js */ "./node_modules/@mantine/core/esm/ColorPicker/Swatches/Swatches.js");
/* harmony import */ var _ColorPicker_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ColorPicker.styles.js */ "./node_modules/@mantine/core/esm/ColorPicker/ColorPicker.styles.js");
/* harmony import */ var _converters_parsers_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./converters/parsers.js */ "./node_modules/@mantine/core/esm/ColorPicker/converters/parsers.js");
/* harmony import */ var _converters_converters_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./converters/converters.js */ "./node_modules/@mantine/core/esm/ColorPicker/converters/converters.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");













var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const SWATCH_SIZES = {
  xs: 26,
  sm: 34,
  md: 42,
  lg: 50,
  xl: 54
};
const defaultProps = {
  swatchesPerRow: 10,
  size: "sm",
  withPicker: true,
  focusable: true,
  __staticSelector: "ColorPicker"
};
const ColorPicker = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("ColorPicker", defaultProps, props), {
    value,
    defaultValue,
    onChange,
    onChangeEnd,
    format,
    swatches,
    swatchesPerRow,
    size,
    withPicker,
    fullWidth,
    focusable,
    __staticSelector,
    saturationLabel,
    hueLabel,
    alphaLabel,
    className,
    styles,
    classNames,
    unstyled,
    onColorSwatchClick,
    variant
  } = _a, others = __objRest(_a, [
    "value",
    "defaultValue",
    "onChange",
    "onChangeEnd",
    "format",
    "swatches",
    "swatchesPerRow",
    "size",
    "withPicker",
    "fullWidth",
    "focusable",
    "__staticSelector",
    "saturationLabel",
    "hueLabel",
    "alphaLabel",
    "className",
    "styles",
    "classNames",
    "unstyled",
    "onColorSwatchClick",
    "variant"
  ]);
  const { classes, cx } = (0,_ColorPicker_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ fullWidth }, { classNames, styles, name: __staticSelector, unstyled, variant, size });
  const formatRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(format);
  const valueRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const updateRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(true);
  const withAlpha = format === "hexa" || format === "rgba" || format === "hsla";
  const [_value, setValue, controlled] = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_3__.useUncontrolled)({
    value,
    defaultValue,
    finalValue: "#FFFFFF",
    onChange
  });
  const [parsed, setParsed] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)((0,_converters_parsers_js__WEBPACK_IMPORTED_MODULE_4__.parseColor)(_value));
  const handleChange = (color) => {
    updateRef.current = false;
    setParsed((current) => {
      const next = __spreadValues(__spreadValues({}, current), color);
      valueRef.current = (0,_converters_converters_js__WEBPACK_IMPORTED_MODULE_5__.convertHsvaTo)(formatRef.current, next);
      return next;
    });
    setValue(valueRef.current);
    setTimeout(() => {
      updateRef.current = true;
    }, 0);
  };
  (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_6__.useDidUpdate)(() => {
    if ((0,_converters_parsers_js__WEBPACK_IMPORTED_MODULE_4__.isColorValid)(value) && updateRef.current) {
      setParsed((0,_converters_parsers_js__WEBPACK_IMPORTED_MODULE_4__.parseColor)(value));
      updateRef.current = true;
    }
  }, [value]);
  (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_6__.useDidUpdate)(() => {
    formatRef.current = format;
    setValue((0,_converters_converters_js__WEBPACK_IMPORTED_MODULE_5__.convertHsvaTo)(format, parsed));
  }, [format]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_7__.Box, __spreadValues({
    className: cx(classes.wrapper, className),
    ref
  }, others), withPicker && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Saturation_Saturation_js__WEBPACK_IMPORTED_MODULE_8__.Saturation, {
    value: parsed,
    onChange: handleChange,
    onChangeEnd: ({ s, v }) => onChangeEnd == null ? void 0 : onChangeEnd((0,_converters_converters_js__WEBPACK_IMPORTED_MODULE_5__.convertHsvaTo)(formatRef.current, __spreadProps(__spreadValues({}, parsed), { s, v }))),
    color: _value,
    styles,
    classNames,
    size,
    focusable,
    saturationLabel,
    __staticSelector
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.body
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.sliders
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_HueSlider_HueSlider_js__WEBPACK_IMPORTED_MODULE_9__.HueSlider, {
    value: parsed.h,
    onChange: (h) => handleChange({ h }),
    onChangeEnd: (h) => onChangeEnd == null ? void 0 : onChangeEnd((0,_converters_converters_js__WEBPACK_IMPORTED_MODULE_5__.convertHsvaTo)(formatRef.current, __spreadProps(__spreadValues({}, parsed), { h }))),
    size,
    styles,
    classNames,
    focusable,
    "aria-label": hueLabel,
    __staticSelector
  }), withAlpha && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_AlphaSlider_AlphaSlider_js__WEBPACK_IMPORTED_MODULE_10__.AlphaSlider, {
    value: parsed.a,
    onChange: (a) => handleChange({ a }),
    onChangeEnd: (a) => {
      onChangeEnd == null ? void 0 : onChangeEnd((0,_converters_converters_js__WEBPACK_IMPORTED_MODULE_5__.convertHsvaTo)(formatRef.current, __spreadProps(__spreadValues({}, parsed), { a })));
    },
    size,
    color: (0,_converters_converters_js__WEBPACK_IMPORTED_MODULE_5__.convertHsvaTo)("hex", parsed),
    style: { marginTop: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_11__.rem)(6) },
    styles,
    classNames,
    focusable,
    "aria-label": alphaLabel,
    __staticSelector
  })), withAlpha && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ColorSwatch_ColorSwatch_js__WEBPACK_IMPORTED_MODULE_12__.ColorSwatch, {
    color: _value,
    radius: "sm",
    size: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_13__.getSize)({ size, sizes: SWATCH_SIZES }),
    className: classes.preview
  }))), Array.isArray(swatches) && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Swatches_Swatches_js__WEBPACK_IMPORTED_MODULE_14__.Swatches, {
    data: swatches,
    style: { marginTop: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_11__.rem)(5) },
    swatchesPerRow,
    focusable,
    classNames,
    styles,
    __staticSelector,
    setValue,
    onChangeEnd: (color) => {
      const convertedColor = (0,_converters_converters_js__WEBPACK_IMPORTED_MODULE_5__.convertHsvaTo)(format, (0,_converters_parsers_js__WEBPACK_IMPORTED_MODULE_4__.parseColor)(color));
      onColorSwatchClick == null ? void 0 : onColorSwatchClick(convertedColor);
      onChangeEnd == null ? void 0 : onChangeEnd(convertedColor);
      if (!controlled) {
        setParsed((0,_converters_parsers_js__WEBPACK_IMPORTED_MODULE_4__.parseColor)(color));
      }
    }
  }));
});
ColorPicker.displayName = "@mantine/core/ColorPicker";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorPicker/ColorPicker.styles.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorPicker/ColorPicker.styles.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "sizes": () => (/* binding */ sizes)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


const sizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(180),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(200),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(240),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(280),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(320)
};
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.createStyles)((theme, { fullWidth }, { size }) => ({
  preview: {},
  wrapper: {
    boxSizing: "border-box",
    width: fullWidth ? "100%" : (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes }),
    padding: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)
  },
  body: {
    display: "flex",
    boxSizing: "border-box",
    paddingTop: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes: theme.spacing })} / 2)`
  },
  sliders: {
    flex: 1,
    boxSizing: "border-box",
    "&:not(:only-child)": {
      marginRight: theme.spacing.xs
    }
  },
  slider: {
    boxSizing: "border-box",
    "& + &": {
      marginTop: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(5)
    }
  },
  swatch: {
    cursor: "pointer"
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);



/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorPicker/ColorSlider/ColorSlider.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorPicker/ColorSlider/ColorSlider.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ColorSlider": () => (/* binding */ ColorSlider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-move/use-move.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-did-update/use-did-update.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-merged-ref/use-merged-ref.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _Thumb_Thumb_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Thumb/Thumb.js */ "./node_modules/@mantine/core/esm/ColorPicker/Thumb/Thumb.js");
/* harmony import */ var _ColorSlider_styles_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ColorSlider.styles.js */ "./node_modules/@mantine/core/esm/ColorPicker/ColorSlider/ColorSlider.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");







var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ColorSlider = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((_a, ref) => {
  var _b = _a, {
    value,
    onChange,
    onChangeEnd,
    maxValue,
    round,
    size = "md",
    thumbColor = "transparent",
    __staticSelector = "ColorSlider",
    focusable = true,
    overlays,
    classNames,
    styles,
    className,
    unstyled,
    variant
  } = _b, others = __objRest(_b, [
    "value",
    "onChange",
    "onChangeEnd",
    "maxValue",
    "round",
    "size",
    "thumbColor",
    "__staticSelector",
    "focusable",
    "overlays",
    "classNames",
    "styles",
    "className",
    "unstyled",
    "variant"
  ]);
  const { classes, cx } = (0,_ColorSlider_styles_js__WEBPACK_IMPORTED_MODULE_1__["default"])(null, {
    classNames,
    styles,
    name: __staticSelector,
    unstyled,
    variant,
    size
  });
  const [position, setPosition] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({ y: 0, x: value / maxValue });
  const positionRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(position);
  const getChangeValue = (val) => round ? Math.round(val * maxValue) : val * maxValue;
  const { ref: sliderRef } = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.useMove)(({ x, y }) => {
    positionRef.current = { x, y };
    onChange(getChangeValue(x));
  }, {
    onScrubEnd: () => {
      const { x } = positionRef.current;
      onChangeEnd(getChangeValue(x));
    }
  });
  (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_3__.useDidUpdate)(() => {
    setPosition({ y: 0, x: value / maxValue });
  }, [value]);
  const handleArrow = (event, pos) => {
    event.preventDefault();
    const _position = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.clampUseMovePosition)(pos);
    onChange(getChangeValue(_position.x));
    onChangeEnd(getChangeValue(_position.x));
  };
  const handleKeyDown = (event) => {
    switch (event.key) {
      case "ArrowRight": {
        handleArrow(event, { x: position.x + 0.05, y: position.y });
        break;
      }
      case "ArrowLeft": {
        handleArrow(event, { x: position.x - 0.05, y: position.y });
        break;
      }
    }
  };
  const layers = overlays.map((overlay, index) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.sliderOverlay,
    style: overlay,
    key: index
  }));
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadProps(__spreadValues({}, others), {
    ref: (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_5__.useMergedRef)(sliderRef, ref),
    className: cx(classes.slider, className),
    role: "slider",
    "aria-valuenow": value,
    "aria-valuemax": maxValue,
    "aria-valuemin": 0,
    tabIndex: focusable ? 0 : -1,
    onKeyDown: handleKeyDown
  }), layers, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Thumb_Thumb_js__WEBPACK_IMPORTED_MODULE_6__.Thumb, {
    __staticSelector,
    classNames,
    styles,
    position,
    style: { top: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_7__.rem)(1), backgroundColor: thumbColor },
    className: classes.sliderThumb,
    size
  }));
});
ColorSlider.displayName = "@mantine/core/ColorSlider";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorPicker/ColorSlider/ColorSlider.styles.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorPicker/ColorSlider/ColorSlider.styles.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/get-styles-ref.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _Thumb_Thumb_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Thumb/Thumb.styles.js */ "./node_modules/@mantine/core/esm/ColorPicker/Thumb/Thumb.styles.js");



var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, _params, { size }) => ({
  sliderThumb: {
    ref: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getStylesRef)("sliderThumb")
  },
  slider: {
    position: "relative",
    height: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes: _Thumb_Thumb_styles_js__WEBPACK_IMPORTED_MODULE_3__.THUMB_SIZES })} + ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(2)})`,
    boxSizing: "border-box",
    marginLeft: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes: _Thumb_Thumb_styles_js__WEBPACK_IMPORTED_MODULE_3__.THUMB_SIZES })} / 2)`,
    marginRight: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes: _Thumb_Thumb_styles_js__WEBPACK_IMPORTED_MODULE_3__.THUMB_SIZES })} / 2)`,
    outline: 0,
    [`&:focus .${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getStylesRef)("sliderThumb")}`]: __spreadValues({}, theme.focusRing === "always" || theme.focusRing === "auto" ? theme.focusRingStyles.styles(theme) : theme.focusRingStyles.resetStyles(theme)),
    [`&:focus:not(:focus-visible) .${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getStylesRef)("sliderThumb")}`]: __spreadValues({}, theme.focusRing === "auto" || theme.focusRing === "never" ? theme.focusRingStyles.resetStyles(theme) : null)
  },
  sliderOverlay: {
    position: "absolute",
    boxSizing: "border-box",
    top: 0,
    bottom: 0,
    left: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes: _Thumb_Thumb_styles_js__WEBPACK_IMPORTED_MODULE_3__.THUMB_SIZES })} * -1 / 2 - ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(1)})`,
    right: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes: _Thumb_Thumb_styles_js__WEBPACK_IMPORTED_MODULE_3__.THUMB_SIZES })} * -1 / 2 - ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(1)})`,
    borderRadius: 1e3
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorPicker/HueSlider/HueSlider.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorPicker/HueSlider/HueSlider.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HueSlider": () => (/* binding */ HueSlider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _ColorSlider_ColorSlider_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../ColorSlider/ColorSlider.js */ "./node_modules/@mantine/core/esm/ColorPicker/ColorSlider/ColorSlider.js");




var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {};
const HueSlider = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("HueSlider", defaultProps, props), { value, onChange, onChangeEnd, __staticSelector } = _a, others = __objRest(_a, ["value", "onChange", "onChangeEnd", "__staticSelector"]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ColorSlider_ColorSlider_js__WEBPACK_IMPORTED_MODULE_2__.ColorSlider, __spreadProps(__spreadValues({}, others), {
    ref,
    value,
    onChange,
    onChangeEnd,
    maxValue: 360,
    thumbColor: `hsl(${value}, 100%, 50%)`,
    round: true,
    __staticSelector: __staticSelector || "HueSlider",
    overlays: [
      {
        backgroundImage: "linear-gradient(to right,hsl(0,100%,50%),hsl(60,100%,50%),hsl(120,100%,50%),hsl(170,100%,50%),hsl(240,100%,50%),hsl(300,100%,50%),hsl(360,100%,50%))"
      },
      {
        boxShadow: `rgba(0, 0, 0, .1) 0 0 0 ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.rem)(1)} inset, rgb(0, 0, 0, .15) 0 0 ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.rem)(4)} inset`
      }
    ]
  }));
});
HueSlider.displayName = "@mantine/core/HueSlider";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorPicker/Saturation/Saturation.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorPicker/Saturation/Saturation.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Saturation": () => (/* binding */ Saturation)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-move/use-move.js");
/* harmony import */ var _Thumb_Thumb_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Thumb/Thumb.js */ "./node_modules/@mantine/core/esm/ColorPicker/Thumb/Thumb.js");
/* harmony import */ var _Saturation_styles_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Saturation.styles.js */ "./node_modules/@mantine/core/esm/ColorPicker/Saturation/Saturation.styles.js");
/* harmony import */ var _converters_converters_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../converters/converters.js */ "./node_modules/@mantine/core/esm/ColorPicker/converters/converters.js");






function Saturation({
  value,
  onChange,
  onChangeEnd,
  focusable = true,
  __staticSelector = "saturation",
  size,
  color,
  saturationLabel,
  classNames,
  styles,
  unstyled,
  variant
}) {
  const { classes } = (0,_Saturation_styles_js__WEBPACK_IMPORTED_MODULE_1__["default"])(null, {
    classNames,
    styles,
    name: __staticSelector,
    unstyled,
    variant,
    size
  });
  const [position, setPosition] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({ x: value.s / 100, y: 1 - value.v / 100 });
  const positionRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(position);
  const { ref } = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.useMove)(({ x, y }) => {
    positionRef.current = { x, y };
    onChange({ s: Math.round(x * 100), v: Math.round((1 - y) * 100) });
  }, {
    onScrubEnd: () => {
      const { x, y } = positionRef.current;
      onChangeEnd({ s: Math.round(x * 100), v: Math.round((1 - y) * 100) });
    }
  });
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    setPosition({ x: value.s / 100, y: 1 - value.v / 100 });
  }, [value.s, value.v]);
  const handleArrow = (event, pos) => {
    event.preventDefault();
    const _position = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.clampUseMovePosition)(pos);
    onChange({ s: Math.round(_position.x * 100), v: Math.round((1 - _position.y) * 100) });
    onChangeEnd({ s: Math.round(_position.x * 100), v: Math.round((1 - _position.y) * 100) });
  };
  const handleKeyDown = (event) => {
    switch (event.key) {
      case "ArrowUp": {
        handleArrow(event, { y: position.y - 0.05, x: position.x });
        break;
      }
      case "ArrowDown": {
        handleArrow(event, { y: position.y + 0.05, x: position.x });
        break;
      }
      case "ArrowRight": {
        handleArrow(event, { x: position.x + 0.05, y: position.y });
        break;
      }
      case "ArrowLeft": {
        handleArrow(event, { x: position.x - 0.05, y: position.y });
        break;
      }
    }
  };
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.saturation,
    ref,
    role: "slider",
    "aria-label": saturationLabel,
    "aria-valuenow": position.x,
    "aria-valuetext": (0,_converters_converters_js__WEBPACK_IMPORTED_MODULE_3__.convertHsvaTo)("rgba", value),
    tabIndex: focusable ? 0 : -1,
    onKeyDown: handleKeyDown
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.saturationOverlay,
    style: { backgroundColor: `hsl(${value.h}, 100%, 50%)` }
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.saturationOverlay,
    style: { backgroundImage: "linear-gradient(90deg, #fff, transparent)" }
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.saturationOverlay,
    style: { backgroundImage: "linear-gradient(0deg, #000, transparent)" }
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Thumb_Thumb_js__WEBPACK_IMPORTED_MODULE_4__.Thumb, {
    __staticSelector,
    classNames,
    styles,
    position,
    className: classes.saturationThumb,
    style: { backgroundColor: color },
    size
  }));
}
Saturation.displayName = "@mantine/core/Saturation";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorPicker/Saturation/Saturation.styles.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorPicker/Saturation/Saturation.styles.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/get-styles-ref.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _Thumb_Thumb_styles_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Thumb/Thumb.styles.js */ "./node_modules/@mantine/core/esm/ColorPicker/Thumb/Thumb.styles.js");



var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
const SATURATION_HEIGHTS = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(100),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(110),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(120),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(140),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(160)
};
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.createStyles)((theme, _params, { size }) => ({
  saturationThumb: {
    ref: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getStylesRef)("saturationThumb")
  },
  saturation: {
    boxSizing: "border-box",
    position: "relative",
    height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes: SATURATION_HEIGHTS }),
    borderRadius: theme.radius.sm,
    margin: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes: _Thumb_Thumb_styles_js__WEBPACK_IMPORTED_MODULE_4__.THUMB_SIZES })} / 2)`,
    WebkitTapHighlightColor: "transparent",
    [`&:focus .${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getStylesRef)("saturationThumb")}`]: __spreadValues({}, theme.focusRing === "always" || theme.focusRing === "auto" ? theme.focusRingStyles.styles(theme) : theme.focusRingStyles.resetStyles(theme)),
    [`&:focus:not(:focus-visible) .${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getStylesRef)("saturationThumb")}`]: __spreadValues({}, theme.focusRing === "auto" || theme.focusRing === "never" ? theme.focusRingStyles.resetStyles(theme) : null)
  },
  saturationOverlay: __spreadValues({
    boxSizing: "border-box",
    borderRadius: theme.radius.sm
  }, theme.fn.cover(`calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getSize)({ size, sizes: _Thumb_Thumb_styles_js__WEBPACK_IMPORTED_MODULE_4__.THUMB_SIZES })} * -1 / 2 - ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)})`))
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorPicker/Swatches/Swatches.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorPicker/Swatches/Swatches.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Swatches": () => (/* binding */ Swatches)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ColorSwatch_ColorSwatch_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../ColorSwatch/ColorSwatch.js */ "./node_modules/@mantine/core/esm/ColorSwatch/ColorSwatch.js");
/* harmony import */ var _Swatches_styles_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Swatches.styles.js */ "./node_modules/@mantine/core/esm/ColorPicker/Swatches/Swatches.styles.js");




var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function Swatches(_a) {
  var _b = _a, {
    data,
    swatchesPerRow = 10,
    focusable = true,
    classNames,
    styles,
    __staticSelector = "color-picker",
    unstyled,
    setValue,
    onChangeEnd,
    variant,
    size
  } = _b, others = __objRest(_b, [
    "data",
    "swatchesPerRow",
    "focusable",
    "classNames",
    "styles",
    "__staticSelector",
    "unstyled",
    "setValue",
    "onChangeEnd",
    "variant",
    "size"
  ]);
  const { classes } = (0,_Swatches_styles_js__WEBPACK_IMPORTED_MODULE_1__["default"])({ swatchesPerRow }, { classNames, styles, name: __staticSelector, unstyled, variant, size });
  const colors = data.map((color, index) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ColorSwatch_ColorSwatch_js__WEBPACK_IMPORTED_MODULE_2__.ColorSwatch, {
    className: classes.swatch,
    component: "button",
    type: "button",
    color,
    key: index,
    radius: "sm",
    onClick: () => {
      setValue(color);
      onChangeEnd == null ? void 0 : onChangeEnd(color);
    },
    style: { cursor: "pointer" },
    "aria-label": color,
    tabIndex: focusable ? 0 : -1
  }));
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", __spreadValues({
    className: classes.swatches
  }, others), colors);
}
Swatches.displayName = "@mantine/core/Swatches";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorPicker/Swatches/Swatches.styles.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorPicker/Swatches/Swatches.styles.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((_theme, { swatchesPerRow }) => ({
  swatch: {
    width: `calc(${100 / swatchesPerRow}% - ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(4)})`,
    height: 0,
    paddingBottom: `calc(${100 / swatchesPerRow}% - ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(4)})`,
    margin: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(2),
    boxSizing: "content-box"
  },
  swatches: {
    boxSizing: "border-box",
    marginLeft: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(-2),
    marginRight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(-2),
    display: "flex",
    flexWrap: "wrap"
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorPicker/Thumb/Thumb.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorPicker/Thumb/Thumb.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Thumb": () => (/* binding */ Thumb)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Thumb_styles_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Thumb.styles.js */ "./node_modules/@mantine/core/esm/ColorPicker/Thumb/Thumb.styles.js");



var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
function Thumb({
  position,
  className,
  styles,
  classNames,
  style,
  size,
  __staticSelector,
  unstyled,
  variant
}) {
  const { classes, cx } = (0,_Thumb_styles_js__WEBPACK_IMPORTED_MODULE_1__["default"])(null, {
    classNames,
    styles,
    name: __staticSelector,
    unstyled,
    size,
    variant
  });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: cx(classes.thumb, className),
    style: __spreadValues({
      left: `calc(${position.x * 100}% - ${_Thumb_styles_js__WEBPACK_IMPORTED_MODULE_1__.THUMB_SIZES[size]} / 2)`,
      top: `calc(${position.y * 100}% - ${_Thumb_styles_js__WEBPACK_IMPORTED_MODULE_1__.THUMB_SIZES[size]} / 2)`
    }, style)
  });
}
Thumb.displayName = "@mantine/core/Thumb";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorPicker/Thumb/Thumb.styles.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorPicker/Thumb/Thumb.styles.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "THUMB_SIZES": () => (/* binding */ THUMB_SIZES),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


const THUMB_SIZES = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(8),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(12),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(16),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(20),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(22)
};
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.createStyles)((theme, _params, { size }) => {
  const _size = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes: THUMB_SIZES });
  return {
    thumb: {
      overflow: "hidden",
      boxSizing: "border-box",
      position: "absolute",
      boxShadow: `0 0 ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)} rgba(0, 0, 0, .6)`,
      border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(2)} solid ${theme.white}`,
      backgroundColor: "transparent",
      width: _size,
      height: _size,
      borderRadius: _size
    }
  };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);



/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorPicker/converters/converters.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorPicker/converters/converters.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "convertHsvaTo": () => (/* binding */ convertHsvaTo),
/* harmony export */   "hsvaToHex": () => (/* binding */ hsvaToHex),
/* harmony export */   "hsvaToHexa": () => (/* binding */ hsvaToHexa),
/* harmony export */   "hsvaToHsl": () => (/* binding */ hsvaToHsl),
/* harmony export */   "hsvaToRgba": () => (/* binding */ hsvaToRgba),
/* harmony export */   "hsvaToRgbaObject": () => (/* binding */ hsvaToRgbaObject)
/* harmony export */ });
/* harmony import */ var _parsers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./parsers.js */ "./node_modules/@mantine/core/esm/ColorPicker/converters/parsers.js");


function hsvaToRgbaObject({ h, s, v, a }) {
  const _h = h / 360 * 6;
  const _s = s / 100;
  const _v = v / 100;
  const hh = Math.floor(_h);
  const l = _v * (1 - _s);
  const c = _v * (1 - (_h - hh) * _s);
  const d = _v * (1 - (1 - _h + hh) * _s);
  const module = hh % 6;
  return {
    r: (0,_parsers_js__WEBPACK_IMPORTED_MODULE_0__.round)([_v, c, l, l, d, _v][module] * 255),
    g: (0,_parsers_js__WEBPACK_IMPORTED_MODULE_0__.round)([d, _v, _v, c, l, l][module] * 255),
    b: (0,_parsers_js__WEBPACK_IMPORTED_MODULE_0__.round)([l, l, d, _v, _v, c][module] * 255),
    a: (0,_parsers_js__WEBPACK_IMPORTED_MODULE_0__.round)(a, 2)
  };
}
function hsvaToRgba(color, includeAlpha) {
  const { r, g, b, a } = hsvaToRgbaObject(color);
  if (!includeAlpha) {
    return `rgb(${r}, ${g}, ${b})`;
  }
  return `rgba(${r}, ${g}, ${b}, ${(0,_parsers_js__WEBPACK_IMPORTED_MODULE_0__.round)(a, 2)})`;
}
function hsvaToHsl({ h, s, v, a }, includeAlpha) {
  const hh = (200 - s) * v / 100;
  const result = {
    h: Math.round(h),
    s: Math.round(hh > 0 && hh < 200 ? s * v / 100 / (hh <= 100 ? hh : 200 - hh) * 100 : 0),
    l: Math.round(hh / 2)
  };
  if (!includeAlpha) {
    return `hsl(${result.h}, ${result.s}%, ${result.l}%)`;
  }
  return `hsla(${result.h}, ${result.s}%, ${result.l}%, ${(0,_parsers_js__WEBPACK_IMPORTED_MODULE_0__.round)(a, 2)})`;
}
function formatHexPart(number) {
  const hex = number.toString(16);
  return hex.length < 2 ? `0${hex}` : hex;
}
function hsvaToHex(color) {
  const { r, g, b } = hsvaToRgbaObject(color);
  return `#${formatHexPart(r)}${formatHexPart(g)}${formatHexPart(b)}`;
}
function hsvaToHexa(color) {
  const a = Math.round(color.a * 255);
  return `${hsvaToHex(color)}${formatHexPart(a)}`;
}
const CONVERTERS = {
  hex: hsvaToHex,
  hexa: (color) => hsvaToHexa(color),
  rgb: (color) => hsvaToRgba(color, false),
  rgba: (color) => hsvaToRgba(color, true),
  hsl: (color) => hsvaToHsl(color, false),
  hsla: (color) => hsvaToHsl(color, true)
};
function convertHsvaTo(format, color) {
  if (!color) {
    return "#000000";
  }
  if (!(format in CONVERTERS)) {
    return CONVERTERS.hex(color);
  }
  return CONVERTERS[format](color);
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorPicker/converters/parsers.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorPicker/converters/parsers.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isColorValid": () => (/* binding */ isColorValid),
/* harmony export */   "parseColor": () => (/* binding */ parseColor),
/* harmony export */   "parseHex": () => (/* binding */ parseHex),
/* harmony export */   "parseHexa": () => (/* binding */ parseHexa),
/* harmony export */   "parseHsla": () => (/* binding */ parseHsla),
/* harmony export */   "parseHue": () => (/* binding */ parseHue),
/* harmony export */   "parseRgba": () => (/* binding */ parseRgba),
/* harmony export */   "round": () => (/* binding */ round)
/* harmony export */ });
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
function round(number, digits = 0, base = 10 ** digits) {
  return Math.round(base * number) / base;
}
function hslaToHsva({ h, s, l, a }) {
  const ss = s * ((l < 50 ? l : 100 - l) / 100);
  return {
    h,
    s: ss > 0 ? 2 * ss / (l + ss) * 100 : 0,
    v: l + ss,
    a
  };
}
const angleUnits = {
  grad: 360 / 400,
  turn: 360,
  rad: 360 / (Math.PI * 2)
};
function parseHue(value, unit = "deg") {
  return Number(value) * (angleUnits[unit] || 1);
}
const HSL_REGEXP = /hsla?\(?\s*(-?\d*\.?\d+)(deg|rad|grad|turn)?[,\s]+(-?\d*\.?\d+)%?[,\s]+(-?\d*\.?\d+)%?,?\s*[/\s]*(-?\d*\.?\d+)?(%)?\s*\)?/i;
function parseHsla(color) {
  const match = HSL_REGEXP.exec(color);
  if (!match) {
    return { h: 0, s: 0, v: 0, a: 1 };
  }
  return hslaToHsva({
    h: parseHue(match[1], match[2]),
    s: Number(match[3]),
    l: Number(match[4]),
    a: match[5] === void 0 ? 1 : Number(match[5]) / (match[6] ? 100 : 1)
  });
}
function rgbaToHsva({ r, g, b, a }) {
  const max = Math.max(r, g, b);
  const delta = max - Math.min(r, g, b);
  const hh = delta ? max === r ? (g - b) / delta : max === g ? 2 + (b - r) / delta : 4 + (r - g) / delta : 0;
  return {
    h: round(60 * (hh < 0 ? hh + 6 : hh)),
    s: round(max ? delta / max * 100 : 0),
    v: round(max / 255 * 100),
    a
  };
}
function parseHex(color) {
  const hex = color[0] === "#" ? color.slice(1) : color;
  if (hex.length === 3) {
    return rgbaToHsva({
      r: parseInt(hex[0] + hex[0], 16),
      g: parseInt(hex[1] + hex[1], 16),
      b: parseInt(hex[2] + hex[2], 16),
      a: 1
    });
  }
  return rgbaToHsva({
    r: parseInt(hex.slice(0, 2), 16),
    g: parseInt(hex.slice(2, 4), 16),
    b: parseInt(hex.slice(4, 6), 16),
    a: 1
  });
}
function parseHexa(color) {
  const hex = color[0] === "#" ? color.slice(1) : color;
  const roundA = (a2) => Math.round(parseInt(a2, 16) / 255 * 100) / 100;
  if (hex.length === 4) {
    const withoutOpacity2 = hex.slice(0, 3);
    const a2 = roundA(hex[3] + hex[3]);
    const hsvaColor2 = __spreadProps(__spreadValues({}, parseHex(withoutOpacity2)), { a: a2 });
    return hsvaColor2;
  }
  const withoutOpacity = hex.slice(0, 6);
  const a = roundA(hex.slice(6, 8));
  const hsvaColor = __spreadProps(__spreadValues({}, parseHex(withoutOpacity)), { a });
  return hsvaColor;
}
const RGB_REGEXP = /rgba?\(?\s*(-?\d*\.?\d+)(%)?[,\s]+(-?\d*\.?\d+)(%)?[,\s]+(-?\d*\.?\d+)(%)?,?\s*[/\s]*(-?\d*\.?\d+)?(%)?\s*\)?/i;
function parseRgba(color) {
  const match = RGB_REGEXP.exec(color);
  if (!match) {
    return { h: 0, s: 0, v: 0, a: 1 };
  }
  return rgbaToHsva({
    r: Number(match[1]) / (match[2] ? 100 / 255 : 1),
    g: Number(match[3]) / (match[4] ? 100 / 255 : 1),
    b: Number(match[5]) / (match[6] ? 100 / 255 : 1),
    a: match[7] === void 0 ? 1 : Number(match[7]) / (match[8] ? 100 : 1)
  });
}
const VALIDATION_REGEXP = {
  hex: /^#?([0-9A-F]{3}){1,2}$/i,
  hexa: /^#?([0-9A-F]{4}){1,2}$/i,
  rgb: /^rgb\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)$/i,
  rgba: /^rgba\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)$/i,
  hsl: /hsl\(\s*(\d+)\s*,\s*(\d+(?:\.\d+)?%)\s*,\s*(\d+(?:\.\d+)?%)\)/i,
  hsla: /^hsla\((\d+),\s*([\d.]+)%,\s*([\d.]+)%,\s*(\d*(?:\.\d+)?)\)$/i
};
const CONVERTERS = {
  hex: parseHex,
  hexa: parseHexa,
  rgb: parseRgba,
  rgba: parseRgba,
  hsl: parseHsla,
  hsla: parseHsla
};
function isColorValid(color) {
  for (const [, regexp] of Object.entries(VALIDATION_REGEXP)) {
    if (regexp.test(color)) {
      return true;
    }
  }
  return false;
}
function parseColor(color) {
  if (typeof color !== "string") {
    return { h: 0, s: 0, v: 0, a: 1 };
  }
  if (color === "transparent") {
    return { h: 0, s: 0, v: 0, a: 0 };
  }
  const trimmed = color.trim();
  for (const [rule, regexp] of Object.entries(VALIDATION_REGEXP)) {
    if (regexp.test(trimmed)) {
      return CONVERTERS[rule](trimmed);
    }
  }
  return { h: 0, s: 0, v: 0, a: 1 };
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorSwatch/ColorSwatch.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorSwatch/ColorSwatch.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ColorSwatch": () => (/* binding */ ColorSwatch),
/* harmony export */   "_ColorSwatch": () => (/* binding */ _ColorSwatch)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _ColorSwatch_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ColorSwatch.styles.js */ "./node_modules/@mantine/core/esm/ColorSwatch/ColorSwatch.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  size: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(25),
  radius: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(25),
  withShadow: true
};
const _ColorSwatch = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.useComponentDefaultProps)("ColorSwatch", defaultProps, props), {
    color,
    size,
    radius,
    className,
    children,
    classNames,
    styles,
    unstyled,
    withShadow,
    variant
  } = _a, others = __objRest(_a, [
    "color",
    "size",
    "radius",
    "className",
    "children",
    "classNames",
    "styles",
    "unstyled",
    "withShadow",
    "variant"
  ]);
  const { classes, cx } = (0,_ColorSwatch_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])({ radius }, { classNames, styles, unstyled, name: "ColorSwatch", size, variant });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    className: cx(classes.root, className),
    ref
  }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: cx(classes.alphaOverlay, classes.overlay)
  }), withShadow && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: cx(classes.shadowOverlay, classes.overlay)
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.overlay,
    style: { backgroundColor: color }
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: cx(classes.children, classes.overlay)
  }, children));
});
_ColorSwatch.displayName = "@mantine/core/ColorSwatch";
const ColorSwatch = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_5__.createPolymorphicComponent)(_ColorSwatch);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/ColorSwatch/ColorSwatch.styles.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/ColorSwatch/ColorSwatch.styles.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { radius }, { size }) => {
  const overlayColor = theme.colorScheme === "dark" ? theme.colors.dark[4] : theme.colors.gray[3];
  return {
    root: __spreadProps(__spreadValues({}, theme.fn.focusStyles()), {
      width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(size),
      height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(size),
      WebkitTapHighlightColor: "transparent",
      border: 0,
      borderRadius: theme.fn.radius(radius),
      appearance: "none",
      WebkitAppearance: "none",
      padding: 0,
      position: "relative",
      overflow: "hidden"
    }),
    overlay: __spreadProps(__spreadValues({}, theme.fn.cover()), {
      position: "absolute",
      borderRadius: theme.fn.radius(radius)
    }),
    children: {
      display: "inline-flex",
      justifyContent: "center",
      alignItems: "center"
    },
    shadowOverlay: {
      boxShadow: `rgba(0, 0, 0, .1) 0 0 0 ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(1)} inset, rgb(0, 0, 0, .15) 0 0 ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(4)} inset`,
      zIndex: 1
    },
    alphaOverlay: {
      backgroundImage: `linear-gradient(45deg, ${overlayColor} 25%, transparent 25%), linear-gradient(-45deg, ${overlayColor} 25%, transparent 25%), linear-gradient(45deg, transparent 75%, ${overlayColor} 75%), linear-gradient(-45deg, ${theme.colorScheme === "dark" ? theme.colors.dark[7] : theme.white} 75%, ${overlayColor} 75%)`,
      backgroundSize: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(8)} ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(8)}`,
      backgroundPosition: `0 0, 0 ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(4)}, ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(4)} -${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(4)}, -${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(4)} 0`
    }
  };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Container/Container.js":
/*!***************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Container/Container.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Container": () => (/* binding */ Container)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _Container_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Container.styles.js */ "./node_modules/@mantine/core/esm/Container/Container.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  sizes: {
    xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(540),
    sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(720),
    md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(960),
    lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(1140),
    xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(1320)
  }
};
const Container = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.useComponentDefaultProps)("Container", defaultProps, props), { className, fluid, size, unstyled, sizes, variant } = _a, others = __objRest(_a, ["className", "fluid", "size", "unstyled", "sizes", "variant"]);
  const { classes, cx } = (0,_Container_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])({ fluid, sizes }, { unstyled, name: "Container", variant, size });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    className: cx(classes.root, className),
    ref
  }, others));
});
Container.displayName = "@mantine/core/Container";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Container/Container.styles.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Container/Container.styles.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { fluid, sizes }, { size }) => ({
  root: {
    paddingLeft: theme.spacing.md,
    paddingRight: theme.spacing.md,
    maxWidth: fluid ? "100%" : (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size, sizes }),
    marginLeft: "auto",
    marginRight: "auto"
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/CopyButton/CopyButton.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/CopyButton/CopyButton.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CopyButton": () => (/* binding */ CopyButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-clipboard/use-clipboard.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");




var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  timeout: 1e3
};
function CopyButton(props) {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("CopyButton", defaultProps, props), { children, timeout, value } = _a, others = __objRest(_a, ["children", "timeout", "value"]);
  const clipboard = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.useClipboard)({ timeout });
  const copy = () => clipboard.copy(value);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, children(__spreadValues({ copy, copied: clipboard.copied }, others)));
}
CopyButton.displayName = "@mantine/core/CopyButton";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Dialog/Dialog.js":
/*!*********************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Dialog/Dialog.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Dialog": () => (/* binding */ Dialog),
/* harmony export */   "DialogBody": () => (/* binding */ DialogBody)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-default-z-index/get-default-z-index.js");
/* harmony import */ var _Dialog_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Dialog.styles.js */ "./node_modules/@mantine/core/esm/Dialog/Dialog.styles.js");
/* harmony import */ var _Affix_Affix_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Affix/Affix.js */ "./node_modules/@mantine/core/esm/Affix/Affix.js");
/* harmony import */ var _Transition_Transition_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Transition/Transition.js */ "./node_modules/@mantine/core/esm/Transition/Transition.js");
/* harmony import */ var _Paper_Paper_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Paper/Paper.js */ "./node_modules/@mantine/core/esm/Paper/Paper.js");
/* harmony import */ var _CloseButton_CloseButton_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../CloseButton/CloseButton.js */ "./node_modules/@mantine/core/esm/CloseButton/CloseButton.js");








var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  shadow: "md",
  p: "md",
  withBorder: false,
  size: "md",
  transition: "pop-top-right",
  transitionDuration: 200
};
function DialogBody(props) {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Dialog", defaultProps, props), {
    withCloseButton,
    onClose,
    position,
    shadow,
    children,
    className,
    style,
    classNames,
    styles,
    opened,
    withBorder,
    size,
    transition,
    transitionDuration,
    transitionTimingFunction,
    unstyled,
    variant,
    keepMounted
  } = _a, others = __objRest(_a, [
    "withCloseButton",
    "onClose",
    "position",
    "shadow",
    "children",
    "className",
    "style",
    "classNames",
    "styles",
    "opened",
    "withBorder",
    "size",
    "transition",
    "transitionDuration",
    "transitionTimingFunction",
    "unstyled",
    "variant",
    "keepMounted"
  ]);
  const { classes, cx } = (0,_Dialog_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])(null, {
    classNames,
    styles,
    unstyled,
    name: "Dialog",
    variant,
    size
  });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Transition_Transition_js__WEBPACK_IMPORTED_MODULE_3__.Transition, {
    keepMounted,
    mounted: opened,
    transition,
    duration: transitionDuration,
    timingFunction: transitionTimingFunction
  }, (transitionStyles) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Paper_Paper_js__WEBPACK_IMPORTED_MODULE_4__.Paper, __spreadValues({
    className: cx(classes.root, className),
    style: __spreadValues(__spreadValues({}, style), transitionStyles),
    shadow,
    withBorder,
    unstyled
  }, others), withCloseButton && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CloseButton_CloseButton_js__WEBPACK_IMPORTED_MODULE_5__.CloseButton, {
    onClick: onClose,
    className: classes.closeButton
  }), children));
}
const Dialog = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((_a, ref) => {
  var _b = _a, { zIndex = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_6__.getDefaultZIndex)("modal") } = _b, props = __objRest(_b, ["zIndex"]);
  const theme = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useMantineTheme)();
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Affix_Affix_js__WEBPACK_IMPORTED_MODULE_7__.Affix, {
    zIndex,
    position: props.position || { bottom: theme.spacing.xl, right: theme.spacing.xl },
    ref
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DialogBody, __spreadValues({}, props)));
});
Dialog.displayName = "@mantine/core/Dialog";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Dialog/Dialog.styles.js":
/*!****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Dialog/Dialog.styles.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const sizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(160),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(200),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(340),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(400),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(500)
};
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.createStyles)((theme, _params, { size }) => ({
  root: __spreadProps(__spreadValues({}, theme.fn.fontStyles()), {
    color: theme.colorScheme === "dark" ? theme.colors.dark[0] : theme.black,
    position: "relative",
    width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes }),
    maxWidth: `calc(100vw - ${theme.spacing.xl} * 2)`,
    minHeight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(50)
  }),
  closeButton: {
    position: "absolute",
    top: `calc(${theme.spacing.md} / 2)`,
    right: `calc(${theme.spacing.md} / 2)`
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Divider/Divider.js":
/*!***********************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Divider/Divider.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Divider": () => (/* binding */ Divider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _Divider_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Divider.styles.js */ "./node_modules/@mantine/core/esm/Divider/Divider.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");
/* harmony import */ var _Text_Text_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Text/Text.js */ "./node_modules/@mantine/core/esm/Text/Text.js");






var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  orientation: "horizontal",
  size: "xs",
  labelPosition: "left",
  variant: "solid"
};
const Divider = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Divider", defaultProps, props), {
    className,
    color,
    orientation,
    size,
    label,
    labelPosition,
    labelProps,
    variant,
    styles,
    classNames,
    unstyled
  } = _a, others = __objRest(_a, [
    "className",
    "color",
    "orientation",
    "size",
    "label",
    "labelPosition",
    "labelProps",
    "variant",
    "styles",
    "classNames",
    "unstyled"
  ]);
  const { classes, cx } = (0,_Divider_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ color }, { classNames, styles, unstyled, name: "Divider", variant, size });
  const vertical = orientation === "vertical";
  const horizontal = orientation === "horizontal";
  const withLabel = !!label && horizontal;
  const useLabelDefaultStyles = !(labelProps == null ? void 0 : labelProps.color);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_3__.Box, __spreadValues({
    ref,
    className: cx(classes.root, {
      [classes.vertical]: vertical,
      [classes.horizontal]: horizontal,
      [classes.withLabel]: withLabel
    }, className),
    role: "separator"
  }, others), withLabel && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Text_Text_js__WEBPACK_IMPORTED_MODULE_4__.Text, __spreadProps(__spreadValues({}, labelProps), {
    size: (labelProps == null ? void 0 : labelProps.size) || "xs",
    mt: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.rem)(2),
    className: cx(classes.label, classes[labelPosition], {
      [classes.labelDefaultStyles]: useLabelDefaultStyles
    })
  }), label));
});
Divider.displayName = "@mantine/core/Divider";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Divider/Divider.styles.js":
/*!******************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Divider/Divider.styles.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


const sizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(2),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(3),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(4),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(5)
};
function getColor(theme, color) {
  const themeColor = theme.fn.variant({ variant: "outline", color }).border;
  return typeof color === "string" && (color in theme.colors || color.split(".")[0] in theme.colors) ? themeColor : color === void 0 ? theme.colorScheme === "dark" ? theme.colors.dark[4] : theme.colors.gray[4] : color;
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.createStyles)((theme, { color }, { size, variant }) => ({
  root: {},
  withLabel: {
    borderTop: "0 !important"
  },
  left: {
    "&::before": {
      display: "none"
    }
  },
  right: {
    "&::after": {
      display: "none"
    }
  },
  label: {
    display: "flex",
    alignItems: "center",
    "&::before": {
      content: '""',
      flex: 1,
      height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1),
      borderTop: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes })} ${variant} ${getColor(theme, color)}`,
      marginRight: theme.spacing.xs
    },
    "&::after": {
      content: '""',
      flex: 1,
      borderTop: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes })} ${variant} ${getColor(theme, color)}`,
      marginLeft: theme.spacing.xs
    }
  },
  labelDefaultStyles: {
    color: color === "dark" ? theme.colors.dark[1] : theme.fn.themeColor(color, theme.colorScheme === "dark" ? 5 : theme.fn.primaryShade(), false)
  },
  horizontal: {
    border: 0,
    borderTopWidth: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)((0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes })),
    borderTopColor: getColor(theme, color),
    borderTopStyle: variant,
    margin: 0
  },
  vertical: {
    border: 0,
    alignSelf: "stretch",
    height: "auto",
    borderLeftWidth: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)((0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes })),
    borderLeftColor: getColor(theme, color),
    borderLeftStyle: variant
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Drawer/Drawer.context.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Drawer/Drawer.context.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DrawerProvider": () => (/* binding */ DrawerProvider),
/* harmony export */   "useDrawerContext": () => (/* binding */ useDrawerContext)
/* harmony export */ });
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-safe-context/create-safe-context.js");


const [DrawerProvider, useDrawerContext] = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_0__.createSafeContext)("Drawer component was not found in tree");




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Drawer/Drawer.js":
/*!*********************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Drawer/Drawer.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Drawer": () => (/* binding */ Drawer)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _DrawerRoot_DrawerRoot_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DrawerRoot/DrawerRoot.js */ "./node_modules/@mantine/core/esm/Drawer/DrawerRoot/DrawerRoot.js");
/* harmony import */ var _DrawerContent_DrawerContent_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./DrawerContent/DrawerContent.js */ "./node_modules/@mantine/core/esm/Drawer/DrawerContent/DrawerContent.js");
/* harmony import */ var _ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ModalBase/ModalBase.js */ "./node_modules/@mantine/core/esm/ModalBase/ModalBase.js");






var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = __spreadProps(__spreadValues({}, _ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__.ModalBaseDefaultProps), {
  withOverlay: true,
  withCloseButton: true
});
function Drawer(props) {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.useComponentDefaultProps)("Drawer", defaultProps, props), {
    title,
    withOverlay,
    overlayProps,
    withCloseButton,
    closeButtonProps,
    children
  } = _a, others = __objRest(_a, [
    "title",
    "withOverlay",
    "overlayProps",
    "withCloseButton",
    "closeButtonProps",
    "children"
  ]);
  const hasHeader = !!title || withCloseButton;
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DrawerRoot_DrawerRoot_js__WEBPACK_IMPORTED_MODULE_3__.DrawerRoot, __spreadValues({}, others), withOverlay && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__.ModalBase.Overlay, __spreadValues({}, overlayProps)), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DrawerContent_DrawerContent_js__WEBPACK_IMPORTED_MODULE_4__.DrawerContent, null, hasHeader && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__.ModalBase.Header, null, title && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__.ModalBase.Title, null, title), withCloseButton && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__.ModalBase.CloseButton, __spreadValues({}, closeButtonProps))), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__.ModalBase.Body, null, children)));
}
Drawer.Root = _DrawerRoot_DrawerRoot_js__WEBPACK_IMPORTED_MODULE_3__.DrawerRoot;
Drawer.CloseButton = _ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__.ModalBase.CloseButton;
Drawer.Overlay = _ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__.ModalBase.Overlay;
Drawer.Content = _DrawerContent_DrawerContent_js__WEBPACK_IMPORTED_MODULE_4__.DrawerContent;
Drawer.Header = _ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__.ModalBase.Header;
Drawer.Title = _ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__.ModalBase.Title;
Drawer.Body = _ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__.ModalBase.Body;
Drawer.NativeScrollArea = _ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__.ModalBase.NativeScrollArea;




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Drawer/DrawerContent/DrawerContent.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Drawer/DrawerContent/DrawerContent.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DrawerContent": () => (/* binding */ DrawerContent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _Drawer_context_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Drawer.context.js */ "./node_modules/@mantine/core/esm/Drawer/Drawer.context.js");
/* harmony import */ var _ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../ModalBase/ModalBase.js */ "./node_modules/@mantine/core/esm/ModalBase/ModalBase.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  shadow: "xl"
};
const DrawerContent = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("ModalContent", defaultProps, props), { children, scrollAreaComponent } = _a, others = __objRest(_a, ["children", "scrollAreaComponent"]);
  const ctx = (0,_Drawer_context_js__WEBPACK_IMPORTED_MODULE_2__.useDrawerContext)();
  const Scroll = scrollAreaComponent || ctx.scrollAreaComponent || _ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_3__.ModalBase.NativeScrollArea;
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_3__.ModalBase.Content, __spreadValues({
    ref,
    radius: 0
  }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Scroll, {
    style: { height: "100vh" }
  }, children));
});




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Drawer/DrawerRoot/DrawerRoot.js":
/*!************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Drawer/DrawerRoot/DrawerRoot.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DrawerRoot": () => (/* binding */ DrawerRoot)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _Drawer_context_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Drawer.context.js */ "./node_modules/@mantine/core/esm/Drawer/Drawer.context.js");
/* harmony import */ var _DrawerRoot_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DrawerRoot.styles.js */ "./node_modules/@mantine/core/esm/Drawer/DrawerRoot/DrawerRoot.styles.js");
/* harmony import */ var _ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../ModalBase/ModalBase.js */ "./node_modules/@mantine/core/esm/ModalBase/ModalBase.js");






var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const transitions = {
  top: "slide-down",
  bottom: "slide-up",
  left: "slide-right",
  right: "slide-left"
};
const rtlTransitions = {
  top: "slide-down",
  bottom: "slide-up",
  right: "slide-right",
  left: "slide-left"
};
const defaultProps = __spreadProps(__spreadValues({}, _ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__.ModalBaseDefaultProps), {
  position: "left"
});
function DrawerRoot(props) {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.useComponentDefaultProps)("DrawerRoot", defaultProps, props), { classNames, variant, size, scrollAreaComponent, position, transitionProps } = _a, others = __objRest(_a, ["classNames", "variant", "size", "scrollAreaComponent", "position", "transitionProps"]);
  const { classes, cx, theme } = (0,_DrawerRoot_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])({ position }, { name: "Drawer", variant, size });
  const drawerTransition = (theme.dir === "rtl" ? rtlTransitions : transitions)[position];
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Drawer_context_js__WEBPACK_IMPORTED_MODULE_4__.DrawerProvider, {
    value: { scrollAreaComponent }
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ModalBase_ModalBase_js__WEBPACK_IMPORTED_MODULE_1__.ModalBase, __spreadValues({
    __staticSelector: "Drawer",
    size,
    variant,
    transitionProps: __spreadValues({ transition: drawerTransition, duration: 200 }, transitionProps),
    classNames: __spreadProps(__spreadValues({}, classNames), {
      content: cx(classes.content, classNames == null ? void 0 : classNames.content),
      inner: cx(classes.inner, classNames == null ? void 0 : classNames.inner)
    })
  }, others)));
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Drawer/DrawerRoot/DrawerRoot.styles.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Drawer/DrawerRoot/DrawerRoot.styles.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


const sizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(320),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(380),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(440),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(620),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(780)
};
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.createStyles)((theme, { position }, { size }) => ({
  header: {
    zIndex: 1e3
  },
  content: {
    flex: position === "right" || position === "left" ? `0 0 ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes })}` : "0 0 100%",
    maxWidth: "100%",
    maxHeight: "100%",
    height: position === "right" || position === "left" ? "100%" : (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes }),
    borderRadius: 0,
    overflowY: "auto"
  },
  inner: {
    display: "flex",
    justifyContent: position === "right" ? "flex-end" : "flex-start",
    alignItems: position === "bottom" ? "flex-end" : "flex-start"
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/FileButton/FileButton.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/FileButton/FileButton.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FileButton": () => (/* binding */ FileButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/utils/assign-ref/assign-ref.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-merged-ref/use-merged-ref.js");




var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  multiple: false
};
const FileButton = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("FileButton", defaultProps, props), {
    onChange,
    children,
    multiple,
    accept,
    name,
    form,
    resetRef,
    disabled,
    capture,
    inputProps
  } = _a, others = __objRest(_a, [
    "onChange",
    "children",
    "multiple",
    "accept",
    "name",
    "form",
    "resetRef",
    "disabled",
    "capture",
    "inputProps"
  ]);
  const inputRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();
  const onClick = () => {
    !disabled && inputRef.current.click();
  };
  const handleChange = (event) => {
    if (multiple) {
      onChange(Array.from(event.currentTarget.files));
    } else {
      onChange(event.currentTarget.files[0] || null);
    }
  };
  const reset = () => {
    inputRef.current.value = "";
  };
  (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.assignRef)(resetRef, reset);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, children(__spreadValues({ onClick }, others)), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", __spreadValues({
    style: { display: "none" },
    type: "file",
    accept,
    multiple,
    onChange: handleChange,
    ref: (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_3__.useMergedRef)(ref, inputRef),
    name,
    form,
    capture
  }, inputProps)));
});
FileButton.displayName = "@mantine/core/FileButton";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/FileInput/FileInput.js":
/*!***************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/FileInput/FileInput.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FileInput": () => (/* binding */ FileInput),
/* harmony export */   "_FileInput": () => (/* binding */ _FileInput)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-uncontrolled/use-uncontrolled.js");
/* harmony import */ var _FileInput_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./FileInput.styles.js */ "./node_modules/@mantine/core/esm/FileInput/FileInput.styles.js");
/* harmony import */ var _Input_use_input_props_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Input/use-input-props.js */ "./node_modules/@mantine/core/esm/Input/use-input-props.js");
/* harmony import */ var _CloseButton_CloseButton_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../CloseButton/CloseButton.js */ "./node_modules/@mantine/core/esm/CloseButton/CloseButton.js");
/* harmony import */ var _Input_Input_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Input/Input.js */ "./node_modules/@mantine/core/esm/Input/Input.js");
/* harmony import */ var _FileButton_FileButton_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../FileButton/FileButton.js */ "./node_modules/@mantine/core/esm/FileButton/FileButton.js");
/* harmony import */ var _Text_Text_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Text/Text.js */ "./node_modules/@mantine/core/esm/Text/Text.js");









var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const DefaultValue = ({ value }) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Text_Text_js__WEBPACK_IMPORTED_MODULE_1__.Text, {
  sx: { overflow: "hidden", textOverflow: "ellipsis", whiteSpace: "nowrap" }
}, Array.isArray(value) ? value.map((file) => file.name).join(", ") : value == null ? void 0 : value.name);
const defaultProps = {
  size: "sm",
  valueComponent: DefaultValue
};
const _FileInput = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_Input_use_input_props_js__WEBPACK_IMPORTED_MODULE_2__.useInputProps)("FileInput", defaultProps, props), {
    inputProps,
    wrapperProps,
    placeholder,
    value,
    defaultValue,
    onChange,
    multiple,
    accept,
    name,
    form,
    classNames,
    styles,
    unstyled,
    valueComponent: ValueComponent,
    rightSection,
    clearable,
    clearButtonProps,
    readOnly,
    capture,
    fileInputProps
  } = _a, others = __objRest(_a, [
    "inputProps",
    "wrapperProps",
    "placeholder",
    "value",
    "defaultValue",
    "onChange",
    "multiple",
    "accept",
    "name",
    "form",
    "classNames",
    "styles",
    "unstyled",
    "valueComponent",
    "rightSection",
    "clearable",
    "clearButtonProps",
    "readOnly",
    "capture",
    "fileInputProps"
  ]);
  const resetRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();
  const { classes, cx } = (0,_FileInput_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])(null, {
    name: "FileInput",
    classNames,
    styles,
    unstyled
  });
  const [_value, setValue] = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_4__.useUncontrolled)({
    value,
    defaultValue,
    onChange,
    finalValue: multiple ? [] : null
  });
  const hasValue = Array.isArray(_value) ? _value.length !== 0 : _value !== null;
  const _rightSection = rightSection || (clearable && hasValue && !readOnly ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CloseButton_CloseButton_js__WEBPACK_IMPORTED_MODULE_5__.CloseButton, __spreadProps(__spreadValues({}, clearButtonProps), {
    variant: "transparent",
    onClick: () => setValue(multiple ? [] : null),
    size: inputProps.size,
    unstyled
  })) : null);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (Array.isArray(_value) && _value.length === 0 || _value === null) {
      resetRef.current();
    }
  }, [_value]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Input_Input_js__WEBPACK_IMPORTED_MODULE_6__.Input.Wrapper, __spreadProps(__spreadValues({}, wrapperProps), {
    __staticSelector: "FileInput"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_FileButton_FileButton_js__WEBPACK_IMPORTED_MODULE_7__.FileButton, {
    onChange: setValue,
    multiple,
    accept,
    name,
    form,
    resetRef,
    disabled: readOnly,
    capture,
    inputProps: fileInputProps
  }, (fileButtonProps) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Input_Input_js__WEBPACK_IMPORTED_MODULE_6__.Input, __spreadProps(__spreadValues(__spreadValues(__spreadValues({
    multiline: true
  }, fileButtonProps), inputProps), others), {
    component: "button",
    type: "button",
    ref,
    __staticSelector: "FileInput",
    rightSection: _rightSection,
    classNames: __spreadProps(__spreadValues({}, classNames), { input: cx(classes.input, classNames == null ? void 0 : classNames.input) })
  }), !hasValue ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Input_Input_js__WEBPACK_IMPORTED_MODULE_6__.Input.Placeholder, {
    className: classes.placeholder
  }, placeholder) : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ValueComponent, {
    value: _value
  }))));
});
_FileInput.displayName = "@mantine/core/FileInput";
const FileInput = _FileInput;




/***/ }),

/***/ "./node_modules/@mantine/core/esm/FileInput/FileInput.styles.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/FileInput/FileInput.styles.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)(() => ({
  placeholder: {},
  input: {
    cursor: "pointer"
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Flex/Flex.js":
/*!*****************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Flex/Flex.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Flex": () => (/* binding */ Flex)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/pack-sx/pack-sx.js");
/* harmony import */ var _flex_props_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./flex-props.js */ "./node_modules/@mantine/core/esm/Flex/flex-props.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");
/* harmony import */ var _Box_style_system_props_get_system_styles_get_system_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box/style-system-props/get-system-styles/get-system-styles.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/get-system-styles/get-system-styles.js");







var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {};
const Flex = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Flex", defaultProps, props), { gap, rowGap, columnGap, align, justify, wrap, direction, sx } = _a, others = __objRest(_a, ["gap", "rowGap", "columnGap", "align", "justify", "wrap", "direction", "sx"]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_2__.Box, __spreadProps(__spreadValues({}, others), {
    sx: [
      { display: "flex" },
      (theme) => (0,_Box_style_system_props_get_system_styles_get_system_styles_js__WEBPACK_IMPORTED_MODULE_3__.getSystemStyles)({ gap, rowGap, columnGap, align, justify, wrap, direction }, theme, _flex_props_js__WEBPACK_IMPORTED_MODULE_4__.FLEX_SYSTEM_PROPS),
      ...(0,_mantine_utils__WEBPACK_IMPORTED_MODULE_5__.packSx)(sx)
    ],
    ref
  }));
});
Flex.displayName = "@mantine/core/Flex";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Flex/flex-props.js":
/*!***********************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Flex/flex-props.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FLEX_SYSTEM_PROPS": () => (/* binding */ FLEX_SYSTEM_PROPS)
/* harmony export */ });
const FLEX_SYSTEM_PROPS = {
  gap: { type: "spacing", property: "gap" },
  rowGap: { type: "spacing", property: "rowGap" },
  columnGap: { type: "spacing", property: "columnGap" },
  align: { type: "identity", property: "alignItems" },
  justify: { type: "identity", property: "justifyContent" },
  wrap: { type: "identity", property: "flexWrap" },
  direction: { type: "identity", property: "flexDirection" }
};




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Floating/FloatingArrow/FloatingArrow.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Floating/FloatingArrow/FloatingArrow.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FloatingArrow": () => (/* binding */ FloatingArrow)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _get_arrow_position_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./get-arrow-position-styles.js */ "./node_modules/@mantine/core/esm/Floating/FloatingArrow/get-arrow-position-styles.js");




var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const FloatingArrow = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((_a, ref) => {
  var _b = _a, {
    position,
    arrowSize,
    arrowOffset,
    arrowRadius,
    arrowPosition,
    visible,
    arrowX,
    arrowY
  } = _b, others = __objRest(_b, [
    "position",
    "arrowSize",
    "arrowOffset",
    "arrowRadius",
    "arrowPosition",
    "visible",
    "arrowX",
    "arrowY"
  ]);
  const theme = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useMantineTheme)();
  if (!visible) {
    return null;
  }
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", __spreadProps(__spreadValues({}, others), {
    ref,
    style: (0,_get_arrow_position_styles_js__WEBPACK_IMPORTED_MODULE_2__.getArrowPositionStyles)({
      position,
      arrowSize,
      arrowOffset,
      arrowRadius,
      arrowPosition,
      dir: theme.dir,
      arrowX,
      arrowY
    })
  }));
});
FloatingArrow.displayName = "@mantine/core/FloatingArrow";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Floating/FloatingArrow/get-arrow-position-styles.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Floating/FloatingArrow/get-arrow-position-styles.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getArrowPositionStyles": () => (/* binding */ getArrowPositionStyles)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
function horizontalSide(placement, arrowY, arrowOffset, arrowPosition) {
  if (placement === "center" || arrowPosition === "center") {
    return { top: arrowY };
  }
  if (placement === "end") {
    return { bottom: arrowOffset };
  }
  if (placement === "start") {
    return { top: arrowOffset };
  }
  return {};
}
function verticalSide(placement, arrowX, arrowOffset, arrowPosition, dir) {
  if (placement === "center" || arrowPosition === "center") {
    return { left: arrowX };
  }
  if (placement === "end") {
    return { [dir === "ltr" ? "right" : "left"]: arrowOffset };
  }
  if (placement === "start") {
    return { [dir === "ltr" ? "left" : "right"]: arrowOffset };
  }
  return {};
}
const radiusByFloatingSide = {
  bottom: "borderTopLeftRadius",
  left: "borderTopRightRadius",
  right: "borderBottomLeftRadius",
  top: "borderBottomRightRadius"
};
function getArrowPositionStyles({
  position,
  arrowSize,
  arrowOffset,
  arrowRadius,
  arrowPosition,
  arrowX,
  arrowY,
  dir
}) {
  const [side, placement = "center"] = position.split("-");
  const baseStyles = {
    width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(arrowSize),
    height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(arrowSize),
    transform: "rotate(45deg)",
    position: "absolute",
    [radiusByFloatingSide[side]]: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(arrowRadius)
  };
  const arrowPlacement = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(-arrowSize / 2);
  if (side === "left") {
    return __spreadProps(__spreadValues(__spreadValues({}, baseStyles), horizontalSide(placement, arrowY, arrowOffset, arrowPosition)), {
      right: arrowPlacement,
      borderLeftColor: "transparent",
      borderBottomColor: "transparent"
    });
  }
  if (side === "right") {
    return __spreadProps(__spreadValues(__spreadValues({}, baseStyles), horizontalSide(placement, arrowY, arrowOffset, arrowPosition)), {
      left: arrowPlacement,
      borderRightColor: "transparent",
      borderTopColor: "transparent"
    });
  }
  if (side === "top") {
    return __spreadProps(__spreadValues(__spreadValues({}, baseStyles), verticalSide(placement, arrowX, arrowOffset, arrowPosition, dir)), {
      bottom: arrowPlacement,
      borderTopColor: "transparent",
      borderLeftColor: "transparent"
    });
  }
  if (side === "bottom") {
    return __spreadProps(__spreadValues(__spreadValues({}, baseStyles), verticalSide(placement, arrowX, arrowOffset, arrowPosition, dir)), {
      top: arrowPlacement,
      borderBottomColor: "transparent",
      borderRightColor: "transparent"
    });
  }
  return {};
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Floating/get-floating-position/get-floating-position.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Floating/get-floating-position/get-floating-position.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getFloatingPosition": () => (/* binding */ getFloatingPosition)
/* harmony export */ });
function getFloatingPosition(dir, position) {
  if (dir === "rtl" && (position.includes("right") || position.includes("left"))) {
    const [side, placement] = position.split("-");
    const flippedPosition = side === "right" ? "left" : "right";
    return placement === void 0 ? flippedPosition : `${flippedPosition}-${placement}`;
  }
  return position;
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Floating/use-delayed-hover.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Floating/use-delayed-hover.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useDelayedHover": () => (/* binding */ useDelayedHover)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


function useDelayedHover({ open, close, openDelay, closeDelay }) {
  const openTimeout = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(-1);
  const closeTimeout = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(-1);
  const clearTimeouts = () => {
    window.clearTimeout(openTimeout.current);
    window.clearTimeout(closeTimeout.current);
  };
  const openDropdown = () => {
    clearTimeouts();
    if (openDelay === 0) {
      open();
    } else {
      openTimeout.current = window.setTimeout(open, openDelay);
    }
  };
  const closeDropdown = () => {
    clearTimeouts();
    if (closeDelay === 0) {
      close();
    } else {
      closeTimeout.current = window.setTimeout(close, closeDelay);
    }
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => clearTimeouts, []);
  return { openDropdown, closeDropdown };
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Floating/use-floating-auto-update.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Floating/use-floating-auto-update.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useFloatingAutoUpdate": () => (/* binding */ useFloatingAutoUpdate)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _floating_ui_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @floating-ui/react */ "./node_modules/@floating-ui/dom/dist/floating-ui.dom.browser.mjs");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-did-update/use-did-update.js");




function useFloatingAutoUpdate({
  opened,
  floating,
  position,
  positionDependencies
}) {
  const [delayedUpdate, setDelayedUpdate] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (floating.refs.reference.current && floating.refs.floating.current) {
      return (0,_floating_ui_react__WEBPACK_IMPORTED_MODULE_1__.autoUpdate)(floating.refs.reference.current, floating.refs.floating.current, floating.update);
    }
    return void 0;
  }, [
    floating.refs.reference.current,
    floating.refs.floating.current,
    opened,
    delayedUpdate,
    position
  ]);
  (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.useDidUpdate)(() => {
    floating.update();
  }, positionDependencies);
  (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.useDidUpdate)(() => {
    setDelayedUpdate((c) => c + 1);
  }, [opened]);
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/FocusTrap/FocusTrap.js":
/*!***************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/FocusTrap/FocusTrap.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FocusTrap": () => (/* binding */ FocusTrap)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/is-element/is-element.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-focus-trap/use-focus-trap.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-merged-ref/use-merged-ref.js");




function FocusTrap({
  children,
  active = true,
  refProp = "ref"
}) {
  const focusTrapRef = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_1__.useFocusTrap)(active);
  const ref = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.useMergedRef)(focusTrapRef, children == null ? void 0 : children.ref);
  if (!(0,_mantine_utils__WEBPACK_IMPORTED_MODULE_3__.isElement)(children)) {
    return children;
  }
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(children, { [refProp]: ref });
}
FocusTrap.displayName = "@mantine/core/FocusTrap";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Grid/Col/Col.js":
/*!********************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Grid/Col/Col.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Col": () => (/* binding */ Col)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _Grid_context_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Grid.context.js */ "./node_modules/@mantine/core/esm/Grid/Grid.context.js");
/* harmony import */ var _Col_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Col.styles.js */ "./node_modules/@mantine/core/esm/Grid/Col/Col.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {};
function isValidSpan(span) {
  if (span === "auto" || span === "content") {
    return true;
  }
  return typeof span === "number" && span > 0 && span % 1 === 0;
}
const Col = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("GridCol", defaultProps, props), {
    children,
    span,
    offset,
    offsetXs,
    offsetSm,
    offsetMd,
    offsetLg,
    offsetXl,
    xs,
    sm,
    md,
    lg,
    xl,
    order,
    orderXs,
    orderSm,
    orderMd,
    orderLg,
    orderXl,
    className,
    id,
    unstyled,
    variant
  } = _a, others = __objRest(_a, [
    "children",
    "span",
    "offset",
    "offsetXs",
    "offsetSm",
    "offsetMd",
    "offsetLg",
    "offsetXl",
    "xs",
    "sm",
    "md",
    "lg",
    "xl",
    "order",
    "orderXs",
    "orderSm",
    "orderMd",
    "orderLg",
    "orderXl",
    "className",
    "id",
    "unstyled",
    "variant"
  ]);
  const ctx = (0,_Grid_context_js__WEBPACK_IMPORTED_MODULE_2__.useGridContext)();
  const colSpan = span || ctx.columns;
  const { classes, cx } = (0,_Col_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
    gutter: ctx.gutter,
    gutterXs: ctx.gutterXs,
    gutterSm: ctx.gutterSm,
    gutterMd: ctx.gutterMd,
    gutterLg: ctx.gutterLg,
    gutterXl: ctx.gutterXl,
    offset,
    offsetXs,
    offsetSm,
    offsetMd,
    offsetLg,
    offsetXl,
    xs,
    sm,
    md,
    lg,
    xl,
    order,
    orderXs,
    orderSm,
    orderMd,
    orderLg,
    orderXl,
    grow: ctx.grow,
    columns: ctx.columns,
    span: colSpan
  }, { unstyled, name: "Grid", variant });
  if (!isValidSpan(colSpan) || colSpan > ctx.columns) {
    return null;
  }
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    className: cx(classes.col, className),
    ref
  }, others), children);
});
Col.displayName = "@mantine/core/Col";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Grid/Col/Col.styles.js":
/*!***************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Grid/Col/Col.styles.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/default-theme.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
const getColumnFlexBasis = (colSpan, columns) => {
  if (colSpan === "content") {
    return "auto";
  }
  if (colSpan === "auto") {
    return "0rem";
  }
  return colSpan ? `${100 / (columns / colSpan)}%` : void 0;
};
const getColumnMaxWidth = (colSpan, columns, grow) => {
  if (grow || colSpan === "auto" || colSpan === "content") {
    return "unset";
  }
  return getColumnFlexBasis(colSpan, columns);
};
const getColumnFlexGrow = (colSpan, grow) => {
  if (!colSpan) {
    return void 0;
  }
  return colSpan === "auto" || grow ? 1 : 0;
};
const getColumnOffset = (offset, columns) => offset === 0 ? 0 : offset ? `${100 / (columns / offset)}%` : void 0;
const getGutterSize = (gutter, theme) => typeof gutter !== "undefined" ? `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.getSize)({ size: gutter, sizes: theme.spacing })} / 2)` : void 0;
function getBreakpointsStyles({
  sizes,
  offsets,
  orders,
  theme,
  columns,
  gutters,
  grow
}) {
  return _mantine_styles__WEBPACK_IMPORTED_MODULE_1__.MANTINE_SIZES.reduce((acc, size) => {
    acc[`@media (min-width: ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.em)(theme.breakpoints[size])})`] = {
      order: orders[size],
      flexBasis: getColumnFlexBasis(sizes[size], columns),
      padding: getGutterSize(gutters[size], theme),
      flexShrink: 0,
      width: sizes[size] === "content" ? "auto" : void 0,
      maxWidth: getColumnMaxWidth(sizes[size], columns, grow),
      marginLeft: getColumnOffset(offsets[size], columns),
      flexGrow: getColumnFlexGrow(sizes[size], grow)
    };
    return acc;
  }, {});
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.createStyles)((theme, {
  gutter,
  gutterXs,
  gutterSm,
  gutterMd,
  gutterLg,
  gutterXl,
  grow,
  offset,
  offsetXs,
  offsetSm,
  offsetMd,
  offsetLg,
  offsetXl,
  columns,
  span,
  xs,
  sm,
  md,
  lg,
  xl,
  order,
  orderXs,
  orderSm,
  orderMd,
  orderLg,
  orderXl
}) => ({
  col: __spreadValues({
    boxSizing: "border-box",
    flexGrow: getColumnFlexGrow(span, grow),
    order,
    padding: getGutterSize(gutter, theme),
    marginLeft: getColumnOffset(offset, columns),
    flexBasis: getColumnFlexBasis(span, columns),
    flexShrink: 0,
    width: span === "content" ? "auto" : void 0,
    maxWidth: getColumnMaxWidth(span, columns, grow)
  }, getBreakpointsStyles({
    sizes: { xs, sm, md, lg, xl },
    offsets: { xs: offsetXs, sm: offsetSm, md: offsetMd, lg: offsetLg, xl: offsetXl },
    orders: { xs: orderXs, sm: orderSm, md: orderMd, lg: orderLg, xl: orderXl },
    gutters: { xs: gutterXs, sm: gutterSm, md: gutterMd, lg: gutterLg, xl: gutterXl },
    theme,
    columns,
    grow
  }))
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Grid/Grid.context.js":
/*!*************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Grid/Grid.context.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GridProvider": () => (/* binding */ GridProvider),
/* harmony export */   "useGridContext": () => (/* binding */ useGridContext)
/* harmony export */ });
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-safe-context/create-safe-context.js");


const [GridProvider, useGridContext] = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_0__.createSafeContext)("Grid component was not found in tree");




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Grid/Grid.js":
/*!*****************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Grid/Grid.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Grid": () => (/* binding */ Grid)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _Col_Col_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Col/Col.js */ "./node_modules/@mantine/core/esm/Grid/Col/Col.js");
/* harmony import */ var _Grid_context_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Grid.context.js */ "./node_modules/@mantine/core/esm/Grid/Grid.context.js");
/* harmony import */ var _Grid_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Grid.styles.js */ "./node_modules/@mantine/core/esm/Grid/Grid.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");







var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  gutter: "md",
  justify: "flex-start",
  align: "stretch",
  columns: 12
};
const Grid = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Grid", defaultProps, props), {
    gutter,
    gutterXs,
    gutterSm,
    gutterMd,
    gutterLg,
    gutterXl,
    children,
    grow,
    justify,
    align,
    columns,
    className,
    id,
    unstyled,
    variant
  } = _a, others = __objRest(_a, [
    "gutter",
    "gutterXs",
    "gutterSm",
    "gutterMd",
    "gutterLg",
    "gutterXl",
    "children",
    "grow",
    "justify",
    "align",
    "columns",
    "className",
    "id",
    "unstyled",
    "variant"
  ]);
  const { classes, cx } = (0,_Grid_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ gutter, justify, align, gutterXs, gutterSm, gutterMd, gutterLg, gutterXl }, { unstyled, name: "Grid", variant });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Grid_context_js__WEBPACK_IMPORTED_MODULE_3__.GridProvider, {
    value: { gutter, gutterXs, gutterSm, gutterMd, gutterLg, gutterXl, grow, columns }
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    className: cx(classes.root, className),
    ref
  }, others), children));
});
Grid.Col = _Col_Col_js__WEBPACK_IMPORTED_MODULE_5__.Col;
Grid.displayName = "@mantine/core/Grid";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Grid/Grid.styles.js":
/*!************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Grid/Grid.styles.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/default-theme.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
function getGutterStyles(gutters, theme) {
  return _mantine_styles__WEBPACK_IMPORTED_MODULE_0__.MANTINE_SIZES.reduce((acc, size) => {
    if (typeof gutters[size] !== "undefined") {
      acc[`@media (min-width: ${theme.breakpoints[size]})`] = {
        margin: `calc(-${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size: gutters[size], sizes: theme.spacing })} / 2)`
      };
    }
    return acc;
  }, {});
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.createStyles)((theme, { justify, align, gutter, gutterXs, gutterSm, gutterMd, gutterLg, gutterXl }) => ({
  root: __spreadValues({
    margin: `calc(-${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size: gutter, sizes: theme.spacing })} / 2)`,
    display: "flex",
    flexWrap: "wrap",
    justifyContent: justify,
    alignItems: align
  }, getGutterStyles({ xs: gutterXs, sm: gutterSm, md: gutterMd, lg: gutterLg, xl: gutterXl }, theme))
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Group/Group.js":
/*!*******************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Group/Group.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Group": () => (/* binding */ Group)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _filter_falsy_children_filter_falsy_children_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./filter-falsy-children/filter-falsy-children.js */ "./node_modules/@mantine/core/esm/Group/filter-falsy-children/filter-falsy-children.js");
/* harmony import */ var _Group_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Group.styles.js */ "./node_modules/@mantine/core/esm/Group/Group.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  position: "left",
  spacing: "md"
};
const Group = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Group", defaultProps, props), {
    className,
    position,
    align,
    children,
    noWrap,
    grow,
    spacing,
    unstyled,
    variant
  } = _a, others = __objRest(_a, [
    "className",
    "position",
    "align",
    "children",
    "noWrap",
    "grow",
    "spacing",
    "unstyled",
    "variant"
  ]);
  const filteredChildren = (0,_filter_falsy_children_filter_falsy_children_js__WEBPACK_IMPORTED_MODULE_2__.filterFalsyChildren)(children);
  const { classes, cx } = (0,_Group_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
    align,
    grow,
    noWrap,
    spacing,
    position,
    count: filteredChildren.length
  }, { unstyled, name: "Group", variant });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    className: cx(classes.root, className),
    ref
  }, others), filteredChildren);
});
Group.displayName = "@mantine/core/Group";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Group/Group.styles.js":
/*!**************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Group/Group.styles.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GROUP_POSITIONS": () => (/* binding */ GROUP_POSITIONS),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


const GROUP_POSITIONS = {
  left: "flex-start",
  center: "center",
  right: "flex-end",
  apart: "space-between"
};
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { spacing, position, noWrap, grow, align, count }) => ({
  root: {
    boxSizing: "border-box",
    display: "flex",
    flexDirection: "row",
    alignItems: align || "center",
    flexWrap: noWrap ? "nowrap" : "wrap",
    justifyContent: GROUP_POSITIONS[position],
    gap: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size: spacing, sizes: theme.spacing }),
    "& > *": {
      boxSizing: "border-box",
      maxWidth: grow ? `calc(${100 / count}% - (${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)((0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size: spacing, sizes: theme.spacing }))} - ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size: spacing, sizes: theme.spacing })} / ${count}))` : void 0,
      flexGrow: grow ? 1 : 0
    }
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);



/***/ }),

/***/ "./node_modules/@mantine/core/esm/Group/filter-falsy-children/filter-falsy-children.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Group/filter-falsy-children/filter-falsy-children.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "filterFalsyChildren": () => (/* binding */ filterFalsyChildren)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


function filterFalsyChildren(children) {
  return react__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(children).filter(Boolean);
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Highlight/Highlight.js":
/*!***************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Highlight/Highlight.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Highlight": () => (/* binding */ Highlight),
/* harmony export */   "_Highlight": () => (/* binding */ _Highlight)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _Text_Text_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Text/Text.js */ "./node_modules/@mantine/core/esm/Text/Text.js");
/* harmony import */ var _Mark_Mark_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Mark/Mark.js */ "./node_modules/@mantine/core/esm/Mark/Mark.js");
/* harmony import */ var _highlighter_highlighter_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./highlighter/highlighter.js */ "./node_modules/@mantine/core/esm/Highlight/highlighter/highlighter.js");







var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  highlightColor: "yellow"
};
const _Highlight = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Highlight", defaultProps, props), { children, highlight, highlightColor, highlightStyles, unstyled } = _a, others = __objRest(_a, ["children", "highlight", "highlightColor", "highlightStyles", "unstyled"]);
  const highlightChunks = (0,_highlighter_highlighter_js__WEBPACK_IMPORTED_MODULE_2__.highlighter)(children, highlight);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Text_Text_js__WEBPACK_IMPORTED_MODULE_3__.Text, __spreadValues({
    unstyled,
    ref,
    __staticSelector: "Highlight"
  }, others), highlightChunks.map(({ chunk, highlighted }, i) => highlighted ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Mark_Mark_js__WEBPACK_IMPORTED_MODULE_4__.Mark, {
    unstyled,
    key: i,
    color: highlightColor,
    sx: highlightStyles,
    "data-highlight": chunk
  }, chunk) : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    key: i
  }, chunk)));
});
_Highlight.displayName = "@mantine/core/Highlight";
const Highlight = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_5__.createPolymorphicComponent)(_Highlight);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Highlight/highlighter/highlighter.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Highlight/highlighter/highlighter.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "highlighter": () => (/* binding */ highlighter)
/* harmony export */ });
function escapeRegex(value) {
  return value.replace(/[-[\]{}()*+?.,\\^$|#]/g, "\\$&");
}
function highlighter(value, _highlight) {
  if (_highlight == null) {
    return [{ chunk: value, highlighted: false }];
  }
  const highlight = Array.isArray(_highlight) ? _highlight.map(escapeRegex) : escapeRegex(_highlight);
  const shouldHighlight = Array.isArray(highlight) ? highlight.filter((part) => part.trim().length > 0).length > 0 : highlight.trim() !== "";
  if (!shouldHighlight) {
    return [{ chunk: value, highlighted: false }];
  }
  const matcher = typeof highlight === "string" ? highlight.trim() : highlight.filter((part) => part.trim().length !== 0).map((part) => part.trim()).join("|");
  const re = new RegExp(`(${matcher})`, "gi");
  const chunks = value.split(re).map((part) => ({ chunk: part, highlighted: re.test(part) })).filter(({ chunk }) => chunk);
  return chunks;
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/HoverCard/HoverCard.context.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/HoverCard/HoverCard.context.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HoverCardContextProvider": () => (/* binding */ HoverCardContextProvider),
/* harmony export */   "useHoverCardContext": () => (/* binding */ useHoverCardContext)
/* harmony export */ });
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-safe-context/create-safe-context.js");
/* harmony import */ var _HoverCard_errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./HoverCard.errors.js */ "./node_modules/@mantine/core/esm/HoverCard/HoverCard.errors.js");



const [HoverCardContextProvider, useHoverCardContext] = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_0__.createSafeContext)(_HoverCard_errors_js__WEBPACK_IMPORTED_MODULE_1__.HOVER_CARD_ERRORS.context);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/HoverCard/HoverCard.errors.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/HoverCard/HoverCard.errors.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HOVER_CARD_ERRORS": () => (/* binding */ HOVER_CARD_ERRORS)
/* harmony export */ });
const HOVER_CARD_ERRORS = {
  context: "HoverCard component was not found in the tree",
  children: "HoverCard.Target component children should be an element or a component that accepts ref. Fragments, strings, numbers and other primitive values are not supported"
};




/***/ }),

/***/ "./node_modules/@mantine/core/esm/HoverCard/HoverCard.js":
/*!***************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/HoverCard/HoverCard.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HoverCard": () => (/* binding */ HoverCard)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-disclosure/use-disclosure.js");
/* harmony import */ var _HoverCard_context_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./HoverCard.context.js */ "./node_modules/@mantine/core/esm/HoverCard/HoverCard.context.js");
/* harmony import */ var _HoverCardDropdown_HoverCardDropdown_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./HoverCardDropdown/HoverCardDropdown.js */ "./node_modules/@mantine/core/esm/HoverCard/HoverCardDropdown/HoverCardDropdown.js");
/* harmony import */ var _HoverCardTarget_HoverCardTarget_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./HoverCardTarget/HoverCardTarget.js */ "./node_modules/@mantine/core/esm/HoverCard/HoverCardTarget/HoverCardTarget.js");
/* harmony import */ var _Floating_use_delayed_hover_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Floating/use-delayed-hover.js */ "./node_modules/@mantine/core/esm/Floating/use-delayed-hover.js");
/* harmony import */ var _Popover_Popover_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Popover/Popover.js */ "./node_modules/@mantine/core/esm/Popover/Popover.js");









var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  openDelay: 0,
  closeDelay: 150,
  initiallyOpened: false
};
function HoverCard(props) {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("HoverCard", defaultProps, props), { children, onOpen, onClose, openDelay, closeDelay, initiallyOpened } = _a, others = __objRest(_a, ["children", "onOpen", "onClose", "openDelay", "closeDelay", "initiallyOpened"]);
  const [opened, { open, close }] = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_2__.useDisclosure)(initiallyOpened, { onClose, onOpen });
  const { openDropdown, closeDropdown } = (0,_Floating_use_delayed_hover_js__WEBPACK_IMPORTED_MODULE_3__.useDelayedHover)({ open, close, openDelay, closeDelay });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_HoverCard_context_js__WEBPACK_IMPORTED_MODULE_4__.HoverCardContextProvider, {
    value: { openDropdown, closeDropdown }
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Popover_Popover_js__WEBPACK_IMPORTED_MODULE_5__.Popover, __spreadValues({
    opened,
    __staticSelector: "HoverCard"
  }, others), children));
}
HoverCard.displayName = "@mantine/core/HoverCard";
HoverCard.Target = _HoverCardTarget_HoverCardTarget_js__WEBPACK_IMPORTED_MODULE_6__.HoverCardTarget;
HoverCard.Dropdown = _HoverCardDropdown_HoverCardDropdown_js__WEBPACK_IMPORTED_MODULE_7__.HoverCardDropdown;




/***/ }),

/***/ "./node_modules/@mantine/core/esm/HoverCard/HoverCardDropdown/HoverCardDropdown.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/HoverCard/HoverCardDropdown/HoverCardDropdown.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HoverCardDropdown": () => (/* binding */ HoverCardDropdown)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-event-handler/create-event-handler.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _HoverCard_context_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../HoverCard.context.js */ "./node_modules/@mantine/core/esm/HoverCard/HoverCard.context.js");
/* harmony import */ var _Popover_Popover_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Popover/Popover.js */ "./node_modules/@mantine/core/esm/Popover/Popover.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {};
function HoverCardDropdown(props) {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("HoverCardDropdown", defaultProps, props), { children, onMouseEnter, onMouseLeave } = _a, others = __objRest(_a, ["children", "onMouseEnter", "onMouseLeave"]);
  const ctx = (0,_HoverCard_context_js__WEBPACK_IMPORTED_MODULE_2__.useHoverCardContext)();
  const handleMouseEnter = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_3__.createEventHandler)(onMouseEnter, ctx.openDropdown);
  const handleMouseLeave = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_3__.createEventHandler)(onMouseLeave, ctx.closeDropdown);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Popover_Popover_js__WEBPACK_IMPORTED_MODULE_4__.Popover.Dropdown, __spreadValues({
    onMouseEnter: handleMouseEnter,
    onMouseLeave: handleMouseLeave
  }, others), children);
}
HoverCardDropdown.displayName = "@mantine/core/HoverCardDropdown";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/HoverCard/HoverCardTarget/HoverCardTarget.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/HoverCard/HoverCardTarget/HoverCardTarget.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HoverCardTarget": () => (/* binding */ HoverCardTarget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/is-element/is-element.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-event-handler/create-event-handler.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _HoverCard_context_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../HoverCard.context.js */ "./node_modules/@mantine/core/esm/HoverCard/HoverCard.context.js");
/* harmony import */ var _HoverCard_errors_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../HoverCard.errors.js */ "./node_modules/@mantine/core/esm/HoverCard/HoverCard.errors.js");
/* harmony import */ var _Popover_Popover_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../Popover/Popover.js */ "./node_modules/@mantine/core/esm/Popover/Popover.js");







var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  refProp: "ref"
};
const HoverCardTarget = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("HoverCardTarget", defaultProps, props), { children, refProp } = _a, others = __objRest(_a, ["children", "refProp"]);
  if (!(0,_mantine_utils__WEBPACK_IMPORTED_MODULE_2__.isElement)(children)) {
    throw new Error(_HoverCard_errors_js__WEBPACK_IMPORTED_MODULE_3__.HOVER_CARD_ERRORS.children);
  }
  const ctx = (0,_HoverCard_context_js__WEBPACK_IMPORTED_MODULE_4__.useHoverCardContext)();
  const onMouseEnter = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_5__.createEventHandler)(children.props.onMouseEnter, ctx.openDropdown);
  const onMouseLeave = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_5__.createEventHandler)(children.props.onMouseLeave, ctx.closeDropdown);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Popover_Popover_js__WEBPACK_IMPORTED_MODULE_6__.Popover.Target, __spreadValues({
    refProp,
    ref
  }, others), (0,react__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(children, { onMouseEnter, onMouseLeave }));
});
HoverCardTarget.displayName = "@mantine/core/HoverCardTarget";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Image/Image.js":
/*!*******************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Image/Image.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Image": () => (/* binding */ Image)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-did-update/use-did-update.js");
/* harmony import */ var _ImageIcon_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ImageIcon.js */ "./node_modules/@mantine/core/esm/Image/ImageIcon.js");
/* harmony import */ var _Image_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Image.styles.js */ "./node_modules/@mantine/core/esm/Image/Image.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");
/* harmony import */ var _Text_Text_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Text/Text.js */ "./node_modules/@mantine/core/esm/Text/Text.js");








var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  fit: "cover",
  width: "100%",
  height: "auto",
  radius: 0
};
const Image = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Image", defaultProps, props), {
    className,
    alt,
    src,
    fit,
    width,
    height,
    radius,
    imageProps,
    withPlaceholder,
    placeholder,
    imageRef,
    classNames,
    styles,
    caption,
    unstyled,
    style,
    variant
  } = _a, others = __objRest(_a, [
    "className",
    "alt",
    "src",
    "fit",
    "width",
    "height",
    "radius",
    "imageProps",
    "withPlaceholder",
    "placeholder",
    "imageRef",
    "classNames",
    "styles",
    "caption",
    "unstyled",
    "style",
    "variant"
  ]);
  const { classes, cx } = (0,_Image_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ radius }, { classNames, styles, unstyled, name: "Image", variant });
  const [error, setError] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(!src);
  const isPlaceholder = withPlaceholder && error;
  (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_3__.useDidUpdate)(() => {
    setError(!src);
  }, [src]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    className: cx(classes.root, className),
    style: __spreadValues({ width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.rem)(width) }, style),
    ref
  }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("figure", {
    className: classes.figure
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.imageWrapper
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("img", __spreadProps(__spreadValues({
    src,
    alt,
    ref: imageRef
  }, imageProps), {
    className: cx(classes.image, imageProps == null ? void 0 : imageProps.className),
    onError: (event) => {
      setError(true);
      typeof (imageProps == null ? void 0 : imageProps.onError) === "function" && imageProps.onError(event);
    },
    style: __spreadValues({ objectFit: fit, width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.rem)(width), height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.rem)(height) }, imageProps == null ? void 0 : imageProps.style)
  })), isPlaceholder && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.placeholder,
    title: alt
  }, placeholder || /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ImageIcon_js__WEBPACK_IMPORTED_MODULE_6__.ImageIcon, {
    width: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.rem)(40),
    height: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.rem)(40)
  })))), !!caption && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Text_Text_js__WEBPACK_IMPORTED_MODULE_7__.Text, {
    component: "figcaption",
    size: "sm",
    align: "center",
    className: classes.caption
  }, caption)));
});
Image.displayName = "@mantine/core/Image";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Image/Image.styles.js":
/*!**************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Image/Image.styles.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { radius }) => ({
  root: {},
  imageWrapper: {
    position: "relative"
  },
  figure: {
    margin: 0
  },
  image: __spreadProps(__spreadValues({}, theme.fn.fontStyles()), {
    display: "block",
    width: "100%",
    height: "100%",
    border: 0,
    borderRadius: theme.fn.radius(radius)
  }),
  caption: {
    color: theme.colorScheme === "dark" ? theme.colors.dark[2] : theme.colors.gray[7],
    marginTop: theme.spacing.xs
  },
  placeholder: __spreadProps(__spreadValues({}, theme.fn.cover()), {
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    color: theme.colorScheme === "dark" ? theme.colors.dark[2] : theme.colors.gray[6],
    backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[8] : theme.colors.gray[0],
    borderRadius: theme.fn.radius(radius)
  })
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Image/ImageIcon.js":
/*!***********************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Image/ImageIcon.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ImageIcon": () => (/* binding */ ImageIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
function ImageIcon(props) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __spreadValues({
    viewBox: "0 0 15 15",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    d: "M2.5 1H12.5C13.3284 1 14 1.67157 14 2.5V12.5C14 13.3284 13.3284 14 12.5 14H2.5C1.67157 14 1 13.3284 1 12.5V2.5C1 1.67157 1.67157 1 2.5 1ZM2.5 2C2.22386 2 2 2.22386 2 2.5V8.3636L3.6818 6.6818C3.76809 6.59551 3.88572 6.54797 4.00774 6.55007C4.12975 6.55216 4.24568 6.60372 4.32895 6.69293L7.87355 10.4901L10.6818 7.6818C10.8575 7.50607 11.1425 7.50607 11.3182 7.6818L13 9.3636V2.5C13 2.22386 12.7761 2 12.5 2H2.5ZM2 12.5V9.6364L3.98887 7.64753L7.5311 11.4421L8.94113 13H2.5C2.22386 13 2 12.7761 2 12.5ZM12.5 13H10.155L8.48336 11.153L11 8.6364L13 10.6364V12.5C13 12.7761 12.7761 13 12.5 13ZM6.64922 5.5C6.64922 5.03013 7.03013 4.64922 7.5 4.64922C7.96987 4.64922 8.35078 5.03013 8.35078 5.5C8.35078 5.96987 7.96987 6.35078 7.5 6.35078C7.03013 6.35078 6.64922 5.96987 6.64922 5.5ZM7.5 3.74922C6.53307 3.74922 5.74922 4.53307 5.74922 5.5C5.74922 6.46693 6.53307 7.25078 7.5 7.25078C8.46693 7.25078 9.25078 6.46693 9.25078 5.5C9.25078 4.53307 8.46693 3.74922 7.5 3.74922Z",
    fill: "currentColor",
    fillRule: "evenodd",
    clipRule: "evenodd"
  }));
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Indicator/Indicator.js":
/*!***************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Indicator/Indicator.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Indicator": () => (/* binding */ Indicator)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-default-z-index/get-default-z-index.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _Indicator_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Indicator.styles.js */ "./node_modules/@mantine/core/esm/Indicator/Indicator.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  position: "top-end",
  offset: 0,
  inline: false,
  withBorder: false,
  disabled: false,
  processing: false,
  size: 10,
  radius: 1e3,
  zIndex: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getDefaultZIndex)("app")
};
const Indicator = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.useComponentDefaultProps)("Indicator", defaultProps, props), {
    children,
    position,
    offset,
    size,
    radius,
    inline,
    withBorder,
    className,
    color,
    styles,
    label,
    classNames,
    disabled,
    zIndex,
    unstyled,
    processing,
    variant
  } = _a, others = __objRest(_a, [
    "children",
    "position",
    "offset",
    "size",
    "radius",
    "inline",
    "withBorder",
    "className",
    "color",
    "styles",
    "label",
    "classNames",
    "disabled",
    "zIndex",
    "unstyled",
    "processing",
    "variant"
  ]);
  const { classes, cx } = (0,_Indicator_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])({ position, offset, radius, inline, color, withBorder, zIndex, withLabel: !!label }, { name: "Indicator", classNames, styles, unstyled, variant, size });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    ref,
    className: cx(classes.root, className)
  }, others), !disabled && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: cx(classes.indicator, classes.common)
  }, label), processing && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: cx(classes.processing, classes.common)
  })), children);
});
Indicator.displayName = "@mantine/core/Indicator";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Indicator/Indicator.styles.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Indicator/Indicator.styles.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@emotion/react/dist/emotion-react.browser.esm.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const processingAnimation = (color) => (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.keyframes)({
  from: {
    boxShadow: `0 0 ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(0.5)} 0 ${color}`,
    opacity: 0.6
  },
  to: {
    boxShadow: `0 0 ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(0.5)} ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(4.4)} ${color}`,
    opacity: 0
  }
});
function getPositionStyles(_position, offset = 0) {
  const styles = {};
  const [position, placement] = _position.split("-");
  let translateX = "";
  let translateY = "";
  if (position === "top") {
    styles.top = offset;
    translateY = "-50%";
  }
  if (position === "middle") {
    styles.top = "50%";
    translateY = "-50%";
  }
  if (position === "bottom") {
    styles.bottom = offset;
    translateY = "50%";
  }
  if (placement === "start") {
    styles.left = offset;
    translateX = "-50%";
  }
  if (placement === "center") {
    styles.left = "50%";
    translateX = "-50%";
  }
  if (placement === "end") {
    styles.right = offset;
    translateX = "50%";
  }
  styles.transform = `translate(${translateX}, ${translateY})`;
  return styles;
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.createStyles)((theme, {
  radius,
  color,
  position,
  offset,
  inline,
  withBorder,
  withLabel,
  zIndex
}, { size }) => {
  const { background } = theme.fn.variant({
    variant: "filled",
    primaryFallback: false,
    color: color || theme.primaryColor
  });
  const _size = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(size);
  return {
    root: {
      position: "relative",
      display: inline ? "inline-block" : "block"
    },
    indicator: __spreadProps(__spreadValues({}, getPositionStyles(position, offset)), {
      zIndex,
      position: "absolute",
      [withLabel ? "minWidth" : "width"]: _size,
      height: _size,
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      fontSize: theme.fontSizes.xs,
      paddingLeft: withLabel ? `calc(${theme.spacing.xs} / 2)` : 0,
      paddingRight: withLabel ? `calc(${theme.spacing.xs} / 2)` : 0,
      borderRadius: theme.fn.radius(radius),
      backgroundColor: theme.fn.variant({
        variant: "filled",
        primaryFallback: false,
        color: color || theme.primaryColor
      }).background,
      border: withBorder ? `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(2)} solid ${theme.colorScheme === "dark" ? theme.colors.dark[7] : theme.white}` : void 0,
      color: theme.white,
      whiteSpace: "nowrap"
    }),
    processing: {
      animation: `${processingAnimation(background)} 1000ms linear infinite`
    },
    common: __spreadProps(__spreadValues({}, getPositionStyles(position, offset)), {
      position: "absolute",
      [withLabel ? "minWidth" : "width"]: _size,
      height: _size,
      borderRadius: theme.fn.radius(radius)
    })
  };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/InlineInput/InlineInput.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/InlineInput/InlineInput.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InlineInput": () => (/* binding */ InlineInput)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _InlineInput_styles_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./InlineInput.styles.js */ "./node_modules/@mantine/core/esm/InlineInput/InlineInput.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");
/* harmony import */ var _Input_Input_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Input/Input.js */ "./node_modules/@mantine/core/esm/Input/Input.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const InlineInput = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((_a, ref) => {
  var _b = _a, {
    __staticSelector,
    className,
    classNames,
    styles,
    unstyled,
    children,
    label,
    description,
    id,
    disabled,
    error,
    size,
    labelPosition,
    variant
  } = _b, others = __objRest(_b, [
    "__staticSelector",
    "className",
    "classNames",
    "styles",
    "unstyled",
    "children",
    "label",
    "description",
    "id",
    "disabled",
    "error",
    "size",
    "labelPosition",
    "variant"
  ]);
  const { classes, cx } = (0,_InlineInput_styles_js__WEBPACK_IMPORTED_MODULE_1__["default"])({ labelPosition }, { name: __staticSelector, styles, classNames, unstyled, variant, size });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_2__.Box, __spreadValues({
    className: cx(classes.root, className),
    ref
  }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: cx(classes.body)
  }, children, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.labelWrapper
  }, label && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", {
    className: classes.label,
    "data-disabled": disabled || void 0,
    htmlFor: id
  }, label), description && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Input_Input_js__WEBPACK_IMPORTED_MODULE_3__.Input.Description, {
    className: classes.description
  }, description), error && error !== "boolean" && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Input_Input_js__WEBPACK_IMPORTED_MODULE_3__.Input.Error, {
    className: classes.error
  }, error))));
});
InlineInput.displayName = "@mantine/core/InlineInput";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/InlineInput/InlineInput.styles.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/InlineInput/InlineInput.styles.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const sizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(16),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(20),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(24),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(30),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(36)
};
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.createStyles)((theme, { labelPosition }, { size }) => ({
  root: {},
  body: {
    display: "flex"
  },
  labelWrapper: __spreadProps(__spreadValues({}, theme.fn.fontStyles()), {
    display: "inline-flex",
    flexDirection: "column",
    WebkitTapHighlightColor: "transparent",
    fontSize: size in sizes ? (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes: theme.fontSizes }) : void 0,
    lineHeight: size in sizes ? (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes }) : void 0,
    color: theme.colorScheme === "dark" ? theme.colors.dark[0] : theme.black,
    cursor: theme.cursorType,
    order: labelPosition === "left" ? 1 : 2
  }),
  description: {
    marginTop: `calc(${theme.spacing.xs} / 2)`,
    [labelPosition === "left" ? "paddingRight" : "paddingLeft"]: theme.spacing.sm
  },
  error: {
    marginTop: `calc(${theme.spacing.xs} / 2)`,
    [labelPosition === "left" ? "paddingRight" : "paddingLeft"]: theme.spacing.sm
  },
  label: {
    cursor: theme.cursorType,
    [labelPosition === "left" ? "paddingRight" : "paddingLeft"]: theme.spacing.sm,
    "&[data-disabled]": {
      color: theme.colorScheme === "dark" ? theme.colors.dark[3] : theme.colors.gray[5]
    }
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Input/Input.js":
/*!*******************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Input/Input.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Input": () => (/* binding */ Input),
/* harmony export */   "_Input": () => (/* binding */ _Input)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _InputWrapper_InputWrapper_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./InputWrapper/InputWrapper.js */ "./node_modules/@mantine/core/esm/Input/InputWrapper/InputWrapper.js");
/* harmony import */ var _InputDescription_InputDescription_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./InputDescription/InputDescription.js */ "./node_modules/@mantine/core/esm/Input/InputDescription/InputDescription.js");
/* harmony import */ var _InputLabel_InputLabel_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./InputLabel/InputLabel.js */ "./node_modules/@mantine/core/esm/Input/InputLabel/InputLabel.js");
/* harmony import */ var _InputError_InputError_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./InputError/InputError.js */ "./node_modules/@mantine/core/esm/Input/InputError/InputError.js");
/* harmony import */ var _InputPlaceholder_InputPlaceholder_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./InputPlaceholder/InputPlaceholder.js */ "./node_modules/@mantine/core/esm/Input/InputPlaceholder/InputPlaceholder.js");
/* harmony import */ var _InputWrapper_context_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InputWrapper.context.js */ "./node_modules/@mantine/core/esm/Input/InputWrapper.context.js");
/* harmony import */ var _Input_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Input.styles.js */ "./node_modules/@mantine/core/esm/Input/Input.styles.js");
/* harmony import */ var _Box_style_system_props_extract_system_styles_extract_system_styles_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box/style-system-props/extract-system-styles/extract-system-styles.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/extract-system-styles/extract-system-styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");













var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  size: "sm",
  variant: "default"
};
const _Input = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Input", defaultProps, props), {
    className,
    error,
    required,
    disabled,
    variant,
    icon,
    style,
    rightSectionWidth,
    iconWidth,
    rightSection,
    rightSectionProps,
    radius,
    size,
    wrapperProps,
    classNames,
    styles,
    __staticSelector,
    multiline,
    sx,
    unstyled,
    pointer
  } = _a, others = __objRest(_a, [
    "className",
    "error",
    "required",
    "disabled",
    "variant",
    "icon",
    "style",
    "rightSectionWidth",
    "iconWidth",
    "rightSection",
    "rightSectionProps",
    "radius",
    "size",
    "wrapperProps",
    "classNames",
    "styles",
    "__staticSelector",
    "multiline",
    "sx",
    "unstyled",
    "pointer"
  ]);
  const { offsetBottom, offsetTop, describedBy } = (0,_InputWrapper_context_js__WEBPACK_IMPORTED_MODULE_2__.useInputWrapperContext)();
  const { classes, cx } = (0,_Input_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
    radius,
    multiline,
    invalid: !!error,
    rightSectionWidth: rightSectionWidth ? (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(rightSectionWidth) : void 0,
    iconWidth,
    withRightSection: !!rightSection,
    offsetBottom,
    offsetTop,
    pointer
  }, { classNames, styles, name: ["Input", __staticSelector], unstyled, variant, size });
  const { systemStyles, rest } = (0,_Box_style_system_props_extract_system_styles_extract_system_styles_js__WEBPACK_IMPORTED_MODULE_5__.extractSystemStyles)(others);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_6__.Box, __spreadValues(__spreadValues({
    className: cx(classes.wrapper, className),
    sx,
    style
  }, systemStyles), wrapperProps), icon && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.icon
  }, icon), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_6__.Box, __spreadProps(__spreadValues({
    component: "input"
  }, rest), {
    ref,
    required,
    "aria-invalid": !!error,
    "aria-describedby": describedBy,
    disabled,
    "data-disabled": disabled || void 0,
    "data-with-icon": !!icon || void 0,
    "data-invalid": !!error || void 0,
    className: classes.input
  })), rightSection && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", __spreadProps(__spreadValues({}, rightSectionProps), {
    className: classes.rightSection
  }), rightSection));
});
_Input.displayName = "@mantine/core/Input";
_Input.Wrapper = _InputWrapper_InputWrapper_js__WEBPACK_IMPORTED_MODULE_7__.InputWrapper;
_Input.Label = _InputLabel_InputLabel_js__WEBPACK_IMPORTED_MODULE_8__.InputLabel;
_Input.Description = _InputDescription_InputDescription_js__WEBPACK_IMPORTED_MODULE_9__.InputDescription;
_Input.Error = _InputError_InputError_js__WEBPACK_IMPORTED_MODULE_10__.InputError;
_Input.Placeholder = _InputPlaceholder_InputPlaceholder_js__WEBPACK_IMPORTED_MODULE_11__.InputPlaceholder;
const Input = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_12__.createPolymorphicComponent)(_Input);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Input/Input.styles.js":
/*!**************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Input/Input.styles.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "sizes": () => (/* binding */ sizes)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const sizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(30),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(36),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(42),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(50),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(60)
};
const INPUT_VARIANTS = ["default", "filled", "unstyled"];
function getVariantStyles({ theme, variant }) {
  if (!INPUT_VARIANTS.includes(variant)) {
    return null;
  }
  if (variant === "default") {
    return {
      border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)} solid ${theme.colorScheme === "dark" ? theme.colors.dark[4] : theme.colors.gray[4]}`,
      backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[6] : theme.white,
      transition: "border-color 100ms ease",
      "&:focus, &:focus-within": theme.focusRingStyles.inputStyles(theme)
    };
  }
  if (variant === "filled") {
    return {
      border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)} solid transparent`,
      backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[5] : theme.colors.gray[1],
      "&:focus, &:focus-within": theme.focusRingStyles.inputStyles(theme)
    };
  }
  return {
    borderWidth: 0,
    color: theme.colorScheme === "dark" ? theme.colors.dark[0] : theme.black,
    backgroundColor: "transparent",
    minHeight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(28),
    outline: 0,
    "&:focus, &:focus-within": {
      outline: "none",
      borderColor: "transparent"
    },
    "&:disabled": {
      backgroundColor: "transparent",
      "&:focus, &:focus-within": {
        outline: "none",
        borderColor: "transparent"
      }
    }
  };
}
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.createStyles)((theme, {
  multiline,
  radius,
  invalid,
  rightSectionWidth,
  withRightSection,
  iconWidth,
  offsetBottom,
  offsetTop,
  pointer
}, { variant, size }) => {
  const invalidColor = theme.fn.variant({
    variant: "filled",
    color: "red"
  }).background;
  const sizeStyles = variant === "default" || variant === "filled" ? {
    minHeight: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes }),
    paddingLeft: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes })}  / 3)`,
    paddingRight: withRightSection ? rightSectionWidth || (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes }) : `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes })}  / 3)`,
    borderRadius: theme.fn.radius(radius)
  } : variant === "unstyled" && withRightSection ? {
    paddingRight: rightSectionWidth || (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes })
  } : null;
  return {
    wrapper: {
      position: "relative",
      marginTop: offsetTop ? `calc(${theme.spacing.xs} / 2)` : void 0,
      marginBottom: offsetBottom ? `calc(${theme.spacing.xs} / 2)` : void 0
    },
    input: __spreadProps(__spreadValues(__spreadValues(__spreadProps(__spreadValues({}, theme.fn.fontStyles()), {
      height: multiline ? variant === "unstyled" ? void 0 : "auto" : (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes }),
      WebkitTapHighlightColor: "transparent",
      lineHeight: multiline ? theme.lineHeight : `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes })} - ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(2)})`,
      appearance: "none",
      resize: "none",
      boxSizing: "border-box",
      fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes: theme.fontSizes }),
      width: "100%",
      color: theme.colorScheme === "dark" ? theme.colors.dark[0] : theme.black,
      display: "block",
      textAlign: "left",
      cursor: pointer ? "pointer" : void 0
    }), getVariantStyles({ theme, variant })), sizeStyles), {
      "&:disabled, &[data-disabled]": {
        backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[6] : theme.colors.gray[1],
        color: theme.colors.dark[2],
        opacity: 0.6,
        cursor: "not-allowed",
        "&::placeholder": {
          color: theme.colors.dark[2]
        }
      },
      "&[data-invalid]": {
        color: invalidColor,
        borderColor: invalidColor,
        "&::placeholder": {
          opacity: 1,
          color: invalidColor
        }
      },
      "&[data-with-icon]": {
        paddingLeft: typeof iconWidth === "number" ? (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(iconWidth) : (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes })
      },
      "&::placeholder": __spreadProps(__spreadValues({}, theme.fn.placeholderStyles()), {
        opacity: 1
      }),
      "&::-webkit-inner-spin-button, &::-webkit-outer-spin-button, &::-webkit-search-decoration, &::-webkit-search-cancel-button, &::-webkit-search-results-button, &::-webkit-search-results-decoration": {
        appearance: "none"
      },
      "&[type=number]": {
        MozAppearance: "textfield"
      }
    }),
    icon: {
      pointerEvents: "none",
      position: "absolute",
      zIndex: 1,
      left: 0,
      top: 0,
      bottom: 0,
      display: "flex",
      alignItems: "center",
      justifyContent: "center",
      width: iconWidth ? (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(iconWidth) : (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes }),
      color: invalid ? theme.colors.red[theme.colorScheme === "dark" ? 6 : 7] : theme.colorScheme === "dark" ? theme.colors.dark[2] : theme.colors.gray[5]
    },
    rightSection: {
      position: "absolute",
      top: 0,
      bottom: 0,
      right: 0,
      display: "flex",
      alignItems: "center",
      justifyContent: "center",
      width: rightSectionWidth || (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size, sizes })
    }
  };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);



/***/ }),

/***/ "./node_modules/@mantine/core/esm/Input/InputDescription/InputDescription.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Input/InputDescription/InputDescription.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InputDescription": () => (/* binding */ InputDescription)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _InputDescription_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InputDescription.styles.js */ "./node_modules/@mantine/core/esm/Input/InputDescription/InputDescription.styles.js");
/* harmony import */ var _Text_Text_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Text/Text.js */ "./node_modules/@mantine/core/esm/Text/Text.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  size: "sm"
};
const InputDescription = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("InputDescription", defaultProps, props), {
    children,
    className,
    classNames,
    styles,
    unstyled,
    size,
    __staticSelector,
    variant
  } = _a, others = __objRest(_a, [
    "children",
    "className",
    "classNames",
    "styles",
    "unstyled",
    "size",
    "__staticSelector",
    "variant"
  ]);
  const { classes, cx } = (0,_InputDescription_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])(null, {
    name: ["InputWrapper", __staticSelector],
    classNames,
    styles,
    unstyled,
    variant,
    size
  });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Text_Text_js__WEBPACK_IMPORTED_MODULE_3__.Text, __spreadValues({
    color: "dimmed",
    className: cx(classes.description, className),
    ref,
    unstyled
  }, others), children);
});
InputDescription.displayName = "@mantine/core/InputDescription";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Input/InputDescription/InputDescription.styles.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Input/InputDescription/InputDescription.styles.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, _params, { size }) => ({
  description: {
    wordBreak: "break-word",
    color: theme.colorScheme === "dark" ? theme.colors.dark[2] : theme.colors.gray[6],
    fontSize: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size, sizes: theme.fontSizes })} - ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(2)})`,
    lineHeight: 1.2,
    display: "block"
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Input/InputError/InputError.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Input/InputError/InputError.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InputError": () => (/* binding */ InputError)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _InputError_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InputError.styles.js */ "./node_modules/@mantine/core/esm/Input/InputError/InputError.styles.js");
/* harmony import */ var _Text_Text_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Text/Text.js */ "./node_modules/@mantine/core/esm/Text/Text.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  size: "sm"
};
const InputError = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("InputError", defaultProps, props), {
    children,
    className,
    classNames,
    styles,
    unstyled,
    size,
    __staticSelector,
    variant
  } = _a, others = __objRest(_a, [
    "children",
    "className",
    "classNames",
    "styles",
    "unstyled",
    "size",
    "__staticSelector",
    "variant"
  ]);
  const { classes, cx } = (0,_InputError_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])(null, {
    name: ["InputWrapper", __staticSelector],
    classNames,
    styles,
    unstyled,
    variant,
    size
  });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Text_Text_js__WEBPACK_IMPORTED_MODULE_3__.Text, __spreadValues({
    className: cx(classes.error, className),
    ref
  }, others), children);
});
InputError.displayName = "@mantine/core/InputError";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Input/InputError/InputError.styles.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Input/InputError/InputError.styles.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, _params, { size }) => ({
  error: {
    wordBreak: "break-word",
    color: theme.fn.variant({ variant: "filled", color: "red" }).background,
    fontSize: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size, sizes: theme.fontSizes })} - ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(2)})`,
    lineHeight: 1.2,
    display: "block"
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Input/InputLabel/InputLabel.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Input/InputLabel/InputLabel.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InputLabel": () => (/* binding */ InputLabel)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _InputLabel_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InputLabel.styles.js */ "./node_modules/@mantine/core/esm/Input/InputLabel/InputLabel.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  labelElement: "label",
  size: "sm"
};
const InputLabel = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("InputLabel", defaultProps, props), {
    labelElement,
    children,
    required,
    size,
    classNames,
    styles,
    unstyled,
    className,
    htmlFor,
    __staticSelector,
    variant,
    onMouseDown
  } = _a, others = __objRest(_a, [
    "labelElement",
    "children",
    "required",
    "size",
    "classNames",
    "styles",
    "unstyled",
    "className",
    "htmlFor",
    "__staticSelector",
    "variant",
    "onMouseDown"
  ]);
  const { classes, cx } = (0,_InputLabel_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])(null, {
    name: ["InputWrapper", __staticSelector],
    classNames,
    styles,
    unstyled,
    variant,
    size
  });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_3__.Box, __spreadValues({
    component: labelElement,
    ref,
    className: cx(classes.label, className),
    htmlFor: labelElement === "label" ? htmlFor : void 0,
    onMouseDown: (event) => {
      onMouseDown == null ? void 0 : onMouseDown(event);
      if (!event.defaultPrevented && event.detail > 1) {
        event.preventDefault();
      }
    }
  }, others), children, required && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: classes.required,
    "aria-hidden": true
  }, " *"));
});
InputLabel.displayName = "@mantine/core/InputLabel";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Input/InputLabel/InputLabel.styles.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Input/InputLabel/InputLabel.styles.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, _params, { size }) => ({
  label: {
    display: "inline-block",
    fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size, sizes: theme.fontSizes }),
    fontWeight: 500,
    color: theme.colorScheme === "dark" ? theme.colors.dark[0] : theme.colors.gray[9],
    wordBreak: "break-word",
    cursor: "default",
    WebkitTapHighlightColor: "transparent"
  },
  required: {
    color: theme.fn.variant({ variant: "filled", color: "red" }).background
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Input/InputPlaceholder/InputPlaceholder.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Input/InputPlaceholder/InputPlaceholder.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InputPlaceholder": () => (/* binding */ InputPlaceholder)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/pack-sx/pack-sx.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {};
const InputPlaceholder = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("InputPlaceholder", defaultProps, props), { sx } = _a, others = __objRest(_a, ["sx"]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_2__.Box, __spreadValues({
    component: "span",
    sx: [(theme) => theme.fn.placeholderStyles(), ...(0,_mantine_utils__WEBPACK_IMPORTED_MODULE_3__.packSx)(sx)],
    ref
  }, others));
});
InputPlaceholder.displayName = "@mantine/core/InputPlaceholder";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Input/InputWrapper.context.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Input/InputWrapper.context.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InputWrapperProvider": () => (/* binding */ InputWrapperProvider),
/* harmony export */   "useInputWrapperContext": () => (/* binding */ useInputWrapperContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const InputWrapperContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({
  offsetBottom: false,
  offsetTop: false,
  describedBy: void 0
});
const InputWrapperProvider = InputWrapperContext.Provider;
const useInputWrapperContext = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(InputWrapperContext);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Input/InputWrapper/InputWrapper.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Input/InputWrapper/InputWrapper.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InputWrapper": () => (/* binding */ InputWrapper)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _InputLabel_InputLabel_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../InputLabel/InputLabel.js */ "./node_modules/@mantine/core/esm/Input/InputLabel/InputLabel.js");
/* harmony import */ var _InputError_InputError_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../InputError/InputError.js */ "./node_modules/@mantine/core/esm/Input/InputError/InputError.js");
/* harmony import */ var _InputDescription_InputDescription_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../InputDescription/InputDescription.js */ "./node_modules/@mantine/core/esm/Input/InputDescription/InputDescription.js");
/* harmony import */ var _InputWrapper_context_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../InputWrapper.context.js */ "./node_modules/@mantine/core/esm/Input/InputWrapper.context.js");
/* harmony import */ var _get_input_offsets_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./get-input-offsets.js */ "./node_modules/@mantine/core/esm/Input/InputWrapper/get-input-offsets.js");
/* harmony import */ var _InputWrapper_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InputWrapper.styles.js */ "./node_modules/@mantine/core/esm/Input/InputWrapper/InputWrapper.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");










var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  labelElement: "label",
  size: "sm",
  inputContainer: (children) => children,
  inputWrapperOrder: ["label", "description", "input", "error"]
};
const InputWrapper = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("InputWrapper", defaultProps, props), {
    className,
    label,
    children,
    required,
    id,
    error,
    description,
    labelElement,
    labelProps,
    descriptionProps,
    errorProps,
    classNames,
    styles,
    size,
    inputContainer,
    __staticSelector,
    unstyled,
    inputWrapperOrder,
    withAsterisk,
    variant
  } = _a, others = __objRest(_a, [
    "className",
    "label",
    "children",
    "required",
    "id",
    "error",
    "description",
    "labelElement",
    "labelProps",
    "descriptionProps",
    "errorProps",
    "classNames",
    "styles",
    "size",
    "inputContainer",
    "__staticSelector",
    "unstyled",
    "inputWrapperOrder",
    "withAsterisk",
    "variant"
  ]);
  const { classes, cx } = (0,_InputWrapper_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])(null, {
    classNames,
    styles,
    name: ["InputWrapper", __staticSelector],
    unstyled,
    variant,
    size
  });
  const sharedProps = {
    classNames,
    styles,
    unstyled,
    size,
    variant,
    __staticSelector
  };
  const isRequired = typeof withAsterisk === "boolean" ? withAsterisk : required;
  const errorId = id ? `${id}-error` : errorProps == null ? void 0 : errorProps.id;
  const descriptionId = id ? `${id}-description` : descriptionProps == null ? void 0 : descriptionProps.id;
  const hasError = !!error && typeof error !== "boolean";
  const _describedBy = `${hasError ? errorId : ""} ${description ? descriptionId : ""}`;
  const describedBy = _describedBy.trim().length > 0 ? _describedBy.trim() : void 0;
  const _label = label && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_InputLabel_InputLabel_js__WEBPACK_IMPORTED_MODULE_3__.InputLabel, __spreadValues(__spreadValues({
    key: "label",
    labelElement,
    id: id ? `${id}-label` : void 0,
    htmlFor: id,
    required: isRequired
  }, sharedProps), labelProps), label);
  const _description = description && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_InputDescription_InputDescription_js__WEBPACK_IMPORTED_MODULE_4__.InputDescription, __spreadProps(__spreadValues(__spreadValues({
    key: "description"
  }, descriptionProps), sharedProps), {
    size: (descriptionProps == null ? void 0 : descriptionProps.size) || sharedProps.size,
    id: (descriptionProps == null ? void 0 : descriptionProps.id) || descriptionId
  }), description);
  const _input = /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: "input"
  }, inputContainer(children));
  const _error = typeof error !== "boolean" && error && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_InputError_InputError_js__WEBPACK_IMPORTED_MODULE_5__.InputError, __spreadProps(__spreadValues(__spreadValues({}, errorProps), sharedProps), {
    size: (errorProps == null ? void 0 : errorProps.size) || sharedProps.size,
    key: "error",
    id: (errorProps == null ? void 0 : errorProps.id) || errorId
  }), error);
  const content = inputWrapperOrder.map((part) => {
    switch (part) {
      case "label":
        return _label;
      case "input":
        return _input;
      case "description":
        return _description;
      case "error":
        return _error;
      default:
        return null;
    }
  });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_InputWrapper_context_js__WEBPACK_IMPORTED_MODULE_6__.InputWrapperProvider, {
    value: __spreadValues({
      describedBy
    }, (0,_get_input_offsets_js__WEBPACK_IMPORTED_MODULE_7__.getInputOffsets)(inputWrapperOrder, {
      hasDescription: !!_description,
      hasError: !!_error
    }))
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_8__.Box, __spreadValues({
    className: cx(classes.root, className),
    ref
  }, others), content));
});
InputWrapper.displayName = "@mantine/core/InputWrapper";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Input/InputWrapper/InputWrapper.styles.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Input/InputWrapper/InputWrapper.styles.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme) => ({
  root: __spreadProps(__spreadValues({}, theme.fn.fontStyles()), {
    lineHeight: theme.lineHeight
  })
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Input/InputWrapper/get-input-offsets.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Input/InputWrapper/get-input-offsets.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getInputOffsets": () => (/* binding */ getInputOffsets)
/* harmony export */ });
function getInputOffsets(inputWrapperOrder, { hasDescription, hasError }) {
  const inputIndex = inputWrapperOrder.findIndex((part) => part === "input");
  const aboveInput = inputWrapperOrder[inputIndex - 1];
  const belowInput = inputWrapperOrder[inputIndex + 1];
  const offsetTop = hasDescription && aboveInput === "description" || hasError && aboveInput === "error";
  const offsetBottom = hasDescription && belowInput === "description" || hasError && belowInput === "error";
  return { offsetBottom, offsetTop };
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Input/use-input-props.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Input/use-input-props.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useInputProps": () => (/* binding */ useInputProps)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-id/use-id.js");
/* harmony import */ var _Box_style_system_props_extract_system_styles_extract_system_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box/style-system-props/extract-system-styles/extract-system-styles.js */ "./node_modules/@mantine/core/esm/Box/style-system-props/extract-system-styles/extract-system-styles.js");




var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function useInputProps(component, defaultProps, props) {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.useComponentDefaultProps)(component, defaultProps, props), {
    label,
    description,
    error,
    required,
    classNames,
    styles,
    className,
    unstyled,
    __staticSelector,
    sx,
    errorProps,
    labelProps,
    descriptionProps,
    wrapperProps: _wrapperProps,
    id,
    size,
    style,
    inputContainer,
    inputWrapperOrder,
    withAsterisk,
    variant
  } = _a, others = __objRest(_a, [
    "label",
    "description",
    "error",
    "required",
    "classNames",
    "styles",
    "className",
    "unstyled",
    "__staticSelector",
    "sx",
    "errorProps",
    "labelProps",
    "descriptionProps",
    "wrapperProps",
    "id",
    "size",
    "style",
    "inputContainer",
    "inputWrapperOrder",
    "withAsterisk",
    "variant"
  ]);
  const uid = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_1__.useId)(id);
  const { systemStyles, rest } = (0,_Box_style_system_props_extract_system_styles_extract_system_styles_js__WEBPACK_IMPORTED_MODULE_2__.extractSystemStyles)(others);
  const wrapperProps = __spreadValues({
    label,
    description,
    error,
    required,
    classNames,
    className,
    __staticSelector,
    sx,
    errorProps,
    labelProps,
    descriptionProps,
    unstyled,
    styles,
    id: uid,
    size,
    style,
    inputContainer,
    inputWrapperOrder,
    withAsterisk,
    variant
  }, _wrapperProps);
  return __spreadProps(__spreadValues({}, rest), {
    classNames,
    styles,
    unstyled,
    wrapperProps: __spreadValues(__spreadValues({}, wrapperProps), systemStyles),
    inputProps: {
      required,
      classNames,
      styles,
      unstyled,
      id: uid,
      size,
      __staticSelector,
      error,
      variant
    }
  });
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/InputBase/InputBase.js":
/*!***************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/InputBase/InputBase.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InputBase": () => (/* binding */ InputBase),
/* harmony export */   "_InputBase": () => (/* binding */ _InputBase)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-polymorphic-component/create-polymorphic-component.js");
/* harmony import */ var _Input_use_input_props_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Input/use-input-props.js */ "./node_modules/@mantine/core/esm/Input/use-input-props.js");
/* harmony import */ var _Input_Input_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Input/Input.js */ "./node_modules/@mantine/core/esm/Input/Input.js");





var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  size: "sm",
  __staticSelector: "InputBase"
};
const _InputBase = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_Input_use_input_props_js__WEBPACK_IMPORTED_MODULE_1__.useInputProps)("InputBase", defaultProps, props), { inputProps, wrapperProps } = _a, others = __objRest(_a, ["inputProps", "wrapperProps"]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Input_Input_js__WEBPACK_IMPORTED_MODULE_2__.Input.Wrapper, __spreadValues({}, wrapperProps), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Input_Input_js__WEBPACK_IMPORTED_MODULE_2__.Input, __spreadProps(__spreadValues(__spreadValues({}, inputProps), others), {
    ref
  })));
});
_InputBase.displayName = "@mantine/core/InputBase";
const InputBase = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_3__.createPolymorphicComponent)(_InputBase);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/JsonInput/JsonInput.js":
/*!***************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/JsonInput/JsonInput.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "JsonInput": () => (/* binding */ JsonInput)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-uncontrolled/use-uncontrolled.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _validate_json_validate_json_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./validate-json/validate-json.js */ "./node_modules/@mantine/core/esm/JsonInput/validate-json/validate-json.js");
/* harmony import */ var _JsonInput_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./JsonInput.styles.js */ "./node_modules/@mantine/core/esm/JsonInput/JsonInput.styles.js");
/* harmony import */ var _Textarea_Textarea_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Textarea/Textarea.js */ "./node_modules/@mantine/core/esm/Textarea/Textarea.js");







var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  formatOnBlur: false,
  size: "sm",
  serialize: JSON.stringify,
  deserialize: JSON.parse
};
const JsonInput = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("JsonInput", defaultProps, props), {
    value,
    defaultValue,
    onChange,
    onFocus,
    onBlur,
    error,
    formatOnBlur,
    size,
    validationError,
    classNames,
    unstyled,
    readOnly,
    variant,
    serialize,
    deserialize
  } = _a, others = __objRest(_a, [
    "value",
    "defaultValue",
    "onChange",
    "onFocus",
    "onBlur",
    "error",
    "formatOnBlur",
    "size",
    "validationError",
    "classNames",
    "unstyled",
    "readOnly",
    "variant",
    "serialize",
    "deserialize"
  ]);
  const { classes, cx } = (0,_JsonInput_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])(null, { name: "JsonInput", unstyled, size, variant });
  const [_value, setValue] = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_3__.useUncontrolled)({
    value,
    defaultValue,
    finalValue: "",
    onChange
  });
  const [valid, setValid] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)((0,_validate_json_validate_json_js__WEBPACK_IMPORTED_MODULE_4__.validateJson)(_value, deserialize));
  const handleFocus = (event) => {
    typeof onFocus === "function" && onFocus(event);
    setValid(true);
  };
  const handleBlur = (event) => {
    typeof onBlur === "function" && onBlur(event);
    const isValid = (0,_validate_json_validate_json_js__WEBPACK_IMPORTED_MODULE_4__.validateJson)(event.currentTarget.value, deserialize);
    formatOnBlur && !readOnly && isValid && event.currentTarget.value.trim() !== "" && setValue(serialize(deserialize(event.currentTarget.value), null, 2));
    setValid(isValid);
  };
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Textarea_Textarea_js__WEBPACK_IMPORTED_MODULE_5__.Textarea, __spreadValues({
    value: _value,
    onChange: (event) => setValue(event.currentTarget.value),
    onFocus: handleFocus,
    onBlur: handleBlur,
    error: valid ? error : validationError || true,
    __staticSelector: "JsonInput",
    classNames: __spreadProps(__spreadValues({}, classNames), { input: cx(classes.input, classNames == null ? void 0 : classNames.input) }),
    autoComplete: "off",
    ref,
    unstyled,
    readOnly,
    size,
    variant
  }, others));
});
JsonInput.displayName = "@mantine/core/JsonInput";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/JsonInput/JsonInput.styles.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/JsonInput/JsonInput.styles.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, _params, { size }) => ({
  input: {
    fontFamily: theme.fontFamilyMonospace,
    fontSize: `calc(${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size, sizes: theme.fontSizes })} - ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.rem)(2)})`
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/JsonInput/validate-json/validate-json.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/JsonInput/validate-json/validate-json.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "validateJson": () => (/* binding */ validateJson)
/* harmony export */ });
function validateJson(value, deserialize) {
  if (typeof value === "string" && value.trim().length === 0) {
    return true;
  }
  try {
    deserialize(value);
    return true;
  } catch (e) {
    return false;
  }
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Kbd/Kbd.js":
/*!***************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Kbd/Kbd.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Kbd": () => (/* binding */ Kbd)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _Kbd_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Kbd.styles.js */ "./node_modules/@mantine/core/esm/Kbd/Kbd.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  size: "sm"
};
const Kbd = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Kbd", defaultProps, props), { className, children, unstyled, variant, size } = _a, others = __objRest(_a, ["className", "children", "unstyled", "variant", "size"]);
  const { classes, cx } = (0,_Kbd_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])(null, { name: "Kbd", unstyled, variant, size });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_3__.Box, __spreadValues({
    component: "kbd",
    className: cx(classes.root, className),
    ref
  }, others), children);
});
Kbd.displayName = "@mantine/core/Kbd";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Kbd/Kbd.styles.js":
/*!**********************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Kbd/Kbd.styles.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


const sizes = {
  xs: { padding: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(2)} ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(4)}`, fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(10) },
  sm: { padding: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(3)} ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(5)}`, fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(12) },
  md: { padding: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(4)} ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(7)}`, fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(14) },
  lg: { padding: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(5)} ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(9)}`, fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(16) },
  xl: { padding: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(8)} ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(14)}`, fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(20) }
};
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.createStyles)((theme, _params, { size }) => {
  const _size = size in sizes ? sizes[size] : sizes.sm;
  return {
    root: {
      lineHeight: theme.lineHeight,
      fontFamily: theme.fontFamilyMonospace,
      fontSize: _size.fontSize,
      fontWeight: 700,
      backgroundColor: theme.colorScheme === "dark" ? theme.colors.dark[5] : theme.colors.gray[0],
      color: theme.colorScheme === "dark" ? theme.colors.dark[0] : theme.colors.gray[7],
      padding: _size.padding,
      borderRadius: theme.radius.sm,
      border: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(1)} solid ${theme.colorScheme === "dark" ? theme.colors.dark[4] : theme.colors.gray[3]}`,
      borderBottom: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.rem)(3)} solid ${theme.colorScheme === "dark" ? theme.colors.dark[4] : theme.colors.gray[3]}`
    }
  };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/List/List.context.js":
/*!*************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/List/List.context.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ListProvider": () => (/* binding */ ListProvider),
/* harmony export */   "useListContext": () => (/* binding */ useListContext)
/* harmony export */ });
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-safe-context/create-safe-context.js");


const [ListProvider, useListContext] = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_0__.createSafeContext)("List component was not found in tree");




/***/ }),

/***/ "./node_modules/@mantine/core/esm/List/List.js":
/*!*****************************************************!*\
  !*** ./node_modules/@mantine/core/esm/List/List.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "List": () => (/* binding */ List)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _ListItem_ListItem_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ListItem/ListItem.js */ "./node_modules/@mantine/core/esm/List/ListItem/ListItem.js");
/* harmony import */ var _List_context_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./List.context.js */ "./node_modules/@mantine/core/esm/List/List.context.js");
/* harmony import */ var _List_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./List.styles.js */ "./node_modules/@mantine/core/esm/List/List.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");







var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  type: "unordered",
  size: "md",
  spacing: 0
};
const List = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("List", defaultProps, props), {
    children,
    type,
    size,
    listStyleType,
    withPadding,
    center,
    spacing,
    icon,
    className,
    styles,
    classNames,
    unstyled,
    variant
  } = _a, others = __objRest(_a, [
    "children",
    "type",
    "size",
    "listStyleType",
    "withPadding",
    "center",
    "spacing",
    "icon",
    "className",
    "styles",
    "classNames",
    "unstyled",
    "variant"
  ]);
  const { classes, cx } = (0,_List_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ withPadding, listStyleType, center, spacing }, { classNames, styles, name: "List", unstyled, size, variant });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_List_context_js__WEBPACK_IMPORTED_MODULE_3__.ListProvider, {
    value: {
      spacing,
      center,
      icon,
      listStyleType,
      size,
      withPadding,
      classNames,
      styles,
      unstyled,
      variant
    }
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    component: type === "unordered" ? "ul" : "ol",
    className: cx(classes.root, className),
    ref
  }, others), children));
});
List.Item = _ListItem_ListItem_js__WEBPACK_IMPORTED_MODULE_5__.ListItem;
List.displayName = "@mantine/core/List";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/List/List.styles.js":
/*!************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/List/List.styles.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { withPadding, listStyleType }, { size }) => ({
  root: __spreadProps(__spreadValues({}, theme.fn.fontStyles()), {
    listStyleType,
    color: theme.colorScheme === "dark" ? theme.colors.dark[0] : theme.black,
    fontSize: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size, sizes: theme.fontSizes }),
    lineHeight: theme.lineHeight,
    margin: 0,
    paddingLeft: withPadding ? theme.spacing.xl : 0,
    listStylePosition: "inside"
  })
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/List/ListItem/ListItem.js":
/*!******************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/List/ListItem/ListItem.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ListItem": () => (/* binding */ ListItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _List_context_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../List.context.js */ "./node_modules/@mantine/core/esm/List/List.context.js");
/* harmony import */ var _ListItem_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ListItem.styles.js */ "./node_modules/@mantine/core/esm/List/ListItem/ListItem.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {};
const ListItem = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("ListItem", defaultProps, props), { className, children, icon } = _a, others = __objRest(_a, ["className", "children", "icon"]);
  const {
    icon: ctxIcon,
    spacing,
    center,
    listStyleType,
    size,
    withPadding,
    classNames,
    styles,
    unstyled,
    variant
  } = (0,_List_context_js__WEBPACK_IMPORTED_MODULE_2__.useListContext)();
  const _icon = icon || ctxIcon;
  const { classes, cx } = (0,_ListItem_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])({ withPadding, listStyleType, center, spacing }, { classNames, styles, unstyled, name: "List", variant, size });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    component: "li",
    className: cx(classes.item, className),
    "data-with-icon": !!_icon || void 0,
    ref
  }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classes.itemWrapper
  }, _icon && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: classes.itemIcon
  }, _icon), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, children)));
});
ListItem.displayName = "@mantine/core/ListItem";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/List/ListItem/ListItem.styles.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/List/ListItem/ListItem.styles.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/get-styles-ref.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { spacing, center }) => ({
  itemWrapper: {
    ref: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getStylesRef)("itemWrapper"),
    display: "inline-flex",
    flexDirection: "column",
    whiteSpace: "normal"
  },
  item: {
    whiteSpace: "nowrap",
    lineHeight: center ? 1 : theme.lineHeight,
    "&:not(:first-of-type)": {
      marginTop: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.getSize)({ size: spacing, sizes: theme.spacing })
    },
    "&[data-with-icon]": {
      listStyle: "none",
      [`& .${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getStylesRef)("itemWrapper")}`]: {
        display: "inline-flex",
        alignItems: center ? "center" : "flex-start",
        flexDirection: "row"
      }
    }
  },
  itemIcon: {
    display: "inline-block",
    verticalAlign: "middle",
    marginRight: theme.spacing.sm
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Loader/Loader.js":
/*!*********************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Loader/Loader.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Loader": () => (/* binding */ Loader)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _loaders_Bars_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./loaders/Bars.js */ "./node_modules/@mantine/core/esm/Loader/loaders/Bars.js");
/* harmony import */ var _loaders_Oval_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./loaders/Oval.js */ "./node_modules/@mantine/core/esm/Loader/loaders/Oval.js");
/* harmony import */ var _loaders_Dots_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./loaders/Dots.js */ "./node_modules/@mantine/core/esm/Loader/loaders/Dots.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");







var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const LOADERS = {
  bars: _loaders_Bars_js__WEBPACK_IMPORTED_MODULE_1__.Bars,
  oval: _loaders_Oval_js__WEBPACK_IMPORTED_MODULE_2__.Oval,
  dots: _loaders_Dots_js__WEBPACK_IMPORTED_MODULE_3__.Dots
};
const sizes = {
  xs: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(18),
  sm: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(22),
  md: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(36),
  lg: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(44),
  xl: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_4__.rem)(58)
};
const defaultProps = {
  size: "md"
};
function Loader(props) {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.useComponentDefaultProps)("Loader", defaultProps, props), { size, color, variant } = _a, others = __objRest(_a, ["size", "color", "variant"]);
  const theme = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_5__.useMantineTheme)();
  const defaultLoader = variant in LOADERS ? variant : theme.loader;
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_6__.Box, __spreadValues({
    role: "presentation",
    component: LOADERS[defaultLoader] || LOADERS.bars,
    size: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_7__.getSize)({ size, sizes }),
    color: theme.fn.variant({
      variant: "filled",
      primaryFallback: false,
      color: color || theme.primaryColor
    }).background
  }, others));
}
Loader.displayName = "@mantine/core/Loader";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Loader/loaders/Bars.js":
/*!***************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Loader/loaders/Bars.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Bars": () => (/* binding */ Bars)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function Bars(_a) {
  var _b = _a, { size, color } = _b, others = __objRest(_b, ["size", "color"]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __spreadValues({
    viewBox: "0 0 135 140",
    xmlns: "http://www.w3.org/2000/svg",
    fill: color,
    width: size
  }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    y: "10",
    width: "15",
    height: "120",
    rx: "6"
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "height",
    begin: "0.5s",
    dur: "1s",
    values: "120;110;100;90;80;70;60;50;40;140;120",
    calcMode: "linear",
    repeatCount: "indefinite"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "y",
    begin: "0.5s",
    dur: "1s",
    values: "10;15;20;25;30;35;40;45;50;0;10",
    calcMode: "linear",
    repeatCount: "indefinite"
  })), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    x: "30",
    y: "10",
    width: "15",
    height: "120",
    rx: "6"
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "height",
    begin: "0.25s",
    dur: "1s",
    values: "120;110;100;90;80;70;60;50;40;140;120",
    calcMode: "linear",
    repeatCount: "indefinite"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "y",
    begin: "0.25s",
    dur: "1s",
    values: "10;15;20;25;30;35;40;45;50;0;10",
    calcMode: "linear",
    repeatCount: "indefinite"
  })), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    x: "60",
    width: "15",
    height: "140",
    rx: "6"
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "height",
    begin: "0s",
    dur: "1s",
    values: "120;110;100;90;80;70;60;50;40;140;120",
    calcMode: "linear",
    repeatCount: "indefinite"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "y",
    begin: "0s",
    dur: "1s",
    values: "10;15;20;25;30;35;40;45;50;0;10",
    calcMode: "linear",
    repeatCount: "indefinite"
  })), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    x: "90",
    y: "10",
    width: "15",
    height: "120",
    rx: "6"
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "height",
    begin: "0.25s",
    dur: "1s",
    values: "120;110;100;90;80;70;60;50;40;140;120",
    calcMode: "linear",
    repeatCount: "indefinite"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "y",
    begin: "0.25s",
    dur: "1s",
    values: "10;15;20;25;30;35;40;45;50;0;10",
    calcMode: "linear",
    repeatCount: "indefinite"
  })), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    x: "120",
    y: "10",
    width: "15",
    height: "120",
    rx: "6"
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "height",
    begin: "0.5s",
    dur: "1s",
    values: "120;110;100;90;80;70;60;50;40;140;120",
    calcMode: "linear",
    repeatCount: "indefinite"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "y",
    begin: "0.5s",
    dur: "1s",
    values: "10;15;20;25;30;35;40;45;50;0;10",
    calcMode: "linear",
    repeatCount: "indefinite"
  })));
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Loader/loaders/Dots.js":
/*!***************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Loader/loaders/Dots.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Dots": () => (/* binding */ Dots)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function Dots(_a) {
  var _b = _a, { size, color } = _b, others = __objRest(_b, ["size", "color"]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __spreadValues({
    width: size,
    viewBox: "0 0 120 30",
    xmlns: "http://www.w3.org/2000/svg",
    fill: color
  }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", {
    cx: "15",
    cy: "15",
    r: "15"
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "r",
    from: "15",
    to: "15",
    begin: "0s",
    dur: "0.8s",
    values: "15;9;15",
    calcMode: "linear",
    repeatCount: "indefinite"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "fill-opacity",
    from: "1",
    to: "1",
    begin: "0s",
    dur: "0.8s",
    values: "1;.5;1",
    calcMode: "linear",
    repeatCount: "indefinite"
  })), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", {
    cx: "60",
    cy: "15",
    r: "9",
    fillOpacity: "0.3"
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "r",
    from: "9",
    to: "9",
    begin: "0s",
    dur: "0.8s",
    values: "9;15;9",
    calcMode: "linear",
    repeatCount: "indefinite"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "fill-opacity",
    from: "0.5",
    to: "0.5",
    begin: "0s",
    dur: "0.8s",
    values: ".5;1;.5",
    calcMode: "linear",
    repeatCount: "indefinite"
  })), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", {
    cx: "105",
    cy: "15",
    r: "15"
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "r",
    from: "15",
    to: "15",
    begin: "0s",
    dur: "0.8s",
    values: "15;9;15",
    calcMode: "linear",
    repeatCount: "indefinite"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animate", {
    attributeName: "fill-opacity",
    from: "1",
    to: "1",
    begin: "0s",
    dur: "0.8s",
    values: "1;.5;1",
    calcMode: "linear",
    repeatCount: "indefinite"
  })));
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Loader/loaders/Oval.js":
/*!***************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Loader/loaders/Oval.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Oval": () => (/* binding */ Oval)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function Oval(_a) {
  var _b = _a, { size, color } = _b, others = __objRest(_b, ["size", "color"]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", __spreadValues({
    width: size,
    height: size,
    viewBox: "0 0 38 38",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: color
  }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", {
    fill: "none",
    fillRule: "evenodd"
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", {
    transform: "translate(2.5 2.5)",
    strokeWidth: "5"
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", {
    strokeOpacity: ".5",
    cx: "16",
    cy: "16",
    r: "16"
  }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    d: "M32 16c0-9.94-8.06-16-16-16"
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("animateTransform", {
    attributeName: "transform",
    type: "rotate",
    from: "0 16 16",
    to: "360 16 16",
    dur: "1s",
    repeatCount: "indefinite"
  })))));
}




/***/ }),

/***/ "./node_modules/@mantine/core/esm/LoadingOverlay/LoadingOverlay.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/LoadingOverlay/LoadingOverlay.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LoadingOverlay": () => (/* binding */ LoadingOverlay)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-default-z-index/get-default-z-index.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _LoadingOverlay_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./LoadingOverlay.styles.js */ "./node_modules/@mantine/core/esm/LoadingOverlay/LoadingOverlay.styles.js");
/* harmony import */ var _Transition_Transition_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Transition/Transition.js */ "./node_modules/@mantine/core/esm/Transition/Transition.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");
/* harmony import */ var _Loader_Loader_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Loader/Loader.js */ "./node_modules/@mantine/core/esm/Loader/Loader.js");
/* harmony import */ var _Overlay_Overlay_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Overlay/Overlay.js */ "./node_modules/@mantine/core/esm/Overlay/Overlay.js");








var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  overlayOpacity: 0.75,
  transitionDuration: 0,
  radius: 0,
  zIndex: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getDefaultZIndex)("overlay")
};
const LoadingOverlay = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.useComponentDefaultProps)("LoadingOverlay", defaultProps, props), {
    className,
    visible,
    loaderProps,
    overlayOpacity,
    overlayColor,
    transitionDuration,
    exitTransitionDuration,
    zIndex,
    style,
    loader,
    radius,
    overlayBlur,
    unstyled,
    variant,
    keepMounted
  } = _a, others = __objRest(_a, [
    "className",
    "visible",
    "loaderProps",
    "overlayOpacity",
    "overlayColor",
    "transitionDuration",
    "exitTransitionDuration",
    "zIndex",
    "style",
    "loader",
    "radius",
    "overlayBlur",
    "unstyled",
    "variant",
    "keepMounted"
  ]);
  const { classes, cx, theme } = (0,_LoadingOverlay_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])(null, { name: "LoadingOverlay", unstyled, variant });
  const _zIndex = `calc(${zIndex} + 1)`;
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Transition_Transition_js__WEBPACK_IMPORTED_MODULE_4__.Transition, {
    keepMounted,
    duration: transitionDuration,
    exitDuration: exitTransitionDuration,
    mounted: visible,
    transition: "fade"
  }, (transitionStyles) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_5__.Box, __spreadValues({
    className: cx(classes.root, className),
    style: __spreadProps(__spreadValues(__spreadValues({}, transitionStyles), style), { zIndex }),
    ref
  }, others), loader ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    style: { zIndex: _zIndex }
  }, loader) : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Loader_Loader_js__WEBPACK_IMPORTED_MODULE_6__.Loader, __spreadValues({
    style: { zIndex: _zIndex }
  }, loaderProps)), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Overlay_Overlay_js__WEBPACK_IMPORTED_MODULE_7__.Overlay, {
    opacity: overlayOpacity,
    zIndex,
    radius,
    blur: overlayBlur,
    unstyled,
    color: overlayColor || (theme.colorScheme === "dark" ? theme.colors.dark[5] : theme.white)
  })));
});
LoadingOverlay.displayName = "@mantine/core/LoadingOverlay";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/LoadingOverlay/LoadingOverlay.styles.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/LoadingOverlay/LoadingOverlay.styles.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme) => ({
  root: __spreadProps(__spreadValues({}, theme.fn.cover()), {
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    overflow: "hidden"
  })
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Mark/Mark.js":
/*!*****************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Mark/Mark.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Mark": () => (/* binding */ Mark)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _Mark_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Mark.styles.js */ "./node_modules/@mantine/core/esm/Mark/Mark.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");





var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  color: "yellow"
};
const Mark = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Mark", defaultProps, props), { color, className, unstyled, variant } = _a, others = __objRest(_a, ["color", "className", "unstyled", "variant"]);
  const { classes, cx } = (0,_Mark_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ color }, { unstyled, name: "Mark", variant });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_3__.Box, __spreadValues({
    component: "mark",
    ref,
    className: cx(classes.root, className)
  }, others));
});
Mark.displayName = "@mantine/core/Mark";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Mark/Mark.styles.js":
/*!************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Mark/Mark.styles.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { color }) => ({
  root: {
    backgroundColor: theme.fn.themeColor(color, theme.colorScheme === "dark" ? 5 : 2),
    color: theme.colorScheme === "dark" ? theme.colors.dark[9] : "inherit"
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/MediaQuery/MediaQuery.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/MediaQuery/MediaQuery.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MediaQuery": () => (/* binding */ MediaQuery)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _MediaQuery_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MediaQuery.styles.js */ "./node_modules/@mantine/core/esm/MediaQuery/MediaQuery.styles.js");




function MediaQuery(props) {
  var _a;
  const { children, smallerThan, largerThan, query, styles, className } = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("MediaQuery", {}, props);
  const { classes, cx } = (0,_MediaQuery_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])({ smallerThan, largerThan, query, styles }, { name: "MediaQuery" });
  const child = react__WEBPACK_IMPORTED_MODULE_0__.Children.only(children);
  if (typeof child === "object" && child !== null && "props" in child) {
    return react__WEBPACK_IMPORTED_MODULE_0___default().cloneElement(child, {
      className: cx(classes.media, (_a = child.props) == null ? void 0 : _a.className, className)
    });
  }
  return child;
}
MediaQuery.displayName = "@mantine/core/MediaQuery";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/MediaQuery/MediaQuery.styles.js":
/*!************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/MediaQuery/MediaQuery.styles.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/get-size/get-size.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/functions/fns/breakpoints/breakpoints.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme, { smallerThan, largerThan, query, styles }) => {
  const media = {};
  const minWidth = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size: largerThan, sizes: theme.breakpoints });
  const maxWidth = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size: smallerThan, sizes: theme.breakpoints });
  const _styles = typeof styles === "function" ? styles(theme) : styles;
  if (largerThan !== void 0 && smallerThan !== void 0) {
    media[`@media (min-width: ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.em)(minWidth)}) and (max-width: ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.em)((0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getBreakpointValue)(maxWidth) - 1)})`] = _styles;
  } else {
    if (largerThan !== void 0) {
      media[`@media (min-width: ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size: largerThan, sizes: theme.breakpoints })})`] = _styles;
    }
    if (smallerThan !== void 0) {
      media[`@media (max-width: ${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_2__.em)((0,_mantine_styles__WEBPACK_IMPORTED_MODULE_3__.getBreakpointValue)((0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.getSize)({ size: smallerThan, sizes: theme.breakpoints })) - 1)})`] = _styles;
    }
  }
  if (query) {
    media[`@media ${query}`] = _styles;
  }
  return { media };
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Menu/Menu.context.js":
/*!*************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Menu/Menu.context.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MenuContextProvider": () => (/* binding */ MenuContextProvider),
/* harmony export */   "useMenuContext": () => (/* binding */ useMenuContext)
/* harmony export */ });
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-safe-context/create-safe-context.js");
/* harmony import */ var _Menu_errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Menu.errors.js */ "./node_modules/@mantine/core/esm/Menu/Menu.errors.js");



const [MenuContextProvider, useMenuContext] = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_0__.createSafeContext)(_Menu_errors_js__WEBPACK_IMPORTED_MODULE_1__.MENU_ERRORS.context);




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Menu/Menu.errors.js":
/*!************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Menu/Menu.errors.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MENU_ERRORS": () => (/* binding */ MENU_ERRORS)
/* harmony export */ });
const MENU_ERRORS = {
  context: "Menu component was not found in the tree",
  children: "Menu.Target component children should be an element or a component that accepts ref. Fragments, strings, numbers and other primitive values are not supported"
};




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Menu/Menu.js":
/*!*****************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Menu/Menu.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Menu": () => (/* binding */ Menu)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/use-hovered/use-hovered.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/get-context-item-index/get-context-item-index.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-uncontrolled/use-uncontrolled.js");
/* harmony import */ var _mantine_hooks__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mantine/hooks */ "./node_modules/@mantine/hooks/esm/use-did-update/use-did-update.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _MenuDivider_MenuDivider_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./MenuDivider/MenuDivider.js */ "./node_modules/@mantine/core/esm/Menu/MenuDivider/MenuDivider.js");
/* harmony import */ var _MenuDropdown_MenuDropdown_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./MenuDropdown/MenuDropdown.js */ "./node_modules/@mantine/core/esm/Menu/MenuDropdown/MenuDropdown.js");
/* harmony import */ var _MenuItem_MenuItem_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./MenuItem/MenuItem.js */ "./node_modules/@mantine/core/esm/Menu/MenuItem/MenuItem.js");
/* harmony import */ var _MenuLabel_MenuLabel_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./MenuLabel/MenuLabel.js */ "./node_modules/@mantine/core/esm/Menu/MenuLabel/MenuLabel.js");
/* harmony import */ var _MenuTarget_MenuTarget_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./MenuTarget/MenuTarget.js */ "./node_modules/@mantine/core/esm/Menu/MenuTarget/MenuTarget.js");
/* harmony import */ var _Menu_context_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Menu.context.js */ "./node_modules/@mantine/core/esm/Menu/Menu.context.js");
/* harmony import */ var _Menu_styles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Menu.styles.js */ "./node_modules/@mantine/core/esm/Menu/Menu.styles.js");
/* harmony import */ var _Floating_use_delayed_hover_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Floating/use-delayed-hover.js */ "./node_modules/@mantine/core/esm/Floating/use-delayed-hover.js");
/* harmony import */ var _Popover_Popover_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Popover/Popover.js */ "./node_modules/@mantine/core/esm/Popover/Popover.js");














var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  closeOnItemClick: true,
  loop: true,
  trigger: "click",
  openDelay: 0,
  closeDelay: 100
};
function Menu(props) {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("Menu", defaultProps, props), {
    children,
    onOpen,
    onClose,
    opened,
    defaultOpened,
    onChange,
    closeOnItemClick,
    loop,
    closeOnEscape,
    trigger,
    openDelay,
    closeDelay,
    classNames,
    styles,
    unstyled,
    radius,
    variant
  } = _a, others = __objRest(_a, [
    "children",
    "onOpen",
    "onClose",
    "opened",
    "defaultOpened",
    "onChange",
    "closeOnItemClick",
    "loop",
    "closeOnEscape",
    "trigger",
    "openDelay",
    "closeDelay",
    "classNames",
    "styles",
    "unstyled",
    "radius",
    "variant"
  ]);
  const { classes, cx } = (0,_Menu_styles_js__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const [hovered, { setHovered, resetHovered }] = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_3__.useHovered)();
  const [_opened, setOpened] = (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_4__.useUncontrolled)({
    value: opened,
    defaultValue: defaultOpened,
    finalValue: false,
    onChange
  });
  const close = () => {
    setOpened(false);
    _opened && (onClose == null ? void 0 : onClose());
  };
  const open = () => {
    setOpened(true);
    !_opened && (onOpen == null ? void 0 : onOpen());
  };
  const toggleDropdown = () => _opened ? close() : open();
  const { openDropdown, closeDropdown } = (0,_Floating_use_delayed_hover_js__WEBPACK_IMPORTED_MODULE_5__.useDelayedHover)({ open, close, closeDelay, openDelay });
  const getItemIndex = (node) => (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_6__.getContextItemIndex)("[data-menu-item]", "[data-menu-dropdown]", node);
  (0,_mantine_hooks__WEBPACK_IMPORTED_MODULE_7__.useDidUpdate)(() => {
    resetHovered();
  }, [_opened]);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Menu_context_js__WEBPACK_IMPORTED_MODULE_8__.MenuContextProvider, {
    value: {
      opened: _opened,
      toggleDropdown,
      getItemIndex,
      hovered,
      setHovered,
      closeOnItemClick,
      closeDropdown: trigger === "click" ? close : closeDropdown,
      openDropdown: trigger === "click" ? open : openDropdown,
      closeDropdownImmediately: close,
      loop,
      trigger,
      radius,
      classNames,
      styles,
      unstyled,
      variant
    }
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Popover_Popover_js__WEBPACK_IMPORTED_MODULE_9__.Popover, __spreadProps(__spreadValues({}, others), {
    radius,
    opened: _opened,
    onChange: toggleDropdown,
    defaultOpened,
    trapFocus: trigger === "click",
    closeOnEscape: closeOnEscape && trigger === "click",
    __staticSelector: "Menu",
    classNames: __spreadProps(__spreadValues({}, classNames), { dropdown: cx(classes.dropdown, classNames == null ? void 0 : classNames.dropdown) }),
    styles,
    unstyled,
    variant
  }), children));
}
Menu.displayName = "@mantine/core/Menu";
Menu.Item = _MenuItem_MenuItem_js__WEBPACK_IMPORTED_MODULE_10__.MenuItem;
Menu.Label = _MenuLabel_MenuLabel_js__WEBPACK_IMPORTED_MODULE_11__.MenuLabel;
Menu.Dropdown = _MenuDropdown_MenuDropdown_js__WEBPACK_IMPORTED_MODULE_12__.MenuDropdown;
Menu.Target = _MenuTarget_MenuTarget_js__WEBPACK_IMPORTED_MODULE_13__.MenuTarget;
Menu.Divider = _MenuDivider_MenuDivider_js__WEBPACK_IMPORTED_MODULE_14__.MenuDivider;




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Menu/Menu.styles.js":
/*!************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Menu/Menu.styles.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)({
  dropdown: { padding: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(4) }
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Menu/MenuDivider/MenuDivider.js":
/*!************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Menu/MenuDivider/MenuDivider.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MenuDivider": () => (/* binding */ MenuDivider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _Menu_context_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Menu.context.js */ "./node_modules/@mantine/core/esm/Menu/Menu.context.js");
/* harmony import */ var _MenuDivider_styles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MenuDivider.styles.js */ "./node_modules/@mantine/core/esm/Menu/MenuDivider/MenuDivider.styles.js");
/* harmony import */ var _Box_Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Box/Box.js */ "./node_modules/@mantine/core/esm/Box/Box.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {};
const MenuDivider = (0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)((props, ref) => {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("MenuDivider", defaultProps, props), { children, className } = _a, others = __objRest(_a, ["children", "className"]);
  const { classNames, styles, unstyled, variant } = (0,_Menu_context_js__WEBPACK_IMPORTED_MODULE_2__.useMenuContext)();
  const { classes, cx } = (0,_MenuDivider_styles_js__WEBPACK_IMPORTED_MODULE_3__["default"])(null, { name: "Menu", classNames, styles, unstyled, variant });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_Box_js__WEBPACK_IMPORTED_MODULE_4__.Box, __spreadValues({
    className: cx(classes.divider, className),
    ref
  }, others));
});
MenuDivider.displayName = "@mantine/core/MenuDivider";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Menu/MenuDivider/MenuDivider.styles.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Menu/MenuDivider/MenuDivider.styles.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/tss/create-styles.js");
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/utils/rem/rem.js");


var useStyles = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_0__.createStyles)((theme) => ({
  divider: {
    marginTop: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(4),
    marginBottom: (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(4),
    borderTop: `${(0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.rem)(1)} solid ${theme.colorScheme === "dark" ? theme.colors.dark[4] : theme.colors.gray[2]}`
  }
}));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useStyles);


/***/ }),

/***/ "./node_modules/@mantine/core/esm/Menu/MenuDropdown/MenuDropdown.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Menu/MenuDropdown/MenuDropdown.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MenuDropdown": () => (/* binding */ MenuDropdown)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony import */ var _mantine_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mantine/utils */ "./node_modules/@mantine/utils/esm/create-event-handler/create-event-handler.js");
/* harmony import */ var _Menu_context_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Menu.context.js */ "./node_modules/@mantine/core/esm/Menu/Menu.context.js");
/* harmony import */ var _Popover_Popover_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Popover/Popover.js */ "./node_modules/@mantine/core/esm/Popover/Popover.js");






var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {};
function MenuDropdown(props) {
  const _a = (0,_mantine_styles__WEBPACK_IMPORTED_MODULE_1__.useComponentDefaultProps)("MenuDropdown", defaultProps, props), { children, onMouseEnter, onMouseLeave } = _a, others = __objRest(_a, ["children", "onMouseEnter", "onMouseLeave"]);
  const wrapperRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();
  const ctx = (0,_Menu_context_js__WEBPACK_IMPORTED_MODULE_2__.useMenuContext)();
  const handleKeyDown = (event) => {
    if (event.key === "ArrowUp" || event.key === "ArrowDown") {
      event.preventDefault();
      wrapperRef.current.querySelectorAll("[data-menu-item]")[0].focus();
    }
  };
  const handleMouseEnter = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_3__.createEventHandler)(onMouseEnter, () => ctx.trigger === "hover" && ctx.openDropdown());
  const handleMouseLeave = (0,_mantine_utils__WEBPACK_IMPORTED_MODULE_3__.createEventHandler)(onMouseLeave, () => ctx.trigger === "hover" && ctx.closeDropdown());
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Popover_Popover_js__WEBPACK_IMPORTED_MODULE_4__.Popover.Dropdown, __spreadValues({
    onMouseEnter: handleMouseEnter,
    onMouseLeave: handleMouseLeave,
    role: "menu",
    "aria-orientation": "vertical"
  }, others), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    tabIndex: -1,
    "data-menu-dropdown": true,
    "data-autofocus": true,
    onKeyDown: handleKeyDown,
    ref: wrapperRef,
    style: { outline: 0 }
  }, children));
}
MenuDropdown.displayName = "@mantine/core/MenuDropdown";




/***/ }),

/***/ "./node_modules/@mantine/core/esm/Menu/MenuItem/MenuItem.js":
/*!******************************************************************!*\
  !*** ./node_modules/@mantine/core/esm/Menu/MenuItem/MenuItem.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MenuItem": () => (/* binding */ MenuItem),
/* harmony export */   "_MenuItem": () => (/* binding */ _MenuItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mantine_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mantine/styles */ "./node_modules/@mantine/styles/esm/theme/MantineProvider.js");
/* harmony i