# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from regula.documentreader.webclient.gen.models.fiber_result import FiberResult
from regula.documentreader.webclient.gen.models.ident_result import IdentResult
from regula.documentreader.webclient.gen.models.ocr_security_text_result import OCRSecurityTextResult
from regula.documentreader.webclient.gen.models.photo_ident_result import PhotoIdentResult
from regula.documentreader.webclient.gen.models.security_feature_result import SecurityFeatureResult
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

AUTHENTICITYCHECKRESULTLISTINNER_ONE_OF_SCHEMAS = ["FiberResult", "IdentResult", "OCRSecurityTextResult", "PhotoIdentResult", "SecurityFeatureResult"]

class AuthenticityCheckResultListInner(BaseModel):
    """
    AuthenticityCheckResultListInner
    """
    # data type: SecurityFeatureResult
    oneof_schema_1_validator: Optional[SecurityFeatureResult] = None
    # data type: IdentResult
    oneof_schema_2_validator: Optional[IdentResult] = None
    # data type: FiberResult
    oneof_schema_3_validator: Optional[FiberResult] = None
    # data type: OCRSecurityTextResult
    oneof_schema_4_validator: Optional[OCRSecurityTextResult] = None
    # data type: PhotoIdentResult
    oneof_schema_5_validator: Optional[PhotoIdentResult] = None
    actual_instance: Optional[Union[FiberResult, IdentResult, OCRSecurityTextResult, PhotoIdentResult, SecurityFeatureResult]] = None
    one_of_schemas: Set[str] = { "FiberResult", "IdentResult", "OCRSecurityTextResult", "PhotoIdentResult", "SecurityFeatureResult" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = AuthenticityCheckResultListInner.model_construct()
        error_messages = []
        match = 0
        # validate data type: SecurityFeatureResult
        if not isinstance(v, SecurityFeatureResult):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SecurityFeatureResult`")
        else:
            match += 1
        # validate data type: IdentResult
        if not isinstance(v, IdentResult):
            error_messages.append(f"Error! Input type `{type(v)}` is not `IdentResult`")
        else:
            match += 1
        # validate data type: FiberResult
        if not isinstance(v, FiberResult):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FiberResult`")
        else:
            match += 1
        # validate data type: OCRSecurityTextResult
        if not isinstance(v, OCRSecurityTextResult):
            error_messages.append(f"Error! Input type `{type(v)}` is not `OCRSecurityTextResult`")
        else:
            match += 1
        # validate data type: PhotoIdentResult
        if not isinstance(v, PhotoIdentResult):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PhotoIdentResult`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in AuthenticityCheckResultListInner with oneOf schemas: FiberResult, IdentResult, OCRSecurityTextResult, PhotoIdentResult, SecurityFeatureResult. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in AuthenticityCheckResultListInner with oneOf schemas: FiberResult, IdentResult, OCRSecurityTextResult, PhotoIdentResult, SecurityFeatureResult. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into SecurityFeatureResult
        try:
            instance.actual_instance = SecurityFeatureResult.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into IdentResult
        try:
            instance.actual_instance = IdentResult.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FiberResult
        try:
            instance.actual_instance = FiberResult.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into OCRSecurityTextResult
        try:
            instance.actual_instance = OCRSecurityTextResult.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PhotoIdentResult
        try:
            instance.actual_instance = PhotoIdentResult.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into AuthenticityCheckResultListInner with oneOf schemas: FiberResult, IdentResult, OCRSecurityTextResult, PhotoIdentResult, SecurityFeatureResult. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AuthenticityCheckResultListInner with oneOf schemas: FiberResult, IdentResult, OCRSecurityTextResult, PhotoIdentResult, SecurityFeatureResult. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], FiberResult, IdentResult, OCRSecurityTextResult, PhotoIdentResult, SecurityFeatureResult]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


