# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List
from regula.documentreader.webclient.gen.models.light import Light
from regula.documentreader.webclient.gen.models.point import Point
from regula.documentreader.webclient.gen.models.rectangle_coordinates import RectangleCoordinates
from typing import Optional, Set
from typing_extensions import Self

class FaceItem(BaseModel):
    """
    FaceItem
    """ # noqa: E501
    coincidence_to_photo_area: StrictInt = Field(alias="CoincidenceToPhotoArea")
    face_rect: RectangleCoordinates = Field(alias="FaceRect")
    field_rect: RectangleCoordinates = Field(alias="FieldRect")
    graph_field_number: StrictInt = Field(alias="GraphFieldNumber")
    landmarks: List[Point] = Field(alias="Landmarks")
    light_type: Light = Field(alias="LightType")
    orientation: StrictInt = Field(alias="Orientation")
    probability: StrictInt = Field(alias="Probability")
    __properties: ClassVar[List[str]] = ["CoincidenceToPhotoArea", "FaceRect", "FieldRect", "GraphFieldNumber", "Landmarks", "LightType", "Orientation", "Probability"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FaceItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of face_rect
        if self.face_rect:
            _dict['FaceRect'] = self.face_rect.to_dict()
        # override the default output from pydantic by calling `to_dict()` of field_rect
        if self.field_rect:
            _dict['FieldRect'] = self.field_rect.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in landmarks (list)
        _items = []
        if self.landmarks:
            for _item_landmarks in self.landmarks:
                if _item_landmarks:
                    _items.append(_item_landmarks.to_dict())
            _dict['Landmarks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FaceItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "CoincidenceToPhotoArea": obj.get("CoincidenceToPhotoArea"),
            "FaceRect": RectangleCoordinates.from_dict(obj["FaceRect"]) if obj.get("FaceRect") is not None else None,
            "FieldRect": RectangleCoordinates.from_dict(obj["FieldRect"]) if obj.get("FieldRect") is not None else None,
            "GraphFieldNumber": obj.get("GraphFieldNumber"),
            "Landmarks": [Point.from_dict(_item) for _item in obj["Landmarks"]] if obj.get("Landmarks") is not None else None,
            "LightType": obj.get("LightType"),
            "Orientation": obj.get("Orientation"),
            "Probability": obj.get("Probability")
        })
        return _obj


