# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from regula.documentreader.webclient.gen.models.lcid import LCID
from regula.documentreader.webclient.gen.models.text_field_type import TextFieldType
from regula.documentreader.webclient.gen.models.verification_result import VerificationResult
from typing import Optional, Set
from typing_extensions import Self

class VerifiedFieldMap(BaseModel):
    """
    VerifiedFieldMap
    """ # noqa: E501
    w_field_type: TextFieldType = Field(alias="wFieldType")
    w_lcid: LCID = Field(alias="wLCID")
    field_mrz: Optional[StrictStr] = Field(default=None, description="Field data extracted from mrz(machine readable zone)", alias="Field_MRZ")
    field_visual: Optional[StrictStr] = Field(default=None, description="Field data extracted from visual zone", alias="Field_Visual")
    field_barcode: Optional[StrictStr] = Field(default=None, description="Field data extracted from barcode", alias="Field_Barcode")
    field_rfid: Optional[StrictStr] = Field(default=None, description="Field data extracted from rfid chip", alias="Field_RFID")
    matrix: Annotated[List[VerificationResult], Field(min_length=10, max_length=10)] = Field(description="results comparison matrix. Elements of the matrix with indices 0, 1, 2, 3 take one of the values Disabled(0), Verified(1) or Not_Verified(2), elements with indices 4, 5, 6, 7, 8 are one of the values Disabled(0), Compare_Match(3) or Compare_Not_Match(4). Elements of the Matrix matrix have the following semantic meaning: - element with index 0 –– the result of verification of data from the MRZ; - 1 –– the result of verification of data from the RFID microcircuit; - 2 –– the result of verification of data from text areas of the document; - 3 –– the result of verification data from barcodes; - 4 - the result of comparing MRZ data and RFID microcircuits; - 5 - the result of comparing MRZ data and text areas of document filling; - 6 - the result of comparing MRZ data and bar codes; - 7 - the result of comparing the data of text areas of the document and the RFID chip; - 8 - the result of comparing the data of the text areas of the document and barcodes; - 9 - the result of comparing the data of the RFID chip and barcodes.", alias="Matrix")
    field_type: Optional[StrictInt] = Field(default=None, alias="FieldType")
    __properties: ClassVar[List[str]] = ["wFieldType", "wLCID", "Field_MRZ", "Field_Visual", "Field_Barcode", "Field_RFID", "Matrix", "FieldType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VerifiedFieldMap from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VerifiedFieldMap from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "wFieldType": obj.get("wFieldType"),
            "wLCID": obj.get("wLCID"),
            "Field_MRZ": obj.get("Field_MRZ"),
            "Field_Visual": obj.get("Field_Visual"),
            "Field_Barcode": obj.get("Field_Barcode"),
            "Field_RFID": obj.get("Field_RFID"),
            "Matrix": obj.get("Matrix"),
            "FieldType": obj.get("FieldType")
        })
        return _obj


