# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class LivenessParams(BaseModel):
    """
    LivenessParams
    """ # noqa: E501
    check_ovi: Optional[StrictBool] = Field(default=None, description="This parameter is used to enable OVI check", alias="checkOVI")
    check_mli: Optional[StrictBool] = Field(default=None, description="This parameter is used to enable MLI check", alias="checkMLI")
    check_holo: Optional[StrictBool] = Field(default=None, description="This parameter is used to enable Hologram detection", alias="checkHolo")
    check_ed: Optional[StrictBool] = Field(default=None, description="This parameter is used to enable Electronic device detection", alias="checkED")
    check_black_and_white_copy: Optional[StrictBool] = Field(default=None, description="This parameter is used to enable Black and white copy check", alias="checkBlackAndWhiteCopy")
    check_dynaprint: Optional[StrictBool] = Field(default=None, description="This parameter is used to enable Dynaprint check", alias="checkDynaprint")
    __properties: ClassVar[List[str]] = ["checkOVI", "checkMLI", "checkHolo", "checkED", "checkBlackAndWhiteCopy", "checkDynaprint"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LivenessParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LivenessParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "checkOVI": obj.get("checkOVI"),
            "checkMLI": obj.get("checkMLI"),
            "checkHolo": obj.get("checkHolo"),
            "checkED": obj.get("checkED"),
            "checkBlackAndWhiteCopy": obj.get("checkBlackAndWhiteCopy"),
            "checkDynaprint": obj.get("checkDynaprint")
        })
        return _obj


