# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from regula.documentreader.webclient.gen.models.symbol_recognition_result import SymbolRecognitionResult
from typing import Optional, Set
from typing_extensions import Self

class StringRecognitionResult(BaseModel):
    """
    Describes single row recognition results in multi-line text field of a document
    """ # noqa: E501
    symbols_count: Union[StrictFloat, StrictInt] = Field(description="Number of StringResult array elements", alias="SymbolsCount")
    string_result: List[SymbolRecognitionResult] = Field(description="Array of recognition results for individual characters of a string", alias="StringResult")
    buf_length: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Buf_Text text string length", alias="Buf_Length")
    buf_text: Optional[StrictStr] = Field(default=None, description="Text field data in UTF8 format. Results of reading different lines of a multi-line field are separated by '^'", alias="Buf_Text")
    reserved: Optional[StrictInt] = Field(default=None, alias="Reserved")
    __properties: ClassVar[List[str]] = ["SymbolsCount", "StringResult", "Buf_Length", "Buf_Text", "Reserved"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StringRecognitionResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in string_result (list)
        _items = []
        if self.string_result:
            for _item_string_result in self.string_result:
                if _item_string_result:
                    _items.append(_item_string_result.to_dict())
            _dict['StringResult'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StringRecognitionResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "SymbolsCount": obj.get("SymbolsCount"),
            "StringResult": [SymbolRecognitionResult.from_dict(_item) for _item in obj["StringResult"]] if obj.get("StringResult") is not None else None,
            "Buf_Length": obj.get("Buf_Length"),
            "Buf_Text": obj.get("Buf_Text"),
            "Reserved": obj.get("Reserved")
        })
        return _obj


