# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from regula.documentreader.webclient.gen.models.area_array import AreaArray
from regula.documentreader.webclient.gen.models.check_result import CheckResult
from regula.documentreader.webclient.gen.models.image_quality_check_type import ImageQualityCheckType
from regula.documentreader.webclient.gen.models.security_feature_type import SecurityFeatureType
from typing import Optional, Set
from typing_extensions import Self

class ImageQualityCheck(BaseModel):
    """
    ImageQualityCheck
    """ # noqa: E501
    type: ImageQualityCheckType
    result: CheckResult
    feature_type: SecurityFeatureType = Field(alias="featureType")
    areas: Optional[AreaArray] = None
    mean: Union[StrictFloat, StrictInt] = Field(description="Check mean value")
    std_dev: Union[StrictFloat, StrictInt] = Field(description="Check deviation value")
    probability: StrictInt = Field(description="Check probability value")
    __properties: ClassVar[List[str]] = ["type", "result", "featureType", "areas", "mean", "std_dev", "probability"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImageQualityCheck from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of areas
        if self.areas:
            _dict['areas'] = self.areas.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImageQualityCheck from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "result": obj.get("result"),
            "featureType": obj.get("featureType"),
            "areas": AreaArray.from_dict(obj["areas"]) if obj.get("areas") is not None else None,
            "mean": obj.get("mean"),
            "std_dev": obj.get("std_dev"),
            "probability": obj.get("probability")
        })
        return _obj


