# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from regula.documentreader.webclient.gen.models.graphic_field_type import GraphicFieldType
from regula.documentreader.webclient.gen.models.images_field_value import ImagesFieldValue
from typing import Optional, Set
from typing_extensions import Self

class ImagesField(BaseModel):
    """
    ImagesField
    """ # noqa: E501
    field_name: StrictStr = Field(description="Human readable field name. Do not bind to this name - use GraphicFieldType instead.", alias="fieldName")
    field_type: GraphicFieldType = Field(alias="fieldType")
    value_list: List[ImagesFieldValue] = Field(alias="valueList")
    value_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Field value count", alias="valueCount")
    __properties: ClassVar[List[str]] = ["fieldName", "fieldType", "valueList", "valueCount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImagesField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in value_list (list)
        _items = []
        if self.value_list:
            for _item_value_list in self.value_list:
                if _item_value_list:
                    _items.append(_item_value_list.to_dict())
            _dict['valueList'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImagesField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fieldName": obj.get("fieldName"),
            "fieldType": obj.get("fieldType"),
            "valueList": [ImagesFieldValue.from_dict(_item) for _item in obj["valueList"]] if obj.get("valueList") is not None else None,
            "valueCount": obj.get("valueCount")
        })
        return _obj


