# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from regula.documentreader.webclient.gen.models.document_format import DocumentFormat
from regula.documentreader.webclient.gen.models.point import Point
from typing import Optional, Set
from typing_extensions import Self

class MrzPosition(BaseModel):
    """
    MrzPosition
    """ # noqa: E501
    doc_format: DocumentFormat = Field(alias="docFormat")
    angle: Union[StrictFloat, StrictInt] = Field(description="Document rotation angle", alias="Angle")
    width: StrictInt = Field(description="Document width", alias="Width")
    height: StrictInt = Field(description="Document height", alias="Height")
    center: Point = Field(alias="Center")
    left_bottom: Point = Field(alias="LeftBottom")
    left_top: Point = Field(alias="LeftTop")
    right_bottom: Point = Field(alias="RightBottom")
    right_top: Point = Field(alias="RightTop")
    dpi: StrictInt = Field(alias="Dpi")
    inverse: Optional[StrictInt] = Field(default=None, alias="Inverse")
    obj_area: Optional[StrictInt] = Field(default=None, alias="ObjArea")
    obj_int_angle_dev: Optional[StrictInt] = Field(default=None, alias="ObjIntAngleDev")
    perspective_tr: Optional[StrictInt] = Field(default=None, alias="PerspectiveTr")
    result_status: Optional[StrictInt] = Field(default=None, alias="ResultStatus")
    __properties: ClassVar[List[str]] = ["docFormat", "Angle", "Width", "Height", "Center", "LeftBottom", "LeftTop", "RightBottom", "RightTop", "Dpi", "Inverse", "ObjArea", "ObjIntAngleDev", "PerspectiveTr", "ResultStatus"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MrzPosition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of center
        if self.center:
            _dict['Center'] = self.center.to_dict()
        # override the default output from pydantic by calling `to_dict()` of left_bottom
        if self.left_bottom:
            _dict['LeftBottom'] = self.left_bottom.to_dict()
        # override the default output from pydantic by calling `to_dict()` of left_top
        if self.left_top:
            _dict['LeftTop'] = self.left_top.to_dict()
        # override the default output from pydantic by calling `to_dict()` of right_bottom
        if self.right_bottom:
            _dict['RightBottom'] = self.right_bottom.to_dict()
        # override the default output from pydantic by calling `to_dict()` of right_top
        if self.right_top:
            _dict['RightTop'] = self.right_top.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MrzPosition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "docFormat": obj.get("docFormat"),
            "Angle": obj.get("Angle"),
            "Width": obj.get("Width"),
            "Height": obj.get("Height"),
            "Center": Point.from_dict(obj["Center"]) if obj.get("Center") is not None else None,
            "LeftBottom": Point.from_dict(obj["LeftBottom"]) if obj.get("LeftBottom") is not None else None,
            "LeftTop": Point.from_dict(obj["LeftTop"]) if obj.get("LeftTop") is not None else None,
            "RightBottom": Point.from_dict(obj["RightBottom"]) if obj.get("RightBottom") is not None else None,
            "RightTop": Point.from_dict(obj["RightTop"]) if obj.get("RightTop") is not None else None,
            "Dpi": obj.get("Dpi"),
            "Inverse": obj.get("Inverse"),
            "ObjArea": obj.get("ObjArea"),
            "ObjIntAngleDev": obj.get("ObjIntAngleDev"),
            "PerspectiveTr": obj.get("PerspectiveTr"),
            "ResultStatus": obj.get("ResultStatus")
        })
        return _obj


