# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from regula.documentreader.webclient.gen.models.document_format import DocumentFormat
from regula.documentreader.webclient.gen.models.rfid_data_group_type_tag import RfidDataGroupTypeTag
from typing import Optional, Set
from typing_extensions import Self

class RfidDG1(BaseModel):
    """
    Structure used to store the contents of EF.DG1 informational data group of ePassport application – document MRZ data
    """ # noqa: E501
    type: RfidDataGroupTypeTag = Field(alias="Type")
    document_id: DocumentFormat = Field(alias="DocumentID")
    document_type: StrictStr = Field(description="Symbolic code of document type", alias="DocumentType")
    state: StrictStr = Field(description="Symbolic code of document issuing state", alias="State")
    holder: StrictStr = Field(description="DO’s name and surname", alias="Holder")
    document_number: StrictStr = Field(description="Document number", alias="DocumentNumber")
    check_digit_document_number: Union[StrictFloat, StrictInt] = Field(description="Check digit of document number", alias="CheckDigitDocumentNumber")
    nationality: StrictStr = Field(description="Symbolic code of DO’s nationality", alias="Nationality")
    birthday: StrictStr = Field(description="DO’s date of birth", alias="Birthday")
    check_digit_birthday: Union[StrictFloat, StrictInt] = Field(description="Check digit of DO’s date of birth", alias="CheckDigitBirthday")
    sex: StrictStr = Field(description="DO’s sex", alias="Sex")
    expiry_date: StrictStr = Field(description="Term of validity of the document", alias="ExpiryDate")
    check_digit_expiry_date: Union[StrictFloat, StrictInt] = Field(description="Check digit of term of validity of the document", alias="CheckDigitExpiryDate")
    optional_data: StrictStr = Field(description="DO’s personal number or other additional data", alias="OptionalData")
    check_digit_optional_data: Union[StrictFloat, StrictInt] = Field(description="Check digit of additional data", alias="CheckDigitOptionalData")
    check_digit_composite: Union[StrictFloat, StrictInt] = Field(description="General check digit", alias="CheckDigitComposite")
    __properties: ClassVar[List[str]] = ["Type", "DocumentID", "DocumentType", "State", "Holder", "DocumentNumber", "CheckDigitDocumentNumber", "Nationality", "Birthday", "CheckDigitBirthday", "Sex", "ExpiryDate", "CheckDigitExpiryDate", "OptionalData", "CheckDigitOptionalData", "CheckDigitComposite"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RfidDG1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RfidDG1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Type": obj.get("Type"),
            "DocumentID": obj.get("DocumentID"),
            "DocumentType": obj.get("DocumentType"),
            "State": obj.get("State"),
            "Holder": obj.get("Holder"),
            "DocumentNumber": obj.get("DocumentNumber"),
            "CheckDigitDocumentNumber": obj.get("CheckDigitDocumentNumber"),
            "Nationality": obj.get("Nationality"),
            "Birthday": obj.get("Birthday"),
            "CheckDigitBirthday": obj.get("CheckDigitBirthday"),
            "Sex": obj.get("Sex"),
            "ExpiryDate": obj.get("ExpiryDate"),
            "CheckDigitExpiryDate": obj.get("CheckDigitExpiryDate"),
            "OptionalData": obj.get("OptionalData"),
            "CheckDigitOptionalData": obj.get("CheckDigitOptionalData"),
            "CheckDigitComposite": obj.get("CheckDigitComposite")
        })
        return _obj


