# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.container_list import ContainerList
from regula.documentreader.webclient.gen.models.processing_status import ProcessingStatus
from regula.documentreader.webclient.gen.models.rfid_location import RfidLocation
from regula.documentreader.webclient.gen.models.transaction_info import TransactionInfo
from typing import Optional, Set
from typing_extensions import Self

class ProcessResponse(BaseModel):
    """
    ProcessResponse
    """ # noqa: E501
    chip_page: RfidLocation = Field(alias="ChipPage")
    core_lib_result_code: Optional[StrictInt] = Field(default=None, alias="CoreLibResultCode")
    processing_finished: ProcessingStatus = Field(alias="ProcessingFinished")
    container_list: ContainerList = Field(alias="ContainerList")
    transaction_info: TransactionInfo = Field(alias="TransactionInfo")
    log: Optional[StrictStr] = Field(default=None, description="Base64 encoded transaction processing log")
    pass_back_object: Optional[Dict[str, Any]] = Field(default=None, description="Free-form object provided in request. See passBackObject property of ProcessRequest.", alias="passBackObject")
    more_pages_available: StrictInt = Field(alias="morePagesAvailable")
    elapsed_time: StrictInt = Field(description="Time the document processing has taken, ms.", alias="elapsedTime")
    metadata: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["ChipPage", "CoreLibResultCode", "ProcessingFinished", "ContainerList", "TransactionInfo", "log", "passBackObject", "morePagesAvailable", "elapsedTime", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProcessResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of container_list
        if self.container_list:
            _dict['ContainerList'] = self.container_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transaction_info
        if self.transaction_info:
            _dict['TransactionInfo'] = self.transaction_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProcessResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ChipPage": obj.get("ChipPage"),
            "CoreLibResultCode": obj.get("CoreLibResultCode"),
            "ProcessingFinished": obj.get("ProcessingFinished"),
            "ContainerList": ContainerList.from_dict(obj["ContainerList"]) if obj.get("ContainerList") is not None else None,
            "TransactionInfo": TransactionInfo.from_dict(obj["TransactionInfo"]) if obj.get("TransactionInfo") is not None else None,
            "log": obj.get("log"),
            "passBackObject": obj.get("passBackObject"),
            "morePagesAvailable": obj.get("morePagesAvailable"),
            "elapsedTime": obj.get("elapsedTime"),
            "metadata": obj.get("metadata")
        })
        return _obj


