# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.device_info_documents_database import DeviceInfoDocumentsDatabase
from typing import Optional, Set
from typing_extensions import Self

class DeviceInfo(BaseModel):
    """
    DeviceInfo
    """ # noqa: E501
    app_name: Optional[StrictStr] = Field(default=None, description="Application name.", alias="app-name")
    version: Optional[StrictStr] = Field(default=None, description="Product version.")
    license_id: Optional[StrictStr] = Field(default=None, description="Unique license identifier.", alias="license-id")
    license_serial: Optional[StrictStr] = Field(default=None, description="License serial number.", alias="license-serial")
    license_type: Optional[StrictStr] = Field(default=None, alias="license-type")
    valid_until: Optional[datetime] = Field(default=None, description="License validity date.", alias="valid-until")
    server_time: Optional[StrictStr] = Field(default=None, alias="server-time")
    supported_scenarios: Optional[List[StrictStr]] = Field(default=None, description="List of supported scenarios.", alias="supported-scenarios")
    metadata: Optional[Dict[str, Any]] = None
    documents_database: Optional[DeviceInfoDocumentsDatabase] = Field(default=None, alias="documents-database")
    __properties: ClassVar[List[str]] = ["app-name", "version", "license-id", "license-serial", "license-type", "valid-until", "server-time", "supported-scenarios", "metadata", "documents-database"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeviceInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of documents_database
        if self.documents_database:
            _dict['documents-database'] = self.documents_database.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeviceInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "app-name": obj.get("app-name"),
            "version": obj.get("version"),
            "license-id": obj.get("license-id"),
            "license-serial": obj.get("license-serial"),
            "license-type": obj.get("license-type"),
            "valid-until": obj.get("valid-until"),
            "server-time": obj.get("server-time"),
            "supported-scenarios": obj.get("supported-scenarios"),
            "metadata": obj.get("metadata"),
            "documents-database": DeviceInfoDocumentsDatabase.from_dict(obj["documents-database"]) if obj.get("documents-database") is not None else None
        })
        return _obj


