# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from regula.documentreader.webclient.gen.models.document_format import DocumentFormat
from regula.documentreader.webclient.gen.models.document_type import DocumentType
from typing import Optional, Set
from typing_extensions import Self

class FDSIDList(BaseModel):
    """
    Extended document type info and Regula's 'Information Reference Systems' links
    """ # noqa: E501
    icao_code: Annotated[str, Field(min_length=3, strict=True, max_length=3)] = Field(description="ICAO code of the issuing country", alias="ICAOCode")
    count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Number of elements in the List", alias="Count")
    list: Optional[List[StrictInt]] = Field(default=None, description="Document identifiers in 'Information Reference Systems'", alias="List")
    d_type: DocumentType = Field(alias="dType")
    d_format: DocumentFormat = Field(alias="dFormat")
    d_mrz: StrictBool = Field(description="Flag indicating the presence of MRZ on the document", alias="dMRZ")
    d_description: Optional[StrictStr] = Field(default=None, description="Document description", alias="dDescription")
    d_year: Optional[StrictStr] = Field(default=None, description="Year of publication of the document", alias="dYear")
    d_country_name: StrictStr = Field(description="Issuing country name", alias="dCountryName")
    d_state_code: Optional[StrictStr] = Field(default=None, description="Issuing state code", alias="dStateCode")
    d_state_name: Optional[StrictStr] = Field(default=None, description="Issuing state name", alias="dStateName")
    is_deprecated: StrictBool = Field(description="Whether the document is deprecated", alias="isDeprecated")
    __properties: ClassVar[List[str]] = ["ICAOCode", "Count", "List", "dType", "dFormat", "dMRZ", "dDescription", "dYear", "dCountryName", "dStateCode", "dStateName", "isDeprecated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FDSIDList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FDSIDList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ICAOCode": obj.get("ICAOCode"),
            "Count": obj.get("Count"),
            "List": obj.get("List"),
            "dType": obj.get("dType"),
            "dFormat": obj.get("dFormat"),
            "dMRZ": obj.get("dMRZ"),
            "dDescription": obj.get("dDescription"),
            "dYear": obj.get("dYear"),
            "dCountryName": obj.get("dCountryName"),
            "dStateCode": obj.get("dStateCode"),
            "dStateName": obj.get("dStateName"),
            "isDeprecated": obj.get("isDeprecated")
        })
        return _obj


