# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from regula.documentreader.webclient.gen.models.parsing_error_codes import ParsingErrorCodes
from regula.documentreader.webclient.gen.models.rfid_attribute_data import RfidAttributeData
from regula.documentreader.webclient.gen.models.rfid_certificate_ex import RfidCertificateEx
from regula.documentreader.webclient.gen.models.rfid_distinguished_name import RfidDistinguishedName
from regula.documentreader.webclient.gen.models.rfid_error_codes import RFIDErrorCodes
from regula.documentreader.webclient.gen.models.trf_ft_bytes import TrfFtBytes
from typing import Optional, Set
from typing_extensions import Self

class RfidSignerInfoEx(BaseModel):
    """
    Structure is used to describe the contents of a single copy of digital signature of the document security object and the results of its check within the context of the communication session with electronic document
    """ # noqa: E501
    version: Union[StrictFloat, StrictInt] = Field(description="Version of SignerInfo ASN.1 structure", alias="Version")
    issuer: RfidDistinguishedName = Field(alias="Issuer")
    serial_number: TrfFtBytes = Field(alias="SerialNumber")
    subject_key_identifier: TrfFtBytes = Field(alias="SubjectKeyIdentifier")
    digest_algorithm: StrictStr = Field(description="Hash algorithm identifier (OID) for digital signature generation", alias="DigestAlgorithm")
    signed_attributes: List[RfidAttributeData] = Field(description="List of the signed attributes", alias="SignedAttributes")
    signature_algorithm: StrictStr = Field(description="Digital signature algorithm identifier (OID)", alias="SignatureAlgorithm")
    signature: TrfFtBytes = Field(alias="Signature")
    pa_status: RFIDErrorCodes = Field(alias="PA_Status")
    certificate_chain: List[RfidCertificateEx] = Field(description="Certificate chain, used for the digital signature verification.", alias="CertificateChain")
    data_to_hash: StrictStr = Field(description="Binary data array used to calculate the hash value for digital signature verification. Base64 encoded.", alias="DataToHash")
    notifications: List[ParsingErrorCodes] = Field(alias="Notifications")
    __properties: ClassVar[List[str]] = ["Version", "Issuer", "SerialNumber", "SubjectKeyIdentifier", "DigestAlgorithm", "SignedAttributes", "SignatureAlgorithm", "Signature", "PA_Status", "CertificateChain", "DataToHash", "Notifications"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RfidSignerInfoEx from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of issuer
        if self.issuer:
            _dict['Issuer'] = self.issuer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of serial_number
        if self.serial_number:
            _dict['SerialNumber'] = self.serial_number.to_dict()
        # override the default output from pydantic by calling `to_dict()` of subject_key_identifier
        if self.subject_key_identifier:
            _dict['SubjectKeyIdentifier'] = self.subject_key_identifier.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in signed_attributes (list)
        _items = []
        if self.signed_attributes:
            for _item_signed_attributes in self.signed_attributes:
                if _item_signed_attributes:
                    _items.append(_item_signed_attributes.to_dict())
            _dict['SignedAttributes'] = _items
        # override the default output from pydantic by calling `to_dict()` of signature
        if self.signature:
            _dict['Signature'] = self.signature.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in certificate_chain (list)
        _items = []
        if self.certificate_chain:
            for _item_certificate_chain in self.certificate_chain:
                if _item_certificate_chain:
                    _items.append(_item_certificate_chain.to_dict())
            _dict['CertificateChain'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RfidSignerInfoEx from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Version": obj.get("Version"),
            "Issuer": RfidDistinguishedName.from_dict(obj["Issuer"]) if obj.get("Issuer") is not None else None,
            "SerialNumber": TrfFtBytes.from_dict(obj["SerialNumber"]) if obj.get("SerialNumber") is not None else None,
            "SubjectKeyIdentifier": TrfFtBytes.from_dict(obj["SubjectKeyIdentifier"]) if obj.get("SubjectKeyIdentifier") is not None else None,
            "DigestAlgorithm": obj.get("DigestAlgorithm"),
            "SignedAttributes": [RfidAttributeData.from_dict(_item) for _item in obj.get("SignedAttributes", []) if RfidAttributeData.from_dict(_item) is not None],
            "SignatureAlgorithm": obj.get("SignatureAlgorithm"),
            "Signature": TrfFtBytes.from_dict(obj["Signature"]) if obj.get("Signature") is not None else None,
            "PA_Status": obj.get("PA_Status"),
            "CertificateChain": [RfidCertificateEx.from_dict(_item) for _item in obj.get("CertificateChain", []) if RfidCertificateEx.from_dict(_item) is not None],
            "DataToHash": obj.get("DataToHash"),
            "Notifications": obj.get("Notifications")
        })
        return _obj


