# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.authenticity_check_result_item import AuthenticityCheckResultItem
from regula.documentreader.webclient.gen.models.authenticity_result_type import AuthenticityResultType
from regula.documentreader.webclient.gen.models.check_diagnose import CheckDiagnose
from regula.documentreader.webclient.gen.models.check_result import CheckResult
from regula.documentreader.webclient.gen.models.critical import Critical
from regula.documentreader.webclient.gen.models.light import Light
from regula.documentreader.webclient.gen.models.rectangle_coordinates import RectangleCoordinates
from regula.documentreader.webclient.gen.models.text_field_type import TextFieldType
from typing import Optional, Set
from typing_extensions import Self

class OCRSecurityTextResult(AuthenticityCheckResultItem):
    """
    OCRSecurityTextResult
    """ # noqa: E501
    critical_flag: Critical = Field(alias="CriticalFlag")
    light_type: Light = Field(alias="LightType")
    field_rect: RectangleCoordinates = Field(alias="FieldRect")
    etalon_result_type: StrictInt = Field(description="Same as Result type, but used for safe parsing of not-described values. See Result type.", alias="EtalonResultType")
    etalon_field_type: TextFieldType = Field(alias="EtalonFieldType")
    etalon_light_type: Light = Field(alias="EtalonLightType")
    etalon_field_rect: RectangleCoordinates = Field(alias="EtalonFieldRect")
    security_text_result_ocr: StrictStr = Field(alias="SecurityTextResultOCR")
    etalon_result_ocr: StrictStr = Field(alias="EtalonResultOCR")
    reserved1: Optional[StrictInt] = Field(default=None, alias="Reserved1")
    reserved2: Optional[StrictInt] = Field(default=None, alias="Reserved2")
    __properties: ClassVar[List[str]] = ["Type", "ElementResult", "ElementDiagnose", "PercentValue", "CriticalFlag", "LightType", "FieldRect", "EtalonResultType", "EtalonFieldType", "EtalonLightType", "EtalonFieldRect", "SecurityTextResultOCR", "EtalonResultOCR", "Reserved1", "Reserved2"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OCRSecurityTextResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of field_rect
        if self.field_rect:
            _dict['FieldRect'] = self.field_rect.to_dict()
        # override the default output from pydantic by calling `to_dict()` of etalon_field_rect
        if self.etalon_field_rect:
            _dict['EtalonFieldRect'] = self.etalon_field_rect.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OCRSecurityTextResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Type": obj.get("Type"),
            "ElementResult": obj.get("ElementResult"),
            "ElementDiagnose": obj.get("ElementDiagnose"),
            "PercentValue": obj.get("PercentValue"),
            "CriticalFlag": obj.get("CriticalFlag"),
            "LightType": obj.get("LightType"),
            "FieldRect": RectangleCoordinates.from_dict(obj["FieldRect"]) if obj.get("FieldRect") is not None else None,
            "EtalonResultType": obj.get("EtalonResultType") if obj.get("EtalonResultType") is not None else 0,
            "EtalonFieldType": obj.get("EtalonFieldType"),
            "EtalonLightType": obj.get("EtalonLightType"),
            "EtalonFieldRect": RectangleCoordinates.from_dict(obj["EtalonFieldRect"]) if obj.get("EtalonFieldRect") is not None else None,
            "SecurityTextResultOCR": obj.get("SecurityTextResultOCR"),
            "EtalonResultOCR": obj.get("EtalonResultOCR"),
            "Reserved1": obj.get("Reserved1"),
            "Reserved2": obj.get("Reserved2")
        })
        return _obj


