# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from regula.documentreader.webclient.gen.models.check_result import CheckResult
from regula.documentreader.webclient.gen.models.original_symbol import OriginalSymbol
from regula.documentreader.webclient.gen.models.rectangle_coordinates import RectangleCoordinates
from regula.documentreader.webclient.gen.models.rfid_origin import RfidOrigin
from regula.documentreader.webclient.gen.models.source import Source
from typing import Optional, Set
from typing_extensions import Self

class TextFieldValue(BaseModel):
    """
    TextFieldValue
    """ # noqa: E501
    source: Source
    value: StrictStr = Field(description="Parsed/processed value. Date format converted for output, delimiters removed")
    original_value: Optional[StrictStr] = Field(default=None, description="Original value as seen in the document", alias="originalValue")
    original_validity: CheckResult = Field(alias="originalValidity")
    original_symbols: Optional[List[OriginalSymbol]] = Field(default=None, alias="originalSymbols")
    page_index: StrictInt = Field(description="Page index of the image from input list", alias="pageIndex")
    probability: Annotated[int, Field(le=100, strict=True, ge=0)] = Field(description="Min recognition probability. Combined minimum probability from single characters probabilities")
    field_rect: Optional[RectangleCoordinates] = Field(default=None, alias="fieldRect")
    rfid_origin: Optional[RfidOrigin] = Field(default=None, alias="rfidOrigin")
    container_type: Optional[StrictInt] = Field(default=0, description="Same as Result type, but used for safe parsing of not-described values. See Result type.", alias="containerType")
    __properties: ClassVar[List[str]] = ["source", "value", "originalValue", "originalValidity", "originalSymbols", "pageIndex", "probability", "fieldRect", "rfidOrigin", "containerType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TextFieldValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in original_symbols (list)
        _items = []
        if self.original_symbols:
            for _item_original_symbols in self.original_symbols:
                if _item_original_symbols:
                    _items.append(_item_original_symbols.to_dict())
            _dict['originalSymbols'] = _items
        # override the default output from pydantic by calling `to_dict()` of field_rect
        if self.field_rect:
            _dict['fieldRect'] = self.field_rect.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rfid_origin
        if self.rfid_origin:
            _dict['rfidOrigin'] = self.rfid_origin.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TextFieldValue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "source": obj.get("source"),
            "value": obj.get("value"),
            "originalValue": obj.get("originalValue"),
            "originalValidity": obj.get("originalValidity"),
            "originalSymbols": [OriginalSymbol.from_dict(_item) for _item in obj.get("originalSymbols", []) if OriginalSymbol.from_dict(_item) is not None],
            "pageIndex": obj.get("pageIndex"),
            "probability": obj.get("probability"),
            "fieldRect": RectangleCoordinates.from_dict(obj["fieldRect"]) if obj.get("fieldRect") is not None else None,
            "rfidOrigin": RfidOrigin.from_dict(obj["rfidOrigin"]) if obj.get("rfidOrigin") is not None else None,
            "containerType": obj.get("containerType") if obj.get("containerType") is not None else 0
        })
        return _obj


