# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from regula.documentreader.webclient.gen.models.check_result import CheckResult
from regula.documentreader.webclient.gen.models.error_coordinates import ErrorCoordinates
from regula.documentreader.webclient.gen.models.field_item import FieldItem
from regula.documentreader.webclient.gen.models.rectangle_coordinates import RectangleCoordinates
from regula.documentreader.webclient.gen.models.symbol_estimation_item import SymbolEstimationItem
from typing import Optional, Set
from typing_extensions import Self

class StringItem(BaseModel):
    """
    StringItem
    """ # noqa: E501
    alignment_symbols_in_string: CheckResult = Field(alias="ALIGNMENT_SYMBOLS_IN_STRING")
    check_sums: CheckResult = Field(alias="CHECK_SUMS")
    error_position: ErrorCoordinates = Field(alias="ErrorPOSITION")
    field_count: StrictInt = Field(alias="FieldCount")
    fields: List[FieldItem] = Field(alias="Fields")
    strings_distance: CheckResult = Field(alias="STRINGS_DISTANCE")
    strings_interval: CheckResult = Field(alias="STRINGS_INTERVAL")
    string_filling: CheckResult = Field(alias="STRING_FILLING")
    strings_position: Optional[CheckResult] = Field(default=None, alias="STRINGS_POSITION")
    symbols_param: CheckResult = Field(alias="SYMBOLS_PARAM")
    size_error_alignment: Union[StrictFloat, StrictInt] = Field(alias="SizeError_ALIGNMENT")
    size_error_distance: Union[StrictFloat, StrictInt] = Field(alias="SizeError_DISTANCE")
    size_error_interval: Union[StrictFloat, StrictInt] = Field(alias="SizeError_INTERVAL")
    string_angle: Union[StrictFloat, StrictInt] = Field(alias="StringAngle")
    string_borders: RectangleCoordinates = Field(alias="StringBorders")
    symbols_count: StrictInt = Field(alias="SymbolsCount")
    symbols_estimations: List[SymbolEstimationItem] = Field(alias="SymbolsEstimations")
    __properties: ClassVar[List[str]] = ["ALIGNMENT_SYMBOLS_IN_STRING", "CHECK_SUMS", "ErrorPOSITION", "FieldCount", "Fields", "STRINGS_DISTANCE", "STRINGS_INTERVAL", "STRING_FILLING", "STRINGS_POSITION", "SYMBOLS_PARAM", "SizeError_ALIGNMENT", "SizeError_DISTANCE", "SizeError_INTERVAL", "StringAngle", "StringBorders", "SymbolsCount", "SymbolsEstimations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StringItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of error_position
        if self.error_position:
            _dict['ErrorPOSITION'] = self.error_position.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in fields (list)
        _items = []
        if self.fields:
            for _item_fields in self.fields:
                if _item_fields:
                    _items.append(_item_fields.to_dict())
            _dict['Fields'] = _items
        # override the default output from pydantic by calling `to_dict()` of string_borders
        if self.string_borders:
            _dict['StringBorders'] = self.string_borders.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in symbols_estimations (list)
        _items = []
        if self.symbols_estimations:
            for _item_symbols_estimations in self.symbols_estimations:
                if _item_symbols_estimations:
                    _items.append(_item_symbols_estimations.to_dict())
            _dict['SymbolsEstimations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StringItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ALIGNMENT_SYMBOLS_IN_STRING": obj.get("ALIGNMENT_SYMBOLS_IN_STRING"),
            "CHECK_SUMS": obj.get("CHECK_SUMS"),
            "ErrorPOSITION": ErrorCoordinates.from_dict(obj["ErrorPOSITION"]) if obj.get("ErrorPOSITION") is not None else None,
            "FieldCount": obj.get("FieldCount"),
            "Fields": [FieldItem.from_dict(_item) for _item in obj.get("Fields", []) if FieldItem.from_dict(_item) is not None],
            "STRINGS_DISTANCE": obj.get("STRINGS_DISTANCE"),
            "STRINGS_INTERVAL": obj.get("STRINGS_INTERVAL"),
            "STRING_FILLING": obj.get("STRING_FILLING"),
            "STRINGS_POSITION": obj.get("STRINGS_POSITION"),
            "SYMBOLS_PARAM": obj.get("SYMBOLS_PARAM"),
            "SizeError_ALIGNMENT": obj.get("SizeError_ALIGNMENT"),
            "SizeError_DISTANCE": obj.get("SizeError_DISTANCE"),
            "SizeError_INTERVAL": obj.get("SizeError_INTERVAL"),
            "StringAngle": obj.get("StringAngle"),
            "StringBorders": RectangleCoordinates.from_dict(obj["StringBorders"]) if obj.get("StringBorders") is not None else None,
            "SymbolsCount": obj.get("SymbolsCount"),
            "SymbolsEstimations": [SymbolEstimationItem.from_dict(_item) for _item in obj.get("SymbolsEstimations", []) if SymbolEstimationItem.from_dict(_item) is not None]
        })
        return _obj


