# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.light import Light
from regula.documentreader.webclient.gen.models.rectangle_coordinates import RectangleCoordinates
from typing import Optional, Set
from typing_extensions import Self

class FiberItem(BaseModel):
    """
    FiberItem
    """ # noqa: E501
    rect_count: StrictInt = Field(description="For UV_Fibers authenticity result type", alias="RectCount")
    expected_count: StrictInt = Field(description="Expected fibers number. For UV_Fibers authentication result type", alias="ExpectedCount")
    light_value: Optional[Light] = Field(default=None, alias="LightValue")
    light_disp: Optional[StrictInt] = Field(default=None, description="For UV_Background authentication result type", alias="LightDisp")
    rect_array: List[RectangleCoordinates] = Field(description="Coordinates of located areas for defined fibers type", alias="RectArray")
    width: List[StrictInt] = Field(description="Fibers width value for located areas (in pixels)", alias="Width")
    length: List[StrictInt] = Field(description="Fibers length value for located areas (in pixels)", alias="Length")
    area: List[StrictInt] = Field(description="Fibers value for areas (in pixels)", alias="Area")
    color_values: List[StrictInt] = Field(description="Fibers color value", alias="ColorValues")
    __properties: ClassVar[List[str]] = ["RectCount", "ExpectedCount", "LightValue", "LightDisp", "RectArray", "Width", "Length", "Area", "ColorValues"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FiberItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in rect_array (list)
        _items = []
        if self.rect_array:
            for _item_rect_array in self.rect_array:
                if _item_rect_array:
                    _items.append(_item_rect_array.to_dict())
            _dict['RectArray'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FiberItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "RectCount": obj.get("RectCount"),
            "ExpectedCount": obj.get("ExpectedCount"),
            "LightValue": obj.get("LightValue"),
            "LightDisp": obj.get("LightDisp"),
            "RectArray": [RectangleCoordinates.from_dict(_item) for _item in obj.get("RectArray", []) if RectangleCoordinates.from_dict(_item) is not None],
            "Width": obj.get("Width"),
            "Length": obj.get("Length"),
            "Area": obj.get("Area"),
            "ColorValues": obj.get("ColorValues")
        })
        return _obj


