# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from regula.documentreader.webclient.gen.models.rfid_signer_info_ex import RfidSignerInfoEx
from typing import Optional, Set
from typing_extensions import Self

class RfidSecurityObject(BaseModel):
    """
    Structure is used to describe the contents of a single document security object (SO) and the results of its check within the context of the communication session with electronic document
    """ # noqa: E501
    version: Union[StrictFloat, StrictInt] = Field(description="Security object version", alias="Version")
    object_type: StrictStr = Field(description="Identifier of the security object", alias="ObjectType")
    file_reference: Union[StrictFloat, StrictInt] = Field(description="Reference to the source file of the security object data", alias="FileReference")
    notifications: List[StrictInt] = Field(description="List of remarks arisen during the analysis of SO data structure. Can be ParsingErrorCodes or ParsingNotificationCodes enum.", alias="Notifications")
    signer_infos: List[RfidSignerInfoEx] = Field(description="List of containers to store information about digital signature objects contained in the SO", alias="SignerInfos")
    __properties: ClassVar[List[str]] = ["Version", "ObjectType", "FileReference", "Notifications", "SignerInfos"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RfidSecurityObject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in signer_infos (list)
        _items = []
        if self.signer_infos:
            for _item_signer_infos in self.signer_infos:
                if _item_signer_infos:
                    _items.append(_item_signer_infos.to_dict())
            _dict['SignerInfos'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RfidSecurityObject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Version": obj.get("Version"),
            "ObjectType": obj.get("ObjectType"),
            "FileReference": obj.get("FileReference"),
            "Notifications": obj.get("Notifications"),
            "SignerInfos": [RfidSignerInfoEx.from_dict(_item) for _item in obj.get("SignerInfos", []) if RfidSignerInfoEx.from_dict(_item) is not None]
        })
        return _obj


