# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from regula.documentreader.webclient.gen.models.check_result import CheckResult
from regula.documentreader.webclient.gen.models.text_available_source import TextAvailableSource
from regula.documentreader.webclient.gen.models.text_field import TextField
from typing import Optional, Set
from typing_extensions import Self

class Text(BaseModel):
    """
    Contains all document text fields data with validity and cross-source compare checks
    """ # noqa: E501
    status: CheckResult
    validity_status: CheckResult = Field(alias="validityStatus")
    comparison_status: CheckResult = Field(alias="comparisonStatus")
    date_format: StrictStr = Field(description="Date format", alias="dateFormat")
    field_list: List[TextField] = Field(alias="fieldList")
    available_source_list: List[TextAvailableSource] = Field(alias="availableSourceList")
    __properties: ClassVar[List[str]] = ["status", "validityStatus", "comparisonStatus", "dateFormat", "fieldList", "availableSourceList"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Text from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in field_list (list)
        _items = []
        if self.field_list:
            for _item_field_list in self.field_list:
                if _item_field_list:
                    _items.append(_item_field_list.to_dict())
            _dict['fieldList'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in available_source_list (list)
        _items = []
        if self.available_source_list:
            for _item_available_source_list in self.available_source_list:
                if _item_available_source_list:
                    _items.append(_item_available_source_list.to_dict())
            _dict['availableSourceList'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Text from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "validityStatus": obj.get("validityStatus"),
            "comparisonStatus": obj.get("comparisonStatus"),
            "dateFormat": obj.get("dateFormat"),
            "fieldList": [TextField.from_dict(_item) for _item in obj.get("fieldList", []) if TextField.from_dict(_item) is not None],
            "availableSourceList": [TextAvailableSource.from_dict(_item) for _item in obj.get("availableSourceList", []) if TextAvailableSource.from_dict(_item) is not None]
        })
        return _obj


