# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from regula.documentreader.webclient.gen.models.rfid_attribute_name import RfidAttributeName
from regula.documentreader.webclient.gen.models.trf_ft_string import TrfFtString
from typing import Optional, Set
from typing_extensions import Self

class RfidDistinguishedName(BaseModel):
    """
    Contents of the identifier in binary form. Base64 encoded.
    """ # noqa: E501
    data: StrictStr = Field(description="Contents of the identifier in binary form. Base64 encoded.", alias="Data")
    friendly_name: TrfFtString = Field(alias="FriendlyName")
    attributes: List[RfidAttributeName] = Field(description="List of individual attributes contained in the identifier", alias="Attributes")
    __properties: ClassVar[List[str]] = ["Data", "FriendlyName", "Attributes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RfidDistinguishedName from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of friendly_name
        if self.friendly_name:
            _dict['FriendlyName'] = self.friendly_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item_attributes in self.attributes:
                if _item_attributes:
                    _items.append(_item_attributes.to_dict())
            _dict['Attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RfidDistinguishedName from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Data": obj.get("Data"),
            "FriendlyName": TrfFtString.from_dict(obj["FriendlyName"]) if obj.get("FriendlyName") is not None else None,
            "Attributes": [RfidAttributeName.from_dict(_item) for _item in obj.get("Attributes", []) if RfidAttributeName.from_dict(_item) is not None]
        })
        return _obj


