# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List
from regula.documentreader.webclient.gen.models.check_result import CheckResult
from regula.documentreader.webclient.gen.models.string_item import StringItem
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class MRZTestQuality(BaseModel):
    """
    MRZTestQuality
    """ # noqa: E501
    check_sums: SkipValidation[CheckResult] = Field(alias="CHECK_SUMS")
    contrast_print: SkipValidation[CheckResult] = Field(alias="CONTRAST_PRINT")
    doc_format: SkipValidation[int] = Field(alias="DOC_FORMAT")
    mrz_format: SkipValidation[int] = Field(alias="MRZ_FORMAT")
    print_position: SkipValidation[CheckResult] = Field(alias="PRINT_POSITION")
    stain_mrz: SkipValidation[CheckResult] = Field(alias="STAIN_MRZ")
    symbols_param: SkipValidation[CheckResult] = Field(alias="SYMBOLS_PARAM")
    str_count: SkipValidation[int] = Field(alias="StrCount")
    strings: SkipValidation[List[StringItem]] = Field(alias="Strings")
    textual_filling: SkipValidation[CheckResult] = Field(alias="TEXTUAL_FILLING")
    __properties: ClassVar[List[str]] = ["CHECK_SUMS", "CONTRAST_PRINT", "DOC_FORMAT", "MRZ_FORMAT", "PRINT_POSITION", "STAIN_MRZ", "SYMBOLS_PARAM", "StrCount", "Strings", "TEXTUAL_FILLING"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MRZTestQuality from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in strings (list)
        _items = []
        if self.strings:
            for _item_strings in self.strings:
                if _item_strings:
                    _items.append(_item_strings.to_dict())
            _dict['Strings'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MRZTestQuality from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "CHECK_SUMS": obj.get("CHECK_SUMS"),
            "CONTRAST_PRINT": obj.get("CONTRAST_PRINT"),
            "DOC_FORMAT": obj.get("DOC_FORMAT"),
            "MRZ_FORMAT": obj.get("MRZ_FORMAT"),
            "PRINT_POSITION": obj.get("PRINT_POSITION"),
            "STAIN_MRZ": obj.get("STAIN_MRZ"),
            "SYMBOLS_PARAM": obj.get("SYMBOLS_PARAM"),
            "StrCount": obj.get("StrCount"),
            "Strings": [StringItem.from_dict(_item) for _item in obj.get("Strings", []) if StringItem.from_dict(_item) is not None],
            "TEXTUAL_FILLING": obj.get("TEXTUAL_FILLING")
        })
        return _obj


