# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from regula.documentreader.webclient.gen.models.fdsid_list import FDSIDList
from regula.documentreader.webclient.gen.models.rfid_location import RfidLocation
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class ChosenDocumentType(BaseModel):
    """
    Contains information about one document type candidate
    """ # noqa: E501
    document_name: SkipValidation[Optional[str]] = Field(alias="DocumentName", default=None, description="Document name")
    id: SkipValidation[int] = Field(alias="ID", description="Unique document type template identifier (Regula's internal numeric code)")
    p: SkipValidation[float] = Field(alias="P", description="A measure of the likelihood of correct recognition in the analysis of this type of document")
    rotated180: SkipValidation[int] = Field(alias="Rotated180", description="Indicates if the document of the given type is rotated by 180 degrees")
    rfid_presence: SkipValidation[RfidLocation] = Field(alias="RFID_Presence")
    fdsid_list: SkipValidation[Optional[FDSIDList]] = Field(alias="FDSIDList", default=None)
    necessary_lights: SkipValidation[int] = Field(alias="NecessaryLights", description="Combination of lighting scheme identifiers (Light enum) required to conduct OCR for this type of document")
    check_authenticity: SkipValidation[int] = Field(alias="CheckAuthenticity", description="Set of authentication options provided for this type of document (combination of Authenticity enum)")
    uv_exp: SkipValidation[int] = Field(alias="UVExp", description="The required exposure value of the camera when receiving images of a document of this type for a UV lighting scheme")
    authenticity_necessary_lights: SkipValidation[int] = Field(alias="AuthenticityNecessaryLights", description="Combination of lighting scheme identifiers (combination of Light enum) needed to perform all authenticity checks specified in CheckAuthenticity")
    ovi_exp: SkipValidation[float] = Field(alias="OVIExp", description="Camera exposure value necessary when obtaining document images of the given type for AXIAL lighting scheme")
    rotation_angle: SkipValidation[Optional[int]] = Field(alias="RotationAngle", default=None)
    __properties: ClassVar[List[str]] = ["DocumentName", "ID", "P", "Rotated180", "RFID_Presence", "FDSIDList", "NecessaryLights", "CheckAuthenticity", "UVExp", "AuthenticityNecessaryLights", "OVIExp", "RotationAngle"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChosenDocumentType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of fdsid_list
        if self.fdsid_list:
            _dict['FDSIDList'] = self.fdsid_list.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChosenDocumentType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "DocumentName": obj.get("DocumentName"),
            "ID": obj.get("ID"),
            "P": obj.get("P"),
            "Rotated180": obj.get("Rotated180"),
            "RFID_Presence": obj.get("RFID_Presence"),
            "FDSIDList": FDSIDList.from_dict(obj["FDSIDList"]) if obj.get("FDSIDList") is not None else None,
            "NecessaryLights": obj.get("NecessaryLights"),
            "CheckAuthenticity": obj.get("CheckAuthenticity"),
            "UVExp": obj.get("UVExp"),
            "AuthenticityNecessaryLights": obj.get("AuthenticityNecessaryLights"),
            "OVIExp": obj.get("OVIExp"),
            "RotationAngle": obj.get("RotationAngle")
        })
        return _obj


