# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.doc_feature import DocFeature
from regula.documentreader.webclient.gen.models.rfid_certificate_ex import RfidCertificateEx
from regula.documentreader.webclient.gen.models.trf_ft_bytes import TrfFtBytes
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class VDSData(BaseModel):
    """
    VDSData
    """ # noqa: E501
    certificate: SkipValidation[Optional[str]] = Field(alias="Certificate", default=None)
    certificate_chain: SkipValidation[Optional[List[RfidCertificateEx]]] = Field(alias="CertificateChain", default=None)
    doc_features: SkipValidation[Optional[List[DocFeature]]] = Field(alias="DocFeatures", default=None)
    doc_issue_date: SkipValidation[Optional[str]] = Field(alias="DocIssueDate", default=None)
    doc_type: SkipValidation[Optional[int]] = Field(alias="DocType", default=None)
    feature_ref: SkipValidation[Optional[int]] = Field(alias="FeatureRef", default=None)
    issuing_country: SkipValidation[Optional[str]] = Field(alias="IssuingCountry", default=None)
    notifications: SkipValidation[Optional[List[int]]] = Field(alias="Notifications", default=None)
    signature: SkipValidation[Optional[TrfFtBytes]] = Field(alias="Signature", default=None)
    signature_date: SkipValidation[Optional[str]] = Field(alias="SignatureDate", default=None)
    signer: SkipValidation[Optional[str]] = Field(alias="Signer", default=None)
    type: SkipValidation[Optional[int]] = Field(alias="Type", default=None)
    version: SkipValidation[Optional[int]] = Field(alias="Version", default=None)
    __properties: ClassVar[List[str]] = ["Certificate", "CertificateChain", "DocFeatures", "DocIssueDate", "DocType", "FeatureRef", "IssuingCountry", "Notifications", "Signature", "SignatureDate", "Signer", "Type", "Version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VDSData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in certificate_chain (list)
        _items = []
        if self.certificate_chain:
            for _item_certificate_chain in self.certificate_chain:
                if _item_certificate_chain:
                    _items.append(_item_certificate_chain.to_dict())
            _dict['CertificateChain'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in doc_features (list)
        _items = []
        if self.doc_features:
            for _item_doc_features in self.doc_features:
                if _item_doc_features:
                    _items.append(_item_doc_features.to_dict())
            _dict['DocFeatures'] = _items
        # override the default output from pydantic by calling `to_dict()` of signature
        if self.signature:
            _dict['Signature'] = self.signature.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VDSData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Certificate": obj.get("Certificate"),
            "CertificateChain": [RfidCertificateEx.from_dict(_item) for _item in obj.get("CertificateChain", []) if RfidCertificateEx.from_dict(_item) is not None],
            "DocFeatures": [DocFeature.from_dict(_item) for _item in obj.get("DocFeatures", []) if DocFeature.from_dict(_item) is not None],
            "DocIssueDate": obj.get("DocIssueDate"),
            "DocType": obj.get("DocType"),
            "FeatureRef": obj.get("FeatureRef"),
            "IssuingCountry": obj.get("IssuingCountry"),
            "Notifications": obj.get("Notifications"),
            "Signature": TrfFtBytes.from_dict(obj["Signature"]) if obj.get("Signature") is not None else None,
            "SignatureDate": obj.get("SignatureDate"),
            "Signer": obj.get("Signer"),
            "Type": obj.get("Type"),
            "Version": obj.get("Version")
        })
        return _obj


