# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.message import Message
from regula.documentreader.webclient.gen.models.rfid_certificate_ex import RfidCertificateEx
from regula.documentreader.webclient.gen.models.trf_ft_bytes import TrfFtBytes
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class VDSNCData(BaseModel):
    """
    VDSNCData
    """ # noqa: E501
    certificate: SkipValidation[Optional[TrfFtBytes]] = Field(alias="Certificate", default=None)
    certificate_chain: SkipValidation[Optional[List[RfidCertificateEx]]] = Field(alias="CertificateChain", default=None)
    issuing_country: SkipValidation[Optional[str]] = Field(alias="IssuingCountry", default=None)
    message: SkipValidation[Optional[Message]] = Field(alias="Message", default=None)
    notifications: SkipValidation[Optional[List[int]]] = Field(alias="Notifications", default=None)
    signature: SkipValidation[Optional[TrfFtBytes]] = Field(alias="Signature", default=None)
    signature_alg: SkipValidation[Optional[str]] = Field(alias="SignatureAlg", default=None)
    type: SkipValidation[Optional[str]] = Field(alias="Type", default=None)
    version: SkipValidation[Optional[int]] = Field(alias="Version", default=None)
    __properties: ClassVar[List[str]] = ["Certificate", "CertificateChain", "IssuingCountry", "Message", "Notifications", "Signature", "SignatureAlg", "Type", "Version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VDSNCData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of certificate
        if self.certificate:
            _dict['Certificate'] = self.certificate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in certificate_chain (list)
        _items = []
        if self.certificate_chain:
            for _item_certificate_chain in self.certificate_chain:
                if _item_certificate_chain:
                    _items.append(_item_certificate_chain.to_dict())
            _dict['CertificateChain'] = _items
        # override the default output from pydantic by calling `to_dict()` of message
        if self.message:
            _dict['Message'] = self.message.to_dict()
        # override the default output from pydantic by calling `to_dict()` of signature
        if self.signature:
            _dict['Signature'] = self.signature.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VDSNCData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Certificate": TrfFtBytes.from_dict(obj["Certificate"]) if obj.get("Certificate") is not None else None,
            "CertificateChain": [RfidCertificateEx.from_dict(_item) for _item in obj.get("CertificateChain", []) if RfidCertificateEx.from_dict(_item) is not None],
            "IssuingCountry": obj.get("IssuingCountry"),
            "Message": Message.from_dict(obj["Message"]) if obj.get("Message") is not None else None,
            "Notifications": obj.get("Notifications"),
            "Signature": TrfFtBytes.from_dict(obj["Signature"]) if obj.get("Signature") is not None else None,
            "SignatureAlg": obj.get("SignatureAlg"),
            "Type": obj.get("Type"),
            "Version": obj.get("Version")
        })
        return _obj


