# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.face_api_search import FaceApiSearch
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class FaceApi(BaseModel):
    """
    FaceApi
    """ # noqa: E501
    url: SkipValidation[Optional[str]] = Field(alias="url", default=None, description="The URL of the Regula Face Web service to be used.")
    mode: SkipValidation[Optional[str]] = Field(alias="mode", default=None, description="The processing mode: \"match\" or \"match+search\".")
    search: SkipValidation[Optional[FaceApiSearch]] = Field(alias="search", default=None)
    threshold: SkipValidation[Optional[int]] = Field(alias="threshold", default=None, description="The similarity threshold, 0-100. Above 75 means that the faces' similarity is verified, below 75 is not.")
    service_timeout: SkipValidation[Optional[int]] = Field(alias="serviceTimeout", default=None, description="The Regula Face Web service requests timeout, ms.")
    proxy: SkipValidation[Optional[str]] = Field(alias="proxy", default=None, description="Proxy to use, should be set according to the <a href=\"https://curl.se/libcurl/c/CURLOPT_PROXY.html\" target=\"_blank\">cURL standard</a>.")
    proxy_userpwd: SkipValidation[Optional[str]] = Field(alias="proxy_userpwd", default=None, description="Username and password to use for proxy authentication, should be set according to the <a href=\"https://curl.se/libcurl/c/CURLOPT_PROXYUSERPWD.html\" target=\"_blank\">cURL standard</a>.")
    proxy_type: SkipValidation[Optional[int]] = Field(alias="proxy_type", default=None, description="Proxy protocol type, should be set according to the <a href=\"https://curl.se/libcurl/c/CURLOPT_PROXYTYPE.html\" target=\"_blank\">cURL standard</a>.")
    child_age_threshold: SkipValidation[Optional[int]] = Field(alias="childAgeThreshold", default=None, description="The age threshold for the portrait comparison. Default: 13.")
    child_doc_validity_years: SkipValidation[Optional[int]] = Field(alias="childDocValidityYears", default=None, description="Estimated duration of validity for a child's passport, years. Default: 5.")
    __properties: ClassVar[List[str]] = ["url", "mode", "search", "threshold", "serviceTimeout", "proxy", "proxy_userpwd", "proxy_type", "childAgeThreshold", "childDocValidityYears"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FaceApi from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of search
        if self.search and isinstance(self.search, FaceApiSearch):
            _dict['search'] = self.search.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FaceApi from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "mode": obj.get("mode"),
            "search": FaceApiSearch.from_dict(obj["search"]) if obj.get("search") is not None else None,
            "threshold": obj.get("threshold"),
            "serviceTimeout": obj.get("serviceTimeout"),
            "proxy": obj.get("proxy"),
            "proxy_userpwd": obj.get("proxy_userpwd"),
            "proxy_type": obj.get("proxy_type"),
            "childAgeThreshold": obj.get("childAgeThreshold"),
            "childDocValidityYears": obj.get("childDocValidityYears")
        })
        return _obj


