# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.light import Light
from regula.documentreader.webclient.gen.models.rectangle_coordinates import RectangleCoordinates
from regula.documentreader.webclient.gen.models.rfid_origin import RfidOrigin
from regula.documentreader.webclient.gen.models.source import Source
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class ImagesFieldValue(BaseModel):
    """
    ImagesFieldValue
    """ # noqa: E501
    source: SkipValidation[Source] = Field(alias="source")
    value: SkipValidation[Optional[str]] = Field(alias="value", default=None, description="Base64 encoded image")
    original_value: SkipValidation[Optional[str]] = Field(alias="originalValue", default=None, description="Base64 encoded image")
    original_page_index: SkipValidation[Optional[int]] = Field(alias="originalPageIndex", default=None, description="Original page index")
    page_index: SkipValidation[int] = Field(alias="pageIndex", description="Page index of the image from input list")
    light_index: SkipValidation[Light] = Field(alias="lightIndex")
    container_type: SkipValidation[int] = Field(alias="containerType", description="Same as Result type, but used for safe parsing of not-described values. See Result type.")
    field_rect: SkipValidation[Optional[RectangleCoordinates]] = Field(alias="fieldRect", default=None)
    rfid_origin: SkipValidation[Optional[RfidOrigin]] = Field(alias="rfidOrigin", default=None)
    __properties: ClassVar[List[str]] = ["source", "value", "originalValue", "originalPageIndex", "pageIndex", "lightIndex", "containerType", "fieldRect", "rfidOrigin"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImagesFieldValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of field_rect
        if self.field_rect and isinstance(self.field_rect, RectangleCoordinates):
            _dict['fieldRect'] = self.field_rect.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rfid_origin
        if self.rfid_origin and isinstance(self.rfid_origin, RfidOrigin):
            _dict['rfidOrigin'] = self.rfid_origin.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImagesFieldValue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "source": obj.get("source"),
            "value": obj.get("value"),
            "originalValue": obj.get("originalValue"),
            "originalPageIndex": obj.get("originalPageIndex"),
            "pageIndex": obj.get("pageIndex"),
            "lightIndex": obj.get("lightIndex"),
            "containerType": obj.get("containerType") if obj.get("containerType") is not None else 0,
            "fieldRect": RectangleCoordinates.from_dict(obj["fieldRect"]) if obj.get("fieldRect") is not None else None,
            "rfidOrigin": RfidOrigin.from_dict(obj["rfidOrigin"]) if obj.get("rfidOrigin") is not None else None
        })
        return _obj


