# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from regula.documentreader.webclient.gen.models.check_result import CheckResult
from regula.documentreader.webclient.gen.models.rfid_access_control_info import RfidAccessControlInfo
from regula.documentreader.webclient.gen.models.rfid_access_key import RfidAccessKey
from regula.documentreader.webclient.gen.models.rfid_application import RfidApplication
from regula.documentreader.webclient.gen.models.rfid_authentication_procedure_type import RfidAuthenticationProcedureType
from regula.documentreader.webclient.gen.models.rfid_card_properties_ext import RfidCardPropertiesExt
from regula.documentreader.webclient.gen.models.rfid_error_codes import RFIDErrorCodes
from regula.documentreader.webclient.gen.models.rfid_security_object import RfidSecurityObject
from regula.documentreader.webclient.gen.models.rfid_terminal import RfidTerminal
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class RfidSessionData(BaseModel):
    """
    Structure is used to describe the results of work with the SDK within the context of the current communication session with electronic document
    """ # noqa: E501
    virtual_mode: SkipValidation[Optional[bool]] = Field(alias="VirtualMode", default=None, description="Sign of virtual session when working with loaded data from a previous communication session with the electronic document")
    sdk_version: SkipValidation[Optional[str]] = Field(alias="SDKVersion", default=None, description="Text SDKVersion value in format A.B (e.g. 3.1)")
    driver_version: SkipValidation[Optional[str]] = Field(alias="DriverVersion", default=None, description="Text DriverVersion value in format A.B.C.D (e.g. 6.2.5.4)")
    firmware_version: SkipValidation[Optional[str]] = Field(alias="FirmwareVersion", default=None, description="Text FirmwareVersion value in format A.B (e.g. 5.19)")
    applications: SkipValidation[List[RfidApplication]] = Field(alias="Applications", description="List of containers to store information about the involved applications of electronic document")
    access_controls: SkipValidation[List[RfidAccessControlInfo]] = Field(alias="AccessControls", description="List of containers to store information about the supported procedures of authentication and secure data access within the context of the session")
    card_properties: SkipValidation[RfidCardPropertiesExt] = Field(alias="CardProperties")
    ext_le_support: SkipValidation[RFIDErrorCodes] = Field(alias="ExtLeSupport")
    process_time: SkipValidation[float] = Field(alias="ProcessTime", description="Time of processing, milliseconds")
    root_files: SkipValidation[List[object]] = Field(alias="RootFiles", description="List of containers to store information about the read files of the root Master File")
    total_bytes_sent: SkipValidation[float] = Field(alias="TotalBytesSent", description="Total number of bytes transmitted to the RFID-chip during the whole session")
    total_bytes_received: SkipValidation[float] = Field(alias="TotalBytesReceived", description="Total number of bytes received from the RFID-chip during the whole session")
    session_key: SkipValidation[Optional[RfidAccessKey]] = Field(alias="Session_key", default=None)
    session_terminal: SkipValidation[RfidTerminal] = Field(alias="Session_terminal")
    session_procedure: SkipValidation[RfidAuthenticationProcedureType] = Field(alias="Session_procedure")
    security_objects: SkipValidation[List[RfidSecurityObject]] = Field(alias="SecurityObjects", description="List of containers to store information about the detected document security objects")
    status: SkipValidation[Optional[CheckResult]] = Field(alias="Status", default=None)
    __properties: ClassVar[List[str]] = ["VirtualMode", "SDKVersion", "DriverVersion", "FirmwareVersion", "Applications", "AccessControls", "CardProperties", "ExtLeSupport", "ProcessTime", "RootFiles", "TotalBytesSent", "TotalBytesReceived", "Session_key", "Session_terminal", "Session_procedure", "SecurityObjects", "Status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RfidSessionData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in applications (list)
        _items = []
        if self.applications:
            for _item_applications in self.applications:
                if _item_applications and hasattr(_item_applications, "to_dict"):
                    _items.append(_item_applications.to_dict())
            _dict['Applications'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in access_controls (list)
        _items = []
        if self.access_controls:
            for _item_access_controls in self.access_controls:
                if _item_access_controls and hasattr(_item_access_controls, "to_dict"):
                    _items.append(_item_access_controls.to_dict())
            _dict['AccessControls'] = _items
        # override the default output from pydantic by calling `to_dict()` of card_properties
        if self.card_properties and isinstance(self.card_properties, RfidCardPropertiesExt):
            _dict['CardProperties'] = self.card_properties.to_dict()
        # override the default output from pydantic by calling `to_dict()` of session_key
        if self.session_key and isinstance(self.session_key, RfidAccessKey):
            _dict['Session_key'] = self.session_key.to_dict()
        # override the default output from pydantic by calling `to_dict()` of session_terminal
        if self.session_terminal and isinstance(self.session_terminal, RfidTerminal):
            _dict['Session_terminal'] = self.session_terminal.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in security_objects (list)
        _items = []
        if self.security_objects:
            for _item_security_objects in self.security_objects:
                if _item_security_objects and hasattr(_item_security_objects, "to_dict"):
                    _items.append(_item_security_objects.to_dict())
            _dict['SecurityObjects'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RfidSessionData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "VirtualMode": obj.get("VirtualMode"),
            "SDKVersion": obj.get("SDKVersion"),
            "DriverVersion": obj.get("DriverVersion"),
            "FirmwareVersion": obj.get("FirmwareVersion"),
            "Applications": [RfidApplication.from_dict(_item) for _item in obj.get("Applications", []) if RfidApplication.from_dict(_item) is not None],
            "AccessControls": [RfidAccessControlInfo.from_dict(_item) for _item in obj.get("AccessControls", []) if RfidAccessControlInfo.from_dict(_item) is not None],
            "CardProperties": RfidCardPropertiesExt.from_dict(obj["CardProperties"]) if obj.get("CardProperties") is not None else None,
            "ExtLeSupport": obj.get("ExtLeSupport"),
            "ProcessTime": obj.get("ProcessTime"),
            "RootFiles": obj.get("RootFiles"),
            "TotalBytesSent": obj.get("TotalBytesSent"),
            "TotalBytesReceived": obj.get("TotalBytesReceived"),
            "Session_key": RfidAccessKey.from_dict(obj["Session_key"]) if obj.get("Session_key") is not None else None,
            "Session_terminal": RfidTerminal.from_dict(obj["Session_terminal"]) if obj.get("Session_terminal") is not None else None,
            "Session_procedure": obj.get("Session_procedure"),
            "SecurityObjects": [RfidSecurityObject.from_dict(_item) for _item in obj.get("SecurityObjects", []) if RfidSecurityObject.from_dict(_item) is not None],
            "Status": obj.get("Status")
        })
        return _obj


