# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from regula.documentreader.webclient.gen.models.rfid_application_type import RfidApplicationType
from regula.documentreader.webclient.gen.models.rfid_data_file import RfidDataFile
from regula.documentreader.webclient.gen.models.rfid_error_codes import RFIDErrorCodes
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class RfidApplication(BaseModel):
    """
    Structure is used to describe the contents of a single LDS application and their analysis within the context of the communication session with electronic document
    """ # noqa: E501
    type: SkipValidation[RfidApplicationType] = Field(alias="Type")
    status: SkipValidation[RFIDErrorCodes] = Field(alias="Status")
    application_id: SkipValidation[str] = Field(alias="ApplicationID", description="Application identifier")
    version: SkipValidation[str] = Field(alias="Version", description="Version of the application")
    unicode_version: SkipValidation[str] = Field(alias="UnicodeVersion", description="Unicode version for application")
    data_hash_algorithm: SkipValidation[str] = Field(alias="DataHashAlgorithm", description="Algorithm for calculating hash values for files for the procedure of PA")
    files: SkipValidation[List[RfidDataFile]] = Field(alias="Files", description="List of containers to store information about the read files of the application")
    __properties: ClassVar[List[str]] = ["Type", "Status", "ApplicationID", "Version", "UnicodeVersion", "DataHashAlgorithm", "Files"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RfidApplication from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item_files in self.files:
                if _item_files and hasattr(_item_files, "to_dict"):
                    _items.append(_item_files.to_dict())
            _dict['Files'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RfidApplication from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Type": obj.get("Type"),
            "Status": obj.get("Status"),
            "ApplicationID": obj.get("ApplicationID"),
            "Version": obj.get("Version"),
            "UnicodeVersion": obj.get("UnicodeVersion"),
            "DataHashAlgorithm": obj.get("DataHashAlgorithm"),
            "Files": [RfidDataFile.from_dict(_item) for _item in obj.get("Files", []) if RfidDataFile.from_dict(_item) is not None]
        })
        return _obj


