# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.check_result import CheckResult
from regula.documentreader.webclient.gen.models.cross_source_value_comparison import CrossSourceValueComparison
from regula.documentreader.webclient.gen.models.lcid import LCID
from regula.documentreader.webclient.gen.models.source_validity import SourceValidity
from regula.documentreader.webclient.gen.models.text_field_type import TextFieldType
from regula.documentreader.webclient.gen.models.text_field_value import TextFieldValue
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class TextField(BaseModel):
    """
    TextField
    """ # noqa: E501
    field_type: SkipValidation[TextFieldType] = Field(alias="fieldType")
    field_name: SkipValidation[str] = Field(alias="fieldName", description="Field name. Only use to search values for fields with fieldType=50(other). In general, use fieldType for lookup.")
    lcid: SkipValidation[LCID] = Field(alias="lcid")
    lcid_name: SkipValidation[Optional[str]] = Field(alias="lcidName", default=None, description="LCID name")
    status: SkipValidation[CheckResult] = Field(alias="status")
    validity_status: SkipValidation[CheckResult] = Field(alias="validityStatus")
    comparison_status: SkipValidation[CheckResult] = Field(alias="comparisonStatus")
    value: SkipValidation[str] = Field(alias="value", description="The most confidence value, selected from valueList")
    value_list: SkipValidation[List[TextFieldValue]] = Field(alias="valueList")
    validity_list: SkipValidation[List[SourceValidity]] = Field(alias="validityList", description="Validity of all field values for given source. If there are two values on different pages for one field-source pair, then validity also will include logical match checking. If such values do not match, validity will return error.")
    comparison_list: SkipValidation[List[CrossSourceValueComparison]] = Field(alias="comparisonList")
    __properties: ClassVar[List[str]] = ["fieldType", "fieldName", "lcid", "lcidName", "status", "validityStatus", "comparisonStatus", "value", "valueList", "validityList", "comparisonList"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TextField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in value_list (list)
        _items = []
        if self.value_list:
            for _item_value_list in self.value_list:
                if _item_value_list and hasattr(_item_value_list, "to_dict"):
                    _items.append(_item_value_list.to_dict())
            _dict['valueList'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in validity_list (list)
        _items = []
        if self.validity_list:
            for _item_validity_list in self.validity_list:
                if _item_validity_list and hasattr(_item_validity_list, "to_dict"):
                    _items.append(_item_validity_list.to_dict())
            _dict['validityList'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in comparison_list (list)
        _items = []
        if self.comparison_list:
            for _item_comparison_list in self.comparison_list:
                if _item_comparison_list and hasattr(_item_comparison_list, "to_dict"):
                    _items.append(_item_comparison_list.to_dict())
            _dict['comparisonList'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TextField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fieldType": obj.get("fieldType"),
            "fieldName": obj.get("fieldName"),
            "lcid": obj.get("lcid"),
            "lcidName": obj.get("lcidName"),
            "status": obj.get("status"),
            "validityStatus": obj.get("validityStatus"),
            "comparisonStatus": obj.get("comparisonStatus"),
            "value": obj.get("value"),
            "valueList": [TextFieldValue.from_dict(_item) for _item in obj.get("valueList", []) if TextFieldValue.from_dict(_item) is not None],
            "validityList": [SourceValidity.from_dict(_item) for _item in obj.get("validityList", []) if SourceValidity.from_dict(_item) is not None],
            "comparisonList": [CrossSourceValueComparison.from_dict(_item) for _item in obj.get("comparisonList", []) if CrossSourceValueComparison.from_dict(_item) is not None]
        })
        return _obj


