# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from regula.documentreader.webclient.gen.models.rectangle_coordinates import RectangleCoordinates
from regula.documentreader.webclient.gen.models.symbol_candidate import SymbolCandidate
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class SymbolRecognitionResult(BaseModel):
    """
    Describes a single character recognition results in the text field line
    """ # noqa: E501
    symbol_rect: SkipValidation[Optional[RectangleCoordinates]] = Field(alias="SymbolRect", default=None)
    candidates_count: SkipValidation[float] = Field(alias="CandidatesCount", description="Number of significant elements of ListOfCandidates array")
    list_of_candidates: SkipValidation[List[SymbolCandidate]] = Field(alias="ListOfCandidates", description="Array of candidate characters. Sorted in descending order of recognition probabilities (the first element has highest probability)")
    base_line_bottom: SkipValidation[Optional[int]] = Field(alias="BaseLineBottom", default=None)
    base_line_top: SkipValidation[Optional[int]] = Field(alias="BaseLineTop", default=None)
    __properties: ClassVar[List[str]] = ["SymbolRect", "CandidatesCount", "ListOfCandidates", "BaseLineBottom", "BaseLineTop"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SymbolRecognitionResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of symbol_rect
        if self.symbol_rect and isinstance(self.symbol_rect, RectangleCoordinates):
            _dict['SymbolRect'] = self.symbol_rect.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in list_of_candidates (list)
        _items = []
        if self.list_of_candidates:
            for _item_list_of_candidates in self.list_of_candidates:
                if _item_list_of_candidates and hasattr(_item_list_of_candidates, "to_dict"):
                    _items.append(_item_list_of_candidates.to_dict())
            _dict['ListOfCandidates'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SymbolRecognitionResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "SymbolRect": RectangleCoordinates.from_dict(obj["SymbolRect"]) if obj.get("SymbolRect") is not None else None,
            "CandidatesCount": obj.get("CandidatesCount"),
            "ListOfCandidates": [SymbolCandidate.from_dict(_item) for _item in obj.get("ListOfCandidates", []) if SymbolCandidate.from_dict(_item) is not None],
            "BaseLineBottom": obj.get("BaseLineBottom"),
            "BaseLineTop": obj.get("BaseLineTop")
        })
        return _obj


